/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm;

import java.io.ByteArrayOutputStream;
import org.luaj.vm.LNil;
import org.luaj.vm.LString;
import org.luaj.vm.LTable;
import org.luaj.vm.LuaErrorException;
import org.luaj.vm.LuaState;

public abstract class LValue {
    public static final LString TM_INDEX = new LString("__index");
    public static final LString TM_NEWINDEX = new LString("__newindex");
    public static final LString TM_METATABLE = new LString("__metatable");
    public static final LString TM_MODE = new LString("__mode");
    private static final int MAXTAGLOOP = 100;

    protected void conversionError(String string) {
        throw new LuaErrorException("bad conversion: " + this.luaGetTypeName() + " to " + string);
    }

    private static LValue arithmeticError(Object object) {
        throw new LuaErrorException("attempt to perform arithmetic on ? (a " + object + " value)");
    }

    protected static LValue compareError(Object object, Object object2) {
        throw new LuaErrorException("attempt to compare " + object + " with " + object2);
    }

    private LValue indexError(LuaState luaState, LValue lValue) {
        luaState.error("attempt to index ? (a " + lValue.luaGetTypeName() + " value)");
        return LNil.NIL;
    }

    public String id() {
        return Integer.toHexString(this.hashCode());
    }

    public boolean isInteger() {
        return false;
    }

    public boolean isNil() {
        return false;
    }

    public boolean luaStackCall(LuaState luaState) {
        luaState.error("attempt to call " + this);
        return false;
    }

    public LValue luaBinOpUnknown(int n, LValue lValue) {
        return LValue.arithmeticError(this.luaGetTypeName());
    }

    public LValue luaBinOpInteger(int n, int n2) {
        return LValue.arithmeticError(this.luaGetTypeName());
    }

    public LValue luaBinOpDouble(int n, double d) {
        return LValue.arithmeticError(this.luaGetTypeName());
    }

    public boolean luaBinCmpUnknown(int n, LValue lValue) {
        if (n == 23) {
            return lValue == this;
        }
        LValue.compareError(lValue.luaGetTypeName(), this.luaGetTypeName());
        return false;
    }

    public boolean luaBinCmpString(int n, LString lString) {
        if (n == 23) {
            return false;
        }
        LValue.compareError(this.luaGetTypeName(), "string");
        return false;
    }

    public boolean luaBinCmpInteger(int n, int n2) {
        if (n == 23) {
            return false;
        }
        LValue.compareError(this.luaGetTypeName(), "number");
        return false;
    }

    public boolean luaBinCmpDouble(int n, double d) {
        if (n == 23) {
            return false;
        }
        LValue.compareError(this.luaGetTypeName(), "number");
        return false;
    }

    public void luaSetTable(LuaState luaState, LValue lValue, LValue lValue2) {
        luaState.luaV_settable(this, lValue, lValue2);
    }

    public LValue luaGetTable(LuaState luaState, LValue lValue) {
        return luaState.luaV_gettable(this, lValue);
    }

    public LString luaAsString() {
        return new LString(this.toJavaString());
    }

    public String toString() {
        return this.toJavaString();
    }

    public LValue luaUnaryMinus() {
        return LValue.arithmeticError(this.luaGetTypeName());
    }

    public int luaLength() {
        throw new LuaErrorException("attempt to get length of ? (a " + this.luaGetTypeName() + " value)");
    }

    public LTable luaGetMetatable() {
        return null;
    }

    public LTable luaSetMetatable(LValue lValue) {
        throw new LuaErrorException("cannot set metatable for " + this.luaGetTypeName());
    }

    public abstract int luaGetType();

    public LString luaGetTypeName() {
        return LString.LTYPENAMES[this.luaGetType()];
    }

    public String toJavaString() {
        return null;
    }

    public boolean toJavaBoolean() {
        return true;
    }

    public byte toJavaByte() {
        this.conversionError("number");
        return 0;
    }

    public char toJavaChar() {
        this.conversionError("number");
        return '\u0000';
    }

    public double toJavaDouble() {
        this.conversionError("number");
        return 0.0;
    }

    public float toJavaFloat() {
        this.conversionError("number");
        return 0.0f;
    }

    public int toJavaInt() {
        this.conversionError("number");
        return 0;
    }

    public long toJavaLong() {
        this.conversionError("number");
        return 0L;
    }

    public short toJavaShort() {
        this.conversionError("number");
        return 0;
    }

    public Boolean toJavaBoxedBoolean() {
        this.conversionError("Boolean");
        return null;
    }

    public Byte toJavaBoxedByte() {
        this.conversionError("Byte");
        return null;
    }

    public Character toJavaBoxedCharacter() {
        this.conversionError("Character");
        return null;
    }

    public Double toJavaBoxedDouble() {
        this.conversionError("Double");
        return null;
    }

    public Float toJavaBoxedFloat() {
        this.conversionError("Float");
        return null;
    }

    public Integer toJavaBoxedInteger() {
        this.conversionError("Integer");
        return null;
    }

    public Long toJavaBoxedLong() {
        this.conversionError("Long");
        return null;
    }

    public Short toJavaBoxedShort() {
        this.conversionError("Short");
        return null;
    }

    public Object toJavaInstance() {
        this.conversionError("instance");
        return null;
    }

    public boolean luaSetEnv(LTable lTable) {
        return false;
    }

    public LTable luaGetEnv(LTable lTable) {
        return lTable;
    }

    public LValue luaToNumber() {
        return LNil.NIL;
    }

    public LValue toStrongReference() {
        return this;
    }

    public void luaConcatTo(ByteArrayOutputStream byteArrayOutputStream) {
        throw new LuaErrorException("attempt to concatenate " + this.luaGetTypeName());
    }

    public boolean isString() {
        return false;
    }

    public boolean isTable() {
        return false;
    }

    public boolean isFunction() {
        return false;
    }

    public boolean isUserData() {
        return false;
    }

    public boolean isNumber() {
        return false;
    }

    public boolean isClosure() {
        return false;
    }
}

