/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm;

import java.lang.ref.WeakReference;
import org.luaj.vm.LNil;
import org.luaj.vm.LTable;
import org.luaj.vm.LUserData;
import org.luaj.vm.LValue;
import org.luaj.vm.LuaState;

public class LWeakTable
extends LTable {
    public LWeakTable() {
    }

    public LWeakTable(int n, int n2) {
        super(n, n2);
    }

    public LWeakTable(LTable lTable) {
        super(lTable.array.length, lTable.hashKeys.length);
        int n = 0;
        int n2 = 1;
        int n3 = lTable.array.length;
        while (n < n3) {
            this.put(n2, lTable.get(n2));
            ++n;
            ++n2;
        }
        n2 = lTable.hashKeys.length;
        for (n = 0; n < n2; ++n) {
            LValue lValue = lTable.hashKeys[n];
            if (lValue == null) continue;
            this.put(lValue, lTable.get(lValue));
        }
    }

    protected LValue normalizeGet(Object object) {
        if (object instanceof WeakReference) {
            object = ((WeakReference)object).get();
        } else if (object instanceof LUserData) {
            LUserData lUserData = (LUserData)object;
            Object t = ((WeakReference)lUserData.m_instance).get();
            object = t != null ? new LUserData(t, lUserData.m_metatable) : LNil.NIL;
        }
        return object == null ? LNil.NIL : (LValue)object;
    }

    protected Object normalizePut(LValue lValue) {
        if (lValue.isNil()) {
            return null;
        }
        if (lValue.isUserData()) {
            LUserData lUserData = (LUserData)lValue;
            return new LUserData(new WeakReference<Object>(lUserData.m_instance), lUserData.m_metatable);
        }
        return new WeakReference<LValue>(lValue);
    }

    public boolean next(LuaState luaState, LValue lValue, boolean bl) {
        while (super.next(luaState, lValue, bl)) {
            if (!luaState.isnil(-1)) {
                return true;
            }
            luaState.pop(1);
            lValue = luaState.poplvalue();
        }
        return false;
    }

    protected void rehash() {
        LValue[] lValueArray = this.hashKeys;
        Object[] objectArray = this.hashValues;
        int n = this.hashKeys.length;
        for (int i = 0; i < n; ++i) {
            if (lValueArray[i] == null || !this.normalizeGet(objectArray[i]).isNil()) continue;
            this.hashClearSlot(i);
            if (this.hashKeys != lValueArray) break;
        }
        if (this.checkLoadFactor()) {
            super.rehash();
        }
    }
}

