/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.luaj.vm.LClosure;
import org.luaj.vm.LDouble;
import org.luaj.vm.LFunction;
import org.luaj.vm.LInteger;
import org.luaj.vm.LPrototype;
import org.luaj.vm.LString;
import org.luaj.vm.LValue;
import org.luaj.vm.Lua;
import org.luaj.vm.LuaState;

public class Print
extends Lua {
    private static final String STRING_FOR_NULL = "null";
    public static PrintStream ps = System.out;
    private static final String[] luaP_opnames = new String[]{"MOVE", "LOADK", "LOADBOOL", "LOADNIL", "GETUPVAL", "GETGLOBAL", "GETTABLE", "SETGLOBAL", "SETUPVAL", "SETTABLE", "NEWTABLE", "SELF", "ADD", "SUB", "MUL", "DIV", "MOD", "POW", "UNM", "NOT", "LEN", "CONCAT", "JMP", "EQ", "LT", "LE", "TEST", "TESTSET", "CALL", "TAILCALL", "RETURN", "FORLOOP", "FORPREP", "TFORLOOP", "SETLIST", "CLOSE", "CLOSURE", "VARARG", null};

    static void printString(PrintStream printStream, LString lString) {
        byte[] byArray = lString.m_bytes;
        int n = lString.m_offset;
        printStream.print('\"');
        int n2 = lString.m_length;
        block10: for (int i = 0; i < n2; ++i) {
            int n3 = byArray[i + n] & 0xFF;
            if (n3 >= 32 && n3 <= 126 && n3 != 34 && n3 != 92) {
                printStream.print((char)n3);
                continue;
            }
            switch (n3) {
                case 34: {
                    printStream.print("\\\"");
                    continue block10;
                }
                case 92: {
                    printStream.print("\\\\");
                    continue block10;
                }
                case 7: {
                    printStream.print("\\a");
                    continue block10;
                }
                case 8: {
                    printStream.print("\\f");
                    continue block10;
                }
                case 12: {
                    printStream.print("\\f");
                    continue block10;
                }
                case 13: {
                    printStream.print("\\r");
                    continue block10;
                }
                case 10: {
                    printStream.print("\\n");
                    continue block10;
                }
                case 11: {
                    printStream.print("\\v");
                    continue block10;
                }
                default: {
                    printStream.print('\\');
                    printStream.print(Integer.toString(1000 + n3).substring(1));
                }
            }
        }
        printStream.print('\"');
    }

    static void printValue(PrintStream printStream, LValue lValue) {
        if (lValue instanceof LString) {
            Print.printString(printStream, lValue.luaAsString());
        } else if (lValue instanceof LInteger) {
            printStream.print(lValue.toJavaInt());
        } else if (lValue instanceof LDouble) {
            double d = lValue.toJavaDouble();
            if (d == (double)((int)d)) {
                printStream.print((int)d);
            } else {
                printStream.print(d);
            }
        } else if (lValue instanceof LFunction) {
            printStream.print(lValue.getClass().getName());
        } else {
            printStream.print(String.valueOf(lValue));
        }
    }

    static void printConstant(PrintStream printStream, LPrototype lPrototype, int n) {
        Print.printValue(printStream, lPrototype.k[n]);
    }

    public static void printCode(LPrototype lPrototype) {
        int[] nArray = lPrototype.code;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Print.printOpCode(lPrototype, i);
            ps.println();
        }
    }

    public static void printOpCode(LPrototype lPrototype, int n) {
        Print.printOpCode(ps, lPrototype, n);
    }

    public static void printOpCode(PrintStream printStream, LPrototype lPrototype, int n) {
        int[] nArray = lPrototype.code;
        int n2 = nArray[n];
        int n3 = Lua.GET_OPCODE(n2);
        int n4 = Lua.GETARG_A(n2);
        int n5 = Lua.GETARG_B(n2);
        int n6 = Lua.GETARG_C(n2);
        int n7 = Lua.GETARG_Bx(n2);
        int n8 = Lua.GETARG_sBx(n2);
        int n9 = Print.getline(lPrototype, n);
        printStream.print("  " + (n + 1) + "  ");
        if (n9 > 0) {
            printStream.print("[" + n9 + "]  ");
        } else {
            printStream.print("[-]  ");
        }
        printStream.print(luaP_opnames[n3] + "  ");
        switch (Lua.getOpMode(n3)) {
            case 0: {
                printStream.print(n4);
                if (Lua.getBMode(n3) != 0) {
                    printStream.print(" " + (Lua.ISK(n5) ? -1 - Lua.INDEXK(n5) : n5));
                }
                if (Lua.getCMode(n3) == 0) break;
                printStream.print(" " + (Lua.ISK(n6) ? -1 - Lua.INDEXK(n6) : n6));
                break;
            }
            case 1: {
                if (Lua.getBMode(n3) == 3) {
                    printStream.print(n4 + " " + (-1 - n7));
                    break;
                }
                printStream.print(n4 + " " + n7);
                break;
            }
            case 2: {
                if (n3 == 22) {
                    printStream.print(n8);
                    break;
                }
                printStream.print(n4 + " " + n8);
                break;
            }
        }
        switch (n3) {
            case 1: {
                printStream.print("  ; ");
                Print.printConstant(printStream, lPrototype, n7);
                break;
            }
            case 4: 
            case 8: {
                printStream.print("  ; ");
                if (lPrototype.upvalues.length > n5) {
                    Print.printValue(printStream, lPrototype.upvalues[n5]);
                    break;
                }
                printStream.print("-");
                break;
            }
            case 5: 
            case 7: {
                printStream.print("  ; ");
                Print.printConstant(printStream, lPrototype, n7);
                break;
            }
            case 6: 
            case 11: {
                if (!Lua.ISK(n6)) break;
                printStream.print("  ; ");
                Print.printConstant(printStream, lPrototype, Lua.INDEXK(n6));
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 23: 
            case 24: 
            case 25: {
                if (!Lua.ISK(n5) && !Lua.ISK(n6)) break;
                printStream.print("  ; ");
                if (Lua.ISK(n5)) {
                    Print.printConstant(printStream, lPrototype, Lua.INDEXK(n5));
                } else {
                    printStream.print("-");
                }
                printStream.print(" ");
                if (Lua.ISK(n6)) {
                    Print.printConstant(printStream, lPrototype, Lua.INDEXK(n6));
                    break;
                }
                printStream.print("-");
                break;
            }
            case 22: 
            case 31: 
            case 32: {
                printStream.print("  ; to " + (n8 + n + 2));
                break;
            }
            case 36: {
                printStream.print("  ; " + lPrototype.p[n7].getClass().getName());
                break;
            }
            case 34: {
                if (n6 == 0) {
                    printStream.print("  ; " + nArray[++n]);
                    break;
                }
                printStream.print("  ; " + n6);
                break;
            }
            case 37: {
                printStream.print("  ; is_vararg=" + lPrototype.is_vararg);
                break;
            }
        }
    }

    private static int getline(LPrototype lPrototype, int n) {
        return n > 0 && lPrototype.lineinfo != null && n < lPrototype.lineinfo.length ? lPrototype.lineinfo[n] : -1;
    }

    static void printHeader(LPrototype lPrototype) {
        String string = String.valueOf(lPrototype.source);
        string = string.startsWith("@") || string.startsWith("=") ? string.substring(1) : ("\u001bLua".equals(string) ? "(bstring)" : "(string)");
        String string2 = lPrototype.linedefined == 0 ? "main" : "function";
        ps.print("\n%" + string2 + " <" + string + ":" + lPrototype.linedefined + "," + lPrototype.lastlinedefined + "> (" + lPrototype.code.length + " instructions, " + lPrototype.code.length * 4 + " bytes at " + Print.id(lPrototype) + ")\n");
        ps.print(lPrototype.numparams + " param, " + lPrototype.maxstacksize + " slot, " + lPrototype.upvalues.length + " upvalue, ");
        ps.print(lPrototype.locvars.length + " local, " + lPrototype.k.length + " constant, " + lPrototype.p.length + " function\n");
    }

    static void printConstants(LPrototype lPrototype) {
        int n = lPrototype.k.length;
        ps.print("constants (" + n + ") for " + Print.id(lPrototype) + ":\n");
        for (int i = 0; i < n; ++i) {
            ps.print("  " + (i + 1) + "  ");
            Print.printValue(ps, lPrototype.k[i]);
            ps.print("\n");
        }
    }

    static void printLocals(LPrototype lPrototype) {
        int n = lPrototype.locvars.length;
        ps.print("locals (" + n + ") for " + Print.id(lPrototype) + ":\n");
        for (int i = 0; i < n; ++i) {
            ps.println("  " + i + "  " + lPrototype.locvars[i].varname + " " + (lPrototype.locvars[i].startpc + 1) + " " + (lPrototype.locvars[i].endpc + 1));
        }
    }

    static void printUpValues(LPrototype lPrototype) {
        int n = lPrototype.upvalues.length;
        ps.print("upvalues (" + n + ") for " + Print.id(lPrototype) + ":\n");
        for (int i = 0; i < n; ++i) {
            ps.print("  " + i + "  " + lPrototype.upvalues[i] + "\n");
        }
    }

    public void printFunction(LPrototype lPrototype, boolean bl) {
        int n = lPrototype.p.length;
        Print.printHeader(lPrototype);
        Print.printCode(lPrototype);
        if (bl) {
            Print.printConstants(lPrototype);
            Print.printLocals(lPrototype);
            Print.printUpValues(lPrototype);
        }
        for (int i = 0; i < n; ++i) {
            this.printFunction(lPrototype.p[i], bl);
        }
    }

    private static void format(String string, int n) {
        int n2 = string.length();
        if (n2 > n) {
            ps.print(string.substring(0, n));
        } else {
            ps.print(string);
            int n3 = n - n2;
            while (--n3 >= 0) {
                ps.print(' ');
            }
        }
    }

    public static void printState(LuaState luaState, int n, int n2, int n3, LClosure lClosure, int n4) {
        int n5;
        PrintStream printStream = ps;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ps = new PrintStream(byteArrayOutputStream);
        Print.printOpCode(lClosure.p, n4);
        ps.flush();
        ps.close();
        ps = printStream;
        Print.format(byteArrayOutputStream.toString(), 40);
        ps.print(" b,t=(");
        Print.format(String.valueOf(n), 3);
        ps.print(",");
        Print.format(String.valueOf(n2), 3);
        ps.print(") ");
        for (n5 = 0; n5 < n; ++n5) {
            ps.print('.');
        }
        ps.print('[');
        while (n5 < n3) {
            LValue lValue = luaState.stack[n5];
            ps.print(lValue != null ? String.valueOf(lValue) : STRING_FOR_NULL);
            if (n5 + 1 == n2) {
                ps.print(']');
            }
            ps.print(" | ");
            ++n5;
        }
        ps.println();
    }

    private static String id(LPrototype lPrototype) {
        return "Proto";
    }
}

