/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.luaj.compiler.DumpState;
import org.luaj.compiler.LuaC;
import org.luaj.platform.J2sePlatform;
import org.luaj.vm.LPrototype;
import org.luaj.vm.LuaState;
import org.luaj.vm.Platform;
import org.luaj.vm.Print;

public class luac {
    private static final String version = "Luaj 1.0.4Copyright (C) 2008 luaj.org";
    private static final String usage = "usage: java -cp luaj-j2se.jar luac [options] [filenames].\nAvailable options are:\n  -        process stdin\n  -l       list\n  -o name  output to file 'name' (default is \"luac.out\")\n  -p       parse only\n  -s       strip debug information\n  -e       little endian format for numbers\n  -i<n>    number format 'n', (n=0,1 or 4, default=0)\n  -v       show version information\n  --       stop handling options\n";
    private boolean list = false;
    private String output = "luac.out";
    private boolean parseonly = false;
    private boolean stripdebug = false;
    private boolean littleendian = false;
    private int numberformat = 0;
    private boolean versioninfo = false;
    private boolean processing = true;

    private static void usageExit() {
        System.out.println(usage);
        System.exit(-1);
    }

    public static void main(String[] stringArray) throws IOException {
        new luac(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private luac(String[] stringArray) throws IOException {
        Platform.setInstance(new J2sePlatform());
        LuaC.install();
        LuaState luaState = Platform.newLuaState();
        try {
            block19: for (int i = 0; i < stringArray.length; ++i) {
                if (!this.processing || !stringArray[i].startsWith("-") || stringArray[i].length() <= 1) continue;
                switch (stringArray[i].charAt(1)) {
                    case 'l': {
                        this.list = true;
                        continue block19;
                    }
                    case 'o': {
                        if (++i >= stringArray.length) {
                            luac.usageExit();
                        }
                        this.output = stringArray[i];
                        continue block19;
                    }
                    case 'p': {
                        this.parseonly = true;
                        continue block19;
                    }
                    case 's': {
                        this.stripdebug = true;
                        continue block19;
                    }
                    case 'e': {
                        this.littleendian = true;
                        continue block19;
                    }
                    case 'i': {
                        if (stringArray[i].length() <= 2) {
                            luac.usageExit();
                        }
                        this.numberformat = Integer.parseInt(stringArray[i].substring(2));
                        continue block19;
                    }
                    case 'v': {
                        this.versioninfo = true;
                        continue block19;
                    }
                    case '-': {
                        if (stringArray[i].length() > 2) {
                            luac.usageExit();
                        }
                        this.processing = false;
                        continue block19;
                    }
                    default: {
                        luac.usageExit();
                    }
                }
            }
            if (this.versioninfo) {
                System.out.println(version);
            }
            FileOutputStream fileOutputStream = new FileOutputStream(this.output);
            try {
                this.processing = true;
                block20: for (int i = 0; i < stringArray.length; ++i) {
                    if (!this.processing || !stringArray[i].startsWith("-")) {
                        this.processScript(luaState, new FileInputStream(stringArray[i]), stringArray[i], fileOutputStream);
                        continue;
                    }
                    if (stringArray[i].length() <= 1) {
                        this.processScript(luaState, System.in, "-", fileOutputStream);
                        continue;
                    }
                    switch (stringArray[i].charAt(1)) {
                        case 'o': {
                            ++i;
                            continue block20;
                        }
                        case '-': {
                            this.processing = false;
                        }
                    }
                }
            }
            finally {
                ((OutputStream)fileOutputStream).close();
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
            System.exit(-2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processScript(LuaState luaState, InputStream inputStream, String string, OutputStream outputStream) throws IOException {
        try {
            LPrototype lPrototype = LuaC.compile(inputStream, string);
            if (this.list) {
                Print.printCode(lPrototype);
            }
            if (!this.parseonly) {
                DumpState.dump(lPrototype, outputStream, this.stripdebug, this.numberformat, this.littleendian);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
        }
        finally {
            inputStream.close();
        }
    }
}

