/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.compiler;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import org.luaj.compiler.FuncState;
import org.luaj.compiler.InstructionPtr;
import org.luaj.compiler.LexState;
import org.luaj.vm.LPrototype;
import org.luaj.vm.LString;
import org.luaj.vm.LValue;
import org.luaj.vm.LoadState;
import org.luaj.vm.LocVars;
import org.luaj.vm.Lua;
import org.luaj.vm.LuaErrorException;

public class LuaC
extends Lua
implements LoadState.LuaCompiler {
    public static final int MAXSTACK = 250;
    static final int LUAI_MAXUPVALUES = 60;
    static final int LUAI_MAXVARS = 200;
    static final int NO_REG = 255;
    static final int iABC = 0;
    static final int iABx = 1;
    static final int iAsBx = 2;
    static final int OpArgN = 0;
    static final int OpArgU = 1;
    static final int OpArgR = 2;
    static final int OpArgK = 3;
    public int nCcalls;
    Hashtable strings = new Hashtable();

    public static void install() {
        LoadState.compiler = new LuaC();
    }

    protected static void _assert(boolean bl) {
        if (!bl) {
            throw new LuaErrorException("compiler assert failed");
        }
    }

    static void SET_OPCODE(InstructionPtr instructionPtr, int n) {
        instructionPtr.set(instructionPtr.get() & 0xFFFFFFC0 | n << 0 & 0x3F);
    }

    static void SETARG_A(InstructionPtr instructionPtr, int n) {
        instructionPtr.set(instructionPtr.get() & 0xFFFFC03F | n << 6 & 0x3FC0);
    }

    static void SETARG_B(InstructionPtr instructionPtr, int n) {
        instructionPtr.set(instructionPtr.get() & 0x7FFFFF | n << 23 & 0xFF800000);
    }

    static void SETARG_C(InstructionPtr instructionPtr, int n) {
        instructionPtr.set(instructionPtr.get() & 0xFF803FFF | n << 14 & 0x7FC000);
    }

    static void SETARG_Bx(InstructionPtr instructionPtr, int n) {
        instructionPtr.set(instructionPtr.get() & 0x3FFF | n << 14 & 0xFFFFC000);
    }

    static void SETARG_sBx(InstructionPtr instructionPtr, int n) {
        LuaC.SETARG_Bx(instructionPtr, n + 131071);
    }

    static int CREATE_ABC(int n, int n2, int n3, int n4) {
        return n << 0 & 0x3F | n2 << 6 & 0x3FC0 | n3 << 23 & 0xFF800000 | n4 << 14 & 0x7FC000;
    }

    static int CREATE_ABx(int n, int n2, int n3) {
        return n << 0 & 0x3F | n2 << 6 & 0x3FC0 | n3 << 14 & 0xFFFFC000;
    }

    static LValue[] realloc(LValue[] lValueArray, int n) {
        LValue[] lValueArray2 = new LValue[n];
        if (lValueArray != null) {
            System.arraycopy(lValueArray, 0, lValueArray2, 0, Math.min(lValueArray.length, n));
        }
        return lValueArray2;
    }

    static LPrototype[] realloc(LPrototype[] lPrototypeArray, int n) {
        LPrototype[] lPrototypeArray2 = new LPrototype[n];
        if (lPrototypeArray != null) {
            System.arraycopy(lPrototypeArray, 0, lPrototypeArray2, 0, Math.min(lPrototypeArray.length, n));
        }
        return lPrototypeArray2;
    }

    static LString[] realloc(LString[] lStringArray, int n) {
        LString[] lStringArray2 = new LString[n];
        if (lStringArray != null) {
            System.arraycopy(lStringArray, 0, lStringArray2, 0, Math.min(lStringArray.length, n));
        }
        return lStringArray2;
    }

    static LocVars[] realloc(LocVars[] locVarsArray, int n) {
        LocVars[] locVarsArray2 = new LocVars[n];
        if (locVarsArray != null) {
            System.arraycopy(locVarsArray, 0, locVarsArray2, 0, Math.min(locVarsArray.length, n));
        }
        return locVarsArray2;
    }

    static int[] realloc(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        if (nArray != null) {
            System.arraycopy(nArray, 0, nArray2, 0, Math.min(nArray.length, n));
        }
        return nArray2;
    }

    static byte[] realloc(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        if (byArray != null) {
            System.arraycopy(byArray, 0, byArray2, 0, Math.min(byArray.length, n));
        }
        return byArray2;
    }

    public static LPrototype compile(InputStream inputStream, String string) throws IOException {
        return new LuaC().compile(inputStream.read(), inputStream, string);
    }

    public LPrototype compile(int n, InputStream inputStream, String string) throws IOException {
        LuaC luaC = new LuaC();
        return luaC.luaY_parser(n, inputStream, string);
    }

    private LPrototype luaY_parser(int n, InputStream inputStream, String string) {
        LexState lexState = new LexState(this, inputStream);
        FuncState funcState = new FuncState();
        lexState.setinput(this, n, inputStream, new LString(string));
        lexState.open_func(funcState);
        funcState.f.is_vararg = 2;
        funcState.f.source = new LString("@" + string);
        lexState.next();
        lexState.chunk();
        lexState.check(287);
        lexState.close_func();
        LuaC._assert(funcState.prev == null);
        LuaC._assert(funcState.f.nups == 0);
        LuaC._assert(lexState.fs == null);
        return funcState.f;
    }

    public LString newlstr(char[] cArray, int n, int n2) {
        return this.newTString(LString.valueOf(new String(cArray, n, n2)));
    }

    public LString newTString(LString lString) {
        LString lString2 = (LString)this.strings.get(lString);
        if (lString2 == null) {
            this.strings.put(lString, lString);
            return lString;
        }
        return lString2;
    }

    public String pushfstring(String string) {
        return string;
    }
}

