/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.lib;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import org.luaj.lib.PackageLib;
import org.luaj.vm.LFunction;
import org.luaj.vm.LNil;
import org.luaj.vm.LString;
import org.luaj.vm.LTable;
import org.luaj.vm.LUserData;
import org.luaj.vm.LValue;
import org.luaj.vm.LuaState;

public abstract class IoLib
extends LFunction {
    public static final String[] NAMES = new String[]{"io", "__index", "close", "flush", "input", "lines", "open", "output", "popen", "read", "tmpfile", "type", "write", "close", "flush", "lines", "read", "seek", "setvbuf", "write"};
    private static final int INSTALL = 0;
    private static final int IO_INDEX = 1;
    private static final int IO_CLOSE = 2;
    private static final int IO_FLUSH = 3;
    private static final int IO_INPUT = 4;
    private static final int IO_LINES = 5;
    private static final int IO_OPEN = 6;
    private static final int IO_OUTPUT = 7;
    private static final int IO_POPEN = 8;
    private static final int IO_READ = 9;
    private static final int IO_TMPFILE = 10;
    private static final int IO_TYPE = 11;
    private static final int IO_WRITE = 12;
    private static final int FILE_CLOSE = 13;
    private static final int FILE_FLUSH = 14;
    private static final int FILE_LINES = 15;
    private static final int FILE_READ = 16;
    private static final int FILE_SEEK = 17;
    private static final int FILE_SETVBUF = 18;
    private static final int FILE_WRITE = 19;
    private static File INPUT = null;
    private static File OUTPUT = null;
    private static File ERROR = null;
    private static LTable FILE_MT;
    private final int id;
    static /* synthetic */ Class class$org$luaj$lib$IoLib$File;

    protected abstract IoLib newInstance(int var1);

    protected abstract File wrapStdin() throws IOException;

    protected abstract File wrapStdout() throws IOException;

    protected abstract File openFile(String var1, boolean var2, boolean var3, boolean var4, boolean var5) throws IOException;

    protected abstract File tmpFile() throws IOException;

    protected abstract File openProgram(String var1, String var2) throws IOException;

    protected void initialize(LTable lTable) {
        int n;
        LTable lTable2 = new LTable();
        for (n = 1; n <= 12; ++n) {
            lTable2.put(NAMES[n], (LValue)this.newInstance(n));
        }
        lTable2.luaSetMetatable(lTable2);
        FILE_MT = new LTable();
        for (n = 13; n <= 19; ++n) {
            FILE_MT.put(NAMES[n], (LValue)this.newInstance(n));
        }
        FILE_MT.put("__index", (LValue)FILE_MT);
        INPUT = null;
        OUTPUT = null;
        ERROR = null;
        lTable.put("io", (LValue)lTable2);
        PackageLib.setIsLoaded("io", lTable2);
    }

    protected IoLib() {
        this.id = 0;
    }

    protected IoLib(int n) {
        this.id = n;
    }

    public LString luaAsString() {
        return new LString(this.toJavaString());
    }

    public String toJavaString() {
        return "io." + this.toString();
    }

    public String toString() {
        return NAMES[this.id] + "()";
    }

    private File input(LuaState luaState) {
        return INPUT != null ? INPUT : (INPUT = this.ioopenfile(luaState, "-", "r"));
    }

    private File output(LuaState luaState) {
        return OUTPUT != null ? OUTPUT : (OUTPUT = this.ioopenfile(luaState, "-", "w"));
    }

    private File error(LuaState luaState) {
        return ERROR != null ? ERROR : (ERROR = this.ioopenfile(luaState, "-", "w"));
    }

    public LValue __index(LuaState luaState, LValue lValue, LValue lValue2) {
        String string = lValue2.toJavaString();
        if ("stdout".equals(string)) {
            return IoLib.touserdata(this.output(luaState));
        }
        if ("stdin".equals(string)) {
            return IoLib.touserdata(this.input(luaState));
        }
        if ("stderr".equals(string)) {
            return IoLib.touserdata(this.error(luaState));
        }
        return LNil.NIL;
    }

    public int invoke(LuaState luaState) {
        try {
            switch (this.id) {
                case 0: {
                    this.initialize(luaState._G);
                    return 0;
                }
                case 2: {
                    File file = luaState.isnoneornil(1) ? this.output(luaState) : IoLib.checkfile(luaState, 1);
                    IoLib.checkopen(luaState, file);
                    IoLib.ioclose(luaState, file);
                    break;
                }
                case 3: {
                    IoLib.checkopen(luaState, this.output(luaState));
                    OUTPUT.flush();
                    luaState.pushboolean(true);
                    return 1;
                }
                case 4: {
                    INPUT = luaState.isnoneornil(1) ? this.input(luaState) : (luaState.isstring(1) ? this.ioopenfile(luaState, luaState.checkstring(1), "r") : IoLib.checkfile(luaState, 1));
                    IoLib.setresult(luaState, INPUT);
                    break;
                }
                case 5: {
                    INPUT = luaState.isnoneornil(1) ? this.input(luaState) : this.ioopenfile(luaState, luaState.checkstring(1), "r");
                    IoLib.checkopen(luaState, INPUT);
                    luaState.pushlvalue(this.lines(luaState, INPUT));
                    return 1;
                }
                case 6: {
                    IoLib.setresult(luaState, this.rawopenfile(luaState.checkstring(1), luaState.optstring(2, "r")));
                    break;
                }
                case 7: {
                    OUTPUT = luaState.isnoneornil(1) ? this.output(luaState) : (luaState.isstring(1) ? this.ioopenfile(luaState, luaState.checkstring(1), "w") : IoLib.checkfile(luaState, 1));
                    IoLib.setresult(luaState, OUTPUT);
                    break;
                }
                case 8: {
                    IoLib.setresult(luaState, this.openProgram(luaState.checkstring(1), luaState.optstring(2, "r")));
                    break;
                }
                case 9: {
                    IoLib.checkopen(luaState, this.input(luaState));
                    IoLib.ioread(luaState, INPUT);
                    break;
                }
                case 10: {
                    IoLib.setresult(luaState, this.tmpFile());
                    break;
                }
                case 11: {
                    File file = this.optfile(luaState, 1);
                    if (file != null) {
                        luaState.pushstring(file.isclosed() ? "closed file" : "file");
                    } else {
                        luaState.pushnil();
                    }
                    return 1;
                }
                case 12: {
                    IoLib.checkopen(luaState, this.output(luaState));
                    IoLib.iowrite(luaState, OUTPUT);
                    break;
                }
                case 13: {
                    File file = IoLib.checkfile(luaState, 1);
                    IoLib.ioclose(luaState, file);
                    break;
                }
                case 14: {
                    File file = IoLib.checkfile(luaState, 1);
                    file.flush();
                    luaState.pushboolean(true);
                    return 1;
                }
                case 15: {
                    File file = IoLib.checkfile(luaState, 1);
                    luaState.pushlvalue(this.lines(luaState, file));
                    return 1;
                }
                case 16: {
                    File file = IoLib.checkfile(luaState, 1);
                    luaState.remove(1);
                    IoLib.ioread(luaState, file);
                    break;
                }
                case 17: {
                    File file = IoLib.checkfile(luaState, 1);
                    luaState.remove(1);
                    int n = file.seek(luaState.optstring(1, "cur"), luaState.optint(2, 0));
                    luaState.pushinteger(n);
                    return 1;
                }
                case 18: {
                    File file = IoLib.checkfile(luaState, 1);
                    luaState.remove(1);
                    file.setvbuf(luaState.checkstring(1), luaState.optint(2, 1024));
                    luaState.pushboolean(true);
                    return 1;
                }
                case 19: {
                    File file = IoLib.checkfile(luaState, 1);
                    luaState.remove(1);
                    IoLib.iowrite(luaState, file);
                    break;
                }
                default: {
                    LuaState.vmerror("bad io id");
                    break;
                }
            }
        }
        catch (IOException iOException) {
            IoLib.seterrorresult(luaState, iOException);
        }
        return -1;
    }

    private static void ioclose(LuaState luaState, File file) throws IOException {
        if (file.isstdfile()) {
            IoLib.seterrorresult(luaState, "cannot close standard file");
        } else {
            file.close();
            IoLib.setsuccessresult(luaState);
        }
    }

    private static void setsuccessresult(LuaState luaState) {
        luaState.resettop();
        luaState.pushboolean(true);
    }

    private static void seterrorresult(LuaState luaState, IOException iOException) {
        String string = iOException.getMessage();
        IoLib.seterrorresult(luaState, "io error: " + (string != null ? string : iOException.toString()));
    }

    private static void seterrorresult(LuaState luaState, String string) {
        luaState.resettop();
        luaState.pushnil();
        luaState.pushstring(string);
    }

    private LValue lines(LuaState luaState, final File file) {
        return new LFunction(){

            public boolean luaStackCall(LuaState luaState) {
                luaState.resettop();
                try {
                    luaState.pushlvalue(IoLib.freadline(file));
                }
                catch (IOException iOException) {
                    IoLib.seterrorresult(luaState, iOException);
                }
                return false;
            }
        };
    }

    private static void iowrite(LuaState luaState, File file) throws IOException {
        int n = luaState.gettop();
        for (int i = 1; i <= n; ++i) {
            file.write(luaState.checklstring(i));
        }
        luaState.resettop();
        luaState.pushboolean(true);
    }

    private static void ioread(LuaState luaState, File file) throws IOException {
        int n;
        int n2 = luaState.gettop();
        for (n = 1; n <= n2; ++n) {
            if (luaState.isnumber(n)) {
                luaState.pushlvalue(IoLib.freadbytes(file, luaState.tointeger(n)));
                continue;
            }
            String string = luaState.checkstring(n);
            if ("*n".equals(string)) {
                luaState.pushnumber(IoLib.freadnumber(file));
                continue;
            }
            if ("*a".equals(string)) {
                luaState.pushlvalue(IoLib.freadall(file));
                continue;
            }
            if ("*l".equals(string)) {
                luaState.pushlvalue(IoLib.freadline(file));
                continue;
            }
            luaState.typerror(n, "(invalid format)");
        }
        for (n = 1; n <= n2; ++n) {
            luaState.remove(1);
        }
    }

    private static File checkfile(LuaState luaState, int n) {
        File file = (File)luaState.checkudata(n, class$org$luaj$lib$IoLib$File == null ? (class$org$luaj$lib$IoLib$File = IoLib.class$("org.luaj.lib.IoLib$File")) : class$org$luaj$lib$IoLib$File);
        IoLib.checkopen(luaState, file);
        return file;
    }

    private File optfile(LuaState luaState, int n) {
        Object object = luaState.touserdata(n);
        return object instanceof File ? (File)object : null;
    }

    private static File checkopen(LuaState luaState, File file) {
        if (file.isclosed()) {
            luaState.error("attempt to use a closed file");
        }
        return file;
    }

    private static void setresult(LuaState luaState, File file) {
        luaState.settop(0);
        luaState.pushlvalue(IoLib.touserdata(file));
    }

    private static LUserData touserdata(File file) {
        return new LUserData(file, FILE_MT);
    }

    private File ioopenfile(LuaState luaState, String string, String string2) {
        try {
            return this.rawopenfile(string, string2);
        }
        catch (Exception exception) {
            luaState.error("io error: " + exception.getMessage());
            return null;
        }
    }

    private File rawopenfile(String string, String string2) throws IOException {
        boolean bl = "-".equals(string);
        boolean bl2 = string2.startsWith("r");
        if (bl) {
            return bl2 ? this.wrapStdin() : this.wrapStdout();
        }
        boolean bl3 = string2.startsWith("a");
        boolean bl4 = string2.indexOf("+") > 0;
        boolean bl5 = string2.endsWith("b");
        return this.openFile(string, bl2, bl3, bl4, bl5);
    }

    public static LValue freadbytes(File file, int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = file.read(byArray, 0, byArray.length);
        if (n2 < 0) {
            return LNil.NIL;
        }
        return new LString(byArray, 0, n2);
    }

    public static LValue freaduntil(File file, boolean bl) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream;
        block9: {
            byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                if (bl) {
                    while ((n = file.read()) > 0) {
                        switch (n) {
                            case 13: {
                                break;
                            }
                            case 10: {
                                break block9;
                            }
                            default: {
                                byteArrayOutputStream.write(n);
                                break;
                            }
                        }
                    }
                    break block9;
                }
                while ((n = file.read()) > 0) {
                    byteArrayOutputStream.write(n);
                }
            }
            catch (EOFException eOFException) {
                n = -1;
            }
        }
        return n < 0 && byteArrayOutputStream.size() == 0 ? LNil.NIL : new LString(byteArrayOutputStream.toByteArray());
    }

    public static LValue freadline(File file) throws IOException {
        return IoLib.freaduntil(file, true);
    }

    public static LValue freadall(File file) throws IOException {
        int n = file.remaining();
        if (n >= 0) {
            return IoLib.freadbytes(file, n);
        }
        return IoLib.freaduntil(file, false);
    }

    public static Double freadnumber(File file) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IoLib.freadchars(file, " \t\r\n", null);
        IoLib.freadchars(file, "-+", byteArrayOutputStream);
        IoLib.freadchars(file, "0123456789", byteArrayOutputStream);
        IoLib.freadchars(file, ".", byteArrayOutputStream);
        IoLib.freadchars(file, "0123456789", byteArrayOutputStream);
        String string = byteArrayOutputStream.toString();
        return string.length() > 0 ? Double.valueOf(string) : null;
    }

    private static void freadchars(File file, String string, ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        int n;
        while (string.indexOf(n = file.peek()) >= 0) {
            file.read();
            if (byteArrayOutputStream == null) continue;
            byteArrayOutputStream.write(n);
        }
        return;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static interface File {
        public void write(LString var1) throws IOException;

        public void flush() throws IOException;

        public boolean isstdfile();

        public void close() throws IOException;

        public boolean isclosed();

        public int seek(String var1, int var2) throws IOException;

        public void setvbuf(String var1, int var2);

        public int remaining() throws IOException;

        public int peek() throws IOException, EOFException;

        public int read() throws IOException, EOFException;

        public int read(byte[] var1, int var2, int var3) throws IOException;
    }
}

