/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.lib.j2se;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import org.luaj.vm.LBoolean;
import org.luaj.vm.LDouble;
import org.luaj.vm.LInteger;
import org.luaj.vm.LNumber;
import org.luaj.vm.LString;
import org.luaj.vm.LTable;
import org.luaj.vm.LUserData;
import org.luaj.vm.LValue;
import org.luaj.vm.LuaErrorException;

public class CoerceLuaToJava {
    static Map COERCIONS = new HashMap();
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    static int scoreParam(LValue lValue, Class clazz) {
        Object object;
        if (lValue instanceof LUserData && clazz.isAssignableFrom((object = ((LUserData)lValue).m_instance).getClass())) {
            return 0;
        }
        object = (Coercion)COERCIONS.get(clazz);
        if (object != null) {
            return object.score(lValue);
        }
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            if (lValue instanceof LTable) {
                return CoerceLuaToJava.scoreParam(((LTable)lValue).get(1), clazz2);
            }
            return 16 + (CoerceLuaToJava.scoreParam(lValue, clazz2) << 8);
        }
        return 4096;
    }

    public static Object coerceArg(LValue lValue, Class clazz) {
        Object object;
        if (lValue instanceof LUserData && clazz.isAssignableFrom((object = ((LUserData)lValue).m_instance).getClass())) {
            return object;
        }
        object = (Coercion)COERCIONS.get(clazz);
        if (object != null) {
            return object.coerce(lValue);
        }
        if (clazz.isArray()) {
            boolean bl = lValue instanceof LTable;
            int n = bl ? lValue.luaLength() : 1;
            Class<?> clazz2 = clazz.getComponentType();
            Object object2 = Array.newInstance(clazz2, n);
            for (int i = 0; i < n; ++i) {
                LValue lValue2;
                LValue lValue3 = lValue2 = bl ? ((LTable)lValue).get(i + 1) : lValue;
                if (lValue2 == null) continue;
                Array.set(object2, i, CoerceLuaToJava.coerceArg(lValue2, clazz2));
            }
            return object2;
        }
        if (lValue.isNil()) {
            return null;
        }
        throw new LuaErrorException("no coercion found for " + lValue.getClass() + " to " + clazz);
    }

    static Object[] coerceArgs(LValue[] lValueArray, Class[] classArray, boolean bl) {
        int n;
        int n2 = lValueArray.length;
        int n3 = classArray.length;
        int n4 = Math.min(bl ? n3 - 1 : n3, n2);
        Object[] objectArray = new Object[n3];
        for (n = 0; n < n4; ++n) {
            objectArray[n] = CoerceLuaToJava.coerceArg(lValueArray[n], classArray[n]);
        }
        if (bl) {
            n = Math.max(0, n2 - n4);
            Class<?> clazz = classArray[n3 - 1].getComponentType();
            Object object = Array.newInstance(clazz, n);
            for (int i = 0; i < n; ++i) {
                Object object2 = CoerceLuaToJava.coerceArg(lValueArray[n4 + i], clazz);
                Array.set(object, i, object2);
            }
            objectArray[n3 - 1] = object;
        }
        return objectArray;
    }

    public static int scoreParamTypes(LValue[] lValueArray, Class[] classArray) {
        int n = classArray.length;
        int n2 = lValueArray.length;
        int n3 = n == n2 ? 0 : (n > n2 ? 16384 : 32768);
        for (int i = 0; i < n2 && i < n; ++i) {
            LValue lValue = lValueArray[i];
            Class clazz = classArray[i];
            int n4 = CoerceLuaToJava.scoreParam(lValue, clazz);
            n3 += n4;
        }
        return n3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Coercion coercion = new Coercion(){

            public Object coerce(LValue lValue) {
                return lValue.toJavaBoolean() ? Boolean.TRUE : Boolean.FALSE;
            }

            public int score(LValue lValue) {
                if (lValue instanceof LBoolean || lValue.isNil()) {
                    return 0;
                }
                if (lValue instanceof LNumber) {
                    return 1;
                }
                return 4;
            }
        };
        Coercion coercion2 = new Coercion(){

            public Object coerce(LValue lValue) {
                return new Byte(lValue.toJavaByte());
            }

            public int score(LValue lValue) {
                if (lValue instanceof LInteger) {
                    return 1;
                }
                if (lValue instanceof LNumber) {
                    return 2;
                }
                return 4;
            }
        };
        Coercion coercion3 = new Coercion(){

            public Object coerce(LValue lValue) {
                return new Character(lValue.toJavaChar());
            }

            public int score(LValue lValue) {
                if (lValue instanceof LInteger) {
                    return 1;
                }
                if (lValue instanceof LNumber) {
                    return 2;
                }
                return 4;
            }
        };
        Coercion coercion4 = new Coercion(){

            public Object coerce(LValue lValue) {
                return new Short(lValue.toJavaShort());
            }

            public int score(LValue lValue) {
                if (lValue instanceof LInteger) {
                    return 1;
                }
                if (lValue instanceof LNumber) {
                    return 2;
                }
                return 4;
            }
        };
        Coercion coercion5 = new Coercion(){

            public Object coerce(LValue lValue) {
                return new Integer(lValue.toJavaInt());
            }

            public int score(LValue lValue) {
                if (lValue instanceof LInteger) {
                    return 0;
                }
                if (lValue instanceof LNumber) {
                    return 1;
                }
                if (lValue instanceof LBoolean || lValue.isNil()) {
                    return 2;
                }
                return 4;
            }
        };
        Coercion coercion6 = new Coercion(){

            public Object coerce(LValue lValue) {
                return new Long(lValue.toJavaLong());
            }

            public int score(LValue lValue) {
                if (lValue instanceof LInteger) {
                    return 1;
                }
                if (lValue instanceof LNumber) {
                    return 2;
                }
                return 4;
            }
        };
        Coercion coercion7 = new Coercion(){

            public Object coerce(LValue lValue) {
                return new Float(lValue.toJavaFloat());
            }

            public int score(LValue lValue) {
                if (lValue instanceof LNumber) {
                    return 1;
                }
                if (lValue instanceof LBoolean) {
                    return 2;
                }
                return 4;
            }
        };
        Coercion coercion8 = new Coercion(){

            public Object coerce(LValue lValue) {
                return new Double(lValue.toJavaDouble());
            }

            public int score(LValue lValue) {
                if (lValue instanceof LDouble) {
                    return 0;
                }
                if (lValue instanceof LNumber) {
                    return 1;
                }
                if (lValue instanceof LBoolean) {
                    return 2;
                }
                return 4;
            }
        };
        Coercion coercion9 = new Coercion(){

            public Object coerce(LValue lValue) {
                return lValue.toJavaString();
            }

            public int score(LValue lValue) {
                if (lValue instanceof LUserData) {
                    return 0;
                }
                return 1;
            }
        };
        Coercion coercion10 = new Coercion(){

            public Object coerce(LValue lValue) {
                if (lValue instanceof LUserData) {
                    return ((LUserData)lValue).m_instance;
                }
                if (lValue instanceof LString) {
                    return lValue.toJavaString();
                }
                if (lValue instanceof LInteger) {
                    return new Integer(lValue.toJavaInt());
                }
                if (lValue instanceof LDouble) {
                    return new Double(lValue.toJavaDouble());
                }
                if (lValue instanceof LBoolean) {
                    return lValue.toJavaBoolean();
                }
                if (lValue.isNil()) {
                    return null;
                }
                return lValue;
            }

            public int score(LValue lValue) {
                if (lValue instanceof LString) {
                    return 0;
                }
                return 16;
            }
        };
        COERCIONS.put(Boolean.TYPE, coercion);
        COERCIONS.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = CoerceLuaToJava.class$("java.lang.Boolean")) : class$java$lang$Boolean, coercion);
        COERCIONS.put(Byte.TYPE, coercion2);
        COERCIONS.put(class$java$lang$Byte == null ? (class$java$lang$Byte = CoerceLuaToJava.class$("java.lang.Byte")) : class$java$lang$Byte, coercion2);
        COERCIONS.put(Character.TYPE, coercion3);
        COERCIONS.put(class$java$lang$Character == null ? (class$java$lang$Character = CoerceLuaToJava.class$("java.lang.Character")) : class$java$lang$Character, coercion3);
        COERCIONS.put(Short.TYPE, coercion4);
        COERCIONS.put(class$java$lang$Short == null ? (class$java$lang$Short = CoerceLuaToJava.class$("java.lang.Short")) : class$java$lang$Short, coercion4);
        COERCIONS.put(Integer.TYPE, coercion5);
        COERCIONS.put(class$java$lang$Integer == null ? (class$java$lang$Integer = CoerceLuaToJava.class$("java.lang.Integer")) : class$java$lang$Integer, coercion5);
        COERCIONS.put(Long.TYPE, coercion6);
        COERCIONS.put(class$java$lang$Long == null ? (class$java$lang$Long = CoerceLuaToJava.class$("java.lang.Long")) : class$java$lang$Long, coercion6);
        COERCIONS.put(Float.TYPE, coercion7);
        COERCIONS.put(class$java$lang$Float == null ? (class$java$lang$Float = CoerceLuaToJava.class$("java.lang.Float")) : class$java$lang$Float, coercion7);
        COERCIONS.put(Double.TYPE, coercion8);
        COERCIONS.put(class$java$lang$Double == null ? (class$java$lang$Double = CoerceLuaToJava.class$("java.lang.Double")) : class$java$lang$Double, coercion8);
        COERCIONS.put(class$java$lang$String == null ? (class$java$lang$String = CoerceLuaToJava.class$("java.lang.String")) : class$java$lang$String, coercion9);
        COERCIONS.put(class$java$lang$Object == null ? (class$java$lang$Object = CoerceLuaToJava.class$("java.lang.Object")) : class$java$lang$Object, coercion10);
    }

    public static interface Coercion {
        public Object coerce(LValue var1);

        public int score(LValue var1);
    }
}

