/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.lib.j2se;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.luaj.lib.j2se.CoerceJavaToLua;
import org.luaj.lib.j2se.CoerceLuaToJava;
import org.luaj.vm.LFunction;
import org.luaj.vm.LInteger;
import org.luaj.vm.LString;
import org.luaj.vm.LTable;
import org.luaj.vm.LUserData;
import org.luaj.vm.LValue;
import org.luaj.vm.LuaErrorException;
import org.luaj.vm.LuaState;

public final class LuajavaLib
extends LFunction {
    static final int INIT = 0;
    static final int BINDCLASS = 1;
    static final int NEWINSTANCE = 2;
    static final int NEW = 3;
    static final int CREATEPROXY = 4;
    static final int LOADLIB = 5;
    static final String[] NAMES = new String[]{"luajava", "bindClass", "newInstance", "new", "createProxy", "loadLib"};
    static final Map classMetatables = new HashMap();
    static final int METHOD_MODIFIERS_VARARGS = 128;
    static final Map consCache = new HashMap();
    static final Map consIndex = new HashMap();
    static final Map methCache = new HashMap();
    static final Map methIndex = new HashMap();
    private int id;
    static LString LENGTH = LString.valueOf("length");
    static /* synthetic */ Class class$org$luaj$vm$LuaState;

    public static void install(LTable lTable) {
        LTable lTable2 = new LTable();
        for (int i = 0; i < NAMES.length; ++i) {
            lTable2.put(NAMES[i], (LValue)new LuajavaLib(i));
        }
        lTable.put("luajava", (LValue)lTable2);
    }

    public LuajavaLib() {
    }

    private LuajavaLib(int n) {
        this.id = n;
    }

    public String toString() {
        return "luajava." + NAMES[this.id];
    }

    public boolean luaStackCall(final LuaState luaState) {
        switch (this.id) {
            case 0: {
                LuajavaLib.install(luaState._G);
                break;
            }
            case 1: {
                String string = luaState.tostring(2);
                try {
                    Class<?> clazz = Class.forName(string);
                    luaState.resettop();
                    luaState.pushlvalue(LuajavaLib.toUserdata(clazz, clazz));
                    break;
                }
                catch (Exception exception) {
                    throw new LuaErrorException(exception);
                }
            }
            case 2: 
            case 3: {
                try {
                    LValue lValue = luaState.topointer(2);
                    Class clazz = this.id == 2 ? Class.forName(lValue.toJavaString()) : (Class)lValue.toJavaInstance();
                    ParamsList paramsList = new ParamsList(luaState);
                    Constructor constructor = LuajavaLib.resolveConstructor(clazz, paramsList);
                    boolean bl = (constructor.getModifiers() & 0x80) != 0;
                    Object[] objectArray = CoerceLuaToJava.coerceArgs(paramsList.values, constructor.getParameterTypes(), bl);
                    Object t = constructor.newInstance(objectArray);
                    luaState.resettop();
                    luaState.pushlvalue(LuajavaLib.toUserdata(t, clazz));
                    break;
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new LuaErrorException(invocationTargetException.getTargetException());
                }
                catch (Exception exception) {
                    throw new LuaErrorException(exception);
                }
            }
            case 4: {
                int n = Math.max(0, luaState.gettop() - 2);
                if (n <= 0) {
                    throw new LuaErrorException("no interfaces");
                }
                final LTable lTable = luaState.totable(-1);
                try {
                    Class[] classArray = new Class[n];
                    for (int i = 0; i < n; ++i) {
                        classArray[i] = Class.forName(luaState.tostring(i + 2));
                    }
                    InvocationHandler invocationHandler = new InvocationHandler(){

                        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                            luaState.pushlvalue(lTable);
                            luaState.getfield(-1, LString.valueOf(method.getName()));
                            luaState.remove(-2);
                            if (!luaState.isnil(-1)) {
                                int n;
                                boolean bl = (method.getModifiers() & 0x80) != 0;
                                int n2 = n = objectArray != null ? objectArray.length : 0;
                                if (bl) {
                                    int n3;
                                    Object object2 = objectArray[--n];
                                    int n4 = Array.getLength(object2);
                                    for (n3 = 0; n3 < n; ++n3) {
                                        luaState.pushlvalue(CoerceJavaToLua.coerce(objectArray[n3]));
                                    }
                                    for (n3 = 0; n3 < n4; ++n3) {
                                        luaState.pushlvalue(CoerceJavaToLua.coerce(Array.get(object2, n3)));
                                    }
                                    luaState.call(n + n4, 1);
                                } else {
                                    for (int i = 0; i < n; ++i) {
                                        luaState.pushlvalue(CoerceJavaToLua.coerce(objectArray[i]));
                                    }
                                    luaState.call(n, 1);
                                }
                            }
                            LValue lValue = luaState.poplvalue();
                            return CoerceLuaToJava.coerceArg(lValue, method.getReturnType());
                        }
                    };
                    Object object = Proxy.newProxyInstance(this.getClass().getClassLoader(), classArray, invocationHandler);
                    luaState.resettop();
                    luaState.pushuserdata(object);
                    break;
                }
                catch (Exception exception) {
                    throw new LuaErrorException(exception);
                }
            }
            case 5: {
                try {
                    String string = luaState.tostring(2);
                    String string2 = luaState.tostring(3);
                    Class<?> clazz = Class.forName(string);
                    Method method = clazz.getMethod(string2, class$org$luaj$vm$LuaState == null ? (class$org$luaj$vm$LuaState = LuajavaLib.class$("org.luaj.vm.LuaState")) : class$org$luaj$vm$LuaState);
                    Object object = method.invoke(clazz, luaState);
                    if (object instanceof Integer) {
                        int n = (Integer)object;
                        int n2 = luaState.gettop() - n;
                        for (int i = 0; i < n2; ++i) {
                            luaState.remove(1);
                        }
                        break;
                    }
                    luaState.resettop();
                    break;
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new LuaErrorException(invocationTargetException.getTargetException());
                }
                catch (Exception exception) {
                    throw new LuaErrorException(exception);
                }
            }
            default: {
                throw new LuaErrorException("not yet supported: " + this);
            }
        }
        return false;
    }

    static LUserData toUserdata(Object object, final Class clazz) {
        LTable lTable = (LTable)classMetatables.get(clazz);
        if (lTable == null) {
            lTable = new LTable();
            lTable.put(LValue.TM_INDEX, (LValue)new LFunction(){

                public boolean luaStackCall(LuaState luaState) {
                    Object object = luaState.touserdata(2);
                    LValue lValue = luaState.topointer(3);
                    if (lValue instanceof LInteger && clazz.isArray()) {
                        luaState.resettop();
                        int n = lValue.toJavaInt() - 1;
                        if (n >= 0 && n < Array.getLength(object)) {
                            luaState.pushlvalue(CoerceJavaToLua.coerce(Array.get(object, n)));
                        } else {
                            luaState.pushnil();
                        }
                        return false;
                    }
                    String string = lValue.toJavaString();
                    luaState.resettop();
                    try {
                        Field field = clazz.getField(string);
                        Object object2 = field.get(object);
                        luaState.pushlvalue(CoerceJavaToLua.coerce(object2));
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        if (clazz.isArray() && lValue.equals(LENGTH)) {
                            luaState.pushinteger(Array.getLength(object));
                        } else {
                            luaState.pushlvalue(new LMethod(clazz, string));
                        }
                    }
                    catch (Exception exception) {
                        throw new LuaErrorException(exception);
                    }
                    return false;
                }
            });
            lTable.put(LValue.TM_NEWINDEX, (LValue)new LFunction(){

                public boolean luaStackCall(LuaState luaState) {
                    Object object = luaState.touserdata(2);
                    LValue lValue = luaState.topointer(3);
                    LValue lValue2 = luaState.topointer(4);
                    if (lValue instanceof LInteger && clazz.isArray()) {
                        luaState.resettop();
                        Object object2 = CoerceLuaToJava.coerceArg(lValue2, clazz.getComponentType());
                        int n = lValue.toJavaInt() - 1;
                        if (n < 0 || n >= Array.getLength(object)) {
                            throw new LuaErrorException("array bounds exceeded " + n);
                        }
                        Array.set(object, lValue.toJavaInt() - 1, object2);
                        luaState.resettop();
                        return false;
                    }
                    String string = lValue.toJavaString();
                    try {
                        Field field = clazz.getField(string);
                        Object object3 = CoerceLuaToJava.coerceArg(lValue2, field.getType());
                        field.set(object, object3);
                        luaState.resettop();
                    }
                    catch (Exception exception) {
                        throw new LuaErrorException(exception);
                    }
                    return false;
                }
            });
            classMetatables.put(clazz, lTable);
        }
        return new LUserData(object, lTable);
    }

    static Constructor resolveConstructor(Class clazz, ParamsList paramsList) {
        Constructor constructor;
        HashMap<ParamsList, Constructor> hashMap = (HashMap<ParamsList, Constructor>)consCache.get(clazz);
        if (hashMap == null) {
            hashMap = new HashMap<ParamsList, Constructor>();
            consCache.put(clazz, hashMap);
        }
        if ((constructor = (Constructor)hashMap.get(paramsList)) != null) {
            return constructor;
        }
        Constructor[] constructorArray = (Constructor[])consIndex.get(clazz);
        if (constructorArray == null) {
            constructorArray = clazz.getConstructors();
            consIndex.put(clazz, constructorArray);
            if (constructorArray == null) {
                throw new IllegalArgumentException("no public constructors");
            }
        }
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        int n3 = constructorArray.length;
        for (int i = 0; i < n3; ++i) {
            Constructor constructor2 = constructorArray[i];
            int n4 = CoerceLuaToJava.scoreParamTypes(paramsList.values, constructor2.getParameterTypes());
            if (n4 >= n) continue;
            n = n4;
            n2 = i;
        }
        constructor = constructorArray[n2];
        if (!paramsList.cantcache) {
            hashMap.put(paramsList, constructor);
        }
        return constructor;
    }

    static Method resolveMethod(Class clazz, String string, ParamsList paramsList) {
        int n;
        Method[] methodArray;
        Method method;
        HashMap<ParamsList, Method> hashMap;
        HashMap hashMap2 = (HashMap)methCache.get(clazz);
        if (hashMap2 == null) {
            hashMap2 = new HashMap();
            methCache.put(clazz, hashMap2);
        }
        if ((hashMap = (HashMap<ParamsList, Method>)hashMap2.get(string)) == null) {
            hashMap = new HashMap<ParamsList, Method>();
            hashMap2.put(string, hashMap);
        }
        if ((method = (Method)hashMap.get(paramsList)) != null) {
            return method;
        }
        HashMap<String, ArrayList<Method>> hashMap3 = (HashMap<String, ArrayList<Method>>)methIndex.get(clazz);
        if (hashMap3 == null) {
            hashMap3 = new HashMap<String, ArrayList<Method>>();
            methIndex.put(clazz, hashMap3);
            methodArray = clazz.getMethods();
            for (n = 0; n < methodArray.length; ++n) {
                Method method2 = methodArray[n];
                String string2 = method2.getName();
                ArrayList<Method> arrayList = (ArrayList<Method>)hashMap3.get(string2);
                if (arrayList == null) {
                    arrayList = new ArrayList<Method>();
                    hashMap3.put(string2, arrayList);
                }
                arrayList.add(method2);
            }
        }
        if ((methodArray = (Method[])hashMap3.get(string)) == null) {
            throw new IllegalArgumentException("no method named '" + string + "'");
        }
        if (methodArray.size() == 1) {
            method = (Method)methodArray.get(0);
            if (!paramsList.cantcache) {
                hashMap.put(paramsList, method);
            }
            return method;
        }
        n = Integer.MAX_VALUE;
        int n2 = 0;
        int n3 = methodArray.size();
        for (int i = 0; i < n3; ++i) {
            Method method3 = (Method)methodArray.get(i);
            int n4 = CoerceLuaToJava.scoreParamTypes(paramsList.values, method3.getParameterTypes());
            if (n4 >= n) continue;
            n = n4;
            n2 = i;
        }
        method = (Method)methodArray.get(n2);
        if (!paramsList.cantcache) {
            hashMap.put(paramsList, method);
        }
        return method;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static final class LMethod
    extends LFunction {
        private final Class clazz;
        private final String s;

        private LMethod(Class clazz, String string) {
            this.clazz = clazz;
            this.s = string;
        }

        public String toString() {
            return this.clazz.getName() + "." + this.s + "()";
        }

        public boolean luaStackCall(LuaState luaState) {
            try {
                Object object = luaState.touserdata(2);
                ParamsList paramsList = new ParamsList(luaState);
                Method method = LuajavaLib.resolveMethod(this.clazz, this.s, paramsList);
                boolean bl = (method.getModifiers() & 0x80) != 0;
                Object[] objectArray = CoerceLuaToJava.coerceArgs(paramsList.values, method.getParameterTypes(), bl);
                Object object2 = method.invoke(object, objectArray);
                luaState.resettop();
                luaState.pushlvalue(CoerceJavaToLua.coerce(object2));
                return false;
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new LuaErrorException(invocationTargetException.getTargetException());
            }
            catch (Exception exception) {
                throw new LuaErrorException(exception);
            }
        }
    }

    public static class ParamsList {
        public final LValue[] values;
        public final Class[] classes;
        public int hash;
        public boolean cantcache;

        ParamsList(LuaState luaState) {
            int n = Math.max(luaState.gettop() - 2, 0);
            this.values = new LValue[n];
            this.classes = new Class[n];
            for (int i = 0; i < n; ++i) {
                this.values[i] = luaState.topointer(i - n);
                this.classes[i] = this.values[i].getClass();
                this.hash += this.classes[i].hashCode();
                Class clazz = this.classes[i];
                if (!(this.values[i] instanceof LUserData) && !(this.values[i] instanceof LTable)) continue;
                this.cantcache = true;
            }
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            return object instanceof ParamsList ? Arrays.equals(this.classes, ((ParamsList)object).classes) : false;
        }
    }
}

