/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.script;

import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class ScriptEngineSample {
    public static void main(String[] stringArray) {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptEngine scriptEngine = scriptEngineManager.getEngineByExtension(".lua");
        ScriptEngineFactory scriptEngineFactory = scriptEngine.getFactory();
        System.out.println("Engine name: " + scriptEngineFactory.getEngineName());
        System.out.println("Engine Version: " + scriptEngineFactory.getEngineVersion());
        System.out.println("LanguageName: " + scriptEngineFactory.getLanguageName());
        System.out.println("Language Version: " + scriptEngineFactory.getLanguageVersion());
        String string = scriptEngineFactory.getOutputStatement("\"hello, world\"");
        System.out.println(string);
        try {
            scriptEngine.eval(string);
            scriptEngine.put("x", 25);
            scriptEngine.eval("y = math.sqrt(x)");
            System.out.println("y=" + scriptEngine.get("y"));
            scriptEngine.put("x", 2);
            scriptEngine.eval("y = math.sqrt(x)");
            System.out.println("y=" + scriptEngine.get("y"));
            CompiledScript compiledScript = ((Compilable)((Object)scriptEngine)).compile("y = math.sqrt(x); return y");
            Bindings bindings = scriptEngine.createBindings();
            bindings.put("x", (Object)3);
            System.out.println("eval: " + compiledScript.eval(bindings));
            System.out.println("y=" + bindings.get("y"));
            scriptEngine.eval("\n\nbogus example\n\n");
        }
        catch (ScriptException scriptException) {
            scriptException.printStackTrace();
        }
    }
}

