/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm;

import org.luaj.vm.LInteger;
import org.luaj.vm.LNumber;
import org.luaj.vm.LValue;
import org.luaj.vm.LuaState;
import org.luaj.vm.Platform;

public class LDouble
extends LNumber {
    private final double m_value;

    public static LDouble valueOf(double d) {
        return new LDouble(d);
    }

    public static LNumber numberOf(double d) {
        int n = (int)d;
        return d == (double)n ? LInteger.valueOf(n) : new LDouble(d);
    }

    public LDouble(double d) {
        this.m_value = d;
    }

    public int hashCode() {
        if (this.m_value == 0.0) {
            return 0;
        }
        int n = (int)this.m_value;
        if ((double)n == this.m_value) {
            return n;
        }
        long l = Double.doubleToLongBits(this.m_value);
        return (int)(l >> 32) + (int)l;
    }

    public String toJavaString() {
        if (Double.isNaN(this.m_value)) {
            return "nan";
        }
        if (Double.isInfinite(this.m_value)) {
            return this.m_value > 0.0 ? "inf" : "-inf";
        }
        if (this.m_value == 0.0) {
            long l = Double.doubleToLongBits(this.m_value);
            return l >> 63 == 0L ? "0" : "-0";
        }
        long l = (long)this.m_value;
        if (this.m_value == (double)l && this.m_value <= 9.223372036854776E18 && this.m_value >= -9.223372036854776E18) {
            return Long.toString(l);
        }
        return Double.toString(this.m_value);
    }

    public boolean isInteger() {
        return (double)((int)this.m_value) == this.m_value;
    }

    public boolean isValidKey() {
        return !Double.isNaN(this.m_value);
    }

    public LValue luaBinOpUnknown(int n, LValue lValue) {
        return lValue.luaBinOpDouble(n, this.m_value);
    }

    public LValue luaBinOpInteger(int n, int n2) {
        return LDouble.luaBinOpDoubleDouble(n, this.m_value, n2);
    }

    public LValue luaBinOpDouble(int n, double d) {
        return LDouble.luaBinOpDoubleDouble(n, this.m_value, d);
    }

    public static LValue luaBinOpDoubleDouble(int n, double d, double d2) {
        switch (n) {
            case 12: {
                return LDouble.numberOf(d + d2);
            }
            case 13: {
                return LDouble.numberOf(d - d2);
            }
            case 14: {
                return LDouble.numberOf(d * d2);
            }
            case 15: {
                return LDouble.numberOf(d / d2);
            }
            case 16: {
                return LDouble.numberOf(d - Math.floor(d / d2) * d2);
            }
            case 17: {
                return Platform.getInstance().mathPow(LDouble.numberOf(d), LDouble.numberOf(d2));
            }
        }
        LuaState.vmerror("bad bin opcode");
        return null;
    }

    public int toJavaInt() {
        return (int)this.m_value;
    }

    public long toJavaLong() {
        return (long)this.m_value;
    }

    public float toJavaFloat() {
        return (float)this.m_value;
    }

    public double toJavaDouble() {
        return this.m_value;
    }

    public boolean luaBinCmpUnknown(int n, LValue lValue) {
        return lValue.luaBinCmpDouble(n, this.m_value);
    }

    public boolean luaBinCmpInteger(int n, int n2) {
        return LDouble.luaBinCmpDoubleDouble(n, this.m_value, n2);
    }

    public boolean luaBinCmpDouble(int n, double d) {
        return LDouble.luaBinCmpDoubleDouble(n, this.m_value, d);
    }

    public static boolean luaBinCmpDoubleDouble(int n, double d, double d2) {
        switch (n) {
            case 23: {
                return d == d2;
            }
            case 24: {
                return d < d2;
            }
            case 25: {
                return d <= d2;
            }
        }
        LuaState.vmerror("bad cmp opcode");
        return false;
    }

    public LValue luaUnaryMinus() {
        return new LDouble(-this.m_value);
    }
}

