/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm;

import org.luaj.vm.LDouble;
import org.luaj.vm.LNumber;
import org.luaj.vm.LString;
import org.luaj.vm.LValue;
import org.luaj.vm.LuaState;

public class LInteger
extends LNumber {
    private final int m_value;
    private static final int INTS_MIN = -16;
    private static final int INTS_MAX = 32;
    private static final LInteger[] s_ints = new LInteger[49];

    public static LInteger valueOf(int n) {
        if (n >= -16 && n <= 32) {
            return s_ints[n - -16];
        }
        return new LInteger(n);
    }

    private LInteger(int n) {
        this.m_value = n;
    }

    public final int hashCode() {
        return LInteger.hashCodeOf(this.m_value);
    }

    public static int hashCodeOf(int n) {
        return n;
    }

    public int toJavaInt() {
        return this.m_value;
    }

    public long toJavaLong() {
        return this.m_value;
    }

    public float toJavaFloat() {
        return this.m_value;
    }

    public double toJavaDouble() {
        return this.m_value;
    }

    public LString luaAsString() {
        return LString.valueOf(this.m_value);
    }

    public String toJavaString() {
        return String.valueOf(this.m_value);
    }

    public boolean isInteger() {
        return true;
    }

    public LValue luaBinOpUnknown(int n, LValue lValue) {
        return lValue.luaBinOpInteger(n, this.m_value);
    }

    public LValue luaBinOpInteger(int n, int n2) {
        switch (n) {
            case 12: {
                return LInteger.valueOf(this.m_value + n2);
            }
            case 13: {
                return LInteger.valueOf(this.m_value - n2);
            }
            case 14: {
                return LInteger.valueOf(this.m_value * n2);
            }
            case 15: 
            case 16: 
            case 17: {
                return LDouble.luaBinOpDoubleDouble(n, this.m_value, n2);
            }
        }
        LuaState.vmerror("bad bin opcode");
        return null;
    }

    public LValue luaBinOpDouble(int n, double d) {
        return LDouble.luaBinOpDoubleDouble(n, this.m_value, d);
    }

    public boolean luaBinCmpUnknown(int n, LValue lValue) {
        return lValue.luaBinCmpInteger(n, this.m_value);
    }

    public boolean luaBinCmpInteger(int n, int n2) {
        switch (n) {
            case 23: {
                return this.m_value == n2;
            }
            case 24: {
                return this.m_value < n2;
            }
            case 25: {
                return this.m_value <= n2;
            }
        }
        LuaState.vmerror("bad cmp opcode");
        return false;
    }

    public boolean luaBinCmpDouble(int n, double d) {
        return LDouble.luaBinCmpDoubleDouble(n, this.m_value, d);
    }

    public LValue luaUnaryMinus() {
        return LInteger.valueOf(-this.m_value);
    }

    static {
        for (int i = -16; i <= 32; ++i) {
            LInteger.s_ints[i - -16] = new LInteger(i);
        }
    }
}

