/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Stack;
import org.luaj.lib.BaseLib;
import org.luaj.lib.CoroutineLib;
import org.luaj.lib.MathLib;
import org.luaj.lib.PackageLib;
import org.luaj.lib.StringLib;
import org.luaj.lib.TableLib;
import org.luaj.vm.CallInfo;
import org.luaj.vm.LBoolean;
import org.luaj.vm.LClosure;
import org.luaj.vm.LDouble;
import org.luaj.vm.LFunction;
import org.luaj.vm.LInteger;
import org.luaj.vm.LNil;
import org.luaj.vm.LNumber;
import org.luaj.vm.LPrototype;
import org.luaj.vm.LString;
import org.luaj.vm.LTable;
import org.luaj.vm.LThread;
import org.luaj.vm.LUserData;
import org.luaj.vm.LValue;
import org.luaj.vm.LoadState;
import org.luaj.vm.Lua;
import org.luaj.vm.LuaErrorException;
import org.luaj.vm.UpVal;

public class LuaState
extends Lua {
    public static final int LUA_YIELD = 1;
    public static final int LUA_ERRRUN = 2;
    public static final int LUA_ERRSYNTAX = 3;
    public static final int LUA_ERRMEM = 4;
    public static final int LUA_ERRERR = 5;
    private static final int LUA_MINSTACK = 20;
    private static final int LUA_MINCALLS = 10;
    private static final int MAXTAGLOOP = 100;
    private static final int LUA_HOOKCALL = 0;
    private static final int LUA_HOOKRET = 1;
    private static final int LUA_HOOKLINE = 2;
    private static final int LUA_HOOKCOUNT = 3;
    private static final int LUA_HOOKTAILRET = 4;
    public static final int LUA_MASKCALL = 1;
    public static final int LUA_MASKRET = 2;
    public static final int LUA_MASKLINE = 4;
    public int base = 0;
    public int top = 0;
    protected int nresults = -1;
    public LValue[] stack = new LValue[20];
    public int cc = -1;
    public CallInfo[] calls;
    protected Stack upvals = new Stack();
    protected LValue errfunc;
    static LuaState mainState;
    public LTable _G;
    private boolean hooksenabled;
    private boolean inhook;
    private int hookmask;
    private int hookcount;
    private LFunction hookfunc;
    private int hookincr;
    private int hookline;
    private int hookcc;

    protected void debugHooks(int n) {
    }

    protected void debugAssert(boolean bl) {
    }

    protected LuaState() {
        this(new LTable());
        mainState = this;
    }

    LuaState(LTable lTable) {
        this._G = lTable;
        this.calls = new CallInfo[10];
        for (int i = 0; i < 10; ++i) {
            this.calls[i] = new CallInfo();
        }
    }

    public void init() {
    }

    public void shutdown() {
    }

    public void installStandardLibs() {
        PackageLib.install(this._G);
        BaseLib.install(this._G);
        CoroutineLib.install(this._G);
        MathLib.install(this._G);
        TableLib.install(this._G);
        StringLib.install(this._G);
    }

    public void prepStackCall() {
        int n;
        int n2;
        int n3;
        LClosure lClosure = (LClosure)this.stack[this.base];
        int n4 = this.base++;
        this.checkstack(lClosure.p.maxstacksize);
        if (lClosure.p.is_vararg == 0) {
            this.luaV_adjusttop(this.base + lClosure.p.numparams);
        } else {
            n3 = lClosure.p.numparams;
            int n5 = Math.max(0, this.top - this.base - 1);
            n2 = Math.min(n5, n3);
            n = Math.max(0, n5 - n2);
            this.stack[this.top] = LInteger.valueOf(n);
            System.arraycopy(this.stack, this.base + 1, this.stack, this.top + 1, n2);
            this.base = this.top + 1;
            this.top = this.base + n2;
            this.luaV_adjusttop(this.base + n3);
            if ((lClosure.p.is_vararg & 4) != 0) {
                LTable lTable = new LTable(n, 1);
                int n6 = 1;
                int n7 = this.base - n - 1;
                while (n6 <= n) {
                    lTable.put(n6, this.stack[n7]);
                    ++n6;
                    ++n7;
                }
                lTable.put("n", n);
                this.pushlvalue(lTable);
            }
        }
        n3 = this.cc + 1;
        if (n3 >= this.calls.length) {
            CallInfo[] callInfoArray = new CallInfo[this.calls.length * 2];
            System.arraycopy(this.calls, 0, callInfoArray, 0, this.cc + 1);
            n = callInfoArray.length;
            for (n2 = this.calls.length; n2 < n; ++n2) {
                callInfoArray[n2] = new CallInfo();
            }
            this.calls = callInfoArray;
        }
        this.calls[n3].init(lClosure, this.base, this.top, n4, this.nresults);
        this.cc = n3;
        this.stackClear(this.top, this.base + lClosure.p.maxstacksize);
    }

    public void execute() {
        int n = this.cc;
        while (this.cc >= n) {
            this.exec();
        }
    }

    public void doCall(LClosure lClosure, LValue[] lValueArray) {
        int n;
        this.settop(0);
        this.pushlvalue(lClosure);
        int n2 = n = lValueArray != null ? lValueArray.length : 0;
        for (int i = 0; i < n; ++i) {
            this.pushlvalue(lValueArray[i]);
        }
        this.prepStackCall();
        this.execute();
        this.base = this.cc >= 0 ? this.calls[this.cc].base : 0;
    }

    public void invokeJavaFunction(LFunction lFunction) {
        ++this.base;
        if (this.hooksenabled && !this.inhook) {
            this.debugCallHooks();
        }
        int n = lFunction.invoke(this);
        if (this.hooksenabled && !this.inhook) {
            this.debugReturnHooks();
        }
        if (n < 0) {
            n = this.top - this.base;
        }
        System.arraycopy(this.stack, this.top - n, this.stack, --this.base, n);
        this.luaV_settop_fillabove(this.base + n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void call(int n, int n2) {
        int n3 = this.base;
        int n4 = this.cc;
        try {
            int n5 = this.base = this.top - 1 - n;
            this.nresults = n2;
            if (this.stack[this.base].luaStackCall(this)) {
                if (this.hooksenabled && !this.inhook) {
                    this.debugCallHooks();
                }
                this.execute();
            }
            if (n2 >= 0) {
                this.luaV_adjusttop(n5 + n2);
            }
        }
        finally {
            this.base = n3;
            while (this.cc > n4) {
                --this.cc;
                this.calls[this.cc].closure = null;
            }
        }
    }

    public int pcall(int n, int n2) {
        int n3 = this.top;
        int n4 = this.base;
        int n5 = this.cc;
        try {
            int n6 = this.base = this.top - 1 - n;
            this.nresults = n2;
            if (this.stack[this.base].luaStackCall(this)) {
                if (this.hooksenabled) {
                    this.debugCallHooks();
                }
                this.execute();
            }
            if (n2 >= 0) {
                this.luaV_adjusttop(n6 + n2);
            }
            this.base = n4;
            return 0;
        }
        catch (Throwable throwable) {
            this.base = n4;
            while (this.cc > n5) {
                --this.cc;
                this.calls[this.cc].closure = null;
            }
            this.closeUpVals(n3);
            String string = throwable.getMessage();
            this.resettop();
            if (string != null) {
                this.pushstring(string);
            } else {
                this.pushnil();
            }
            return throwable instanceof OutOfMemoryError ? 4 : 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int xpcall(int n, int n2, LValue lValue) {
        LValue lValue2 = this.errfunc;
        try {
            this.errfunc = lValue;
            int n3 = this.pcall(n, n2);
            return n3;
        }
        finally {
            this.errfunc = lValue2;
        }
    }

    public int load(InputStream inputStream, String string) {
        try {
            LPrototype lPrototype = LoadState.undump(this, inputStream, string);
            this.pushlvalue(lPrototype.newClosure(this._G));
            return 0;
        }
        catch (Throwable throwable) {
            this.pushstring(throwable.getMessage());
            return throwable instanceof OutOfMemoryError ? 4 : 3;
        }
    }

    private LValue RKBC(LValue[] lValueArray, int n) {
        return Lua.ISK(n) ? lValueArray[Lua.INDEXK(n)] : this.stack[this.base + n];
    }

    private LValue GETARG_RKB(LValue[] lValueArray, int n) {
        return this.RKBC(lValueArray, Lua.GETARG_B(n));
    }

    private LValue GETARG_RKC(LValue[] lValueArray, int n) {
        return this.RKBC(lValueArray, Lua.GETARG_C(n));
    }

    private final void stackClear(int n, int n2) {
        while (n < n2) {
            this.stack[n] = LNil.NIL;
            ++n;
        }
    }

    public void exec() {
        if (this.cc < 0) {
            return;
        }
        CallInfo callInfo = this.calls[this.cc];
        LClosure lClosure = callInfo.closure;
        LPrototype lPrototype = lClosure.p;
        int[] nArray = lPrototype.code;
        LValue[] lValueArray = lPrototype.k;
        this.base = callInfo.base;
        block35: while (true) {
            this.debugAssert(callInfo == this.calls[this.cc]);
            callInfo.top = this.top;
            this.debugHooks(callInfo.pc);
            int n = nArray[callInfo.pc++];
            if (this.hooksenabled && !this.inhook) {
                this.debugBytecodeHooks(callInfo.pc - 1);
            }
            int n2 = n >> 0 & 0x3F;
            int n3 = n >> 6 & 0xFF;
            switch (n2) {
                case 0: {
                    int n4 = Lua.GETARG_B(n);
                    this.stack[this.base + n3] = this.stack[this.base + n4];
                    continue block35;
                }
                case 1: {
                    int n4 = Lua.GETARG_Bx(n);
                    this.stack[this.base + n3] = lValueArray[n4];
                    continue block35;
                }
                case 2: {
                    int n4 = Lua.GETARG_B(n);
                    int n5 = Lua.GETARG_C(n);
                    LValue lValue = this.stack[this.base + n3] = n4 != 0 ? LBoolean.TRUE : LBoolean.FALSE;
                    if (n5 == 0) continue block35;
                    ++callInfo.pc;
                    continue block35;
                }
                case 3: {
                    int n4 = Lua.GETARG_B(n);
                    do {
                        this.stack[this.base + n4] = LNil.NIL;
                    } while (--n4 >= n3);
                    continue block35;
                }
                case 4: {
                    int n4 = Lua.GETARG_B(n);
                    this.stack[this.base + n3] = lClosure.upVals[n4].getValue();
                    continue block35;
                }
                case 5: {
                    LValue lValue;
                    int n4 = Lua.GETARG_Bx(n);
                    LValue lValue2 = lValueArray[n4];
                    LValue lValue3 = lClosure.env;
                    this.stack[this.base + n3] = lValue = this.luaV_gettable(lValue3, lValue2);
                    continue block35;
                }
                case 6: {
                    LValue lValue;
                    int n4 = Lua.GETARG_B(n);
                    LValue lValue2 = this.GETARG_RKC(lValueArray, n);
                    LValue lValue3 = this.stack[this.base + n4];
                    this.stack[this.base + n3] = lValue = this.luaV_gettable(lValue3, lValue2);
                    continue block35;
                }
                case 7: {
                    int n4 = Lua.GETARG_Bx(n);
                    LValue lValue2 = lValueArray[n4];
                    LValue lValue = this.stack[this.base + n3];
                    LValue lValue3 = lClosure.env;
                    this.luaV_settable(lValue3, lValue2, lValue);
                    continue block35;
                }
                case 8: {
                    int n4 = Lua.GETARG_B(n);
                    lClosure.upVals[n4].setValue(this.stack[this.base + n3]);
                    continue block35;
                }
                case 9: {
                    LValue lValue2 = this.GETARG_RKB(lValueArray, n);
                    LValue lValue = this.GETARG_RKC(lValueArray, n);
                    LValue lValue3 = this.stack[this.base + n3];
                    this.luaV_settable(lValue3, lValue2, lValue);
                    continue block35;
                }
                case 10: {
                    int n4 = Lua.GETARG_B(n);
                    int n5 = Lua.GETARG_C(n);
                    this.stack[this.base + n3] = new LTable(n4, n5);
                    continue block35;
                }
                case 11: {
                    LValue lValue;
                    LValue lValue4 = this.stack[this.base + Lua.GETARG_B(n)];
                    LValue lValue5 = this.GETARG_RKC(lValueArray, n);
                    this.stack[this.base + n3] = lValue = this.luaV_gettable(lValue4, lValue5);
                    this.stack[this.base + n3 + 1] = lValue4;
                    continue block35;
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    LValue lValue4 = this.GETARG_RKB(lValueArray, n);
                    LValue lValue5 = this.GETARG_RKC(lValueArray, n);
                    this.stack[this.base + n3] = lValue5.luaBinOpUnknown(n2, lValue4);
                    continue block35;
                }
                case 18: {
                    LValue lValue4 = this.GETARG_RKB(lValueArray, n);
                    this.stack[this.base + n3] = lValue4.luaUnaryMinus();
                    continue block35;
                }
                case 19: {
                    LValue lValue4 = this.GETARG_RKB(lValueArray, n);
                    this.stack[this.base + n3] = !lValue4.toJavaBoolean() ? LBoolean.TRUE : LBoolean.FALSE;
                    continue block35;
                }
                case 20: {
                    LValue lValue4 = this.GETARG_RKB(lValueArray, n);
                    this.stack[this.base + n3] = LInteger.valueOf(lValue4.luaLength());
                    continue block35;
                }
                case 21: {
                    int n4 = Lua.GETARG_B(n);
                    int n5 = Lua.GETARG_C(n);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    int n6 = n4;
                    int n7 = 0;
                    while (n6 <= n5) {
                        this.stack[this.base + n6].luaConcatTo(byteArrayOutputStream);
                        ++n6;
                        ++n7;
                    }
                    this.stack[this.base + n3] = new LString(byteArrayOutputStream.toByteArray());
                    continue block35;
                }
                case 22: {
                    callInfo.pc += Lua.GETARG_sBx(n);
                    continue block35;
                }
                case 23: 
                case 24: 
                case 25: {
                    LValue lValue4 = this.GETARG_RKB(lValueArray, n);
                    LValue lValue5 = this.GETARG_RKC(lValueArray, n);
                    boolean bl = lValue5.luaBinCmpUnknown(n2, lValue4);
                    if (bl != (n3 == 0)) continue block35;
                    ++callInfo.pc;
                    continue block35;
                }
                case 26: {
                    int n5 = Lua.GETARG_C(n);
                    if (this.stack[this.base + n3].toJavaBoolean() == (n5 != 0)) continue block35;
                    ++callInfo.pc;
                    continue block35;
                }
                case 27: {
                    LValue lValue4 = this.stack[this.base + Lua.GETARG_B(n)];
                    int n5 = Lua.GETARG_C(n);
                    if (lValue4.toJavaBoolean() != (n5 != 0)) {
                        ++callInfo.pc;
                        continue block35;
                    }
                    this.stack[this.base + n3] = lValue4;
                    continue block35;
                }
                case 28: {
                    int n8;
                    this.base += n3;
                    int n4 = Lua.GETARG_B(n);
                    if (n4 != 0) {
                        this.luaV_settop_fillabove(this.base + n4);
                    }
                    this.nresults = n8 = Lua.GETARG_C(n) - 1;
                    if (this.stack[this.base].luaStackCall(this)) {
                        if (this.hooksenabled && !this.inhook) {
                            this.debugCallHooks();
                        }
                        return;
                    }
                    if (n8 >= 0) {
                        this.luaV_adjusttop(this.base + n8);
                    }
                    this.base = callInfo.base;
                    continue block35;
                }
                case 29: {
                    if (this.hooksenabled && !this.inhook) {
                        this.debugTailReturnHooks();
                    }
                    this.closeUpVals(this.base);
                    int n4 = Lua.GETARG_B(n);
                    if (n4 != 0) {
                        this.luaV_settop_fillabove(this.base + n3 + n4);
                    } else {
                        n4 = this.top - (this.base + n3);
                    }
                    int n8 = callInfo.nresults;
                    System.arraycopy(this.stack, this.base + n3, this.stack, callInfo.resultbase, n4);
                    this.base = callInfo.resultbase;
                    this.luaV_settop_fillabove(this.base + n4);
                    this.nresults = n8;
                    --this.cc;
                    this.calls[this.cc].closure = null;
                    try {
                        if (this.stack[this.base].luaStackCall(this)) {
                            if (this.hooksenabled && !this.inhook) {
                                this.debugCallHooks();
                            }
                            return;
                        }
                    }
                    catch (LuaErrorException luaErrorException) {
                        ++this.cc;
                        throw luaErrorException;
                    }
                    if (n8 >= 0) {
                        this.luaV_adjusttop(this.base + n8);
                    }
                    return;
                }
                case 30: {
                    if (this.hooksenabled && !this.inhook) {
                        this.debugReturnHooks();
                    }
                    this.closeUpVals(this.base);
                    int n4 = Lua.GETARG_B(n) - 1;
                    if (n4 >= 0) {
                        this.luaV_settop_fillabove(this.base + n3 + n4);
                    } else {
                        n4 = this.top - (this.base + n3);
                    }
                    System.arraycopy(this.stack, this.base + n3, this.stack, callInfo.resultbase, n4);
                    this.debugAssert(callInfo.resultbase + n4 <= this.top);
                    this.luaV_settop_fillabove(callInfo.resultbase + n4);
                    if (callInfo.nresults >= 0) {
                        this.luaV_adjusttop(callInfo.resultbase + callInfo.nresults);
                    }
                    --this.cc;
                    this.calls[this.cc].closure = null;
                    return;
                }
                case 31: {
                    LValue lValue = this.stack[this.base + n3];
                    LValue lValue6 = this.stack[this.base + n3 + 2];
                    LValue lValue7 = lValue6.luaBinOpUnknown(12, lValue);
                    LValue lValue8 = this.stack[this.base + n3 + 1];
                    boolean bl = lValue6.luaBinCmpInteger(24, 0);
                    boolean bl2 = bl ? lValue7.luaBinCmpUnknown(25, lValue8) : lValue8.luaBinCmpUnknown(25, lValue7);
                    if (!bl2) continue block35;
                    this.stack[this.base + n3] = lValue7;
                    this.stack[this.base + n3 + 3] = lValue7;
                    callInfo.pc += Lua.GETARG_sBx(n);
                    continue block35;
                }
                case 32: {
                    LValue lValue = this.stack[this.base + n3].luaToNumber();
                    LValue lValue8 = this.stack[this.base + n3 + 1].luaToNumber();
                    LValue lValue6 = this.stack[this.base + n3 + 2].luaToNumber();
                    if (lValue.isNil()) {
                        this.error("'for' initial value must be a number");
                    }
                    if (lValue8.isNil()) {
                        this.error("'for' limit must be a number");
                    }
                    if (lValue6.isNil()) {
                        this.error("'for' step must be a number");
                    }
                    this.stack[this.base + n3] = lValue6.luaBinOpUnknown(13, lValue);
                    this.stack[this.base + n3 + 1] = lValue8;
                    this.stack[this.base + n3 + 2] = lValue6;
                    int n4 = Lua.GETARG_sBx(n);
                    callInfo.pc += n4;
                    continue block35;
                }
                case 33: {
                    int n9;
                    int n5;
                    this.base = n9 = this.base + n3 + 3;
                    System.arraycopy(this.stack, n9 - 3, this.stack, n9, 3);
                    this.luaV_settop_fillabove(n9 + 3);
                    this.nresults = n5 = Lua.GETARG_C(n);
                    if (this.stack[n9].luaStackCall(this)) {
                        this.execute();
                    }
                    this.base = callInfo.base;
                    this.luaV_adjusttop(n9 + n5);
                    if (!this.stack[n9].isNil()) {
                        this.stack[n9 - 1] = this.stack[n9];
                        continue block35;
                    }
                    ++callInfo.pc;
                    continue block35;
                }
                case 34: {
                    int n4 = Lua.GETARG_B(n);
                    int n5 = Lua.GETARG_C(n);
                    int n10 = this.base + n3;
                    if (n4 == 0) {
                        n4 = this.top - n10 - 1;
                    }
                    if (n5 == 0) {
                        n5 = nArray[callInfo.pc++];
                    }
                    int n6 = (n5 - 1) * 50;
                    LTable lTable = (LTable)this.stack[this.base + n3];
                    lTable.arrayPresize(n6 + n4);
                    int n11 = 1;
                    while (true) {
                        if (n11 > n4) continue block35;
                        lTable.put(n6 + n11, this.stack[n10 + n11]);
                        ++n11;
                    }
                }
                case 35: {
                    this.closeUpVals(this.base + n3);
                    continue block35;
                }
                case 36: {
                    int n4 = Lua.GETARG_Bx(n);
                    LPrototype lPrototype2 = lClosure.p.p[n4];
                    LClosure lClosure2 = lPrototype2.newClosure(lClosure.env);
                    int n12 = 0;
                    while (n12 < lClosure2.upVals.length) {
                        n = nArray[callInfo.pc];
                        n2 = Lua.GET_OPCODE(n);
                        n4 = Lua.GETARG_B(n);
                        if (n2 == 4) {
                            lClosure2.upVals[n12] = lClosure.upVals[n4];
                        } else if (n2 == 0) {
                            lClosure2.upVals[n12] = this.findUpVal(this.base + n4);
                        } else {
                            throw new IllegalArgumentException("bad opcode: " + n2);
                        }
                        ++n12;
                        ++callInfo.pc;
                    }
                    this.stack[this.base + n3] = lClosure2;
                    continue block35;
                }
                case 37: {
                    int n4 = Lua.GETARG_B(n) - 1;
                    LValue lValue = this.stack[this.base - 1];
                    int n8 = lValue.toJavaInt();
                    if (n4 == -1) {
                        n4 = n8;
                        this.luaV_settop_fillabove(this.base + n3 + n4);
                    }
                    this.checkstack(n3 + n4);
                    int n13 = 0;
                    while (true) {
                        if (n13 >= n4) continue block35;
                        this.stack[this.base + n3 + n13] = n13 < n8 ? this.stack[this.base - n8 + n13 - 1] : LNil.NIL;
                        ++n13;
                    }
                }
            }
        }
    }

    public UpVal findUpVal(int n) {
        UpVal upVal;
        int n2;
        for (n2 = this.upvals.size() - 1; n2 >= 0; --n2) {
            upVal = (UpVal)this.upvals.elementAt(n2);
            if (upVal.state == this && upVal.position == n) {
                return upVal;
            }
            if (upVal.position < n) break;
        }
        upVal = new UpVal(this, n);
        this.upvals.insertElementAt(upVal, n2 + 1);
        return upVal;
    }

    public void closeUpVals(int n) {
        while (!this.upvals.empty() && ((UpVal)this.upvals.lastElement()).close(n)) {
            this.upvals.pop();
        }
    }

    public CallInfo getStackFrame(int n) {
        return this.calls[this.cc - n];
    }

    private void indexError(LValue lValue) {
        this.error("attempt to index ? (a " + lValue.luaGetTypeName() + " value)");
    }

    public static LValue luaV_getmetafield(LValue lValue, LString lString) {
        LTable lTable = lValue.luaGetMetatable();
        if (lTable == null) {
            return null;
        }
        LValue lValue2 = lTable.get(lString);
        return lValue2.isNil() ? null : lValue2;
    }

    public LValue luaV_gettable(LValue lValue, LValue lValue2) {
        LValue lValue3 = LNil.NIL;
        LValue lValue4 = lValue;
        for (int i = 0; i < 100; ++i) {
            if (lValue4.isTable()) {
                LValue lValue5 = ((LTable)lValue4).get(lValue2);
                if (!lValue5.isNil()) {
                    return lValue5;
                }
                lValue3 = LuaState.luaV_getmetafield(lValue4, LValue.TM_INDEX);
                if (lValue3 == null) {
                    return lValue5;
                }
            } else {
                lValue3 = LuaState.luaV_getmetafield(lValue4, LValue.TM_INDEX);
                if (lValue3 == null) {
                    this.indexError(lValue4);
                }
            }
            if (lValue3.isFunction()) {
                return ((LFunction)lValue3).__index(this, lValue, lValue2);
            }
            lValue4 = lValue3;
        }
        this.error("loop in gettable");
        return LNil.NIL;
    }

    public void luaV_settable(LValue lValue, LValue lValue2, LValue lValue3) {
        if (!lValue2.isValidKey()) {
            this.error("table index is " + lValue2.toJavaString());
        }
        LValue lValue4 = LNil.NIL;
        LValue lValue5 = lValue;
        for (int i = 0; i < 100; ++i) {
            if (lValue5.isTable()) {
                LTable lTable = (LTable)lValue5;
                if (lTable.containsKey(lValue2)) {
                    lTable.put(lValue2, lValue3);
                    return;
                }
                lValue4 = LuaState.luaV_getmetafield(lValue5, LValue.TM_NEWINDEX);
                if (lValue4 == null) {
                    lTable.put(lValue2, lValue3);
                    return;
                }
            } else {
                lValue4 = LuaState.luaV_getmetafield(lValue5, LValue.TM_NEWINDEX);
                if (lValue4 == null) {
                    this.indexError(lValue5);
                }
            }
            if (lValue4.isFunction()) {
                ((LFunction)lValue4).__newindex(this, lValue, lValue2, lValue3);
                return;
            }
            lValue5 = lValue4;
        }
        this.error("loop in settable");
    }

    private void luaV_adjusttop(int n) {
        while (this.top < n) {
            this.stack[this.top++] = LNil.NIL;
        }
        while (this.top > n) {
            this.stack[--this.top] = LNil.NIL;
        }
    }

    private void luaV_settop_fillabove(int n) {
        while (this.top > n) {
            this.stack[--this.top] = LNil.NIL;
        }
        this.top = n;
    }

    public String getSourceFileName(LString lString) {
        return this.getSourceFileName(lString.toJavaString());
    }

    protected String getSourceFileName(String string) {
        return LoadState.getSourceName(string);
    }

    protected String getFileLine(int n) {
        LClosure lClosure = null;
        for (int i = this.cc; i >= 0; --i) {
            CallInfo callInfo = this.calls[i];
            LFunction lFunction = callInfo.currentfunc(this);
            if (!(lFunction == null || lFunction.isClosure() && lFunction == lClosure || n == -1 || n-- > 0)) {
                return "[Java]: " + lFunction.toString();
            }
            lClosure = callInfo.closure;
            if (n-- > 0) continue;
            return lClosure.p.sourceshort() + ":" + callInfo.currentline();
        }
        return "";
    }

    public void error(String string, int n) {
        throw new LuaErrorException(this, string, n);
    }

    public void error(String string) {
        throw new LuaErrorException(this, string, -1);
    }

    public void checkstack(int n) {
        if (this.top + n >= this.stack.length) {
            int n2 = Math.max(this.top + n + 20, this.stack.length * 2);
            LValue[] lValueArray = new LValue[n2];
            System.arraycopy(this.stack, 0, lValueArray, 0, this.stack.length);
            this.stack = lValueArray;
        }
    }

    public void getfield(int n, LString lString) {
        this.pushlvalue(this.luaV_gettable(this.topointer(n), lString));
    }

    public void getglobal(String string) {
        this.pushlvalue(this.luaV_gettable(this._G, new LString(string)));
    }

    public boolean getmetatable(int n) {
        LTable lTable = this.topointer(n).luaGetMetatable();
        if (lTable != null) {
            this.pushlvalue(lTable);
            return true;
        }
        return false;
    }

    public void insert(int n) {
        int n2 = this.index2adr(n);
        LValue lValue = this.stack[this.top - 1];
        System.arraycopy(this.stack, n2, this.stack, n2 + 1, this.top - n2 - 1);
        this.stack[n2] = lValue;
    }

    public boolean isboolean(int n) {
        return this.type(n) == 1;
    }

    public boolean isfunction(int n) {
        return this.type(n) == 6;
    }

    public boolean isnil(int n) {
        return this.topointer(n).isNil();
    }

    public boolean isnoneornil(int n) {
        LValue lValue = this.topointer(n);
        return lValue == null || lValue == LNil.NIL;
    }

    public boolean isnumber(int n) {
        return !this.tolnumber(n).isNil();
    }

    public LValue tolnumber(int n) {
        return this.topointer(n).luaToNumber();
    }

    public boolean isstring(int n) {
        return this.topointer(n).isString();
    }

    public boolean istable(int n) {
        return this.topointer(n).isTable();
    }

    public boolean isthread(int n) {
        return this.type(n) == 8;
    }

    public boolean isuserdata(int n) {
        return this.type(n) == 7;
    }

    public void pop(int n) {
        for (int i = 0; i < n; ++i) {
            this.stack[--this.top] = LNil.NIL;
        }
    }

    public LValue poplvalue() {
        LValue lValue = this.stack[--this.top];
        this.stack[this.top] = LNil.NIL;
        return lValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushlvalue(LValue lValue) {
        if (lValue == null) {
            throw new IllegalArgumentException("stack values cannot be null");
        }
        try {
            this.stack[this.top] = lValue;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.checkstack(20);
            this.stack[this.top] = lValue;
        }
        finally {
            ++this.top;
        }
    }

    public void pushboolean(boolean bl) {
        this.pushlvalue(LBoolean.valueOf(bl));
    }

    public void pushinteger(int n) {
        this.pushlvalue(LInteger.valueOf(n));
    }

    public void pushfunction(LFunction lFunction) {
        this.pushlvalue(lFunction);
    }

    public void pushlstring(LString lString) {
        this.pushlvalue(lString);
    }

    public void pushlstring(byte[] byArray, int n, int n2) {
        this.pushlvalue(new LString(byArray, n, n2));
    }

    public void pushlstring(byte[] byArray) {
        this.pushlstring(byArray, 0, byArray.length);
    }

    public void pushnil() {
        this.pushlvalue(LNil.NIL);
    }

    public void pushnumber(double d) {
        this.pushlvalue(LDouble.numberOf(d));
    }

    public void pushstring(String string) {
        if (string == null) {
            this.pushnil();
        } else {
            this.pushlstring(LString.valueOf(string));
        }
    }

    public void pushvalue(int n) {
        this.pushlvalue(this.topointer(n));
    }

    public void rawgeti(int n, int n2) {
        this.pushlvalue(this.totable(n).get(n2));
    }

    public void remove(int n) {
        int n2 = this.index2adr(n);
        System.arraycopy(this.stack, n2 + 1, this.stack, n2, this.top - n2 - 1);
        this.poplvalue();
    }

    public void replace(int n) {
        int n2 = this.index2adr(n);
        this.stack[n2] = this.poplvalue();
    }

    public void setfield(int n, LString lString) {
        LTable lTable = this.totable(n);
        this.luaV_settable(lTable, lString, this.poplvalue());
    }

    public void setglobal(String string) {
        this.luaV_settable(this._G, new LString(string), this.poplvalue());
    }

    public boolean toboolean(int n) {
        return this.topointer(n).toJavaBoolean();
    }

    public int tointeger(int n) {
        LValue lValue = this.tolnumber(n);
        return lValue.isNil() ? 0 : lValue.toJavaInt();
    }

    public LValue tofunction(int n) {
        LValue lValue = this.topointer(n);
        return lValue.isFunction() ? lValue : LNil.NIL;
    }

    public LString tolstring(int n) {
        return this.topointer(n).luaAsString();
    }

    public double tonumber(int n) {
        LValue lValue = this.tolnumber(n);
        return lValue.isNil() ? 0.0 : lValue.toJavaDouble();
    }

    public int gettop() {
        return this.top - this.base;
    }

    public void settop(int n) {
        int n2;
        int n3 = n2 = n >= 0 ? this.base + n : this.top + n;
        if (n2 < this.base) {
            throw new IllegalArgumentException("index out of bounds: " + n2);
        }
        this.luaV_adjusttop(n2);
    }

    public void resettop() {
        this.luaV_settop_fillabove(this.base);
    }

    private int index2adr(int n) {
        int n2;
        int n3 = n2 = n > 0 ? this.base + n - 1 : this.top + n;
        if (n2 < this.base) {
            throw new IllegalArgumentException("index out of bounds: " + n2);
        }
        return n2;
    }

    public LValue topointer(int n) {
        int n2 = this.index2adr(n);
        if (n2 >= this.top) {
            return LNil.NIL;
        }
        return this.stack[n2];
    }

    public String tostring(int n) {
        return this.topointer(n).toJavaString();
    }

    public LTable totable(int n) {
        return (LTable)this.topointer(n);
    }

    public Object touserdata(int n) {
        LValue lValue = this.topointer(n);
        if (lValue.luaGetType() != 7) {
            return null;
        }
        return ((LUserData)lValue).m_instance;
    }

    public int type(int n) {
        return this.topointer(n).luaGetType();
    }

    public String typename(int n) {
        return this.topointer(n).luaGetTypeName().toJavaString();
    }

    public void xmove(LuaState luaState, int n) {
        if (n > 0) {
            luaState.checkstack(n);
            LuaState luaState2 = luaState;
            luaState2.checkstack(n);
            System.arraycopy(this.stack, this.top - n, luaState2.stack, luaState2.top, n);
            luaState2.top += n;
        }
    }

    public void pushboolean(Boolean bl) {
        if (bl == null) {
            this.pushnil();
        } else {
            this.pushboolean((boolean)bl);
        }
    }

    public void pushinteger(Byte by) {
        if (by == null) {
            this.pushnil();
        } else {
            this.pushinteger((int)by.byteValue());
        }
    }

    public void pushinteger(Character c) {
        if (c == null) {
            this.pushnil();
        } else {
            this.pushinteger((int)c.charValue());
        }
    }

    public void pushnumber(Double d) {
        if (d == null) {
            this.pushnil();
        } else {
            this.pushnumber((double)d);
        }
    }

    public void pushnumber(Float f) {
        if (f == null) {
            this.pushnil();
        } else {
            this.pushnumber(f.doubleValue());
        }
    }

    public void pushinteger(Integer n) {
        if (n == null) {
            this.pushnil();
        } else {
            this.pushinteger((int)n);
        }
    }

    public void pushinteger(Short s) {
        if (s == null) {
            this.pushnil();
        } else {
            this.pushinteger((int)s.shortValue());
        }
    }

    public void pushnumber(Long l) {
        if (l == null) {
            this.pushnil();
        } else {
            this.pushnumber(l.doubleValue());
        }
    }

    public void pushuserdata(Object object) {
        if (object == null) {
            this.pushnil();
        } else {
            this.pushlvalue(new LUserData(object));
        }
    }

    public Boolean toboxedboolean(int n) {
        return this.topointer(n).toJavaBoxedBoolean();
    }

    public Byte toboxedbyte(int n) {
        return this.topointer(n).toJavaBoxedByte();
    }

    public Double toboxeddouble(int n) {
        return this.topointer(n).toJavaBoxedDouble();
    }

    public Float toboxedfloat(int n) {
        return this.topointer(n).toJavaBoxedFloat();
    }

    public Integer toboxedinteger(int n) {
        return this.topointer(n).toJavaBoxedInteger();
    }

    public Long toboxedlong(int n) {
        return this.topointer(n).toJavaBoxedLong();
    }

    public void argerror(int n, String string) {
        this.error("bad argument #" + n + " (" + string + ")");
    }

    public void argcheck(boolean bl, int n, String string) {
        if (!bl) {
            this.argerror(n, string);
        }
    }

    public void typerror(int n, String string) {
        this.argerror(n, string + " expected, got " + this.typename(n));
    }

    public void typerror(int n, int n2) {
        this.typerror(n, Lua.TYPE_NAMES[n2]);
    }

    public LValue checkany(int n) {
        if (this.gettop() < n) {
            this.argerror(n, "value expected");
        }
        return this.topointer(n);
    }

    public LFunction checkfunction(int n) {
        return (LFunction)this.checktype(n, 6);
    }

    public LThread checkthread(int n) {
        return (LThread)this.checktype(n, 8);
    }

    public int checkint(int n) {
        LValue lValue = this.tolnumber(n);
        if (lValue.isNil()) {
            this.typerror(n, 3);
        }
        return lValue.toJavaInt();
    }

    public LInteger checkinteger(int n) {
        return LInteger.valueOf(this.checkint(n));
    }

    public long checklong(int n) {
        return this.checknumber(n).toJavaLong();
    }

    public double checkdouble(int n) {
        return this.checknumber(n).toJavaDouble();
    }

    public LNumber checknumber(int n) {
        LValue lValue = this.topointer(n).luaToNumber();
        if (lValue.isNil()) {
            this.typerror(n, 3);
        }
        return (LNumber)lValue;
    }

    public LString checklstring(int n) {
        LValue lValue = this.topointer(n);
        if (!lValue.isString()) {
            this.typerror(n, 4);
        }
        return lValue.luaAsString();
    }

    public String checkstring(int n) {
        LValue lValue = this.topointer(n);
        if (!lValue.isString()) {
            this.typerror(n, 4);
        }
        return lValue.toJavaString();
    }

    public LTable checktable(int n) {
        return (LTable)this.checktype(n, 5);
    }

    public LValue checktype(int n, int n2) {
        LValue lValue = this.topointer(n);
        if (lValue.luaGetType() != n2) {
            this.typerror(n, n2);
        }
        return lValue;
    }

    public Object checkudata(int n, Class clazz) {
        Object object = this.touserdata(n);
        if (clazz.isInstance(object)) {
            return object;
        }
        this.typerror(n, clazz.getName());
        return null;
    }

    public int optint(int n, int n2) {
        LNumber lNumber = this.optnumber(n, null);
        return lNumber == null ? n2 : lNumber.toJavaInt();
    }

    public LInteger optinteger(int n, int n2) {
        return LInteger.valueOf(this.optint(n, n2));
    }

    public long optlong(int n, long l) {
        LNumber lNumber = this.optnumber(n, null);
        return lNumber == null ? l : lNumber.toJavaLong();
    }

    public LNumber optnumber(int n, LNumber lNumber) {
        LValue lValue = this.topointer(n);
        if (lValue.isNil()) {
            return lNumber;
        }
        if ((lValue = lValue.luaToNumber()).isNil()) {
            this.typerror(n, 3);
        }
        return (LNumber)lValue;
    }

    public LString optlstring(int n, LString lString) {
        LValue lValue = this.topointer(n);
        if (lValue.isNil()) {
            return lString;
        }
        if (!lValue.isString()) {
            this.typerror(n, 4);
        }
        return lValue.luaAsString();
    }

    public String optstring(int n, String string) {
        LValue lValue = this.topointer(n);
        if (lValue.isNil()) {
            return string;
        }
        if (!lValue.isString()) {
            this.typerror(n, 4);
        }
        return lValue.toJavaString();
    }

    public static void vmerror(String string) {
        throw new LuaErrorException("internal error: " + string);
    }

    public LValue call(LFunction lFunction) {
        this.pushlvalue(lFunction);
        this.call(0, 1);
        return this.poplvalue();
    }

    public LValue call(LFunction lFunction, LValue lValue) {
        this.pushlvalue(lFunction);
        this.pushlvalue(lValue);
        this.call(1, 1);
        return this.poplvalue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LValue luaV_call_index(LFunction lFunction, LValue lValue, LValue lValue2) {
        int n = this.top;
        try {
            int n2;
            if (this.cc >= 0 && (n2 = this.base + this.calls[this.cc].closure.p.maxstacksize) > this.top) {
                this.top = n2;
            }
            this.pushlvalue(lFunction);
            this.pushlvalue(lValue);
            this.pushlvalue(lValue2);
            this.call(2, 1);
            LValue lValue3 = this.poplvalue();
            return lValue3;
        }
        finally {
            this.top = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LValue luaV_call_newindex(LFunction lFunction, LValue lValue, LValue lValue2, LValue lValue3) {
        int n = this.top;
        try {
            int n2;
            if (this.cc >= 0 && (n2 = this.base + this.calls[this.cc].closure.p.maxstacksize) > this.top) {
                this.top = n2;
            }
            this.pushlvalue(lFunction);
            this.pushlvalue(lValue);
            this.pushlvalue(lValue2);
            this.pushlvalue(lValue3);
            this.call(3, 1);
            LValue lValue4 = this.poplvalue();
            return lValue4;
        }
        finally {
            this.top = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String luaV_call_errfunc(String string) {
        if (this.inhook || this.errfunc == null) {
            return string;
        }
        int n = this.top;
        try {
            int n2;
            this.inhook = true;
            if (this.cc >= 0 && (n2 = this.base + this.calls[this.cc].closure.p.maxstacksize) > this.top) {
                this.top = n2;
            }
            this.pushlvalue(this.errfunc);
            this.pushstring(string);
            this.call(1, 1);
            String string2 = this.poplvalue().toJavaString();
            return string2;
        }
        catch (Throwable throwable) {
            String string3 = "error in error handling: " + throwable.getMessage();
            return string3;
        }
        finally {
            this.top = n;
            this.inhook = false;
        }
    }

    public void sethook(LFunction lFunction, int n, int n2) {
        this.hooksenabled = n != 0 || n2 > 0;
        this.hookfunc = lFunction;
        this.hookmask = n;
        this.hookcount = n2;
    }

    public LFunction gethook() {
        return this.hookfunc;
    }

    public int gethookcount() {
        return this.hookcount;
    }

    public int gethookmask() {
        return this.hookmask;
    }

    private void debugBytecodeHooks(int n) {
        if (this.hookfunc != null) {
            int n2;
            if (this.hookcount != 0 && --this.hookincr <= 0) {
                this.hookincr = this.hookcount;
                this.debugInvokeHook(3, -1);
            }
            if ((this.hookmask & 4) != 0 && ((n2 = this.calls[this.cc].currentline()) != this.hookline || this.cc != this.hookcc) && n2 >= 0) {
                this.hookline = n2;
                this.hookcc = this.cc;
                this.debugInvokeHook(2, n2);
            }
        }
    }

    private void debugCallHooks() {
        if (this.hookfunc != null && (this.hookmask & 1) != 0) {
            this.debugInvokeHook(0, this.calls[this.cc].currentline());
        }
    }

    private void debugReturnHooks() {
        if (this.hookfunc != null && (this.hookmask & 2) != 0) {
            this.debugInvokeHook(1, this.calls[this.cc].currentline());
        }
    }

    private void debugTailReturnHooks() {
        if (this.hookfunc != null && (this.hookmask & 2) != 0) {
            this.debugInvokeHook(4, this.calls[this.cc].currentline());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void debugInvokeHook(int n, int n2) {
        int n3;
        if (this.inhook) {
            return;
        }
        int n4 = this.top;
        int n5 = this.base;
        int n6 = this.cc;
        int n7 = this.nresults;
        int n8 = n3 = this.cc >= 0 ? this.base + this.calls[this.cc].closure.p.maxstacksize : this.top;
        if (n3 < this.top) {
            n3 = this.top;
        }
        try {
            this.inhook = true;
            this.top = this.base = n3;
            this.pushfunction(this.hookfunc);
            switch (n) {
                case 3: {
                    this.pushstring("count");
                    break;
                }
                case 0: {
                    this.pushstring("call");
                    break;
                }
                case 1: {
                    this.pushstring("return");
                    break;
                }
                case 4: {
                    this.pushstring("tail return");
                    break;
                }
                default: {
                    this.pushstring("line");
                    this.pushinteger(n2);
                }
            }
            this.nresults = 0;
            if (this.stack[this.base].luaStackCall(this)) {
                this.execute();
            }
        }
        catch (Throwable throwable) {
            System.err.println("hook exception: " + throwable);
        }
        finally {
            this.luaV_settop_fillabove(n3);
            this.cc = n6;
            this.base = n5;
            this.top = n4;
            this.nresults = n7;
            this.inhook = false;
        }
    }
}

