/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.compiler;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.luaj.vm.LPrototype;
import org.luaj.vm.LString;
import org.luaj.vm.LValue;
import org.luaj.vm.LocVars;

public class DumpState {
    public static final String LUA_SIGNATURE = "\u001bLua";
    public static final int LUAC_VERSION = 81;
    public static final int LUAC_FORMAT = 0;
    public static final int LUAC_HEADERSIZE = 12;
    private static final byte[] LUAC_HEADER_SIGNATURE = new byte[]{27, 76, 117, 97};
    public static boolean ALLOW_INTEGER_CASTING = false;
    public static final int NUMBER_FORMAT_FLOATS_OR_DOUBLES = 0;
    public static final int NUMBER_FORMAT_INTS_ONLY = 1;
    public static final int NUMBER_FORMAT_NUM_PATCH_INT32 = 4;
    public static final int NUMBER_FORMAT_DEFAULT = 0;
    private boolean IS_LITTLE_ENDIAN = false;
    private int NUMBER_FORMAT = 0;
    private int SIZEOF_LUA_NUMBER = 8;
    private static final int SIZEOF_INT = 4;
    private static final int SIZEOF_SIZET = 4;
    private static final int SIZEOF_INSTRUCTION = 4;
    DataOutputStream writer;
    boolean strip;
    int status;

    public DumpState(OutputStream outputStream, boolean bl) {
        this.writer = new DataOutputStream(outputStream);
        this.strip = bl;
        this.status = 0;
    }

    void dumpBlock(byte[] byArray, int n) throws IOException {
        this.writer.write(byArray, 0, n);
    }

    void dumpChar(int n) throws IOException {
        this.writer.write(n);
    }

    void dumpInt(int n) throws IOException {
        if (this.IS_LITTLE_ENDIAN) {
            this.writer.writeByte(n & 0xFF);
            this.writer.writeByte(n >> 8 & 0xFF);
            this.writer.writeByte(n >> 16 & 0xFF);
            this.writer.writeByte(n >> 24 & 0xFF);
        } else {
            this.writer.writeInt(n);
        }
    }

    void dumpString(LString lString) throws IOException {
        int n = lString.length();
        this.dumpInt(n + 1);
        lString.write(this.writer, 0, n);
        this.writer.write(0);
    }

    void dumpDouble(double d) throws IOException {
        long l = Double.doubleToLongBits(d);
        if (this.IS_LITTLE_ENDIAN) {
            this.dumpInt((int)l);
            this.dumpInt((int)(l >> 32));
        } else {
            this.writer.writeLong(l);
        }
    }

    void dumpCode(LPrototype lPrototype) throws IOException {
        int[] nArray = lPrototype.code;
        int n = nArray.length;
        this.dumpInt(n);
        for (int i = 0; i < n; ++i) {
            this.dumpInt(nArray[i]);
        }
    }

    void dumpConstants(LPrototype lPrototype) throws IOException {
        int n;
        LValue[] lValueArray = lPrototype.k;
        int n2 = lValueArray.length;
        this.dumpInt(n2);
        block11: for (n = 0; n < n2; ++n) {
            LValue lValue = lValueArray[n];
            switch (lValue.luaGetType()) {
                case 0: {
                    this.writer.write(0);
                    continue block11;
                }
                case 1: {
                    this.writer.write(1);
                    this.dumpChar(lValue.toJavaBoolean() ? 1 : 0);
                    continue block11;
                }
                case 3: {
                    switch (this.NUMBER_FORMAT) {
                        case 0: {
                            this.writer.write(3);
                            this.dumpDouble(lValue.toJavaDouble());
                            continue block11;
                        }
                        case 1: {
                            if (!ALLOW_INTEGER_CASTING && !lValue.isInteger()) {
                                throw new IllegalArgumentException("not an integer: " + lValue);
                            }
                            this.writer.write(3);
                            this.dumpInt(lValue.toJavaInt());
                            continue block11;
                        }
                        case 4: {
                            if (lValue.isInteger()) {
                                this.writer.write(-2);
                                this.dumpInt(lValue.toJavaInt());
                                continue block11;
                            }
                            this.writer.write(3);
                            this.dumpDouble(lValue.toJavaDouble());
                            continue block11;
                        }
                    }
                    throw new IllegalArgumentException("number format not supported: " + this.NUMBER_FORMAT);
                }
                case 4: {
                    this.writer.write(4);
                    this.dumpString(lValue.luaAsString());
                    continue block11;
                }
                default: {
                    throw new IllegalArgumentException("bad type for " + lValue);
                }
            }
        }
        n2 = lPrototype.p.length;
        this.dumpInt(n2);
        for (n = 0; n < n2; ++n) {
            this.dumpFunction(lPrototype.p[n], lPrototype.source);
        }
    }

    void dumpDebug(LPrototype lPrototype) throws IOException {
        int n;
        int n2 = this.strip ? 0 : lPrototype.lineinfo.length;
        this.dumpInt(n2);
        for (n = 0; n < n2; ++n) {
            this.dumpInt(lPrototype.lineinfo[n]);
        }
        n2 = this.strip ? 0 : lPrototype.locvars.length;
        this.dumpInt(n2);
        for (n = 0; n < n2; ++n) {
            LocVars locVars = lPrototype.locvars[n];
            this.dumpString(locVars.varname);
            this.dumpInt(locVars.startpc);
            this.dumpInt(locVars.endpc);
        }
        n2 = this.strip ? 0 : lPrototype.upvalues.length;
        this.dumpInt(n2);
        for (n = 0; n < n2; ++n) {
            this.dumpString(lPrototype.upvalues[n]);
        }
    }

    void dumpFunction(LPrototype lPrototype, LString lString) throws IOException {
        if (lPrototype.source == null || lPrototype.source.equals(lString) || this.strip) {
            this.dumpInt(0);
        } else {
            this.dumpString(lPrototype.source);
        }
        this.dumpInt(lPrototype.linedefined);
        this.dumpInt(lPrototype.lastlinedefined);
        this.dumpChar(lPrototype.nups);
        this.dumpChar(lPrototype.numparams);
        this.dumpChar(lPrototype.is_vararg);
        this.dumpChar(lPrototype.maxstacksize);
        this.dumpCode(lPrototype);
        this.dumpConstants(lPrototype);
        this.dumpDebug(lPrototype);
    }

    void dumpHeader() throws IOException {
        ((OutputStream)this.writer).write(LUAC_HEADER_SIGNATURE);
        this.writer.write(81);
        this.writer.write(0);
        this.writer.write(this.IS_LITTLE_ENDIAN ? 1 : 0);
        this.writer.write(4);
        this.writer.write(4);
        this.writer.write(4);
        this.writer.write(this.SIZEOF_LUA_NUMBER);
        this.writer.write(this.NUMBER_FORMAT);
    }

    public static int dump(LPrototype lPrototype, OutputStream outputStream, boolean bl) throws IOException {
        DumpState dumpState = new DumpState(outputStream, bl);
        dumpState.dumpHeader();
        dumpState.dumpFunction(lPrototype, null);
        return dumpState.status;
    }

    public static int dump(LPrototype lPrototype, OutputStream outputStream, boolean bl, int n, boolean bl2) throws IOException {
        switch (n) {
            case 0: 
            case 1: 
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException("number format not supported: " + n);
            }
        }
        DumpState dumpState = new DumpState(outputStream, bl);
        dumpState.IS_LITTLE_ENDIAN = bl2;
        dumpState.NUMBER_FORMAT = n;
        dumpState.SIZEOF_LUA_NUMBER = n == 1 ? 4 : 8;
        dumpState.dumpHeader();
        dumpState.dumpFunction(lPrototype, null);
        return dumpState.status;
    }
}

