/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.lib;

import java.io.IOException;
import java.util.Date;
import org.luaj.lib.PackageLib;
import org.luaj.vm.LFunction;
import org.luaj.vm.LInteger;
import org.luaj.vm.LString;
import org.luaj.vm.LTable;
import org.luaj.vm.LValue;
import org.luaj.vm.LuaState;

public class OsLib
extends LFunction {
    public static String TMP_PREFIX = ".luaj";
    public static String TMP_SUFFIX = "tmp";
    public static final String[] NAMES = new String[]{"os", "clock", "date", "difftime", "execute", "exit", "getenv", "remove", "rename", "setlocale", "time", "tmpname"};
    private static final int INSTALL = 0;
    private static final int CLOCK = 1;
    private static final int DATE = 2;
    private static final int DIFFTIME = 3;
    private static final int EXECUTE = 4;
    private static final int EXIT = 5;
    private static final int GETENV = 6;
    private static final int REMOVE = 7;
    private static final int RENAME = 8;
    private static final int SETLOCALE = 9;
    private static final int TIME = 10;
    private static final int TMPNAME = 11;
    private static final long t0;
    private static long tmpnames;
    private final int id;

    protected OsLib newInstance(int n) {
        return new OsLib(n);
    }

    public static void install(LTable lTable) {
        OsLib.install(lTable, new OsLib());
    }

    public static void install(LTable lTable, OsLib osLib) {
        LTable lTable2 = new LTable();
        for (int i = 1; i <= 11; ++i) {
            lTable2.put(NAMES[i], (LValue)osLib.newInstance(i));
        }
        lTable.put("os", (LValue)lTable2);
        PackageLib.setIsLoaded("os", lTable2);
    }

    protected OsLib() {
        this.id = 0;
    }

    protected OsLib(int n) {
        this.id = n;
    }

    public LString luaAsString() {
        return new LString(this.toJavaString());
    }

    public String toJavaString() {
        return "os." + this.toString();
    }

    public String toString() {
        return NAMES[this.id] + "()";
    }

    public int invoke(LuaState luaState) {
        try {
            switch (this.id) {
                case 0: {
                    OsLib.install(luaState._G, this);
                    return 0;
                }
                case 1: {
                    luaState.pushnumber(this.clock());
                    return 1;
                }
                case 2: {
                    String string = luaState.optstring(1, null);
                    double d = luaState.optnumber(2, LInteger.valueOf(-1)).toJavaDouble();
                    luaState.pushlvalue(this.date(string, d == -1.0 ? (double)System.currentTimeMillis() / 1000.0 : d));
                    return 1;
                }
                case 3: {
                    double d = luaState.checkdouble(1);
                    double d2 = luaState.checkdouble(2);
                    luaState.pushnumber(this.difftime(d, d2));
                    return 1;
                }
                case 4: {
                    int n = this.execute(luaState.optstring(1, null));
                    luaState.pushinteger(n);
                    return 1;
                }
                case 5: {
                    this.exit(luaState.optint(1, 0));
                    return 0;
                }
                case 6: {
                    String string = this.getenv(luaState.checkstring(1));
                    luaState.pushstring(string);
                    return 1;
                }
                case 7: {
                    this.remove(luaState.checkstring(1));
                    luaState.pushboolean(true);
                    return 1;
                }
                case 8: {
                    this.rename(luaState.checkstring(1), luaState.checkstring(2));
                    luaState.pushboolean(true);
                    return 1;
                }
                case 9: {
                    String string = this.setlocale(luaState.optstring(1, null), luaState.optstring(2, "all"));
                    if (string != null) {
                        luaState.pushstring(string);
                    } else {
                        luaState.pushnil();
                    }
                    return 1;
                }
                case 10: {
                    double d = this.time(luaState.isnoneornil(1) ? null : luaState.checktable(1));
                    luaState.pushnumber(d);
                    return 1;
                }
                case 11: {
                    luaState.pushstring(this.tmpname());
                    return 1;
                }
            }
            LuaState.vmerror("bad os id");
            return 0;
        }
        catch (IOException iOException) {
            luaState.pushnil();
            luaState.pushstring(iOException.getMessage());
            return 2;
        }
    }

    protected double clock() {
        return (double)(System.currentTimeMillis() - t0) / 1000.0;
    }

    protected double difftime(double d, double d2) {
        return d - d2;
    }

    protected LValue date(String string, double d) {
        return LString.valueOf(new Date((long)(d * 1000.0)).toString());
    }

    protected int execute(String string) {
        return 0;
    }

    protected void exit(int n) {
        System.exit(n);
    }

    protected String getenv(String string) {
        return System.getProperty(string);
    }

    protected void remove(String string) throws IOException {
        throw new IOException("not implemented");
    }

    protected void rename(String string, String string2) throws IOException {
        throw new IOException("not implemented");
    }

    protected String setlocale(String string, String string2) {
        return "C";
    }

    protected long time(LTable lTable) {
        return System.currentTimeMillis();
    }

    protected String tmpname() {
        return TMP_PREFIX + tmpnames++ + TMP_SUFFIX;
    }

    static {
        tmpnames = t0 = System.currentTimeMillis();
    }
}

