/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.luaj.vm.LBoolean;
import org.luaj.vm.LDouble;
import org.luaj.vm.LInteger;
import org.luaj.vm.LNil;
import org.luaj.vm.LNumber;
import org.luaj.vm.LPrototype;
import org.luaj.vm.LString;
import org.luaj.vm.LValue;
import org.luaj.vm.LocVars;
import org.luaj.vm.LuaState;

public class LoadState {
    public static LuaCompiler compiler = null;
    private static final byte[] LUA_SIGNATURE = new byte[]{27, 76, 117, 97};
    public static final String SOURCE_BINARY_STRING = "binary string";
    public static final int LUAC_VERSION = 81;
    public static final int LUAC_FORMAT = 0;
    public static final int LUAC_HEADERSIZE = 12;
    private int luacVersion;
    private int luacFormat;
    private boolean luacLittleEndian;
    private int luacSizeofInt;
    private int luacSizeofSizeT;
    private int luacSizeofInstruction;
    private int luacSizeofLuaNumber;
    private int luacNumberFormat;
    private DataInputStream is;
    String name;
    LuaState L;
    private byte[] buf = new byte[512];
    private static int[] EMPTY_INT_ARRAY = new int[0];

    int loadInt() throws IOException {
        this.is.readFully(this.buf, 0, 4);
        return this.luacLittleEndian ? this.buf[3] << 24 | (0xFF & this.buf[2]) << 16 | (0xFF & this.buf[1]) << 8 | 0xFF & this.buf[0] : this.buf[0] << 24 | (0xFF & this.buf[1]) << 16 | (0xFF & this.buf[2]) << 8 | 0xFF & this.buf[3];
    }

    int[] loadIntArray() throws IOException {
        int n = this.loadInt();
        if (n == 0) {
            return EMPTY_INT_ARRAY;
        }
        int n2 = n << 2;
        if (this.buf.length < n2) {
            this.buf = new byte[n2];
        }
        this.is.readFully(this.buf, 0, n2);
        int[] nArray = new int[n];
        int n3 = 0;
        int n4 = 0;
        while (n3 < n) {
            nArray[n3] = this.luacLittleEndian ? this.buf[n4 + 3] << 24 | (0xFF & this.buf[n4 + 2]) << 16 | (0xFF & this.buf[n4 + 1]) << 8 | 0xFF & this.buf[n4 + 0] : this.buf[n4 + 0] << 24 | (0xFF & this.buf[n4 + 1]) << 16 | (0xFF & this.buf[n4 + 2]) << 8 | 0xFF & this.buf[n4 + 3];
            ++n3;
            n4 += 4;
        }
        return nArray;
    }

    long loadInt64() throws IOException {
        int n;
        int n2;
        if (this.luacLittleEndian) {
            n2 = this.loadInt();
            n = this.loadInt();
        } else {
            n = this.loadInt();
            n2 = this.loadInt();
        }
        return (long)n << 32 | (long)n2 & 0xFFFFFFFFL;
    }

    LString loadString() throws IOException {
        int n = this.loadInt();
        if (n == 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        this.is.readFully(byArray, 0, n);
        return new LString(byArray, 0, byArray.length - 1);
    }

    public static LNumber longBitsToLuaNumber(long l) {
        int n;
        long l2;
        long l3;
        if ((l & Long.MAX_VALUE) == 0L) {
            return LInteger.valueOf(0);
        }
        int n2 = (int)(l >> 52 & 0x7FFL) - 1023;
        if (n2 >= 0 && n2 < 31 && ((l3 = l & 0xFFFFFFFFFFFFFL) & (l2 = (1L << (n = 52 - n2)) - 1L)) == 0L) {
            int n3 = (int)(l3 >> n) | 1 << n2;
            return LInteger.valueOf(l >> 63 != 0L ? -n3 : n3);
        }
        double d = Double.longBitsToDouble(l);
        return LDouble.numberOf(d);
    }

    LNumber loadNumber() throws IOException {
        if (this.luacNumberFormat == 1) {
            return LInteger.valueOf(this.loadInt());
        }
        return LoadState.longBitsToLuaNumber(this.loadInt64());
    }

    void loadConstants(LPrototype lPrototype) throws IOException {
        int n = this.loadInt();
        LValue[] lValueArray = new LValue[n];
        block7: for (int i = 0; i < n; ++i) {
            switch (this.is.readByte()) {
                case 0: {
                    lValueArray[i] = LNil.NIL;
                    continue block7;
                }
                case 1: {
                    lValueArray[i] = 0 != this.is.readUnsignedByte() ? LBoolean.TRUE : LBoolean.FALSE;
                    continue block7;
                }
                case -2: {
                    lValueArray[i] = LInteger.valueOf(this.loadInt());
                    continue block7;
                }
                case 3: {
                    lValueArray[i] = this.loadNumber();
                    continue block7;
                }
                case 4: {
                    lValueArray[i] = this.loadString();
                    continue block7;
                }
                default: {
                    throw new IllegalStateException("bad constant");
                }
            }
        }
        lPrototype.k = lValueArray;
        n = this.loadInt();
        LPrototype[] lPrototypeArray = new LPrototype[n];
        for (int i = 0; i < n; ++i) {
            lPrototypeArray[i] = this.loadFunction(lPrototype.source);
        }
        lPrototype.p = lPrototypeArray;
    }

    void loadDebug(LPrototype lPrototype) throws IOException {
        int n;
        lPrototype.lineinfo = this.loadIntArray();
        int n2 = this.loadInt();
        lPrototype.locvars = new LocVars[n2];
        for (n = 0; n < n2; ++n) {
            LString lString = this.loadString();
            int n3 = this.loadInt();
            int n4 = this.loadInt();
            lPrototype.locvars[n] = new LocVars(lString, n3, n4);
        }
        n2 = this.loadInt();
        lPrototype.upvalues = new LString[n2];
        for (n = 0; n < n2; ++n) {
            lPrototype.upvalues[n] = this.loadString();
        }
    }

    public LPrototype loadFunction(LString lString) throws IOException {
        LPrototype lPrototype = new LPrototype();
        lPrototype.source = this.loadString();
        if (lPrototype.source == null) {
            lPrototype.source = lString;
        }
        lPrototype.linedefined = this.loadInt();
        lPrototype.lastlinedefined = this.loadInt();
        lPrototype.nups = this.is.readUnsignedByte();
        lPrototype.numparams = this.is.readUnsignedByte();
        lPrototype.is_vararg = this.is.readUnsignedByte();
        lPrototype.maxstacksize = this.is.readUnsignedByte();
        lPrototype.code = this.loadIntArray();
        this.loadConstants(lPrototype);
        this.loadDebug(lPrototype);
        return lPrototype;
    }

    public void loadHeader() throws IOException {
        this.luacVersion = this.is.readByte();
        this.luacFormat = this.is.readByte();
        this.luacLittleEndian = 0 != this.is.readByte();
        this.luacSizeofInt = this.is.readByte();
        this.luacSizeofSizeT = this.is.readByte();
        this.luacSizeofInstruction = this.is.readByte();
        this.luacSizeofLuaNumber = this.is.readByte();
        this.luacNumberFormat = this.is.readByte();
    }

    public static LPrototype undump(LuaState luaState, InputStream inputStream, String string) throws IOException {
        int n = inputStream.read();
        if (n != LUA_SIGNATURE[0]) {
            if (compiler != null) {
                return compiler.compile(n, inputStream, string);
            }
            throw new IllegalArgumentException("no compiler");
        }
        for (int i = 1; i < 4; ++i) {
            if (inputStream.read() == LUA_SIGNATURE[i]) continue;
            throw new IllegalArgumentException("bad signature");
        }
        String string2 = LoadState.getSourceName(string);
        LoadState loadState = new LoadState(luaState, inputStream, string2);
        loadState.loadHeader();
        switch (loadState.luacNumberFormat) {
            case 0: 
            case 1: 
            case 4: {
                break;
            }
            default: {
                luaState.error("unsupported int size");
            }
        }
        return loadState.loadFunction(LString.valueOf(string2));
    }

    public static String getSourceName(String string) {
        String string2 = string;
        if (string.startsWith("@") || string.startsWith("=")) {
            string2 = string.substring(1);
        } else if (string.startsWith("\u001b")) {
            string2 = SOURCE_BINARY_STRING;
        }
        return string2;
    }

    private LoadState(LuaState luaState, InputStream inputStream, String string) {
        this.L = luaState;
        this.name = string;
        this.is = new DataInputStream(inputStream);
    }

    public static interface LuaCompiler {
        public LPrototype compile(int var1, InputStream var2, String var3) throws IOException;
    }
}

