/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.jit;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.luaj.compiler.LuaC;
import org.luaj.jit.JitPrototype;
import org.luaj.vm.LPrototype;
import org.luaj.vm.LValue;
import org.luaj.vm.LoadState;
import org.luaj.vm.Lua;
import org.luaj.vm.LuaState;
import org.luaj.vm.Print;

public class LuaJit
extends Lua
implements LoadState.LuaCompiler {
    private static LuaC luac;
    private static int filenum;
    private static Set<Integer> TESTS;

    public static void install() {
        luac = new LuaC();
        LoadState.compiler = new LuaJit();
    }

    private static synchronized String filename() {
        return "LuaJit" + filenum++;
    }

    public LPrototype compile(int n, InputStream inputStream, String string) throws IOException {
        return LuaJit.jitCompile(luac.compile(n, inputStream, string));
    }

    public static LPrototype jitCompile(LPrototype lPrototype) {
        try {
            JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
            if (javaCompiler == null) {
                System.err.println("no java compiler");
                return lPrototype;
            }
            String string = LuaJit.filename();
            new File("jit").mkdirs();
            File file = new File("jit/" + string + JavaFileObject.Kind.SOURCE.extension);
            PrintStream printStream = new PrintStream(new FileOutputStream(file));
            LuaJit.writeSource(printStream, string, lPrototype);
            printStream.close();
            List<File> list = Arrays.asList(new File("bin"));
            StandardJavaFileManager standardJavaFileManager = javaCompiler.getStandardFileManager(null, null, null);
            standardJavaFileManager.setLocation(StandardLocation.CLASS_OUTPUT, list);
            Iterable<? extends JavaFileObject> iterable = standardJavaFileManager.getJavaFileObjects(file);
            JavaCompiler.CompilationTask compilationTask = javaCompiler.getTask(null, standardJavaFileManager, null, null, null, iterable);
            boolean bl = compilationTask.call();
            if (bl) {
                if (lPrototype.p != null) {
                    int n = lPrototype.p.length;
                    for (int i = 0; i < n; ++i) {
                        if (lPrototype.p[i] instanceof JitPrototype) continue;
                        lPrototype.p[i] = LuaJit.jitCompile(lPrototype.p[i]);
                    }
                }
                Class<?> clazz = Class.forName(string);
                Object obj = clazz.newInstance();
                JitPrototype jitPrototype = (JitPrototype)obj;
                jitPrototype.setLuaPrototype(lPrototype);
                return jitPrototype;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return lPrototype;
    }

    private static String RKBC_jit(int n) {
        return LuaState.ISK(n) ? "k" + LuaState.INDEXK(n) : "s" + n;
    }

    private static String GETARG_RKB_jit(int n) {
        return LuaJit.RKBC_jit(LuaJit.GETARG_B(n));
    }

    private static String GETARG_RKC_jit(int n) {
        return LuaJit.RKBC_jit(LuaJit.GETARG_C(n));
    }

    private static boolean istest(int n) {
        int n2 = Lua.GET_OPCODE(n);
        return TESTS.contains(n2);
    }

    private static boolean isjump(int n) {
        return 22 == Lua.GET_OPCODE(n);
    }

    private static boolean isbackwardjump(int n) {
        return LuaJit.isjump(n) && LuaState.GETARG_sBx(n) < 0;
    }

    private static boolean isforwardjump(int n) {
        return LuaJit.isjump(n) && LuaState.GETARG_sBx(n) > 0;
    }

    private static boolean isloopbottom(int n) {
        return LuaJit.isbackwardjump(n) || 31 == Lua.GET_OPCODE(n);
    }

    private static String append(String string, String string2) {
        return string == null ? string2 : (string2 == null ? string : string + string2);
    }

    private static void assertTrue(boolean bl) {
        if (!bl) {
            throw new RuntimeException("assert failed");
        }
    }

    private static String[] extractControlFlow(int[] nArray) {
        int n = nArray.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            int n4 = nArray[i];
            if (LuaJit.isbackwardjump(n4)) {
                n3 = LuaState.GETARG_sBx(n4);
                stringArray[i + n3 + 1] = LuaJit.append(stringArray[i + n3 + 1], "while (true) { if(false)break; /* WHILETOP */ ");
                stringArray[i] = LuaJit.append("} /* LOOPBOT */ ", stringArray[i]);
                n2 = nArray[i - 1];
                if (LuaJit.istest(n2)) {
                    stringArray[i] = LuaJit.append("break; /* UNTIL */", stringArray[i]);
                    continue;
                }
                if (Lua.GET_OPCODE(n2) != 33) continue;
                int n5 = LuaState.GETARG_A(n2);
                int n6 = LuaState.GETARG_C(n2);
                LuaJit.assertTrue(n6 == 2);
                stringArray[i + n3 + 1] = LuaJit.append(stringArray[i + n3 + 1], "\n\t\tvm.stack[base+" + (n5 + 3) + "] = s" + (n5 + 0) + ";" + "\n\t\tvm.stack[base+" + (n5 + 4) + "] = s" + (n5 + 1) + ";" + "\n\t\tvm.stack[base+" + (n5 + 5) + "] = s" + (n5 + 2) + ";" + "\n\t\tvm.top = base+" + (n5 + 6) + ";" + "\n\t\tvm.call(2,2);" + "\n\t\ts" + (n5 + 3) + " = vm.stack[base+" + (n5 + 3) + "];" + "\n\t\ts" + (n5 + 4) + " = vm.stack[base+" + (n5 + 4) + "];" + "\n\t\tif ( s" + (n5 + 3) + ".isNil() )" + "\n\t\t\tbreak;" + "\n\t\ts" + (n5 + 2) + " = s" + (n5 + 3) + ";");
                continue;
            }
            if (!LuaJit.isforwardjump(n4)) continue;
            n3 = LuaState.GETARG_sBx(n4);
            if (LuaJit.isloopbottom(nArray[i + n3])) {
                stringArray[i] = LuaJit.append(stringArray[i], "if(true)break;");
                continue;
            }
            if (!LuaJit.istest(nArray[i - 1])) continue;
            stringArray[i] = LuaJit.append(stringArray[i], "{ /* IF */ ");
            stringArray[i + n3 + 1] = LuaJit.append("} /* ENDIF */ ", stringArray[i + n3 + 1]);
            if (!LuaJit.isforwardjump(nArray[i + n3]) || LuaJit.isloopbottom(nArray[i + n3 + (n2 = LuaState.GETARG_sBx(nArray[i + n3]))])) continue;
            stringArray[i + n3 + 1] = LuaJit.append(stringArray[i + n3 + 1], "else { /* ELSE */ ");
            stringArray[i + n3 + n2 + 1] = LuaJit.append("}  /* ENDELSE */ ", stringArray[i + n3 + n2 + 1]);
        }
        return stringArray;
    }

    private static void writeSource(PrintStream printStream, String string, LPrototype lPrototype) {
        int n;
        int n2;
        int[] nArray = lPrototype.code;
        LValue[] lValueArray = lPrototype.k;
        String[] stringArray = LuaJit.extractControlFlow(nArray);
        printStream.print("import org.luaj.vm.*;\nimport org.luaj.jit.*;\nimport java.io.*;\n\npublic class " + string + " extends JitPrototype {\n");
        int n3 = lValueArray.length;
        if (n3 > 0) {
            printStream.print("\tprivate LValue k0");
            for (n2 = 1; n2 < n3; ++n2) {
                printStream.print(",k" + n2);
            }
            printStream.println(";");
            printStream.println("\tprotected void setLuaPrototype(LPrototype lp) {\n");
            printStream.println("\t\tsuper.setLuaPrototype(lp);\n");
            printStream.println("\t\tfinal LValue[] k = p.k;");
            for (n2 = 0; n2 < n3; ++n2) {
                printStream.println("\t\tk" + n2 + " = k[" + n2 + "];");
            }
            printStream.println("\t}");
        }
        printStream.println("\tpublic void jitCall(LuaState vm, LTable env, JitClosure jcl) {");
        n2 = lPrototype.maxstacksize;
        if (lPrototype.is_vararg == 0) {
            printStream.println("\t\tvm.checkstack(" + (lPrototype.maxstacksize + 1) + ");");
            printStream.println("\t\tvm.settop(" + (lPrototype.numparams + 1) + ");");
            printStream.println("\t\tint base = vm.base + 1;");
            for (n = 0; n < lPrototype.numparams; ++n) {
                printStream.println("\t\tLValue s" + n + " = vm.stack[base+" + n + "];");
            }
        }
        while (n < n2) {
            printStream.println("\t\tLValue s" + n + " = LNil.NIL;");
            ++n;
        }
        printStream.println("\t\tLClosure newcl;");
        printStream.println("\t\tByteArrayOutputStream baos;");
        printStream.println("\t\tLTable t;");
        printStream.println();
        if (lPrototype.is_vararg != 0) {
            printStream.println("\t\tint ncopy, ntotal;");
            printStream.println("\t\tint nvarargs = vm.top - vm.base - 1;");
            printStream.println("\t\tint base = vm.base + 1 + nvarargs;");
        }
        printStream.println();
        block35: for (int i = 0; i < nArray.length; ++i) {
            printStream.print("\n\t\t// ");
            Print.printOpCode(printStream, lPrototype, i);
            printStream.println();
            if (stringArray[i] != null) {
                printStream.println("\t\t" + stringArray[i]);
            }
            int n4 = nArray[i];
            int n5 = n4 >> 0 & 0x3F;
            int n6 = n4 >> 6 & 0xFF;
            switch (n5) {
                default: {
                    printStream.println("\t\tunimplemented();");
                    continue block35;
                }
                case 0: {
                    int n7 = LuaState.GETARG_B(n4);
                    printStream.println("\t\ts" + n6 + " = s" + n7 + ";");
                    continue block35;
                }
                case 1: {
                    int n7 = LuaState.GETARG_Bx(n4);
                    printStream.println("\t\ts" + n6 + " = k" + n7 + ";");
                    continue block35;
                }
                case 2: {
                    int n7 = LuaState.GETARG_B(n4);
                    int n8 = LuaState.GETARG_C(n4);
                    printStream.println("\t\ts" + n6 + " = LBoolean." + (n7 != 0 ? "TRUE" : "FALSE") + ";");
                    if (n8 == 0) continue block35;
                    throw new UnsupportedOperationException("can't jit compile LOADBOOL with c != 0");
                }
                case 3: {
                    int n7 = LuaState.GETARG_B(n4);
                    printStream.print("\t\t");
                    for (int j = n6; j <= n7; ++j) {
                        printStream.print("s" + j + "=");
                    }
                    printStream.println("LNil.NIL;");
                    continue block35;
                }
                case 4: {
                    int n7 = LuaState.GETARG_B(n4);
                    printStream.println("\t\t\ts" + n6 + " = jcl.upVals[" + n7 + "].getValue();");
                    continue block35;
                }
                case 5: {
                    int n7 = LuaState.GETARG_Bx(n4);
                    printStream.println("\t\ts" + n6 + " = vm.luaV_gettable(env, k" + n7 + ");");
                    continue block35;
                }
                case 6: {
                    int n7 = LuaJit.GETARG_B(n4);
                    String string2 = LuaJit.GETARG_RKC_jit(n4);
                    printStream.println("\t\ts" + n6 + " = vm.luaV_gettable(s" + n7 + ", " + string2 + ");");
                    continue block35;
                }
                case 7: {
                    int n7 = LuaState.GETARG_Bx(n4);
                    printStream.println("\t\tvm.luaV_settable(env, k" + n7 + ", s" + n6 + ");");
                    continue block35;
                }
                case 8: {
                    int n7 = LuaState.GETARG_B(n4);
                    printStream.println("\t\t\tjcl.upVals[" + n7 + "].setValue(s" + n6 + ");");
                    continue block35;
                }
                case 9: {
                    String string3 = LuaJit.GETARG_RKB_jit(n4);
                    String string2 = LuaJit.GETARG_RKC_jit(n4);
                    printStream.println("\t\tvm.luaV_settable(s" + n6 + ", " + string3 + ", " + string2 + ");");
                    continue block35;
                }
                case 10: {
                    int n7 = LuaJit.GETARG_B(n4);
                    int n8 = LuaJit.GETARG_C(n4);
                    printStream.println("\t\ts" + n6 + " = new LTable(" + n7 + "," + n8 + ");");
                    continue block35;
                }
                case 11: {
                    String string3 = LuaJit.GETARG_RKB_jit(n4);
                    String string2 = LuaJit.GETARG_RKC_jit(n4);
                    printStream.println("\t\ts" + n6 + " = vm.luaV_gettable((s" + (n6 + 1) + "=" + string3 + "), " + string2 + ");");
                    continue block35;
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    String string3 = LuaJit.GETARG_RKB_jit(n4);
                    String string2 = LuaJit.GETARG_RKC_jit(n4);
                    printStream.println("\t\ts" + n6 + " = " + string2 + ".luaBinOpUnknown(" + n5 + "," + string3 + ");");
                    continue block35;
                }
                case 18: {
                    String string3 = LuaJit.GETARG_RKB_jit(n4);
                    printStream.println("\t\ts" + n6 + " = " + string3 + ".luaUnaryMinus();");
                }
                case 19: {
                    String string3 = LuaJit.GETARG_RKB_jit(n4);
                    printStream.println("\t\ts" + n6 + " = (" + string3 + ".toJavaBoolean()? LBoolean.TRUE: LBoolean.FALSE);");
                    continue block35;
                }
                case 20: {
                    String string3 = LuaJit.GETARG_RKB_jit(n4);
                    printStream.println("\t\ts" + n6 + " = LInteger.valueOf(" + string3 + ".luaLength());");
                }
                case 21: {
                    int n7 = LuaState.GETARG_B(n4);
                    int n8 = LuaState.GETARG_C(n4);
                    printStream.println("\t\tbaos = new ByteArrayOutputStream();");
                    for (int j = n7; j <= n8; ++j) {
                        printStream.println("\t\ts" + j + ".luaConcatTo( baos );");
                    }
                    printStream.println("\t\ts" + n6 + " = new LString( baos.toByteArray() );");
                    printStream.println("\t\tbaos = null;");
                    continue block35;
                }
                case 22: {
                    continue block35;
                }
                case 23: 
                case 24: 
                case 25: {
                    String string3 = LuaJit.GETARG_RKB_jit(n4);
                    String string2 = LuaJit.GETARG_RKC_jit(n4);
                    printStream.println("\t\tif ( " + (n6 == 0 ? "!" : "") + " " + string2 + ".luaBinCmpUnknown(" + n5 + ", " + string3 + ") )");
                    continue block35;
                }
                case 26: {
                    int n8 = LuaState.GETARG_C(n4);
                    printStream.println("\t\tif ( " + (n8 != 0 ? "!" : "") + " s" + n6 + ".toJavaBoolean() )");
                    continue block35;
                }
                case 27: {
                    String string3 = LuaJit.GETARG_RKB_jit(n4);
                    int n8 = LuaState.GETARG_C(n4);
                    printStream.println("\t\tif ( " + (n8 != 0 ? "!" : "") + " " + string3 + ".toJavaBoolean() )");
                    printStream.println("\t\t\ts" + n6 + " = " + string3 + ";");
                    printStream.println("\t\telse");
                    continue block35;
                }
                case 28: {
                    int n7 = LuaState.GETARG_B(n4);
                    int n8 = LuaState.GETARG_C(n4);
                    printStream.println("\t\tvm.stack[base+" + n6 + "] = s" + n6 + ";");
                    if (n7 > 0) {
                        for (int j = 1; j < n7; ++j) {
                            printStream.println("\t\tvm.stack[base+" + (n6 + j) + "] = s" + (n6 + j) + ";");
                        }
                        printStream.println("\t\tvm.top = base+" + (n6 + n7) + ";");
                        printStream.println("\t\tvm.call(" + (n7 - 1) + "," + (n8 - 1) + ");");
                    } else {
                        printStream.println("\t\tvm.call(vm.top-base+" + (n6 - 1) + "," + (n8 - 1) + ");");
                    }
                    if (n8 <= 0) continue block35;
                    for (int j = 0; j < n8 - 1; ++j) {
                        printStream.println("\t\ts" + (n6 + j) + " = vm.stack[base+" + (n6 + j) + "];");
                    }
                    continue block35;
                }
                case 30: {
                    if (Lua.GET_OPCODE(nArray[i - 1]) == 30) continue block35;
                    if (lPrototype.is_vararg != 0) {
                        printStream.println("\t\tbase -= nvarargs;");
                    } else {
                        printStream.println("\t\tbase -= 1;");
                    }
                    int n7 = LuaState.GETARG_B(n4);
                    if (n7 > 0) {
                        for (int j = 1; j < n7; ++j) {
                            printStream.println("\t\tvm.stack[base+" + (j - 1) + "] = s" + (n6 + j - 1) + ";");
                        }
                        printStream.println("\t\tvm.top = base+" + (n7 - 1) + ";");
                    }
                    printStream.println("\t\treturn;");
                    continue block35;
                }
                case 32: {
                    int n7 = LuaState.GETARG_sBx(n4);
                    String string4 = "s" + n6;
                    String string5 = "s" + (n6 + 1);
                    String string6 = "s" + (n6 + 2);
                    String string7 = "s" + (n6 + 3);
                    String string8 = "back" + i;
                    printStream.println("\t\tboolean " + string8 + "=" + string6 + ".luaBinCmpInteger(Lua.OP_LT,0);");
                    printStream.println("\t\tfor ( " + string7 + "=" + string4 + ";\n" + "\t\t\t" + string8 + "? " + string7 + ".luaBinCmpUnknown(Lua.OP_LE, " + string5 + "): " + string5 + ".luaBinCmpUnknown(Lua.OP_LE, " + string7 + ");\n" + "\t\t\t" + string7 + "=" + string7 + ".luaBinOpUnknown(Lua.OP_ADD," + string6 + ") )\n" + "\t\t{ /* FORLOOP */");
                    continue block35;
                }
                case 31: {
                    printStream.println("\t\t} /* LOOPBOT */");
                    continue block35;
                }
                case 33: {
                    continue block35;
                }
                case 34: {
                    int n7 = LuaState.GETARG_B(n4);
                    int n8 = LuaState.GETARG_C(n4);
                    if (n8 == 0) {
                        n8 = nArray[++i];
                    }
                    int n9 = (n8 - 1) * 50;
                    if (n7 == 0) {
                        printStream.println("\t\tt = (LTable) s" + n6 + ";");
                        printStream.println("\t\tfor ( int j=0, nj=vm.top-base-" + (n6 + 1) + "; j<nj; j++ )");
                        printStream.println("\t\t\tt.put(" + n9 + "+j,vm.stack[base+" + n6 + "+j]);");
                        continue block35;
                    }
                    printStream.println("\t\tt = (LTable) s" + n6 + ";");
                    for (int j = 1; j <= n7; ++j) {
                        printStream.println("\t\tt.put(" + (n9 + j) + ",s" + (n6 + j) + ");");
                    }
                    continue block35;
                }
                case 36: {
                    int n7 = LuaState.GETARG_Bx(n4);
                    printStream.println("\t\ts" + n6 + " = newcl = p.p[" + n7 + "].newClosure(env);");
                    int n10 = lPrototype.p[n7].nups;
                    for (int j = 0; j < n10; ++j) {
                        n4 = nArray[++i];
                        n5 = LuaState.GET_OPCODE(n4);
                        n7 = LuaState.GETARG_B(n4);
                        if (n5 == 4) {
                            printStream.println("\t\tnewcl.upVals[" + j + "] = newcl.upVals[" + n7 + "];");
                            continue;
                        }
                        if (n5 == 0) {
                            printStream.println("\t\tnewcl.upVals[" + j + "] = vm.findUpVal(base+" + n7 + ");");
                            continue;
                        }
                        throw new IllegalArgumentException("bad opcode: " + n5);
                    }
                    continue block35;
                }
                case 37: {
                    int n7 = LuaState.GETARG_B(n4) - 1;
                    if (n7 == -1) {
                        printStream.println("\t\tncopy = ntotal = nvarargs;");
                    } else {
                        printStream.println("\t\tncopy = Math.min(ntotal=" + n7 + ",nvarargs);");
                    }
                    printStream.println("\t\tSystem.arraycopy(vm.stack,base-nvarargs,vm.stack,base+" + n6 + ",ncopy);");
                    printStream.println("\t\tfor (int j = ncopy; j < ntotal; j++)");
                    printStream.println("\t\t\tvm.stack[base+j] = LNil.NIL;");
                    printStream.println("\t\tvm.top = base+ntotal+" + n6 + ";");
                }
            }
        }
        printStream.print("\t}\n}\n");
    }

    static {
        filenum = 0;
        TESTS = new HashSet<Integer>();
        TESTS.add(26);
        TESTS.add(23);
        TESTS.add(24);
        TESTS.add(25);
        TESTS.add(27);
    }
}

