/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.lib;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.luaj.vm.CallInfo;
import org.luaj.vm.LClosure;
import org.luaj.vm.LFunction;
import org.luaj.vm.LNil;
import org.luaj.vm.LString;
import org.luaj.vm.LTable;
import org.luaj.vm.LValue;
import org.luaj.vm.LuaState;
import org.luaj.vm.Platform;

public class BaseLib
extends LFunction {
    public static InputStream STDIN = null;
    public static PrintStream STDOUT = System.out;
    private static final String[] NAMES = new String[]{"base", "print", "pairs", "getmetatable", "setmetatable", "type", "pcall", "ipairs", "error", "assert", "loadfile", "tonumber", "rawequal", "rawget", "rawset", "getfenv", "setfenv", "select", "collectgarbage", "dofile", "loadstring", "load", "tostring", "unpack", "xpcall", "next", "_inext"};
    private static final int INSTALL = 0;
    private static final int PRINT = 1;
    private static final int PAIRS = 2;
    private static final int GETMETATABLE = 3;
    private static final int SETMETATABLE = 4;
    private static final int TYPE = 5;
    private static final int PCALL = 6;
    private static final int IPAIRS = 7;
    private static final int ERROR = 8;
    private static final int ASSERT = 9;
    private static final int LOADFILE = 10;
    private static final int TONUMBER = 11;
    private static final int RAWEQUAL = 12;
    private static final int RAWGET = 13;
    private static final int RAWSET = 14;
    private static final int GETFENV = 15;
    private static final int SETFENV = 16;
    private static final int SELECT = 17;
    private static final int COLLECTGARBAGE = 18;
    private static final int DOFILE = 19;
    private static final int LOADSTRING = 20;
    private static final int LOAD = 21;
    private static final int TOSTRING = 22;
    private static final int UNPACK = 23;
    private static final int XPCALL = 24;
    private static final int NEXT = 25;
    private static final int INEXT = 26;
    private static LFunction next;
    private static LFunction inext;
    private int id;

    public static void install(LTable lTable) {
        int n = NAMES.length;
        for (int i = 1; i < n; ++i) {
            lTable.put(NAMES[i], (LValue)new BaseLib(i));
        }
        next = new BaseLib(25);
        inext = new BaseLib(26);
        lTable.put("_G", (LValue)lTable);
        lTable.put("_VERSION", (LValue)new LString("Luaj 1.0"));
    }

    private BaseLib(int n) {
        this.id = n;
    }

    public String toString() {
        return NAMES[this.id] + "()";
    }

    private static void setResult(LuaState luaState, LValue lValue) {
        luaState.resettop();
        luaState.pushlvalue(lValue);
    }

    private static void setErrorResult(LuaState luaState, String string) {
        luaState.resettop();
        luaState.pushnil();
        luaState.pushstring(string);
    }

    public int invoke(LuaState luaState) {
        switch (this.id) {
            case 1: {
                int n = luaState.gettop();
                luaState.getglobal("tostring");
                for (int i = 1; i <= n; ++i) {
                    luaState.pushvalue(-1);
                    luaState.pushvalue(i);
                    luaState.call(1, 1);
                    if (luaState.type(-1) != 4) {
                        luaState.error("'tostring' must return a string to 'print'");
                    }
                    if (i > 1) {
                        STDOUT.print("\t");
                    }
                    STDOUT.print(luaState.tostring(-1));
                    luaState.poplvalue();
                }
                STDOUT.println();
                return 0;
            }
            case 7: {
                LTable lTable = luaState.checktable(1);
                luaState.pushfunction(inext);
                luaState.pushlvalue(lTable);
                luaState.pushinteger(0);
                return 3;
            }
            case 2: {
                LTable lTable = luaState.checktable(1);
                luaState.pushfunction(next);
                luaState.pushlvalue(lTable);
                luaState.pushnil();
                return 3;
            }
            case 26: {
                int n = luaState.checkint(2) + 1;
                LTable lTable = luaState.checktable(1);
                LValue lValue = lTable.get(n);
                if (!lValue.isNil()) {
                    luaState.pushinteger(n);
                    luaState.pushlvalue(lValue);
                    return 2;
                }
                return 0;
            }
            case 25: {
                LTable lTable = luaState.checktable(1);
                LValue lValue = luaState.topointer(2);
                luaState.resettop();
                lTable.next(luaState, lValue, false);
                return -1;
            }
            case 3: {
                luaState.checkany(1);
                if (!luaState.getmetatable(1)) {
                    luaState.pushnil();
                    return 1;
                }
                luaState.getfield(-1, LValue.TM_METATABLE);
                if (luaState.isnil(-1)) {
                    luaState.pop(1);
                }
                return 1;
            }
            case 4: {
                LTable lTable = luaState.checktable(1);
                LValue lValue = luaState.checkany(2);
                luaState.argcheck(lValue.isTable() || lValue.isNil(), 2, "table or nil expected");
                lTable = lTable.luaSetMetatable(lValue);
                luaState.pushlvalue(lTable);
                return 1;
            }
            case 5: {
                LValue lValue = luaState.checkany(1);
                luaState.pushlstring(lValue.luaGetTypeName());
                return 1;
            }
            case 6: {
                luaState.checkany(1);
                int n = luaState.gettop();
                int n2 = luaState.pcall(n - 1, -1, 0);
                if (n2 == 0) {
                    luaState.pushboolean(true);
                    luaState.insert(1);
                    return -1;
                }
                luaState.pushboolean(false);
                luaState.insert(-2);
                return 2;
            }
            case 24: {
                LValue lValue = luaState.checkany(3);
                luaState.settop(1);
                int n = luaState.pcall(0, -1, 0);
                if (n == 0) {
                    luaState.pushboolean(true);
                    luaState.insert(1);
                    return -1;
                }
                luaState.pushlvalue(lValue);
                luaState.insert(1);
                n = luaState.pcall(luaState.gettop() - 1, 1, 0);
                if (n == 0) {
                    luaState.pushboolean(false);
                    luaState.insert(1);
                    return -1;
                }
                luaState.pushboolean(false);
                luaState.pushstring("error in error handling");
                return 2;
            }
            case 8: {
                luaState.error(luaState.optstring(1, null), luaState.optint(2, -1));
                return 0;
            }
            case 9: {
                if (!luaState.toboolean(1)) {
                    luaState.error(luaState.optstring(2, "assertion failed!"));
                }
                return -1;
            }
            case 10: {
                BaseLib.loadfile(luaState, luaState.optstring(1, null));
                return -1;
            }
            case 11: {
                int n = luaState.optint(2, 10);
                if (n == 10) {
                    luaState.checkany(1);
                    LValue lValue = luaState.tolnumber(1);
                    luaState.pushlvalue(lValue);
                    return 1;
                }
                if (n < 2 || n > 36) {
                    luaState.argerror(2, "base out of range");
                }
                LString lString = luaState.checklstring(1);
                luaState.pushlvalue(lString.luaToNumber(n));
                return 1;
            }
            case 12: {
                LValue lValue = luaState.checkany(1);
                LValue lValue2 = luaState.checkany(2);
                luaState.pushboolean(lValue == lValue2);
                return 1;
            }
            case 13: {
                LTable lTable = luaState.checktable(1);
                LValue lValue = luaState.checkany(2);
                luaState.pushlvalue(lTable.get(lValue));
                return 1;
            }
            case 14: {
                LTable lTable = luaState.checktable(1);
                LValue lValue = luaState.checkany(2);
                LValue lValue3 = luaState.checkany(3);
                lTable.put(lValue, lValue3);
                luaState.pushlvalue(lTable);
                return 1;
            }
            case 15: {
                LValue lValue = BaseLib.getfunc(luaState, true);
                luaState.pushlvalue(lValue.luaGetEnv(luaState._G));
                return 1;
            }
            case 16: {
                LTable lTable = luaState.checktable(2);
                if (luaState.isnumber(1) && luaState.tointeger(1) == 0) {
                    luaState._G = lTable;
                } else {
                    LValue lValue = BaseLib.getfunc(luaState, false);
                    if (!(lValue instanceof LClosure) || !lValue.luaSetEnv(lTable)) {
                        luaState.error("'setfenv' cannot change environment of given object");
                    }
                    luaState.pushlvalue(lValue);
                    return 1;
                }
            }
            case 17: {
                luaState.checkany(1);
                int n = luaState.gettop();
                if (luaState.isnumber(1)) {
                    int n3 = luaState.tolnumber(1).toJavaInt();
                    if (n3 < 0) {
                        n3 += n;
                    }
                    if (n3 <= 0) {
                        luaState.argerror(1, "index out of range");
                    }
                    if (n3 >= n) {
                        return 0;
                    }
                    return n - n3;
                }
                if (luaState.checkstring(1).equals("#")) {
                    luaState.pushnumber(n - 1);
                    return 1;
                }
                luaState.typerror(1, "expected number or '#'");
                return 0;
            }
            case 18: {
                String string = luaState.optstring(1, "collect");
                int n = 0;
                if ("collect".equals(string)) {
                    System.gc();
                } else if ("count".equals(string)) {
                    Runtime runtime = Runtime.getRuntime();
                    long l = runtime.totalMemory() - runtime.freeMemory();
                    n = (int)(l >> 10);
                } else {
                    luaState.argerror(2, "gc op");
                }
                luaState.pushnumber(n);
                return 1;
            }
            case 19: {
                this.dofile(luaState);
                return -1;
            }
            case 20: {
                this.loadstring(luaState, luaState.checklstring(1), luaState.optstring(2, "(string)"));
                return -1;
            }
            case 21: {
                this.load(luaState);
                return -1;
            }
            case 22: {
                LValue lValue = luaState.checkany(1);
                luaState.pushlvalue(lValue.luaAsString());
                return 1;
            }
            case 23: {
                LTable lTable = luaState.checktable(1);
                int n = luaState.gettop();
                int n4 = luaState.optint(2, 1);
                int n5 = n >= 3 ? luaState.checkint(3) : lTable.luaLength();
                luaState.resettop();
                luaState.checkstack(n5 + 1 - n4);
                for (int i = n4; i <= n5; ++i) {
                    luaState.pushlvalue(lTable.get(i));
                }
                return -1;
            }
        }
        LuaState.vmerror("bad base id");
        return 0;
    }

    private static LValue getfunc(LuaState luaState, boolean bl) {
        if (luaState.isfunction(1)) {
            return luaState.tofunction(1);
        }
        int n = bl ? luaState.optint(1, 1) : luaState.checkint(1);
        luaState.argcheck(n >= 0, 1, "level must be non-negative");
        luaState.argcheck(n - 1 <= luaState.cc, 1, "invalid level");
        CallInfo callInfo = luaState.getStackFrame(n - 1);
        if (callInfo == null || callInfo.closure == null) {
            return LNil.NIL;
        }
        return callInfo.closure;
    }

    public static void redirectOutput(OutputStream outputStream) {
        STDOUT = new PrintStream(outputStream);
    }

    public static void restoreStandardOutput() {
        STDOUT = System.out;
    }

    private static void closeSafely(InputStream inputStream) {
        try {
            if (inputStream != null && inputStream != STDIN) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static void closeSafely(OutputStream outputStream) {
        try {
            if (outputStream != null && outputStream != STDOUT) {
                outputStream.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean loadis(LuaState luaState, InputStream inputStream, String string) {
        try {
            luaState.resettop();
            if (0 != luaState.load(inputStream, string)) {
                BaseLib.setErrorResult(luaState, "cannot load " + string + ": " + luaState.topointer(-1));
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            BaseLib.closeSafely(inputStream);
        }
    }

    private static boolean loadfile(LuaState luaState, String string) {
        InputStream inputStream;
        String string2;
        if (string != null) {
            string2 = string;
            inputStream = Platform.getInstance().openFile(string);
            if (inputStream == null) {
                BaseLib.setErrorResult(luaState, "cannot open " + string + ": No such file or directory");
                return false;
            }
        } else {
            inputStream = STDIN != null ? STDIN : new ByteArrayInputStream(new byte[0]);
            string2 = "-";
        }
        return BaseLib.loadis(luaState, inputStream, string2);
    }

    private void dofile(LuaState luaState) {
        String string = luaState.optstring(1, null);
        if (BaseLib.loadfile(luaState, string)) {
            luaState.call(0, 0);
        } else {
            luaState.error(luaState.tostring(-1));
        }
    }

    private boolean loadstring(LuaState luaState, LString lString, String string) {
        return BaseLib.loadis(luaState, lString.toInputStream(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean load(LuaState luaState) {
        LFunction lFunction = luaState.checkfunction(2);
        String string = luaState.optstring(3, "=(load)");
        LClosure lClosure = (LClosure)lFunction;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            while (true) {
                BaseLib.setResult(luaState, lClosure);
                if (0 != luaState.pcall(0, 1, 0)) {
                    BaseLib.setErrorResult(luaState, luaState.tostring(2));
                    boolean bl = false;
                    return bl;
                }
                LValue lValue = luaState.topointer(2);
                if (lValue.isNil()) break;
                LString lString = lValue.luaAsString();
                lString.write(byteArrayOutputStream, 0, lString.length());
            }
            boolean bl = BaseLib.loadis(luaState, new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), string);
            return bl;
        }
        catch (IOException iOException) {
            BaseLib.setErrorResult(luaState, iOException.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            BaseLib.closeSafely(byteArrayOutputStream);
        }
    }
}

