/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.lib;

import org.luaj.lib.PackageLib;
import org.luaj.vm.CallInfo;
import org.luaj.vm.LBoolean;
import org.luaj.vm.LClosure;
import org.luaj.vm.LFunction;
import org.luaj.vm.LInteger;
import org.luaj.vm.LNil;
import org.luaj.vm.LPrototype;
import org.luaj.vm.LString;
import org.luaj.vm.LTable;
import org.luaj.vm.LValue;
import org.luaj.vm.Lua;
import org.luaj.vm.LuaErrorException;
import org.luaj.vm.LuaState;
import org.luaj.vm.UpVal;

public class DebugLib
extends LFunction {
    private static final String[] NAMES = new String[]{"debuglib", "debug", "getfenv", "gethook", "getinfo", "getlocal", "getmetatable", "getregistry", "getupvalue", "setfenv", "sethook", "setlocal", "setmetatable", "setupvalue", "traceback"};
    private static final int INSTALL = 0;
    private static final int DEBUG = 1;
    private static final int GETFENV = 2;
    private static final int GETHOOK = 3;
    private static final int GETINFO = 4;
    private static final int GETLOCAL = 5;
    private static final int GETMETATABLE = 6;
    private static final int GETREGISTRY = 7;
    private static final int GETUPVALUE = 8;
    private static final int SETFENV = 9;
    private static final int SETHOOK = 10;
    private static final int SETLOCAL = 11;
    private static final int SETMETATABLE = 12;
    private static final int SETUPVALUE = 13;
    private static final int TRACEBACK = 14;
    private static final int MAXSTACK = 250;
    private static final LString LUA = new LString("Lua");
    private static final LString JAVA = new LString("Java");
    private static final LString JAVASRC = new LString("[Java]");
    private static final LString QMARK = new LString("?");
    private static final LString GLOBAL = new LString("global");
    private static final LString LOCAL = new LString("local");
    private static final LString METHOD = new LString("method");
    private static final LString UPVALUE = new LString("upvalue");
    private static final LString FIELD = new LString("field");
    private static final LString NOSTRING = new LString("");
    private final int id;

    public static void install(LuaState luaState) {
        LTable lTable = new LTable();
        for (int i = 1; i < NAMES.length; ++i) {
            lTable.put(NAMES[i], (LValue)new DebugLib(i));
        }
        luaState._G.put("debug", (LValue)lTable);
        PackageLib.setIsLoaded("debug", lTable);
    }

    public DebugLib() {
        this.id = 0;
    }

    private DebugLib(int n) {
        this.id = n;
    }

    public String toString() {
        return NAMES[this.id] + "()";
    }

    public int invoke(LuaState luaState) {
        switch (this.id) {
            case 0: {
                DebugLib.install(luaState);
                return 0;
            }
            case 1: {
                return this.debug(luaState);
            }
            case 2: {
                return this.getfenv(luaState);
            }
            case 3: {
                return this.gethook(luaState);
            }
            case 4: {
                return this.getinfo(luaState);
            }
            case 5: {
                return this.getlocal(luaState);
            }
            case 6: {
                return this.getmetatable(luaState);
            }
            case 7: {
                return this.getregistry(luaState);
            }
            case 8: {
                return this.getupvalue(luaState);
            }
            case 9: {
                return this.setfenv(luaState);
            }
            case 10: {
                return this.sethook(luaState);
            }
            case 11: {
                return this.setlocal(luaState);
            }
            case 12: {
                return this.setmetatable(luaState);
            }
            case 13: {
                return this.setupvalue(luaState);
            }
            case 14: {
                return this.traceback(luaState);
            }
        }
        LuaState.vmerror("bad package id");
        return 0;
    }

    protected int debug(LuaState luaState) {
        return 0;
    }

    protected int gethook(LuaState luaState) {
        LuaState luaState2 = luaState;
        if (luaState.gettop() >= 2) {
            luaState2 = luaState.checkthread((int)1).vm;
        }
        luaState.pushlvalue(luaState2.gethook());
        luaState.pushinteger(luaState2.gethookmask());
        luaState.pushinteger(luaState2.gethookcount());
        return 3;
    }

    protected LuaState optthreadvm(LuaState luaState, int n) {
        if (!luaState.isthread(n)) {
            return luaState;
        }
        LuaState luaState2 = luaState.checkthread((int)n).vm;
        luaState.remove(n);
        return luaState2;
    }

    protected int sethook(LuaState luaState) {
        LuaState luaState2 = this.optthreadvm(luaState, 1);
        LFunction lFunction = luaState.isnoneornil(1) ? null : luaState.checkfunction(1);
        String string = luaState.optstring(2, "");
        int n = luaState.optint(3, 0);
        int n2 = 0;
        block5: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case 'c': {
                    n2 |= 1;
                    continue block5;
                }
                case 'l': {
                    n2 |= 4;
                    continue block5;
                }
                case 'r': {
                    n2 |= 2;
                }
            }
        }
        luaState2.sethook(lFunction, n2, n);
        return 0;
    }

    protected int getfenv(LuaState luaState) {
        LValue lValue = luaState.topointer(1);
        LTable lTable = lValue.luaGetEnv(null);
        luaState.pushlvalue(lTable != null ? lTable : LNil.NIL);
        return 1;
    }

    protected int setfenv(LuaState luaState) {
        LValue lValue = luaState.topointer(1);
        LTable lTable = luaState.checktable(2);
        lValue.luaSetEnv(lTable);
        luaState.settop(1);
        return 1;
    }

    protected int getinfo(LuaState luaState) {
        StackInfo stackInfo;
        LuaState luaState2 = this.optthreadvm(luaState, 1);
        String string = luaState.optstring(2, "nSluf");
        if (luaState.isnumber(1)) {
            int n = luaState.tointeger(1);
            stackInfo = DebugLib.getstackinfo(luaState2, n, 1)[0];
            if (stackInfo == null) {
                return 0;
            }
        } else {
            LFunction lFunction = luaState.checkfunction(1);
            stackInfo = DebugLib.findstackinfo(luaState2, lFunction);
        }
        LTable lTable = new LTable();
        luaState.pushlvalue(lTable);
        LClosure lClosure = stackInfo.closure();
        int n = string.length();
        block8: for (int i = 0; i < n; ++i) {
            switch (string.charAt(i)) {
                case 'S': {
                    if (lClosure != null) {
                        LPrototype lPrototype = lClosure.p;
                        lTable.put("what", (LValue)LUA);
                        lTable.put("source", (LValue)lPrototype.source);
                        lTable.put("short_src", (LValue)new LString(lPrototype.sourceshort()));
                        lTable.put("linedefined", lPrototype.linedefined);
                        lTable.put("lastlinedefined", lPrototype.lastlinedefined);
                        continue block8;
                    }
                    LString lString = stackInfo.func != null ? new LString("[Java] " + stackInfo.func.toString()) : JAVASRC;
                    lTable.put("what", (LValue)JAVA);
                    lTable.put("source", (LValue)lString);
                    lTable.put("short_src", (LValue)lString);
                    lTable.put("linedefined", -1);
                    lTable.put("lastlinedefined", -1);
                    continue block8;
                }
                case 'l': {
                    int n2 = stackInfo.currentline();
                    lTable.put("currentline", n2);
                    continue block8;
                }
                case 'u': {
                    lTable.put("nups", lClosure != null ? lClosure.p.nups : 0);
                    continue block8;
                }
                case 'n': {
                    LString[] lStringArray = stackInfo.getfunckind();
                    lTable.put("name", (LValue)(lStringArray != null ? lStringArray[0] : QMARK));
                    lTable.put("namewhat", (LValue)(lStringArray != null ? lStringArray[1] : NOSTRING));
                    continue block8;
                }
                case 'f': {
                    lTable.put("func", stackInfo.func);
                    continue block8;
                }
                case 'L': {
                    int n3;
                    LTable lTable2 = new LTable();
                    lTable.put("activelines", (LValue)lTable2);
                    if (stackInfo.luainfo == null || (n3 = stackInfo.luainfo.currentline()) < 0) continue block8;
                    lTable2.put(1, (LValue)LInteger.valueOf(n3));
                    continue block8;
                }
            }
        }
        return 1;
    }

    protected int getlocal(LuaState luaState) {
        LString lString;
        LuaState luaState2 = this.optthreadvm(luaState, 1);
        int n = luaState.checkint(1);
        int n2 = luaState.checkint(2);
        StackInfo stackInfo = DebugLib.getstackinfo(luaState2, n, 1)[0];
        CallInfo callInfo = stackInfo != null ? stackInfo.luainfo : null;
        LPrototype lPrototype = callInfo != null ? callInfo.closure.p : null;
        LString lString2 = lString = lPrototype != null ? lPrototype.getlocalname(n2, callInfo.currentpc()) : null;
        if (lString != null) {
            LValue lValue = luaState2.stack[callInfo.base + (n2 - 1)];
            luaState.pushlvalue(lString);
            luaState.pushlvalue(lValue);
            return 2;
        }
        luaState.pushnil();
        return 1;
    }

    protected int setlocal(LuaState luaState) {
        LString lString;
        LuaState luaState2 = this.optthreadvm(luaState, 1);
        int n = luaState.checkint(1);
        int n2 = luaState.checkint(2);
        LValue lValue = luaState.topointer(3);
        StackInfo stackInfo = DebugLib.getstackinfo(luaState2, n, 1)[0];
        CallInfo callInfo = stackInfo != null ? stackInfo.luainfo : null;
        LPrototype lPrototype = callInfo != null ? callInfo.closure.p : null;
        LString lString2 = lString = lPrototype != null ? lPrototype.getlocalname(n2, callInfo.currentpc()) : null;
        if (lString != null) {
            luaState2.stack[callInfo.base + (n2 - 1)] = lValue;
            luaState.pushlvalue(lString);
        } else {
            luaState.pushnil();
        }
        return 1;
    }

    protected int getmetatable(LuaState luaState) {
        LValue lValue = luaState.topointer(1);
        LTable lTable = lValue.luaGetMetatable();
        if (lTable != null) {
            luaState.pushlvalue(lValue.luaGetMetatable());
        } else {
            luaState.pushnil();
        }
        return 1;
    }

    protected int setmetatable(LuaState luaState) {
        LValue lValue = luaState.topointer(1);
        try {
            if (!luaState.isnoneornil(2)) {
                lValue.luaSetMetatable(luaState.checktable(3));
            } else {
                lValue.luaSetMetatable(null);
            }
            luaState.pushboolean(true);
            return 1;
        }
        catch (LuaErrorException luaErrorException) {
            luaState.pushboolean(false);
            luaState.pushstring(luaErrorException.toString());
            return 2;
        }
    }

    protected int getregistry(LuaState luaState) {
        luaState.pushlvalue(new LTable());
        return 1;
    }

    private static LString findupvalue(LClosure lClosure, int n) {
        if (lClosure.upVals != null && n > 0 && n <= lClosure.upVals.length) {
            if (lClosure.p.upvalues != null && n <= lClosure.p.upvalues.length) {
                return lClosure.p.upvalues[n - 1];
            }
            return new LString("." + n + "");
        }
        return null;
    }

    protected int getupvalue(LuaState luaState) {
        LClosure lClosure;
        LString lString;
        LFunction lFunction = luaState.checkfunction(1);
        int n = luaState.checkint(2);
        luaState.resettop();
        if (lFunction.isClosure() && (lString = DebugLib.findupvalue(lClosure = (LClosure)lFunction, n)) != null) {
            luaState.pushlstring(lString);
            luaState.pushlvalue(lClosure.upVals[n - 1].getValue());
            return 2;
        }
        luaState.pushnil();
        return 1;
    }

    protected int setupvalue(LuaState luaState) {
        LClosure lClosure;
        LString lString;
        LFunction lFunction = luaState.checkfunction(1);
        int n = luaState.checkint(2);
        LValue lValue = luaState.topointer(3);
        luaState.resettop();
        if (lFunction instanceof LClosure && (lString = DebugLib.findupvalue(lClosure = (LClosure)lFunction, n)) != null) {
            lClosure.upVals[n - 1].setValue(lValue);
            luaState.pushlstring(lString);
            return 1;
        }
        luaState.pushnil();
        return 1;
    }

    protected int traceback(LuaState luaState) {
        LuaState luaState2 = this.optthreadvm(luaState, 1);
        String string = "stack traceback:\n";
        int n = luaState.optint(2, 1);
        if (!luaState.isnoneornil(1)) {
            string = luaState.checkstring(1) + "\n";
        }
        String string2 = DebugLib.traceback(luaState2, n);
        luaState.pushstring(string + string2);
        return 1;
    }

    public static LValue[] getlocal(LuaState luaState, CallInfo callInfo, int n) {
        LPrototype lPrototype = callInfo.closure.p;
        LString lString = lPrototype.getlocalname(n, callInfo.currentpc());
        if (lString != null) {
            LValue lValue = luaState.stack[callInfo.base + (n - 1)];
            return new LValue[]{lString, lValue};
        }
        return null;
    }

    public static LValue[] getupvalue(LClosure lClosure, int n) {
        LString lString = DebugLib.findupvalue(lClosure, n);
        if (lString != null) {
            UpVal upVal = lClosure.upVals[n - 1];
            LValue lValue = upVal.getValue();
            boolean bl = upVal.isClosed();
            return new LValue[]{lString, lValue, LBoolean.valueOf(bl)};
        }
        return null;
    }

    public static String traceback(LuaState luaState, int n) {
        StackInfo[] stackInfoArray = DebugLib.getstackinfo(luaState, n, 10);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stackInfoArray.length; ++i) {
            StackInfo stackInfo = stackInfoArray[i];
            if (stackInfo == null) continue;
            stringBuffer.append("\n\t");
            stringBuffer.append(stackInfo.sourceline());
            stringBuffer.append(": in ");
            stringBuffer.append(stackInfo.tracename());
        }
        return stringBuffer.toString();
    }

    private static void lua_assert(boolean bl) {
        if (!bl) {
            throw new RuntimeException("lua_assert failed");
        }
    }

    private static StackInfo[] getstackinfo(LuaState luaState, int n, int n2) {
        StackInfo[] stackInfoArray = new StackInfo[n2];
        int n3 = 0;
        LClosure lClosure = null;
        for (int i = luaState.cc; i >= 0; --i) {
            CallInfo callInfo = luaState.calls[i];
            LFunction lFunction = callInfo.currentfunc(luaState);
            if (!(lFunction == null || lFunction.isClosure() && lFunction == lClosure || n-- > 0)) {
                stackInfoArray[n3++] = new StackInfo(luaState, callInfo, callInfo.currentfunca(luaState), null, lFunction);
                if (n3 >= n2) {
                    return stackInfoArray;
                }
            }
            if (n-- <= 0) {
                if (i > 0 && luaState.calls[i - 1].currentfunc(luaState) == callInfo.closure) {
                    CallInfo callInfo2 = luaState.calls[i - 1];
                    int n4 = callInfo2.currentfunca(luaState);
                    stackInfoArray[n3++] = new StackInfo(luaState, callInfo2, n4, callInfo, callInfo.closure);
                } else {
                    stackInfoArray[n3++] = new StackInfo(luaState, null, -1, callInfo, callInfo.closure);
                }
                if (n3 >= n2) {
                    return stackInfoArray;
                }
            }
            lClosure = callInfo.closure;
        }
        return stackInfoArray;
    }

    private static StackInfo findstackinfo(LuaState luaState, LFunction lFunction) {
        for (int i = luaState.cc; i >= 0; --i) {
            CallInfo callInfo = luaState.calls[i];
            int n = callInfo.closure.p.code[callInfo.currentpc()];
            if (Lua.GET_OPCODE(n) != 28) continue;
            int n2 = Lua.GETARG_A(n);
            if (lFunction == luaState.stack[callInfo.base + n2]) {
                return new StackInfo(luaState, callInfo, n2, null, lFunction);
            }
            if (lFunction != callInfo.closure) continue;
            return new StackInfo(luaState, i > 0 ? luaState.calls[i - 1] : null, 0, callInfo, null);
        }
        return new StackInfo(luaState, null, -1, null, lFunction);
    }

    private static LString[] getobjname(LuaState luaState, CallInfo callInfo, int n) {
        if (callInfo.isLua()) {
            LPrototype lPrototype = callInfo.closure.p;
            int n2 = callInfo.pc > 0 ? callInfo.pc - 1 : 0;
            LString lString = lPrototype.getlocalname(n + 1, n2);
            if (lString != null) {
                return new LString[]{lString, LOCAL};
            }
            int n3 = DebugLib.symbexec(lPrototype, n2, n);
            DebugLib.lua_assert(n2 != -1);
            switch (Lua.GET_OPCODE(n3)) {
                case 5: {
                    int n4 = Lua.GETARG_Bx(n3);
                    return new LString[]{lPrototype.k[n4].luaAsString(), GLOBAL};
                }
                case 0: {
                    int n5 = Lua.GETARG_A(n3);
                    int n6 = Lua.GETARG_B(n3);
                    if (n6 >= n5) break;
                    return DebugLib.getobjname(luaState, callInfo, n6);
                }
                case 6: {
                    int n7 = Lua.GETARG_C(n3);
                    lString = DebugLib.kname(lPrototype, n7);
                    return new LString[]{lString, FIELD};
                }
                case 4: {
                    int n8 = Lua.GETARG_B(n3);
                    lString = n8 < lPrototype.upvalues.length ? lPrototype.upvalues[n8] : QMARK;
                    return new LString[]{lString, UPVALUE};
                }
                case 11: {
                    int n9 = Lua.GETARG_C(n3);
                    lString = DebugLib.kname(lPrototype, n9);
                    return new LString[]{lString, METHOD};
                }
            }
        }
        return null;
    }

    private static LString kname(LPrototype lPrototype, int n) {
        if (Lua.ISK(n) && lPrototype.k[Lua.INDEXK(n)].isString()) {
            return lPrototype.k[Lua.INDEXK(n)].luaAsString();
        }
        return QMARK;
    }

    private static boolean checkreg(LPrototype lPrototype, int n) {
        return n < lPrototype.maxstacksize;
    }

    private static boolean precheck(LPrototype lPrototype) {
        if (lPrototype.maxstacksize > 250) {
            return false;
        }
        DebugLib.lua_assert(lPrototype.numparams + (lPrototype.is_vararg & 1) <= lPrototype.maxstacksize);
        DebugLib.lua_assert((lPrototype.is_vararg & 4) == 0 || (lPrototype.is_vararg & 1) != 0);
        if (lPrototype.upvalues.length > lPrototype.nups) {
            return false;
        }
        if (lPrototype.lineinfo.length != lPrototype.code.length && lPrototype.lineinfo.length != 0) {
            return false;
        }
        return Lua.GET_OPCODE(lPrototype.code[lPrototype.code.length - 1]) == 30;
    }

    private static boolean checkopenop(LPrototype lPrototype, int n) {
        int n2 = lPrototype.code[n + 1];
        switch (Lua.GET_OPCODE(n2)) {
            case 28: 
            case 29: 
            case 30: 
            case 34: {
                return Lua.GETARG_B(n2) == 0;
            }
        }
        return false;
    }

    private static boolean checkArgMode(LPrototype lPrototype, int n, int n2) {
        switch (n2) {
            case 0: {
                if (n == 0) break;
                return false;
            }
            case 1: {
                break;
            }
            case 2: {
                DebugLib.checkreg(lPrototype, n);
                break;
            }
            case 3: {
                if (!Lua.ISK(n) ? n < lPrototype.maxstacksize : Lua.INDEXK(n) < lPrototype.k.length) break;
                return false;
            }
        }
        return true;
    }

    private static int symbexec(LPrototype lPrototype, int n, int n2) {
        int n3 = lPrototype.code.length - 1;
        if (!DebugLib.precheck(lPrototype)) {
            return 0;
        }
        block21: for (int i = 0; i < n; ++i) {
            int n4;
            int n5;
            int n6 = lPrototype.code[i];
            int n7 = Lua.GET_OPCODE(n6);
            int n8 = Lua.GETARG_A(n6);
            int n9 = 0;
            int n10 = 0;
            if (n7 >= 38) {
                return 0;
            }
            if (!DebugLib.checkreg(lPrototype, n8)) {
                return 0;
            }
            switch (Lua.getOpMode(n7)) {
                case 0: {
                    n9 = Lua.GETARG_B(n6);
                    n10 = Lua.GETARG_C(n6);
                    if (!DebugLib.checkArgMode(lPrototype, n9, Lua.getBMode(n7))) {
                        return 0;
                    }
                    if (DebugLib.checkArgMode(lPrototype, n10, Lua.getCMode(n7))) break;
                    return 0;
                }
                case 1: {
                    n9 = Lua.GETARG_Bx(n6);
                    if (Lua.getBMode(n7) != 3 || n9 < lPrototype.k.length) break;
                    return 0;
                }
                case 2: {
                    n9 = Lua.GETARG_sBx(n6);
                    if (Lua.getBMode(n7) != 2) break;
                    n5 = i + 1 + n9;
                    if (0 > n5 || n5 >= lPrototype.code.length) {
                        return 0;
                    }
                    if (n5 <= 0 || Lua.GET_OPCODE(n4 = lPrototype.code[n5 - 1]) != 34 || Lua.GETARG_C(n4) != 0) break;
                    return 0;
                }
            }
            if (Lua.testAMode(n7) && n8 == n2) {
                n3 = i;
            }
            if (Lua.testTMode(n7)) {
                if (i + 2 >= lPrototype.code.length) {
                    return 0;
                }
                if (Lua.GET_OPCODE(lPrototype.code[i + 1]) != 22) {
                    return 0;
                }
            }
            switch (n7) {
                case 2: {
                    if (n10 == 0 || i + 2 < lPrototype.code.length) continue block21;
                    return 0;
                }
                case 3: {
                    if (n8 > n2 || n2 > n9) continue block21;
                    n3 = i;
                    continue block21;
                }
                case 4: 
                case 8: {
                    if (n9 < lPrototype.nups) continue block21;
                    return 0;
                }
                case 5: 
                case 7: {
                    if (lPrototype.k[n9].isString()) continue block21;
                    return 0;
                }
                case 11: {
                    if (!DebugLib.checkreg(lPrototype, n8 + 1)) {
                        return 0;
                    }
                    if (n2 != n8 + 1) continue block21;
                    n3 = i;
                    continue block21;
                }
                case 21: {
                    if (n9 < n10) continue block21;
                    return 0;
                }
                case 33: {
                    if (n10 < 1) {
                        return 0;
                    }
                    if (!DebugLib.checkreg(lPrototype, n8 + 2 + n10)) {
                        return 0;
                    }
                    if (n2 < n8 + 2) continue block21;
                    n3 = i;
                    continue block21;
                }
                case 31: 
                case 32: {
                    if (!DebugLib.checkreg(lPrototype, n8 + 3)) {
                        return 0;
                    }
                }
                case 22: {
                    n5 = i + 1 + n9;
                    if (n2 == 255 || i >= n5 || n5 > n) continue block21;
                    i += n9;
                    continue block21;
                }
                case 28: 
                case 29: {
                    if (n9 != 0 && !DebugLib.checkreg(lPrototype, n8 + n9 - 1)) {
                        return 0;
                    }
                    if (--n10 == -1 ? !DebugLib.checkopenop(lPrototype, i) : n10 != 0 && !DebugLib.checkreg(lPrototype, n8 + n10 - 1)) {
                        return 0;
                    }
                    if (n2 < n8) continue block21;
                    n3 = i;
                    continue block21;
                }
                case 30: {
                    if (--n9 <= 0 || DebugLib.checkreg(lPrototype, n8 + n9 - 1)) continue block21;
                    return 0;
                }
                case 34: {
                    if (n9 > 0 && !DebugLib.checkreg(lPrototype, n8 + n9)) {
                        return 0;
                    }
                    if (n10 != 0) continue block21;
                    ++i;
                    continue block21;
                }
                case 36: {
                    if (n9 >= lPrototype.p.length) {
                        return 0;
                    }
                    n5 = lPrototype.p[n9].nups;
                    if (i + n5 >= lPrototype.code.length) {
                        return 0;
                    }
                    for (n4 = 1; n4 <= n5; ++n4) {
                        int n11 = Lua.GET_OPCODE(lPrototype.code[i + n4]);
                        if (n11 == 4 || n11 == 0) continue;
                        return 0;
                    }
                    if (n2 == 255) continue block21;
                    i += n5;
                    continue block21;
                }
                case 37: {
                    if ((lPrototype.is_vararg & 2) == 0 || (lPrototype.is_vararg & 4) != 0) {
                        return 0;
                    }
                    if (--n9 == -1 && !DebugLib.checkopenop(lPrototype, i)) {
                        return 0;
                    }
                    if (DebugLib.checkreg(lPrototype, n8 + n9 - 1)) continue block21;
                    return 0;
                }
            }
        }
        return lPrototype.code[n3];
    }

    private static class StackInfo {
        private LuaState vm;
        private CallInfo caller;
        private int stackpos;
        private CallInfo luainfo;
        private LValue func;

        public StackInfo(LuaState luaState, CallInfo callInfo, int n, CallInfo callInfo2, LFunction lFunction) {
            this.vm = luaState;
            this.caller = callInfo;
            this.stackpos = n;
            this.luainfo = callInfo2;
            this.func = lFunction != null ? lFunction : (callInfo2 != null ? callInfo2.closure : null);
        }

        public LClosure closure() {
            return this.luainfo != null ? this.luainfo.closure : (this.func != null && this.func.isClosure() ? (LClosure)this.func : null);
        }

        public String sourceline() {
            if (this.luainfo != null) {
                String string = this.luainfo.closure.p.source.toJavaString();
                int n = this.currentline();
                return (string.startsWith("@") || string.startsWith("=") ? string.substring(1) : string) + ":" + n;
            }
            return "[Java]";
        }

        public LString[] getfunckind() {
            return this.caller != null && this.stackpos >= 0 ? DebugLib.getobjname(this.vm, this.caller, this.stackpos) : null;
        }

        public int currentline() {
            return this.luainfo != null ? this.luainfo.currentline() : -1;
        }

        public String tracename() {
            if (this.caller == null) {
                return "main chunk";
            }
            if (this.func != null) {
                return this.func.toString();
            }
            LString[] lStringArray = this.getfunckind();
            if (lStringArray == null) {
                return "function ?";
            }
            return "function " + lStringArray[0].toJavaString();
        }
    }
}

