/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.lib.j2se;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.luaj.lib.j2se.CoerceJavaToLua;
import org.luaj.lib.j2se.CoerceLuaToJava;
import org.luaj.vm.LFunction;
import org.luaj.vm.LString;
import org.luaj.vm.LTable;
import org.luaj.vm.LUserData;
import org.luaj.vm.LValue;
import org.luaj.vm.LuaErrorException;
import org.luaj.vm.LuaState;

public final class LuajavaLib
extends LFunction {
    private static final int INIT = 0;
    private static final int BINDCLASS = 1;
    private static final int NEWINSTANCE = 2;
    private static final int NEW = 3;
    private static final int CREATEPROXY = 4;
    private static final int LOADLIB = 5;
    private static final String[] NAMES = new String[]{"luajava", "bindClass", "newInstance", "new", "createProxy", "loadLib"};
    private static final Map classMetatables = new HashMap();
    private int id;
    private static Map consCache = new HashMap();
    private static Map consIndex = new HashMap();
    private static Map methCache = new HashMap();
    private static Map methIndex = new HashMap();
    static /* synthetic */ Class class$org$luaj$vm$LuaState;

    public static void install(LTable lTable) {
        LTable lTable2 = new LTable();
        for (int i = 0; i < NAMES.length; ++i) {
            lTable2.put(NAMES[i], (LValue)new LuajavaLib(i));
        }
        lTable.put("luajava", (LValue)lTable2);
    }

    public LuajavaLib() {
    }

    private LuajavaLib(int n) {
        this.id = n;
    }

    public String toString() {
        return "luajava." + NAMES[this.id];
    }

    public boolean luaStackCall(final LuaState luaState) {
        switch (this.id) {
            case 0: {
                LuajavaLib.install(luaState._G);
                break;
            }
            case 1: {
                String string = luaState.tostring(2);
                try {
                    Class<?> clazz = Class.forName(string);
                    luaState.resettop();
                    luaState.pushlvalue(LuajavaLib.toUserdata(clazz, clazz));
                    break;
                }
                catch (Exception exception) {
                    throw new LuaErrorException(exception);
                }
            }
            case 2: 
            case 3: {
                try {
                    LValue lValue = luaState.topointer(2);
                    Class clazz = this.id == 2 ? Class.forName(lValue.toJavaString()) : (Class)lValue.toJavaInstance();
                    ParamsList paramsList = new ParamsList(luaState);
                    Constructor constructor = LuajavaLib.resolveConstructor(clazz, paramsList);
                    Object[] objectArray = CoerceLuaToJava.coerceArgs(paramsList.values, constructor.getParameterTypes());
                    Object t = constructor.newInstance(objectArray);
                    luaState.resettop();
                    luaState.pushlvalue(LuajavaLib.toUserdata(t, clazz));
                    break;
                }
                catch (Exception exception) {
                    throw new LuaErrorException(exception);
                }
            }
            case 4: {
                int n = Math.max(0, luaState.gettop() - 2);
                if (n <= 0) {
                    throw new LuaErrorException("no interfaces");
                }
                final LTable lTable = luaState.totable(-1);
                try {
                    Class[] classArray = new Class[n];
                    for (int i = 0; i < n; ++i) {
                        classArray[i] = Class.forName(luaState.tostring(i + 2));
                    }
                    InvocationHandler invocationHandler = new InvocationHandler(){

                        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                            luaState.pushlvalue(lTable);
                            luaState.getfield(-1, LString.valueOf(method.getName()));
                            luaState.remove(-2);
                            if (!luaState.isnil(-1)) {
                                int n = objectArray != null ? objectArray.length : 0;
                                for (int i = 0; i < n; ++i) {
                                    luaState.pushlvalue(CoerceJavaToLua.coerce(objectArray[i]));
                                }
                                luaState.call(n, 1);
                            }
                            LValue lValue = luaState.poplvalue();
                            return CoerceLuaToJava.coerceArg(lValue, method.getReturnType());
                        }
                    };
                    Object object = Proxy.newProxyInstance(this.getClass().getClassLoader(), classArray, invocationHandler);
                    luaState.resettop();
                    luaState.pushuserdata(object);
                    break;
                }
                catch (Exception exception) {
                    throw new LuaErrorException(exception);
                }
            }
            case 5: {
                try {
                    String string = luaState.tostring(2);
                    String string2 = luaState.tostring(3);
                    Class<?> clazz = Class.forName(string);
                    Method method = clazz.getMethod(string2, class$org$luaj$vm$LuaState == null ? (class$org$luaj$vm$LuaState = LuajavaLib.class$("org.luaj.vm.LuaState")) : class$org$luaj$vm$LuaState);
                    Object object = method.invoke(clazz, luaState);
                    if (object instanceof Integer) {
                        int n = (Integer)object;
                        int n2 = luaState.gettop() - n;
                        for (int i = 0; i < n2; ++i) {
                            luaState.remove(1);
                        }
                        break;
                    }
                    luaState.resettop();
                    break;
                }
                catch (Exception exception) {
                    throw new LuaErrorException(exception);
                }
            }
            default: {
                throw new LuaErrorException("not yet supported: " + this);
            }
        }
        return false;
    }

    static LUserData toUserdata(Object object, final Class clazz) {
        LTable lTable = (LTable)classMetatables.get(clazz);
        if (lTable == null) {
            lTable = new LTable();
            lTable.put(LValue.TM_INDEX, (LValue)new LFunction(){

                public boolean luaStackCall(LuaState luaState) {
                    LValue lValue = luaState.topointer(2);
                    LValue lValue2 = luaState.topointer(3);
                    String string = lValue2.toJavaString();
                    luaState.resettop();
                    try {
                        Field field = clazz.getField(string);
                        Object object = field.get(lValue.toJavaInstance());
                        luaState.pushlvalue(CoerceJavaToLua.coerce(object));
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        luaState.pushlvalue(new LMethod(clazz, string));
                    }
                    catch (Exception exception) {
                        throw new LuaErrorException(exception);
                    }
                    return false;
                }
            });
            lTable.put(LValue.TM_NEWINDEX, (LValue)new LFunction(){

                public boolean luaStackCall(LuaState luaState) {
                    LValue lValue = luaState.topointer(2);
                    LValue lValue2 = luaState.topointer(3);
                    LValue lValue3 = luaState.topointer(4);
                    String string = lValue2.toJavaString();
                    try {
                        Field field = clazz.getField(string);
                        Object object = CoerceLuaToJava.coerceArg(lValue3, field.getType());
                        field.set(lValue.toJavaInstance(), object);
                        luaState.resettop();
                    }
                    catch (Exception exception) {
                        throw new LuaErrorException(exception);
                    }
                    return false;
                }
            });
            classMetatables.put(clazz, lTable);
        }
        return new LUserData(object, lTable);
    }

    private static Constructor resolveConstructor(Class clazz, ParamsList paramsList) {
        List list;
        Constructor<?>[] constructorArray;
        Constructor constructor;
        HashMap<ParamsList, Constructor> hashMap = (HashMap<ParamsList, Constructor>)consCache.get(clazz);
        if (hashMap == null) {
            hashMap = new HashMap<ParamsList, Constructor>();
            consCache.put(clazz, hashMap);
        }
        if ((constructor = (Constructor)hashMap.get(paramsList)) != null) {
            return constructor;
        }
        HashMap hashMap2 = (HashMap)consIndex.get(clazz);
        if (hashMap2 == null) {
            hashMap2 = new HashMap();
            consIndex.put(clazz, hashMap2);
            constructorArray = clazz.getConstructors();
            for (int i = 0; i < constructorArray.length; ++i) {
                Constructor<?> constructor2 = constructorArray[i];
                Integer n = new Integer(constructor2.getParameterTypes().length);
                ArrayList arrayList = (ArrayList)hashMap2.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList();
                    hashMap2.put(n, arrayList);
                }
                arrayList.add(constructor2);
            }
        }
        if ((list = (List)hashMap2.get(constructorArray = new Integer(paramsList.classes.length))) == null) {
            throw new IllegalArgumentException("no constructor with " + constructorArray + " args");
        }
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        int n3 = list.size();
        for (int i = 0; i < n3; ++i) {
            Constructor constructor3 = (Constructor)list.get(i);
            int n4 = CoerceLuaToJava.scoreParamTypes(paramsList.values, constructor3.getParameterTypes());
            if (n4 >= n) continue;
            n = n4;
            n2 = i;
        }
        constructor = (Constructor)list.get(n2);
        hashMap.put(paramsList, constructor);
        return constructor;
    }

    private static Method resolveMethod(Class clazz, String string, ParamsList paramsList) {
        Object object;
        Method[] methodArray;
        Method method;
        HashMap<ParamsList, Method> hashMap;
        HashMap hashMap2 = (HashMap)methCache.get(clazz);
        if (hashMap2 == null) {
            hashMap2 = new HashMap();
            methCache.put(clazz, hashMap2);
        }
        if ((hashMap = (HashMap<ParamsList, Method>)hashMap2.get(string)) == null) {
            hashMap = new HashMap<ParamsList, Method>();
            hashMap2.put(string, hashMap);
        }
        if ((method = (Method)hashMap.get(paramsList)) != null) {
            return method;
        }
        HashMap hashMap3 = (HashMap)methIndex.get(clazz);
        if (hashMap3 == null) {
            hashMap3 = new HashMap();
            methIndex.put(clazz, hashMap3);
            methodArray = clazz.getMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                ArrayList<Object> arrayList;
                object = methodArray[i];
                String string2 = ((Method)object).getName();
                Integer n = new Integer(((Method)object).getParameterTypes().length);
                HashMap<Integer, ArrayList<Object>> hashMap4 = (HashMap<Integer, ArrayList<Object>>)hashMap3.get(string2);
                if (hashMap4 == null) {
                    hashMap4 = new HashMap<Integer, ArrayList<Object>>();
                    hashMap3.put(string2, hashMap4);
                }
                if ((arrayList = (ArrayList<Object>)hashMap4.get(n)) == null) {
                    arrayList = new ArrayList<Object>();
                    hashMap4.put(n, arrayList);
                }
                arrayList.add(object);
            }
        }
        if ((methodArray = (Method[])hashMap3.get(string)) == null) {
            throw new IllegalArgumentException("no method named '" + string + "'");
        }
        Integer n = new Integer(paramsList.classes.length);
        object = (List)methodArray.get(n);
        if (object == null) {
            throw new IllegalArgumentException("no method named '" + string + "' with " + n + " args");
        }
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        int n4 = object.size();
        for (int i = 0; i < n4; ++i) {
            Method method2 = (Method)object.get(i);
            int n5 = CoerceLuaToJava.scoreParamTypes(paramsList.values, method2.getParameterTypes());
            if (n5 >= n2) continue;
            n2 = n5;
            n3 = i;
        }
        method = (Method)object.get(n3);
        hashMap.put(paramsList, method);
        return method;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class LMethod
    extends LFunction {
        private final Class clazz;
        private final String s;

        private LMethod(Class clazz, String string) {
            this.clazz = clazz;
            this.s = string;
        }

        public String toString() {
            return this.clazz.getName() + "." + this.s + "()";
        }

        public boolean luaStackCall(LuaState luaState) {
            try {
                Object object = luaState.touserdata(2);
                ParamsList paramsList = new ParamsList(luaState);
                Method method = LuajavaLib.resolveMethod(this.clazz, this.s, paramsList);
                Object[] objectArray = CoerceLuaToJava.coerceArgs(paramsList.values, method.getParameterTypes());
                Object object2 = method.invoke(object, objectArray);
                luaState.resettop();
                luaState.pushlvalue(CoerceJavaToLua.coerce(object2));
                return false;
            }
            catch (Exception exception) {
                throw new LuaErrorException(exception);
            }
        }
    }

    public static class ParamsList {
        public final LValue[] values;
        public final Class[] classes;
        public int hash;

        ParamsList(LuaState luaState) {
            int n = Math.max(luaState.gettop() - 2, 0);
            this.values = new LValue[n];
            this.classes = new Class[n];
            for (int i = 0; i < n; ++i) {
                this.values[i] = luaState.topointer(i - n);
                this.classes[i] = this.values[i].getClass();
                this.hash += this.classes[i].hashCode();
            }
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            return object instanceof ParamsList ? Arrays.equals(this.classes, ((ParamsList)object).classes) : false;
        }
    }
}

