/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.platform;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.luaj.lib.j2se.J2seIoLib;
import org.luaj.lib.j2se.LuajavaLib;
import org.luaj.vm.LDouble;
import org.luaj.vm.LNumber;
import org.luaj.vm.LuaState;
import org.luaj.vm.Platform;

public class J2sePlatform
extends Platform {
    public String getName() {
        return "j2se";
    }

    public Reader createReader(InputStream inputStream) {
        return new InputStreamReader(inputStream);
    }

    public String getProperty(String string) {
        return System.getProperty(string);
    }

    protected void installOptionalLibs(LuaState luaState) {
        luaState.installStandardLibs();
        J2seIoLib.install(luaState._G);
        LuajavaLib.install(luaState._G);
    }

    public InputStream openFile(String string) {
        File file = new File(string);
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public LNumber mathPow(LNumber lNumber, LNumber lNumber2) {
        return LDouble.numberOf(Math.pow(lNumber.toJavaDouble(), lNumber2.toJavaDouble()));
    }

    public LNumber mathop(int n, LNumber lNumber, LNumber lNumber2) {
        double d = lNumber.toJavaDouble();
        double d2 = lNumber2.toJavaDouble();
        double d3 = 0.0;
        switch (n) {
            default: {
                return this.unsupportedMathOp();
            }
            case 10: {
                d3 = Math.atan2(d, d2);
                break;
            }
            case 11: {
                d3 = d - d2 * (double)((int)(d / d2));
                break;
            }
            case 12: {
                d3 = Math.pow(d, d2);
            }
        }
        return LDouble.numberOf(d3);
    }

    public LNumber mathop(int n, LNumber lNumber) {
        double d = lNumber.toJavaDouble();
        double d2 = 0.0;
        switch (n) {
            default: {
                return this.unsupportedMathOp();
            }
            case 13: {
                d2 = Math.abs(d);
                break;
            }
            case 14: {
                d2 = Math.acos(d);
                break;
            }
            case 15: {
                d2 = Math.asin(d);
                break;
            }
            case 16: {
                d2 = Math.atan(d);
                break;
            }
            case 17: {
                d2 = Math.cos(d);
                break;
            }
            case 18: {
                d2 = Math.cosh(d);
                break;
            }
            case 19: {
                d2 = Math.toDegrees(d);
                break;
            }
            case 20: {
                d2 = Math.exp(d);
                break;
            }
            case 21: {
                d2 = Math.log(d);
                break;
            }
            case 22: {
                d2 = Math.log10(d);
                break;
            }
            case 23: {
                d2 = Math.toRadians(d);
                break;
            }
            case 24: {
                d2 = Math.sin(d);
                break;
            }
            case 25: {
                d2 = Math.sinh(d);
                break;
            }
            case 26: {
                d2 = Math.sqrt(d);
                break;
            }
            case 27: {
                d2 = Math.tan(d);
                break;
            }
            case 28: {
                d2 = Math.tanh(d);
            }
        }
        return LDouble.numberOf(d2);
    }
}

