/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.script;

import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.luaj.compiler.LuaC;
import org.luaj.platform.J2sePlatform;
import org.luaj.script.LuaScriptEngineFactory;
import org.luaj.vm.LClosure;
import org.luaj.vm.LDouble;
import org.luaj.vm.LFunction;
import org.luaj.vm.LNil;
import org.luaj.vm.LPrototype;
import org.luaj.vm.LString;
import org.luaj.vm.LTable;
import org.luaj.vm.LUserData;
import org.luaj.vm.LValue;
import org.luaj.vm.LoadState;
import org.luaj.vm.LuaErrorException;
import org.luaj.vm.LuaState;
import org.luaj.vm.Platform;

public class LuaScriptEngine
implements ScriptEngine,
Compilable {
    private static final String __ENGINE_VERSION__ = "Luaj 1.0";
    private static final String __NAME__ = "Luaj";
    private static final String __SHORT_NAME__ = "Luaj";
    private static final String __LANGUAGE__ = "lua";
    private static final String __LANGUAGE_VERSION__ = "5.1";
    private static final String __ARGV__ = "arg";
    private static final String __FILENAME__ = "?";
    private static final ScriptEngineFactory myFactory;
    private ScriptContext defaultContext;
    private final LuaState luaState;

    public LuaScriptEngine() {
        Platform.getInstance();
        this.luaState = Platform.newLuaState();
        SimpleScriptContext simpleScriptContext = new SimpleScriptContext();
        simpleScriptContext.setBindings(this.createBindings(), 100);
        this.setContext(simpleScriptContext);
        this.put("javax.script.language_version", __LANGUAGE_VERSION__);
        this.put("javax.script.language", __LANGUAGE__);
        this.put("javax.script.engine", "Luaj");
        this.put("javax.script.engine_version", __ENGINE_VERSION__);
        this.put("javax.script.argv", __ARGV__);
        this.put("javax.script.filename", __FILENAME__);
        this.put("javax.script.name", "Luaj");
        this.put("THREADING", null);
    }

    public Object eval(String string) throws ScriptException {
        return this.eval(new StringReader(string));
    }

    public Object eval(String string, ScriptContext scriptContext) throws ScriptException {
        return this.eval((Reader)new StringReader(string), scriptContext);
    }

    public Object eval(String string, Bindings bindings) throws ScriptException {
        return this.eval((Reader)new StringReader(string), bindings);
    }

    public Object eval(Reader reader) throws ScriptException {
        return this.eval(reader, this.getContext());
    }

    public Object eval(Reader reader, ScriptContext scriptContext) throws ScriptException {
        return this.compile(reader).eval(scriptContext);
    }

    public Object eval(Reader reader, Bindings bindings) throws ScriptException {
        ScriptContext scriptContext = this.getContext();
        Bindings bindings2 = scriptContext.getBindings(100);
        scriptContext.setBindings(bindings, 100);
        Object object = this.eval(reader);
        scriptContext.setBindings(bindings2, 100);
        return object;
    }

    public void put(String string, Object object) {
        Bindings bindings = this.getBindings(100);
        ((LuaBindings)bindings).put(string, object);
    }

    public Object get(String string) {
        Bindings bindings = this.getBindings(100);
        return ((LuaBindings)bindings).get(string);
    }

    public Bindings getBindings(int n) {
        return this.getContext().getBindings(n);
    }

    public void setBindings(Bindings bindings, int n) {
        this.getContext().setBindings(bindings, n);
    }

    public Bindings createBindings() {
        return new LuaBindings(this.luaState);
    }

    public ScriptContext getContext() {
        return this.defaultContext;
    }

    public void setContext(ScriptContext scriptContext) {
        this.defaultContext = scriptContext;
    }

    public ScriptEngineFactory getFactory() {
        return myFactory;
    }

    public CompiledScript compile(String string) throws ScriptException {
        return this.compile(new StringReader(string));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CompiledScript compile(Reader reader) throws ScriptException {
        try {
            Utf8Encoder utf8Encoder = new Utf8Encoder(reader);
            LineNumberInputStream lineNumberInputStream = new LineNumberInputStream(utf8Encoder);
            try {
                final LPrototype lPrototype = LoadState.undump(this.luaState, lineNumberInputStream, "script");
                CompiledScript compiledScript = new CompiledScript(){

                    public Object eval(ScriptContext scriptContext) throws ScriptException {
                        Bindings bindings = scriptContext.getBindings(100);
                        LuaBindings luaBindings = (LuaBindings)bindings;
                        LClosure lClosure = lPrototype.newClosure(luaBindings.env);
                        LuaScriptEngine.this.luaState.doCall(lClosure, new LValue[0]);
                        return LuaScriptEngine.this.luaState.topointer(1);
                    }

                    public ScriptEngine getEngine() {
                        return LuaScriptEngine.this;
                    }
                };
                return compiledScript;
            }
            catch (LuaErrorException luaErrorException) {
                throw new ScriptException(luaErrorException.getMessage(), "script", lineNumberInputStream.getLineNumber());
            }
            finally {
                lineNumberInputStream.close();
            }
        }
        catch (Throwable throwable) {
            throw new ScriptException("eval threw " + throwable.toString());
        }
    }

    static {
        Platform.setInstance(new J2sePlatform());
        LuaC.install();
        myFactory = new LuaScriptEngineFactory();
    }

    private final class Utf8Encoder
    extends InputStream {
        private final Reader r;
        private final int[] buf = new int[2];
        private int n;

        private Utf8Encoder(Reader reader) {
            this.r = reader;
        }

        public int read() throws IOException {
            if (this.n > 0) {
                return this.buf[--this.n];
            }
            int n = this.r.read();
            if (n < 128) {
                return n;
            }
            this.n = 0;
            if (n < 2048) {
                this.buf[this.n++] = 0x80 | n & 0x3F;
                return 0xC0 | n >> 6 & 0x1F;
            }
            this.buf[this.n++] = 0x80 | n & 0x3F;
            this.buf[this.n++] = 0x80 | n >> 6 & 0x3F;
            return 0xE0 | n >> 12 & 0xF;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LuaBindings
    extends LFunction
    implements Bindings {
        private LTable env;
        private LTable mt = new LTable();

        private LuaBindings(LuaState luaState) {
            this.mt.put(LValue.TM_INDEX, (LValue)luaState._G);
            this.clear();
        }

        @Override
        public void clear() {
            this.env = new LTable();
            this.env.luaSetMetatable(this.mt);
        }

        private Object toJava(LValue lValue) {
            switch (lValue.luaGetType()) {
                case 0: {
                    return null;
                }
                case 4: {
                    return lValue.toJavaString();
                }
                case 7: {
                    return lValue.toJavaInstance();
                }
                case 3: {
                    return lValue.isInteger() ? (Number)lValue.toJavaBoxedInteger() : (Number)lValue.toJavaBoxedDouble();
                }
            }
            throw new UnsupportedOperationException("LuaBindings cannot convert lua type '" + lValue.luaGetTypeName() + "' to Java");
        }

        private LValue toLua(Object object) {
            if (object instanceof Number) {
                return LDouble.numberOf(((Number)object).doubleValue());
            }
            if (object instanceof String) {
                return LString.valueOf(object.toString());
            }
            if (object == null) {
                return LNil.NIL;
            }
            return new LUserData(object);
        }

        @Override
        public boolean containsKey(Object object) {
            return this.env.containsKey(this.toLua(object));
        }

        @Override
        public Object get(Object object) {
            return this.toJava(this.env.get(this.toLua(object)));
        }

        @Override
        public Object put(String string, Object object) {
            LValue lValue = this.toLua(string);
            Object object2 = this.toJava(this.env.get(lValue));
            this.env.put(lValue, this.toLua(object));
            return object2;
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> map) {
            for (Map.Entry<? extends String, ? extends Object> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public Object remove(Object object) {
            LValue lValue = this.toLua(object);
            Object object2 = this.toJava(this.env.get(lValue));
            this.env.put(lValue, (LValue)LNil.NIL);
            return object2;
        }

        @Override
        public boolean containsValue(Object object) {
            throw new UnsupportedOperationException("containsValue() not supported for LuaBindings");
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            throw new UnsupportedOperationException("entrySet() not supported for LuaBindings");
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException("isEmpty() not supported for LuaBindings");
        }

        @Override
        public Set<String> keySet() {
            throw new UnsupportedOperationException("keySet() not supported for LuaBindings");
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException("size() not supported for LuaBindings");
        }

        @Override
        public Collection<Object> values() {
            throw new UnsupportedOperationException("values() not supported for LuaBindings");
        }
    }
}

