/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm;

import java.io.InputStream;
import java.io.Reader;
import org.luaj.vm.LNumber;
import org.luaj.vm.LuaErrorException;
import org.luaj.vm.LuaState;

public abstract class Platform {
    public static String LUA_STATE_CLASS_NAME = null;
    private static Platform instance;

    public static Platform getInstance() {
        if (instance == null) {
            throw new RuntimeException("Platform instance is null. Use Platform.setInstance(Platform p) to set the instance first.");
        }
        return instance;
    }

    public static void setInstance(Platform platform) {
        instance = platform;
    }

    public static LuaState newLuaState() {
        Platform platform = Platform.getInstance();
        LuaState luaState = null;
        if (LUA_STATE_CLASS_NAME != null) {
            try {
                luaState = (LuaState)Class.forName(LUA_STATE_CLASS_NAME).newInstance();
            }
            catch (Exception exception) {
                System.out.println("Warning: no debug support, " + exception);
            }
        }
        if (luaState == null) {
            luaState = new LuaState();
        }
        luaState.init();
        platform.installOptionalLibs(luaState);
        return luaState;
    }

    public abstract String getName();

    public abstract InputStream openFile(String var1);

    public abstract Reader createReader(InputStream var1);

    public abstract String getProperty(String var1);

    protected abstract void installOptionalLibs(LuaState var1);

    public abstract LNumber mathPow(LNumber var1, LNumber var2);

    public abstract LNumber mathop(int var1, LNumber var2);

    public abstract LNumber mathop(int var1, LNumber var2, LNumber var3);

    public LNumber unsupportedMathOp() {
        throw new LuaErrorException("math op not supported on " + this.getName());
    }
}

