/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2;

import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaValue;

public final class Buffer {
    private static final int DEFAULT_CAPACITY = 64;
    private byte[] bytes;
    private int length;

    public Buffer() {
        this(64);
    }

    public Buffer(int n) {
        this.bytes = new byte[n];
        this.length = 0;
    }

    public final String tojstring() {
        return LuaString.valueOf(this.bytes, 0, this.length).tojstring();
    }

    public final void append(byte by) {
        this.ensureCapacity(this.length + 1);
        this.bytes[this.length++] = by;
    }

    public final void append(LuaValue luaValue) {
        if (!luaValue.isstring()) {
            LuaValue.error("attempt to concatenate a '" + luaValue.typename() + "' value");
        }
        this.append(luaValue.strvalue());
    }

    public final void append(LuaString luaString) {
        int n = luaString.length();
        this.ensureCapacity(this.length + n);
        luaString.copyInto(0, this.bytes, this.length, n);
        this.length += n;
    }

    public final void append(String string) {
        char[] cArray = string.toCharArray();
        int n = LuaString.lengthAsUtf8(cArray);
        this.ensureCapacity(this.length + n);
        LuaString.encodeToUtf8(cArray, this.bytes, this.length);
        this.length += n;
    }

    public final void setLength(int n) {
        this.ensureCapacity(n);
        this.length = n;
    }

    public final LuaString tostring() {
        return LuaString.valueOf(Buffer.realloc(this.bytes, this.length));
    }

    public final void ensureCapacity(int n) {
        if (n > this.bytes.length) {
            this.realloc(n);
        }
    }

    private final void realloc(int n) {
        this.bytes = Buffer.realloc(this.bytes, Math.max(this.bytes.length * 2, n));
    }

    private static final byte[] realloc(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, Math.min(byArray.length, n));
        return byArray2;
    }
}

