/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2;

import org.luaj.vm2.LuaThread;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.DebugLib;

public class LuaError
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private LuaValue msgvalue = null;
    private String traceback;
    private Throwable cause;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String errorHook(String string) {
        LuaThread luaThread = LuaThread.getRunning();
        if (luaThread.err != null) {
            LuaValue luaValue = luaThread.err;
            luaThread.err = null;
            try {
                String string2 = luaValue.call(LuaValue.valueOf(string)).tojstring();
                return string2;
            }
            catch (Throwable throwable) {
                String string3 = "error in error handling";
                return string3;
            }
            finally {
                luaThread.err = luaValue;
            }
        }
        return string;
    }

    public LuaError(Throwable throwable) {
        super(LuaError.errorHook(LuaError.addFileLine("vm error: " + throwable)));
        this.cause = throwable;
        this.traceback = DebugLib.traceback(1);
    }

    public LuaError(String string) {
        super(LuaError.errorHook(LuaError.addFileLine(string)));
        this.traceback = DebugLib.traceback(1);
    }

    public LuaError(String string, int n) {
        super(LuaError.errorHook(LuaError.addFileLine(string, n)));
        this.traceback = DebugLib.traceback(1);
    }

    private static String addFileLine(String string, int n) {
        if (string == null) {
            return null;
        }
        if (n == 0) {
            return string;
        }
        String string2 = DebugLib.fileline(n - 1);
        return string2 != null ? string2 + ": " + string : string;
    }

    private static String addFileLine(String string) {
        if (string == null) {
            return null;
        }
        String string2 = DebugLib.fileline();
        return string2 != null ? string2 + ": " + string : string;
    }

    public void printStackTrace() {
        System.out.println(this.toString());
        if (this.traceback != null) {
            System.out.println(this.traceback);
        }
    }

    public Throwable getCause() {
        return this.cause;
    }
}

