/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2;

import org.luaj.vm2.Buffer;
import org.luaj.vm2.LuaInteger;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.WeakTable;

public class LuaTable
extends LuaValue {
    private static final int MIN_HASH_CAPACITY = 2;
    private static final LuaString N = LuaTable.valueOf("n");
    protected LuaValue[] array;
    protected LuaValue[] hashKeys;
    protected LuaValue[] hashValues;
    private int hashEntries;
    private LuaValue m_metatable;

    public LuaTable() {
        this.array = NOVALS;
        this.hashKeys = NOVALS;
        this.hashValues = NOVALS;
    }

    public LuaTable(int n, int n2) {
        this.presize(n, n2);
    }

    public LuaTable(LuaValue[] luaValueArray, LuaValue[] luaValueArray2, Varargs varargs) {
        int n;
        int n2 = luaValueArray != null ? luaValueArray.length : 0;
        int n3 = luaValueArray2 != null ? luaValueArray2.length : 0;
        int n4 = varargs != null ? varargs.narg() : 0;
        this.presize(n3 + n4, n2 - (n2 >> 1));
        for (n = 0; n < n3; ++n) {
            this.array[n] = luaValueArray2[n].optvalue(null);
        }
        if (varargs != null) {
            int n5 = varargs.narg();
            for (n = 0; n < n5; ++n) {
                this.array[n3 + n] = varargs.arg(n + 1).optvalue(null);
            }
        }
        for (n = 0; n < n2; n += 2) {
            if (luaValueArray[n + 1].isnil()) continue;
            this.rawset(luaValueArray[n], luaValueArray[n + 1]);
        }
    }

    public LuaTable(Varargs varargs) {
        this(varargs, 1);
    }

    public LuaTable(Varargs varargs, int n) {
        int n2 = n - 1;
        int n3 = Math.max(varargs.narg() - n2, 0);
        this.presize(n3, 1);
        this.set(N, (LuaValue)LuaTable.valueOf(n3));
        for (int i = 1; i <= n3; ++i) {
            this.set(i, varargs.arg(i + n2));
        }
    }

    private void presize(int n, int n2) {
        if (n2 > 0 && n2 < 2) {
            n2 = 2;
        }
        this.array = n > 0 ? new LuaValue[n] : NOVALS;
        this.hashKeys = n2 > 0 ? new LuaValue[n2] : NOVALS;
        this.hashValues = n2 > 0 ? new LuaValue[n2] : NOVALS;
        this.hashEntries = 0;
    }

    public int type() {
        return 5;
    }

    public String typename() {
        return "table";
    }

    public boolean istable() {
        return true;
    }

    public LuaTable checktable() {
        return this;
    }

    public LuaTable opttable(LuaTable luaTable) {
        return this;
    }

    public void presize(int n) {
        if (n > this.array.length) {
            this.array = LuaTable.resize(this.array, n);
        }
    }

    private static LuaValue[] resize(LuaValue[] luaValueArray, int n) {
        LuaValue[] luaValueArray2 = new LuaValue[n];
        System.arraycopy(luaValueArray, 0, luaValueArray2, 0, luaValueArray.length);
        return luaValueArray2;
    }

    public LuaValue getmetatable() {
        if (this.m_metatable != null) {
            return this.m_metatable.rawget(METATABLE).optvalue(this.m_metatable);
        }
        return this.m_metatable;
    }

    public LuaValue setmetatable(LuaValue luaValue) {
        LuaValue luaValue2;
        if (this.m_metatable != null && !this.m_metatable.rawget(METATABLE).isnil()) {
            LuaTable.error("cannot change a protected metatable");
        }
        this.m_metatable = luaValue;
        if (this.m_metatable != null && (luaValue2 = this.m_metatable.rawget(MODE)).isstring()) {
            String string = luaValue2.tojstring();
            boolean bl = string.indexOf(107) >= 0;
            boolean bl2 = string.indexOf(118) >= 0;
            return this.changemode(bl, bl2);
        }
        return this;
    }

    protected LuaTable changemode(boolean bl, boolean bl2) {
        if (bl || bl2) {
            return this.recreateas(bl, bl2);
        }
        return this;
    }

    protected LuaTable recreateas(boolean bl, boolean bl2) {
        Varargs varargs;
        LuaTable luaTable = bl || bl2 ? new WeakTable(bl, bl2) : new LuaTable();
        super.presize(this.array.length, this.hashKeys.length);
        LuaValue luaValue = NIL;
        while (!(luaValue = (varargs = this.next(luaValue)).arg1()).isnil()) {
            luaTable.rawset(luaValue, varargs.arg(2));
        }
        luaTable.m_metatable = this.m_metatable;
        return luaTable;
    }

    public LuaValue get(int n) {
        LuaValue luaValue = this.rawget(n);
        return luaValue.isnil() && this.m_metatable != null ? LuaTable.gettable(this, LuaTable.valueOf(n)) : luaValue;
    }

    public LuaValue get(LuaValue luaValue) {
        LuaValue luaValue2 = this.rawget(luaValue);
        return luaValue2.isnil() && this.m_metatable != null ? LuaTable.gettable(this, luaValue) : luaValue2;
    }

    public LuaValue rawget(int n) {
        if (n > 0 && n <= this.array.length) {
            return this.array[n - 1] != null ? this.array[n - 1] : NIL;
        }
        return this.hashget(LuaInteger.valueOf(n));
    }

    public LuaValue rawget(LuaValue luaValue) {
        int n;
        if (luaValue.isinttype() && (n = luaValue.toint()) > 0 && n <= this.array.length) {
            return this.array[n - 1] != null ? this.array[n - 1] : NIL;
        }
        return this.hashget(luaValue);
    }

    private LuaValue hashget(LuaValue luaValue) {
        if (this.hashEntries > 0) {
            LuaValue luaValue2 = this.hashValues[this.hashFindSlot(luaValue)];
            return luaValue2 != null ? luaValue2 : NIL;
        }
        return NIL;
    }

    public void set(int n, LuaValue luaValue) {
        if (this.m_metatable == null || !this.rawget(n).isnil() || !LuaTable.settable(this, LuaInteger.valueOf(n), luaValue)) {
            this.rawset(n, luaValue);
        }
    }

    public void set(LuaValue luaValue, LuaValue luaValue2) {
        luaValue.checkvalidkey();
        if (this.m_metatable == null || !this.rawget(luaValue).isnil() || !LuaTable.settable(this, luaValue, luaValue2)) {
            this.rawset(luaValue, luaValue2);
        }
    }

    public void rawset(int n, LuaValue luaValue) {
        if (!this.arrayset(n, luaValue)) {
            this.hashset(LuaInteger.valueOf(n), luaValue);
        }
    }

    public void rawset(LuaValue luaValue, LuaValue luaValue2) {
        if (!luaValue.isinttype() || !this.arrayset(luaValue.toint(), luaValue2)) {
            this.hashset(luaValue, luaValue2);
        }
    }

    private boolean arrayset(int n, LuaValue luaValue) {
        if (n > 0 && n <= this.array.length) {
            this.array[n - 1] = luaValue.isnil() ? null : luaValue;
            return true;
        }
        if (n == this.array.length + 1 && !luaValue.isnil()) {
            this.expandarray();
            this.array[n - 1] = luaValue;
            return true;
        }
        return false;
    }

    private void expandarray() {
        int n = this.array.length;
        int n2 = Math.max(2, n * 2);
        this.array = LuaTable.resize(this.array, n2);
        for (int i = n; i < n2; ++i) {
            LuaInteger luaInteger = LuaInteger.valueOf(i + 1);
            LuaValue luaValue = this.hashget(luaInteger);
            if (luaValue.isnil()) continue;
            this.hashset(luaInteger, NIL);
            this.array[i] = luaValue;
        }
    }

    public LuaValue remove(int n) {
        LuaValue luaValue;
        if (n == 0) {
            n = this.length();
        }
        if (n < 1 || n > this.array.length) {
            return NONE;
        }
        LuaValue luaValue2 = luaValue = this.rawget(n);
        while (!luaValue2.isnil()) {
            luaValue2 = this.rawget(n + 1);
            this.rawset(n++, luaValue2);
        }
        return luaValue.isnil() ? NONE : luaValue;
    }

    public void insert(int n, LuaValue luaValue) {
        if (n == 0) {
            n = this.length() + 1;
        }
        while (!luaValue.isnil()) {
            LuaValue luaValue2 = this.rawget(n);
            this.rawset(n++, luaValue);
            luaValue = luaValue2;
        }
    }

    public LuaValue concat(LuaString luaString, int n, int n2) {
        Buffer buffer = new Buffer();
        if (n <= n2) {
            buffer.append(this.get(n).checkstring());
            while (++n <= n2) {
                buffer.append(luaString);
                buffer.append(this.get(n).checkstring());
            }
        }
        return buffer.tostring();
    }

    public LuaValue getn() {
        int n = this.array.length;
        while (--n > 0) {
            if (this.array[n] == null) continue;
            return LuaInteger.valueOf(n + 1);
        }
        return ZERO;
    }

    public int length() {
        int n = this.array.length + 1;
        int n2 = 0;
        while (!this.rawget(n).isnil()) {
            n2 = n;
            n += this.array.length + this.hashEntries + 1;
        }
        while (n > n2 + 1) {
            int n3 = (n + n2) / 2;
            if (!this.rawget(n3).isnil()) {
                n2 = n3;
                continue;
            }
            n = n3;
        }
        return n2;
    }

    public LuaValue len() {
        return LuaInteger.valueOf(this.length());
    }

    public int maxn() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.array.length; ++n) {
            if (this.array[n] == null) continue;
            n2 = n + 1;
        }
        for (n = 0; n < this.hashKeys.length; ++n) {
            int n3;
            LuaValue luaValue = this.hashKeys[n];
            if (luaValue == null || !luaValue.isinttype() || (n3 = luaValue.toint()) <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    public Varargs next(LuaValue luaValue) {
        int n = 0;
        if (!luaValue.isnil()) {
            if (luaValue.isinttype() && (n = luaValue.toint()) > 0 && n <= this.array.length) {
                if (this.array[n - 1] == null) {
                    LuaTable.error("invalid key to 'next'");
                }
            } else {
                if (this.hashKeys.length == 0) {
                    LuaTable.error("invalid key to 'next'");
                }
                if (this.hashKeys[n = this.hashFindSlot(luaValue)] == null) {
                    LuaTable.error("invalid key to 'next'");
                }
                n += 1 + this.array.length;
            }
        }
        while (n < this.array.length) {
            if (this.array[n] != null) {
                return LuaTable.varargsOf(LuaInteger.valueOf(n + 1), (Varargs)this.array[n]);
            }
            ++n;
        }
        n -= this.array.length;
        while (n < this.hashKeys.length) {
            if (this.hashKeys[n] != null) {
                return LuaTable.varargsOf(this.hashKeys[n], (Varargs)this.hashValues[n]);
            }
            ++n;
        }
        return NIL;
    }

    public Varargs inext(LuaValue luaValue) {
        int n = luaValue.optint(0);
        return n < 0 || n >= this.array.length || this.array[n] == null ? NIL : LuaTable.varargsOf(LuaInteger.valueOf(n + 1), (Varargs)this.array[n]);
    }

    public LuaValue foreach(LuaValue luaValue) {
        int n;
        LuaValue luaValue2 = NIL;
        for (n = 0; n < this.array.length; ++n) {
            if (this.array[n] == null || (luaValue2 = luaValue.call(LuaInteger.valueOf(n + 1), this.array[n])).isnil()) continue;
            return luaValue2;
        }
        for (n = 0; n < this.hashKeys.length; ++n) {
            if (this.hashKeys[n] == null || (luaValue2 = luaValue.call(this.hashKeys[n], this.hashValues[n])).isnil()) continue;
            return luaValue2;
        }
        return luaValue2;
    }

    public LuaValue foreachi(LuaValue luaValue) {
        LuaValue luaValue2 = NIL;
        for (int i = 0; i < this.array.length && this.array[i] != null; ++i) {
            luaValue2 = luaValue.call(LuaInteger.valueOf(i + 1), this.array[i]);
            if (luaValue2.isnil()) continue;
            return luaValue2;
        }
        return luaValue2;
    }

    int arrayCapacity() {
        return this.array.length;
    }

    int hashCapacity() {
        return this.hashKeys.length;
    }

    int keyCount() {
        int n = 0;
        for (int i = 0; i < this.array.length; ++i) {
            if (this.array[i] == null) continue;
            ++n;
        }
        return n + this.hashEntries;
    }

    public LuaValue[] keys() {
        int n;
        LuaValue[] luaValueArray = new LuaValue[this.keyCount()];
        int n2 = 0;
        for (n = 0; n < this.array.length; ++n) {
            if (this.array[n] == null) continue;
            luaValueArray[n2++] = LuaInteger.valueOf(n + 1);
        }
        for (n = 0; n < this.hashKeys.length; ++n) {
            if (this.hashKeys[n] == null) continue;
            luaValueArray[n2++] = this.hashKeys[n];
        }
        return luaValueArray;
    }

    public void hashset(LuaValue luaValue, LuaValue luaValue2) {
        if (luaValue2.isnil()) {
            this.hashRemove(luaValue);
        } else {
            int n;
            if (this.hashKeys.length == 0) {
                this.hashKeys = new LuaValue[2];
                this.hashValues = new LuaValue[2];
            }
            if (this.hashFillSlot(n = this.hashFindSlot(luaValue), luaValue2)) {
                return;
            }
            this.hashKeys[n] = luaValue;
            this.hashValues[n] = luaValue2;
            if (this.checkLoadFactor()) {
                this.rehash();
            }
        }
    }

    public int hashFindSlot(LuaValue luaValue) {
        LuaValue luaValue2;
        int n = (luaValue.hashCode() & Integer.MAX_VALUE) % this.hashKeys.length;
        while ((luaValue2 = this.hashKeys[n]) != null && !luaValue2.eq_b(luaValue)) {
            n = (n + 1) % this.hashKeys.length;
        }
        return n;
    }

    private boolean hashFillSlot(int n, LuaValue luaValue) {
        this.hashValues[n] = luaValue;
        if (this.hashKeys[n] != null) {
            return true;
        }
        ++this.hashEntries;
        return false;
    }

    private void hashRemove(LuaValue luaValue) {
        if (this.hashKeys.length > 0) {
            int n = this.hashFindSlot(luaValue);
            this.hashClearSlot(n);
        }
    }

    private void hashClearSlot(int n) {
        if (this.hashKeys[n] != null) {
            int n2 = n;
            int n3 = this.hashKeys.length;
            while (this.hashKeys[n2 = (n2 + 1) % n3] != null) {
                int n4 = (this.hashKeys[n2].hashCode() & Integer.MAX_VALUE) % n3;
                if ((n2 <= n || n4 > n && n4 <= n2) && (n2 >= n || n4 > n || n4 <= n2)) continue;
                this.hashKeys[n] = this.hashKeys[n2];
                this.hashValues[n] = this.hashValues[n2];
                n = n2;
            }
            --this.hashEntries;
            this.hashKeys[n] = null;
            this.hashValues[n] = null;
            if (this.hashEntries == 0) {
                this.hashKeys = NOVALS;
                this.hashValues = NOVALS;
            }
        }
    }

    private boolean checkLoadFactor() {
        int n = this.hashKeys.length;
        return this.hashEntries >= n - (n >> 3);
    }

    private void rehash() {
        int n = this.hashKeys.length;
        int n2 = n + (n >> 2) + 2;
        LuaValue[] luaValueArray = this.hashKeys;
        LuaValue[] luaValueArray2 = this.hashValues;
        this.hashKeys = new LuaValue[n2];
        this.hashValues = new LuaValue[n2];
        for (int i = 0; i < n; ++i) {
            LuaValue luaValue = luaValueArray[i];
            if (luaValue == null) continue;
            LuaValue luaValue2 = luaValueArray2[i];
            int n3 = this.hashFindSlot(luaValue);
            this.hashKeys[n3] = luaValue;
            this.hashValues[n3] = luaValue2;
        }
    }

    public void sort(LuaValue luaValue) {
        int n;
        for (n = this.array.length; n > 0 && this.array[n - 1] == null; --n) {
        }
        if (n > 1) {
            this.heapSort(n, luaValue);
        }
    }

    private void heapSort(int n, LuaValue luaValue) {
        this.heapify(n, luaValue);
        int n2 = n - 1;
        while (n2 > 0) {
            this.swap(n2, 0);
            this.siftDown(0, --n2, luaValue);
        }
    }

    private void heapify(int n, LuaValue luaValue) {
        for (int i = n / 2 - 1; i >= 0; --i) {
            this.siftDown(i, n - 1, luaValue);
        }
    }

    private void siftDown(int n, int n2, LuaValue luaValue) {
        int n3 = n;
        while (n3 * 2 + 1 <= n2) {
            int n4 = n3 * 2 + 1;
            if (n4 < n2 && this.compare(n4, n4 + 1, luaValue)) {
                ++n4;
            }
            if (this.compare(n3, n4, luaValue)) {
                this.swap(n3, n4);
                n3 = n4;
                continue;
            }
            return;
        }
    }

    private boolean compare(int n, int n2, LuaValue luaValue) {
        LuaValue luaValue2 = this.array[n];
        LuaValue luaValue3 = this.array[n2];
        if (luaValue2 == null || luaValue3 == null) {
            return false;
        }
        if (!luaValue.isnil()) {
            return luaValue.call(luaValue2, luaValue3).toboolean();
        }
        return luaValue2.lt_b(luaValue3);
    }

    private void swap(int n, int n2) {
        LuaValue luaValue = this.array[n];
        this.array[n] = this.array[n2];
        this.array[n2] = luaValue;
    }
}

