/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2;

import java.lang.ref.WeakReference;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;

public class WeakTable
extends LuaTable {
    private final boolean weakKeys;
    private final boolean weakValues;

    WeakTable(boolean bl, boolean bl2) {
        this.weakKeys = bl;
        this.weakValues = bl2;
    }

    private boolean shouldWeaken(LuaValue luaValue) {
        switch (luaValue.type()) {
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    private LuaValue toWeak(LuaValue luaValue) {
        switch (luaValue.type()) {
            case 5: 
            case 6: 
            case 8: {
                return new WeakValue(luaValue);
            }
            case 7: {
                return new WeakUserdata(luaValue.checkuserdata(), luaValue.getmetatable());
            }
        }
        return luaValue;
    }

    public LuaValue rawget(int n) {
        LuaValue luaValue = super.rawget(n);
        if (luaValue.isnil()) {
            return NIL;
        }
        if ((luaValue = luaValue.strongvalue()).isnil()) {
            super.rawset(n, NIL);
        }
        return luaValue;
    }

    public LuaValue rawget(LuaValue luaValue) {
        LuaValue luaValue2 = super.rawget(luaValue);
        if (luaValue2.isnil()) {
            return NIL;
        }
        if ((luaValue2 = luaValue2.strongvalue()).isnil()) {
            super.rawset(luaValue, NIL);
        }
        return luaValue2;
    }

    public void rawset(int n, LuaValue luaValue) {
        if (luaValue.isnil() || !this.weakValues || !this.shouldWeaken(luaValue)) {
            super.rawset(n, luaValue);
        } else {
            super.rawset(n, this.toWeak(luaValue));
        }
    }

    public void rawset(LuaValue luaValue, LuaValue luaValue2) {
        if (luaValue2.isnil()) {
            super.rawset(luaValue, luaValue2);
        } else {
            boolean bl;
            boolean bl2 = this.weakKeys && this.shouldWeaken(luaValue);
            boolean bl3 = bl = this.weakValues && this.shouldWeaken(luaValue2);
            if (bl2) {
                WeakEntry weakEntry = new WeakEntry(this.toWeak(luaValue), bl ? this.toWeak(luaValue2) : luaValue2);
                super.rawset(weakEntry, (LuaValue)weakEntry);
            } else if (bl) {
                super.rawset(luaValue, this.toWeak(luaValue2));
            } else {
                super.rawset(luaValue, luaValue2);
            }
        }
    }

    protected LuaTable changemode(boolean bl, boolean bl2) {
        if (bl != this.weakKeys || bl2 != this.weakValues) {
            return this.recreateas(bl, bl2);
        }
        return this;
    }

    private static class WeakEntry
    extends LuaValue {
        private LuaValue key;
        private LuaValue val;

        private WeakEntry(LuaValue luaValue, LuaValue luaValue2) {
            this.key = luaValue;
            this.val = luaValue2;
        }

        public int type() {
            return 0;
        }

        public String typename() {
            return "weakentry";
        }

        public LuaValue strongkey() {
            LuaValue luaValue = this.key.strongvalue();
            LuaValue luaValue2 = this.val.strongvalue();
            if (luaValue.isnil() || luaValue2.isnil()) {
                this.key = this.val = NIL;
                return this.val;
            }
            return luaValue;
        }

        public LuaValue strongvalue() {
            LuaValue luaValue = this.key.strongvalue();
            LuaValue luaValue2 = this.val.strongvalue();
            if (luaValue.isnil() || luaValue2.isnil()) {
                this.key = this.val = NIL;
                return this.val;
            }
            return luaValue2;
        }

        public boolean eq_b(LuaValue luaValue) {
            return this.strongkey().eq_b(luaValue);
        }

        public int hashCode() {
            return this.strongkey().hashCode();
        }
    }

    private static class WeakUserdata
    extends LuaValue {
        private WeakReference ref;
        private WeakReference mt;

        public WeakUserdata(Object object, LuaValue luaValue) {
            this.ref = new WeakReference<Object>(object);
            this.mt = new WeakReference<LuaValue>(luaValue);
        }

        public int type() {
            return 9;
        }

        public String typename() {
            return "weakuserdata";
        }

        public LuaValue strongvalue() {
            Object t;
            if (this.ref != null && (t = this.ref.get()) != null) {
                return WeakUserdata.userdataOf(t, (LuaValue)this.mt.get());
            }
            this.mt = null;
            this.ref = null;
            return NIL;
        }
    }

    private static class WeakValue
    extends LuaValue {
        private final WeakReference ref;

        public WeakValue(LuaValue luaValue) {
            this.ref = new WeakReference<LuaValue>(luaValue);
        }

        public int type() {
            return this.strongvalue().type();
        }

        public String typename() {
            return "weakvalue";
        }

        public LuaValue strongvalue() {
            Object t = this.ref.get();
            return t != null ? (LuaValue)t : NIL;
        }

        public String tojstring() {
            return this.strongvalue().tojstring();
        }
    }
}

