/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib;

import java.io.InputStream;
import java.io.PrintStream;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaThread;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.BaseLib;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.VarArgFunction;

public class PackageLib
extends OneArgFunction {
    public static String DEFAULT_LUA_PATH = "?.lua";
    public InputStream STDIN = null;
    public PrintStream STDOUT = System.out;
    public LuaTable LOADED;
    public LuaTable PACKAGE;
    public static PackageLib instance;
    public LuaValue preload_loader;
    public LuaValue lua_loader;
    public LuaValue java_loader;
    private static final LuaString _M;
    private static final LuaString _NAME;
    private static final LuaString _PACKAGE;
    private static final LuaString _DOT;
    private static final LuaString _LOADERS;
    private static final LuaString _LOADED;
    private static final LuaString _LOADLIB;
    private static final LuaString _PRELOAD;
    private static final LuaString _PATH;
    private static final LuaString _SEEALL;
    private static final LuaString _SENTINEL;
    private static final int OP_MODULE = 0;
    private static final int OP_REQUIRE = 1;
    private static final int OP_LOADLIB = 2;
    private static final int OP_SEEALL = 3;
    private static final int OP_PRELOAD_LOADER = 4;
    private static final int OP_LUA_LOADER = 5;
    private static final int OP_JAVA_LOADER = 6;

    public PackageLib() {
        instance = this;
    }

    public LuaValue call(LuaValue luaValue) {
        this.env.set("require", (LuaValue)new PkgLib1(this.env, "require", 1, this));
        this.env.set("module", (LuaValue)new PkgLibV(this.env, "module", 0, this));
        LuaValue[] luaValueArray = new LuaValue[12];
        luaValueArray[0] = _LOADED;
        this.LOADED = PackageLib.tableOf();
        luaValueArray[1] = this.LOADED;
        luaValueArray[2] = _PRELOAD;
        luaValueArray[3] = PackageLib.tableOf();
        luaValueArray[4] = _PATH;
        luaValueArray[5] = PackageLib.valueOf(DEFAULT_LUA_PATH);
        luaValueArray[6] = _LOADLIB;
        luaValueArray[7] = new PkgLibV(this.env, "loadlib", 2, this);
        luaValueArray[8] = _SEEALL;
        luaValueArray[9] = new PkgLib1(this.env, "seeall", 3, this);
        luaValueArray[10] = _LOADERS;
        this.preload_loader = new PkgLibV(this.env, "preload_loader", 4, this);
        this.lua_loader = new PkgLibV(this.env, "lua_loader", 5, this);
        this.java_loader = new PkgLibV(this.env, "java_loader", 6, this);
        luaValueArray[11] = PackageLib.listOf(new LuaValue[]{this.preload_loader, this.lua_loader, this.java_loader});
        this.PACKAGE = PackageLib.tableOf(luaValueArray);
        this.env.set("package", (LuaValue)this.PACKAGE);
        this.LOADED.set("package", (LuaValue)this.PACKAGE);
        return this.env;
    }

    public void setIsLoaded(String string, LuaTable luaTable) {
        this.LOADED.set(string, (LuaValue)luaTable);
    }

    public void setLuaPath(String string) {
        this.PACKAGE.set(_PATH, (LuaValue)PackageLib.valueOf(string));
    }

    public String tojstring() {
        return "package";
    }

    public Varargs module(Varargs varargs) {
        LuaFunction luaFunction;
        LuaValue luaValue;
        LuaValue luaValue2;
        LuaString luaString = varargs.checkstring(1);
        int n = varargs.narg();
        LuaValue luaValue3 = this.LOADED.get(luaString);
        if (!luaValue3.istable()) {
            luaValue2 = LuaThread.getGlobals();
            luaValue = PackageLib.findtable(luaValue2, luaString);
            if (luaValue == null) {
                PackageLib.error("name conflict for module '" + luaString + "'");
            }
            this.LOADED.set(luaString, luaValue);
        } else {
            luaValue = (LuaTable)luaValue3;
        }
        luaValue2 = ((LuaValue)luaValue).get(_NAME);
        if (luaValue2.isnil()) {
            PackageLib.modinit(luaValue, luaString);
        }
        if ((luaFunction = LuaThread.getCallstackFunction(1)) == null) {
            PackageLib.error("no calling function");
        }
        if (!luaFunction.isclosure()) {
            PackageLib.error("'module' not called from a Lua function");
        }
        luaFunction.setfenv(luaValue);
        for (int i = 2; i <= n; ++i) {
            varargs.arg(i).call(luaValue);
        }
        return NONE;
    }

    private static final LuaValue findtable(LuaValue luaValue, LuaString luaString) {
        int n = -1;
        do {
            LuaString luaString2;
            LuaValue luaValue2;
            int n2;
            if ((n = luaString.indexOf(_DOT, n2 = n + 1)) < 0) {
                n = luaString.m_length;
            }
            if ((luaValue2 = luaValue.rawget(luaString2 = luaString.substring(n2, n))).isnil()) {
                LuaTable luaTable = new LuaTable();
                luaValue.set(luaString2, (LuaValue)luaTable);
                luaValue = luaTable;
                continue;
            }
            if (!luaValue2.istable()) {
                return null;
            }
            luaValue = luaValue2;
        } while (n < luaString.m_length);
        return luaValue;
    }

    private static final void modinit(LuaValue luaValue, LuaString luaString) {
        luaValue.set(_M, luaValue);
        int n = luaString.lastIndexOf(_DOT);
        luaValue.set(_NAME, (LuaValue)luaString);
        luaValue.set(_PACKAGE, (LuaValue)(n < 0 ? EMPTYSTRING : luaString.substring(0, n + 1)));
    }

    public LuaValue require(LuaValue luaValue) {
        LuaString luaString = luaValue.checkstring();
        LuaValue luaValue2 = this.LOADED.get(luaString);
        if (luaValue2.toboolean()) {
            if (luaValue2 == _SENTINEL) {
                PackageLib.error("loop or previous error loading module '" + luaString + "'");
            }
            return luaValue2;
        }
        LuaTable luaTable = this.PACKAGE.get(_LOADERS).checktable();
        StringBuffer stringBuffer = new StringBuffer();
        LuaValue luaValue3 = null;
        int n = 1;
        while (true) {
            LuaValue luaValue4;
            if ((luaValue4 = luaTable.get(n)).isnil()) {
                PackageLib.error("module '" + luaString + "' not found: " + luaString + stringBuffer);
            }
            if ((luaValue3 = luaValue4.call(luaString)).isfunction()) break;
            if (luaValue3.isstring()) {
                stringBuffer.append(luaValue3.tojstring());
            }
            ++n;
        }
        this.LOADED.set(luaString, (LuaValue)_SENTINEL);
        LuaValue luaValue5 = luaValue3.call(luaString);
        if (!luaValue5.isnil()) {
            this.LOADED.set(luaString, luaValue5);
        } else {
            luaValue5 = this.LOADED.get(luaString);
            if (luaValue5 == _SENTINEL) {
                luaValue5 = LuaValue.TRUE;
                this.LOADED.set(luaString, luaValue5);
            }
        }
        return luaValue5;
    }

    public static Varargs loadlib(Varargs varargs) {
        varargs.checkstring(1);
        return PackageLib.varargsOf(NIL, PackageLib.valueOf("dynamic libraries not enabled"), PackageLib.valueOf("absent"));
    }

    LuaValue loader_preload(Varargs varargs) {
        LuaString luaString = varargs.checkstring(1);
        LuaTable luaTable = this.PACKAGE.get(_PRELOAD).checktable();
        LuaValue luaValue = ((LuaValue)luaTable).get(luaString);
        return luaValue.isnil() ? PackageLib.valueOf("\n\tno field package.preload['" + luaString + "']") : luaValue;
    }

    LuaValue loader_Lua(Varargs varargs) {
        String string = varargs.checkjstring(1);
        Object var3_3 = null;
        LuaValue luaValue = this.PACKAGE.get(_PATH);
        if (!luaValue.isstring()) {
            return PackageLib.valueOf("package.path is not a string");
        }
        String string2 = luaValue.tojstring();
        int n = -1;
        int n2 = string2.length();
        StringBuffer stringBuffer = null;
        string = string.replace('.', '/');
        while (n < n2) {
            Varargs varargs2;
            int n3 = n + 1;
            if ((n = string2.indexOf(59, n3)) < 0) {
                n = string2.length();
            }
            String string3 = string2.substring(n3, n);
            int n4 = string3.indexOf(63);
            String string4 = string3;
            if (n4 >= 0) {
                string4 = string3.substring(0, n4) + string + string3.substring(n4 + 1);
            }
            if ((varargs2 = BaseLib.loadFile(string4)).arg1().isfunction()) {
                return varargs2.arg1();
            }
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            }
            stringBuffer.append("\n\t'" + string4 + "': " + varargs2.arg(2));
        }
        return PackageLib.valueOf(stringBuffer.toString());
    }

    LuaValue loader_Java(Varargs varargs) {
        String string = varargs.checkjstring(1);
        String string2 = PackageLib.toClassname(string);
        Class<?> clazz = null;
        LuaValue luaValue = null;
        try {
            clazz = Class.forName(string2);
            luaValue = (LuaValue)clazz.newInstance();
            luaValue.setfenv(this.env);
            return luaValue;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return PackageLib.valueOf("\n\tno class '" + string2 + "'");
        }
        catch (Exception exception) {
            return PackageLib.valueOf("\n\tjava load failed on '" + string2 + "', " + exception);
        }
    }

    public static final String toClassname(String string) {
        int n;
        int n2 = n = string.length();
        if (string.endsWith(".lua")) {
            n2 -= 4;
        }
        for (int i = 0; i < n2; ++i) {
            int n3 = string.charAt(i);
            if (PackageLib.isClassnamePart((char)n3) && n3 != 47 && n3 != 92) continue;
            StringBuffer stringBuffer = new StringBuffer(n2);
            for (int j = 0; j < n2; ++j) {
                n3 = string.charAt(j);
                stringBuffer.append((char)(PackageLib.isClassnamePart((char)n3) ? n3 : (n3 == 47 || n3 == 92 ? 46 : 95)));
            }
            return stringBuffer.toString();
        }
        return n == n2 ? string : string.substring(0, n2);
    }

    private static final boolean isClassnamePart(char c) {
        if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
            return true;
        }
        switch (c) {
            case '$': 
            case '.': 
            case '_': {
                return true;
            }
        }
        return false;
    }

    static {
        _M = PackageLib.valueOf("_M");
        _NAME = PackageLib.valueOf("_NAME");
        _PACKAGE = PackageLib.valueOf("_PACKAGE");
        _DOT = PackageLib.valueOf(".");
        _LOADERS = PackageLib.valueOf("loaders");
        _LOADED = PackageLib.valueOf("loaded");
        _LOADLIB = PackageLib.valueOf("loadlib");
        _PRELOAD = PackageLib.valueOf("preload");
        _PATH = PackageLib.valueOf("path");
        _SEEALL = PackageLib.valueOf("seeall");
        _SENTINEL = PackageLib.valueOf("\u0001");
    }

    public static final class PkgLibV
    extends VarArgFunction {
        PackageLib lib;

        public PkgLibV(LuaValue luaValue, String string, int n, PackageLib packageLib) {
            this.env = luaValue;
            this.name = string;
            this.opcode = n;
            this.lib = packageLib;
        }

        public Varargs invoke(Varargs varargs) {
            switch (this.opcode) {
                case 0: {
                    return this.lib.module(varargs);
                }
                case 2: {
                    return PackageLib.loadlib(varargs);
                }
                case 4: {
                    return this.lib.loader_preload(varargs);
                }
                case 5: {
                    return this.lib.loader_Lua(varargs);
                }
                case 6: {
                    return this.lib.loader_Java(varargs);
                }
            }
            return NONE;
        }
    }

    public static final class PkgLib1
    extends OneArgFunction {
        PackageLib lib;

        public PkgLib1(LuaValue luaValue, String string, int n, PackageLib packageLib) {
            this.env = luaValue;
            this.name = string;
            this.opcode = n;
            this.lib = packageLib;
        }

        public LuaValue call(LuaValue luaValue) {
            switch (this.opcode) {
                case 1: {
                    return this.lib.require(luaValue);
                }
                case 3: {
                    LuaTable luaTable = luaValue.checktable();
                    LuaValue luaValue2 = luaTable.getmetatable();
                    if (luaValue2 == null) {
                        luaValue2 = PkgLib1.tableOf();
                        luaTable.setmetatable(luaValue2);
                    }
                    luaValue2.set(INDEX, LuaThread.getGlobals());
                    return NONE;
                }
            }
            return NIL;
        }
    }
}

