/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.luaj.vm2.Buffer;
import org.luaj.vm2.LuaClosure;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.compiler.DumpState;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.PackageLib;
import org.luaj.vm2.lib.VarArgFunction;

public class StringLib
extends OneArgFunction {
    public static LuaTable instance;
    private static final String FLAGS = "-+ #0";
    private static final int L_ESC = 37;
    private static final LuaString SPECIALS;
    private static final int MAX_CAPTURES = 32;
    private static final int CAP_UNFINISHED = -1;
    private static final int CAP_POSITION = -2;
    private static final byte MASK_ALPHA = 1;
    private static final byte MASK_LOWERCASE = 2;
    private static final byte MASK_UPPERCASE = 4;
    private static final byte MASK_DIGIT = 8;
    private static final byte MASK_PUNCT = 16;
    private static final byte MASK_SPACE = 32;
    private static final byte MASK_CONTROL = 64;
    private static final byte MASK_HEXDIGIT = -128;
    private static final byte[] CHAR_TABLE;
    static /* synthetic */ Class class$org$luaj$vm2$lib$StringLib$StringLib1;
    static /* synthetic */ Class class$org$luaj$vm2$lib$StringLib$StringLibV;

    public LuaValue call(LuaValue luaValue) {
        LuaTable luaTable = new LuaTable();
        this.bind(luaTable, class$org$luaj$vm2$lib$StringLib$StringLib1 == null ? (class$org$luaj$vm2$lib$StringLib$StringLib1 = StringLib.class$("org.luaj.vm2.lib.StringLib$StringLib1")) : class$org$luaj$vm2$lib$StringLib$StringLib1, new String[]{"dump", "len", "lower", "reverse", "upper"});
        this.bind(luaTable, class$org$luaj$vm2$lib$StringLib$StringLibV == null ? (class$org$luaj$vm2$lib$StringLib$StringLibV = StringLib.class$("org.luaj.vm2.lib.StringLib$StringLibV")) : class$org$luaj$vm2$lib$StringLib$StringLibV, new String[]{"byte", "char", "find", "format", "gmatch", "gsub", "match", "rep", "sub"});
        this.env.set("string", (LuaValue)luaTable);
        instance = luaTable;
        if (LuaString.s_metatable == null) {
            LuaString.s_metatable = StringLib.tableOf(new LuaValue[]{INDEX, luaTable});
        }
        PackageLib.instance.LOADED.set("string", (LuaValue)luaTable);
        return luaTable;
    }

    static Varargs byte_(Varargs varargs) {
        LuaString luaString = varargs.checkstring(1);
        int n = luaString.m_length;
        int n2 = StringLib.posrelat(varargs.optint(2, 1), n);
        int n3 = StringLib.posrelat(varargs.optint(3, n2), n);
        if (n2 <= 0) {
            n2 = 1;
        }
        if (n3 > n) {
            n3 = n;
        }
        if (n2 > n3) {
            return NONE;
        }
        int n4 = n3 - n2 + 1;
        if (n2 + n4 <= n3) {
            StringLib.error("string slice too long");
        }
        LuaValue[] luaValueArray = new LuaValue[n4];
        for (int i = 0; i < n4; ++i) {
            luaValueArray[i] = StringLib.valueOf(luaString.luaByte(n2 + i - 1));
        }
        return StringLib.varargsOf(luaValueArray);
    }

    public static Varargs char_(Varargs varargs) {
        int n = varargs.narg();
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 1;
        while (n2 < n) {
            int n4 = varargs.checkint(n3);
            if (n4 < 0 || n4 >= 256) {
                StringLib.argerror(n3, "invalid value");
            }
            byArray[n2] = (byte)n4;
            ++n2;
            ++n3;
        }
        return LuaString.valueOf(byArray);
    }

    static LuaValue dump(LuaValue luaValue) {
        LuaValue luaValue2 = luaValue.checkfunction();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            DumpState.dump(((LuaClosure)luaValue2).p, byteArrayOutputStream, true);
            return LuaString.valueOf(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            return StringLib.error(iOException.getMessage());
        }
    }

    static Varargs find(Varargs varargs) {
        return StringLib.str_find_aux(varargs, true);
    }

    static Varargs format(Varargs varargs) {
        LuaString luaString = varargs.checkstring(1);
        int n = luaString.length();
        Buffer buffer = new Buffer(n);
        int n2 = 1;
        int n3 = 0;
        block12: while (n3 < n) {
            int n4 = luaString.luaByte(n3++);
            switch (n4) {
                case 10: {
                    buffer.append("\n");
                    continue block12;
                }
                default: {
                    buffer.append((byte)n4);
                    continue block12;
                }
                case 37: 
            }
            if (n3 >= n) continue;
            n4 = luaString.luaByte(n3);
            if (n4 == 37) {
                ++n3;
                buffer.append((byte)37);
                continue;
            }
            ++n2;
            FormatDesc formatDesc = new FormatDesc(varargs, luaString, n3);
            n3 += formatDesc.length;
            switch (formatDesc.conversion) {
                case 99: {
                    formatDesc.format(buffer, (byte)varargs.checkint(n2));
                    break;
                }
                case 100: 
                case 105: {
                    formatDesc.format(buffer, varargs.checkint(n2));
                    break;
                }
                case 88: 
                case 111: 
                case 117: 
                case 120: {
                    formatDesc.format(buffer, varargs.checklong(n2));
                    break;
                }
                case 69: 
                case 71: 
                case 101: 
                case 102: 
                case 103: {
                    formatDesc.format(buffer, varargs.checkdouble(n2));
                    break;
                }
                case 113: {
                    StringLib.addquoted(buffer, varargs.checkstring(n2));
                    break;
                }
                case 115: {
                    LuaString luaString2 = varargs.checkstring(n2);
                    if (formatDesc.precision == -1 && luaString2.length() >= 100) {
                        buffer.append(luaString2);
                        break;
                    }
                    formatDesc.format(buffer, luaString2);
                    break;
                }
                default: {
                    StringLib.error("invalid option '%" + (char)formatDesc.conversion + "' to 'format'");
                }
            }
        }
        return buffer.tostring();
    }

    private static void addquoted(Buffer buffer, LuaString luaString) {
        buffer.append((byte)34);
        int n = luaString.length();
        block5: for (int i = 0; i < n; ++i) {
            int n2 = luaString.luaByte(i);
            switch (n2) {
                case 10: 
                case 34: 
                case 92: {
                    buffer.append((byte)92);
                    buffer.append((byte)n2);
                    continue block5;
                }
                case 13: {
                    buffer.append("\\r");
                    continue block5;
                }
                case 0: {
                    buffer.append("\\000");
                    continue block5;
                }
                default: {
                    buffer.append((byte)n2);
                }
            }
        }
        buffer.append((byte)34);
    }

    static Varargs gmatch(Varargs varargs) {
        LuaString luaString = varargs.checkstring(1);
        LuaString luaString2 = varargs.checkstring(2);
        return new GMatchAux(varargs, luaString, luaString2);
    }

    static Varargs gsub(Varargs varargs) {
        LuaString luaString = varargs.checkstring(1);
        int n = luaString.length();
        LuaString luaString2 = varargs.checkstring(2);
        LuaValue luaValue = varargs.arg(3);
        int n2 = varargs.optint(4, n + 1);
        boolean bl = luaString2.length() > 0 && luaString2.charAt(0) == 94;
        Buffer buffer = new Buffer(n);
        MatchState matchState = new MatchState(varargs, luaString, luaString2);
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            matchState.reset();
            int n5 = matchState.match(n3, bl ? 1 : 0);
            if (n5 != -1) {
                ++n4;
                matchState.add_value(buffer, n3, n5, luaValue);
            }
            if (n5 != -1 && n5 > n3) {
                n3 = n5;
            } else {
                if (n3 >= n) break;
                buffer.append((byte)luaString.luaByte(n3++));
            }
            if (!bl) continue;
            break;
        }
        buffer.append(luaString.substring(n3, n));
        return StringLib.varargsOf(buffer.tostring(), (Varargs)StringLib.valueOf(n4));
    }

    static LuaValue len(LuaValue luaValue) {
        return luaValue.checkstring().len();
    }

    static LuaValue lower(LuaValue luaValue) {
        return StringLib.valueOf(luaValue.checkjstring().toLowerCase());
    }

    static Varargs match(Varargs varargs) {
        return StringLib.str_find_aux(varargs, false);
    }

    static Varargs rep(Varargs varargs) {
        LuaString luaString = varargs.checkstring(1);
        int n = varargs.checkint(2);
        byte[] byArray = new byte[luaString.length() * n];
        int n2 = luaString.length();
        for (int i = 0; i < byArray.length; i += n2) {
            luaString.copyInto(0, byArray, i, n2);
        }
        return LuaString.valueOf(byArray);
    }

    static LuaValue reverse(LuaValue luaValue) {
        LuaString luaString = luaValue.checkstring();
        int n = luaString.length();
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = n - 1;
        while (n2 < n) {
            byArray[n3] = (byte)luaString.luaByte(n2);
            ++n2;
            --n3;
        }
        return LuaString.valueOf(byArray);
    }

    static Varargs sub(Varargs varargs) {
        LuaString luaString = varargs.checkstring(1);
        int n = luaString.length();
        int n2 = StringLib.posrelat(varargs.checkint(2), n);
        int n3 = StringLib.posrelat(varargs.optint(3, -1), n);
        if (n2 < 1) {
            n2 = 1;
        }
        if (n3 > n) {
            n3 = n;
        }
        if (n2 <= n3) {
            return luaString.substring(n2 - 1, n3);
        }
        return EMPTYSTRING;
    }

    static LuaValue upper(LuaValue luaValue) {
        return StringLib.valueOf(luaValue.checkjstring().toUpperCase());
    }

    static Varargs str_find_aux(Varargs varargs, boolean bl) {
        boolean bl2;
        LuaString luaString = varargs.checkstring(1);
        LuaString luaString2 = varargs.checkstring(2);
        int n = varargs.optint(3, 1);
        if (n > 0) {
            n = Math.min(n - 1, luaString.length());
        } else if (n < 0) {
            n = Math.max(0, luaString.length() + n);
        }
        boolean bl3 = bl2 = bl && (varargs.arg(4).toboolean() || luaString2.indexOfAny(SPECIALS) == -1);
        if (bl2) {
            int n2 = luaString.indexOf(luaString2, n);
            if (n2 != -1) {
                return StringLib.varargsOf(StringLib.valueOf(n2 + 1), (Varargs)StringLib.valueOf(n2 + luaString2.length()));
            }
        } else {
            MatchState matchState = new MatchState(varargs, luaString, luaString2);
            boolean bl4 = false;
            int n3 = 0;
            if (luaString2.luaByte(0) == 94) {
                bl4 = true;
                n3 = 1;
            }
            int n4 = n;
            do {
                matchState.reset();
                int n5 = matchState.match(n4, n3);
                if (n5 == -1) continue;
                if (bl) {
                    return StringLib.varargsOf(StringLib.valueOf(n4 + 1), StringLib.valueOf(n5), matchState.push_captures(false, n4, n5));
                }
                return matchState.push_captures(true, n4, n5);
            } while (n4++ < luaString.length() && !bl4);
        }
        return NIL;
    }

    private static int posrelat(int n, int n2) {
        return n >= 0 ? n : n2 + n + 1;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        SPECIALS = StringLib.valueOf("^$*+?.([%-");
        CHAR_TABLE = new byte[256];
        for (int i = 0; i < 256; ++i) {
            char c = (char)i;
            StringLib.CHAR_TABLE[i] = (byte)((Character.isDigit(c) ? 8 : 0) | (Character.isLowerCase(c) ? 2 : 0) | (Character.isUpperCase(c) ? 4 : 0) | (c < ' ' || c == '\u007f' ? 64 : 0));
            if (c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F' || c >= '0' && c <= '9') {
                int n = i;
                CHAR_TABLE[n] = (byte)(CHAR_TABLE[n] | 0xFFFFFF80);
            }
            if (c >= '!' && c <= '/' || c >= ':' && c <= '@') {
                int n = i;
                CHAR_TABLE[n] = (byte)(CHAR_TABLE[n] | 0x10);
            }
            if ((CHAR_TABLE[i] & 6) == 0) continue;
            int n = i;
            CHAR_TABLE[n] = (byte)(CHAR_TABLE[n] | 1);
        }
        StringLib.CHAR_TABLE[32] = 32;
        CHAR_TABLE[13] = (byte)(CHAR_TABLE[13] | 0x20);
        CHAR_TABLE[10] = (byte)(CHAR_TABLE[10] | 0x20);
        CHAR_TABLE[9] = (byte)(CHAR_TABLE[9] | 0x20);
        CHAR_TABLE[12] = (byte)(CHAR_TABLE[12] | 0x20);
        CHAR_TABLE[12] = (byte)(CHAR_TABLE[12] | 0x20);
    }

    private static class MatchState {
        final LuaString s;
        final LuaString p;
        final Varargs args;
        int level;
        int[] cinit;
        int[] clen;

        MatchState(Varargs varargs, LuaString luaString, LuaString luaString2) {
            this.s = luaString;
            this.p = luaString2;
            this.args = varargs;
            this.level = 0;
            this.cinit = new int[32];
            this.clen = new int[32];
        }

        void reset() {
            this.level = 0;
        }

        private void add_s(Buffer buffer, LuaString luaString, int n, int n2) {
            int n3 = luaString.length();
            for (int i = 0; i < n3; ++i) {
                byte by = (byte)luaString.luaByte(i);
                if (by != 37) {
                    buffer.append(by);
                    continue;
                }
                if (!Character.isDigit((char)(by = (byte)luaString.luaByte(++i)))) {
                    buffer.append(by);
                    continue;
                }
                if (by == 48) {
                    buffer.append(this.s.substring(n, n2));
                    continue;
                }
                buffer.append(this.push_onecapture(by - 49, n, n2).strvalue());
            }
        }

        public void add_value(Buffer buffer, int n, int n2, LuaValue luaValue) {
            switch (luaValue.type()) {
                case 3: 
                case 4: {
                    this.add_s(buffer, luaValue.strvalue(), n, n2);
                    return;
                }
                case 6: {
                    luaValue = luaValue.invoke(this.push_captures(true, n, n2)).arg1();
                    break;
                }
                case 5: {
                    luaValue = luaValue.get(this.push_onecapture(0, n, n2));
                    break;
                }
                default: {
                    LuaValue.error("bad argument: string/function/table expected");
                    return;
                }
            }
            if (!luaValue.toboolean()) {
                luaValue = this.s.substring(n, n2);
            } else if (!luaValue.isstring()) {
                LuaValue.error("invalid replacement value (a " + luaValue.typename() + ")");
            }
            buffer.append(luaValue.strvalue());
        }

        Varargs push_captures(boolean bl, int n, int n2) {
            int n3 = this.level == 0 && bl ? 1 : this.level;
            switch (n3) {
                case 0: {
                    return LuaValue.NONE;
                }
                case 1: {
                    return this.push_onecapture(0, n, n2);
                }
            }
            LuaValue[] luaValueArray = new LuaValue[n3];
            for (int i = 0; i < n3; ++i) {
                luaValueArray[i] = this.push_onecapture(i, n, n2);
            }
            return LuaValue.varargsOf(luaValueArray);
        }

        private LuaValue push_onecapture(int n, int n2, int n3) {
            if (n >= this.level) {
                if (n == 0) {
                    return this.s.substring(n2, n3);
                }
                return LuaValue.error("invalid capture index");
            }
            int n4 = this.clen[n];
            if (n4 == -1) {
                return LuaValue.error("unfinished capture");
            }
            if (n4 == -2) {
                return LuaValue.valueOf(this.cinit[n] + 1);
            }
            int n5 = this.cinit[n];
            return this.s.substring(n5, n5 + n4);
        }

        private int check_capture(int n) {
            if ((n -= 49) < 0 || n >= this.level || this.clen[n] == -1) {
                LuaValue.error("invalid capture index");
            }
            return n;
        }

        private int capture_to_close() {
            int n = this.level;
            --n;
            while (n >= 0) {
                if (this.clen[n] == -1) {
                    return n;
                }
                --n;
            }
            LuaValue.error("invalid pattern capture");
            return 0;
        }

        int classend(int n) {
            switch (this.p.luaByte(n++)) {
                case 37: {
                    if (n == this.p.length()) {
                        LuaValue.error("malformed pattern (ends with %)");
                    }
                    return n + 1;
                }
                case 91: {
                    if (this.p.luaByte(n) == 94) {
                        ++n;
                    }
                    do {
                        if (n == this.p.length()) {
                            LuaValue.error("malformed pattern (missing ])");
                        }
                        if (this.p.luaByte(n++) != 37 || n == this.p.length()) continue;
                        ++n;
                    } while (this.p.luaByte(n) != 93);
                    return n + 1;
                }
            }
            return n;
        }

        static boolean match_class(int n, int n2) {
            boolean bl;
            char c = Character.toLowerCase((char)n2);
            byte by = CHAR_TABLE[n];
            switch (c) {
                case 'a': {
                    bl = (by & 1) != 0;
                    break;
                }
                case 'd': {
                    bl = (by & 8) != 0;
                    break;
                }
                case 'l': {
                    bl = (by & 2) != 0;
                    break;
                }
                case 'u': {
                    bl = (by & 4) != 0;
                    break;
                }
                case 'c': {
                    bl = (by & 0x40) != 0;
                    break;
                }
                case 'p': {
                    bl = (by & 0x10) != 0;
                    break;
                }
                case 's': {
                    bl = (by & 0x20) != 0;
                    break;
                }
                case 'w': {
                    bl = (by & 9) != 0;
                    break;
                }
                case 'x': {
                    bl = (by & 0xFFFFFF80) != 0;
                    break;
                }
                case 'z': {
                    bl = n == 0;
                    break;
                }
                default: {
                    return n2 == n;
                }
            }
            return c == n2 ? bl : !bl;
        }

        boolean matchbracketclass(int n, int n2, int n3) {
            boolean bl = true;
            if (this.p.luaByte(n2 + 1) == 94) {
                bl = false;
                ++n2;
            }
            while (++n2 < n3) {
                if (!(this.p.luaByte(n2) == 37 ? MatchState.match_class(n, this.p.luaByte(++n2)) : (this.p.luaByte(n2 + 1) == 45 && n2 + 2 < n3 ? this.p.luaByte((n2 += 2) - 2) <= n && n <= this.p.luaByte(n2) : this.p.luaByte(n2) == n))) continue;
                return bl;
            }
            return !bl;
        }

        boolean singlematch(int n, int n2, int n3) {
            switch (this.p.luaByte(n2)) {
                case 46: {
                    return true;
                }
                case 37: {
                    return MatchState.match_class(n, this.p.luaByte(n2 + 1));
                }
                case 91: {
                    return this.matchbracketclass(n, n2, n3 - 1);
                }
            }
            return this.p.luaByte(n2) == n;
        }

        int match(int n, int n2) {
            block16: while (n2 != this.p.length()) {
                int n3;
                int n4;
                switch (this.p.luaByte(n2)) {
                    case 40: {
                        if (++n2 < this.p.length() && this.p.luaByte(n2) == 41) {
                            return this.start_capture(n, n2 + 1, -2);
                        }
                        return this.start_capture(n, n2, -1);
                    }
                    case 41: {
                        return this.end_capture(n, n2 + 1);
                    }
                    case 37: {
                        if (n2 + 1 == this.p.length()) {
                            LuaValue.error("malformed pattern (ends with '%')");
                        }
                        switch (this.p.luaByte(n2 + 1)) {
                            case 98: {
                                n = this.matchbalance(n, n2 + 2);
                                if (n == -1) {
                                    return -1;
                                }
                                n2 += 4;
                                continue block16;
                            }
                            case 102: {
                                if (this.p.luaByte(n2 += 2) != 91) {
                                    LuaValue.error("Missing [ after %f in pattern");
                                }
                                n4 = this.classend(n2);
                                int n5 = n3 = n == 0 ? -1 : this.s.luaByte(n - 1);
                                if (this.matchbracketclass(n3, n2, n4 - 1) || this.matchbracketclass(this.s.luaByte(n), n2, n4 - 1)) {
                                    return -1;
                                }
                                n2 = n4;
                                continue block16;
                            }
                        }
                        n4 = this.p.luaByte(n2 + 1);
                        if (Character.isDigit((char)n4)) {
                            if ((n = this.match_capture(n, n4)) == -1) {
                                return -1;
                            }
                            return this.match(n, n2 + 2);
                        }
                    }
                    case 36: {
                        if (n2 + 1 != this.p.length()) break;
                        return n == this.s.length() ? n : -1;
                    }
                }
                n4 = this.classend(n2);
                n3 = n < this.s.length() && this.singlematch(this.s.luaByte(n), n2, n4) ? 1 : 0;
                int n6 = n4 < this.p.length() ? this.p.luaByte(n4) : 0;
                switch (n6) {
                    case 63: {
                        int n7;
                        if (n3 != 0 && (n7 = this.match(n + 1, n4 + 1)) != -1) {
                            return n7;
                        }
                        n2 = n4 + 1;
                        continue block16;
                    }
                    case 42: {
                        return this.max_expand(n, n2, n4);
                    }
                    case 43: {
                        return n3 != 0 ? this.max_expand(n + 1, n2, n4) : -1;
                    }
                    case 45: {
                        return this.min_expand(n, n2, n4);
                    }
                }
                if (n3 == 0) {
                    return -1;
                }
                ++n;
                n2 = n4;
            }
            return n;
        }

        int max_expand(int n, int n2, int n3) {
            int n4 = 0;
            while (n + n4 < this.s.length() && this.singlematch(this.s.luaByte(n + n4), n2, n3)) {
                ++n4;
            }
            while (n4 >= 0) {
                int n5 = this.match(n + n4, n3 + 1);
                if (n5 != -1) {
                    return n5;
                }
                --n4;
            }
            return -1;
        }

        int min_expand(int n, int n2, int n3) {
            while (true) {
                int n4;
                if ((n4 = this.match(n, n3 + 1)) != -1) {
                    return n4;
                }
                if (n >= this.s.length() || !this.singlematch(this.s.luaByte(n), n2, n3)) break;
                ++n;
            }
            return -1;
        }

        int start_capture(int n, int n2, int n3) {
            int n4 = this.level;
            if (n4 >= 32) {
                LuaValue.error("too many captures");
            }
            this.cinit[n4] = n;
            this.clen[n4] = n3;
            this.level = n4 + 1;
            int n5 = this.match(n, n2);
            if (n5 == -1) {
                --this.level;
            }
            return n5;
        }

        int end_capture(int n, int n2) {
            int n3 = this.capture_to_close();
            this.clen[n3] = n - this.cinit[n3];
            int n4 = this.match(n, n2);
            if (n4 == -1) {
                this.clen[n3] = -1;
            }
            return n4;
        }

        int match_capture(int n, int n2) {
            n2 = this.check_capture(n2);
            int n3 = this.clen[n2];
            if (this.s.length() - n >= n3 && LuaString.equals(this.s, this.cinit[n2], this.s, n, n3)) {
                return n + n3;
            }
            return -1;
        }

        int matchbalance(int n, int n2) {
            int n3 = this.p.length();
            if (n2 == n3 || n2 + 1 == n3) {
                LuaValue.error("unbalanced pattern");
            }
            if (this.s.luaByte(n) != this.p.luaByte(n2)) {
                return -1;
            }
            int n4 = this.p.luaByte(n2);
            int n5 = this.p.luaByte(n2 + 1);
            int n6 = 1;
            while (++n < this.s.length()) {
                if (this.s.luaByte(n) == n5) {
                    if (--n6 != 0) continue;
                    return n + 1;
                }
                if (this.s.luaByte(n) != n4) continue;
                ++n6;
            }
            return -1;
        }
    }

    static class GMatchAux
    extends VarArgFunction {
        private final int srclen;
        private final MatchState ms;
        private int soffset;

        public GMatchAux(Varargs varargs, LuaString luaString, LuaString luaString2) {
            this.srclen = luaString.length();
            this.ms = new MatchState(varargs, luaString, luaString2);
            this.soffset = 0;
        }

        public Varargs invoke(Varargs varargs) {
            while (this.soffset < this.srclen) {
                this.ms.reset();
                int n = this.ms.match(this.soffset, 0);
                if (n >= 0) {
                    int n2 = this.soffset;
                    this.soffset = n;
                    return this.ms.push_captures(true, n2, n);
                }
                ++this.soffset;
            }
            return NIL;
        }
    }

    private static class FormatDesc {
        private boolean leftAdjust;
        private boolean zeroPad;
        private boolean explicitPlus;
        private boolean space;
        private boolean alternateForm;
        private static final int MAX_FLAGS = 5;
        private int width;
        private int precision;
        public final int conversion;
        public final int length;

        public FormatDesc(Varargs varargs, LuaString luaString, int n) {
            int n2 = n;
            int n3 = luaString.length();
            int n4 = 0;
            boolean bl = true;
            block7: while (bl) {
                n4 = n2 < n3 ? luaString.luaByte(n2++) : 0;
                switch (n4) {
                    case 45: {
                        this.leftAdjust = true;
                        continue block7;
                    }
                    case 43: {
                        this.explicitPlus = true;
                        continue block7;
                    }
                    case 32: {
                        this.space = true;
                        continue block7;
                    }
                    case 35: {
                        this.alternateForm = true;
                        continue block7;
                    }
                    case 48: {
                        this.zeroPad = true;
                        continue block7;
                    }
                }
                bl = false;
            }
            if (n2 - n > 5) {
                LuaValue.error("invalid format (repeated flags)");
            }
            this.width = -1;
            if (Character.isDigit((char)n4)) {
                this.width = n4 - 48;
                int n5 = n4 = n2 < n3 ? luaString.luaByte(n2++) : 0;
                if (Character.isDigit((char)n4)) {
                    this.width = this.width * 10 + (n4 - 48);
                    n4 = n2 < n3 ? luaString.luaByte(n2++) : 0;
                }
            }
            this.precision = -1;
            if (n4 == 46) {
                int n6 = n4 = n2 < n3 ? luaString.luaByte(n2++) : 0;
                if (Character.isDigit((char)n4)) {
                    this.precision = n4 - 48;
                    int n7 = n4 = n2 < n3 ? luaString.luaByte(n2++) : 0;
                    if (Character.isDigit((char)n4)) {
                        this.precision = this.precision * 10 + (n4 - 48);
                        int n8 = n4 = n2 < n3 ? luaString.luaByte(n2++) : 0;
                    }
                }
            }
            if (Character.isDigit((char)n4)) {
                LuaValue.error("invalid format (width or precision too long)");
            }
            this.zeroPad &= !this.leftAdjust;
            this.conversion = n4;
            this.length = n2 - n;
        }

        public void format(Buffer buffer, byte by) {
            buffer.append(by);
        }

        public void format(Buffer buffer, long l) {
            int n;
            int n2;
            String string;
            if (l == 0L && this.precision == 0) {
                string = "";
            } else {
                switch (this.conversion) {
                    case 88: 
                    case 120: {
                        n2 = 16;
                        break;
                    }
                    case 111: {
                        n2 = 8;
                        break;
                    }
                    default: {
                        n2 = 10;
                    }
                }
                string = Long.toString(l, n2);
                if (this.conversion == 88) {
                    string = string.toUpperCase();
                }
            }
            int n3 = n2 = string.length();
            if (l < 0L) {
                --n3;
            } else if (this.explicitPlus || this.space) {
                ++n2;
            }
            int n4 = this.precision > n3 ? this.precision - n3 : (this.precision == -1 && this.zeroPad && this.width > n2 ? this.width - n2 : 0);
            int n5 = n = this.width > (n2 += n4) ? this.width - n2 : 0;
            if (!this.leftAdjust) {
                FormatDesc.pad(buffer, ' ', n);
            }
            if (l < 0L) {
                if (n4 > 0) {
                    buffer.append((byte)45);
                    string = string.substring(1);
                }
            } else if (this.explicitPlus) {
                buffer.append((byte)43);
            } else if (this.space) {
                buffer.append((byte)32);
            }
            if (n4 > 0) {
                FormatDesc.pad(buffer, '0', n4);
            }
            buffer.append(string);
            if (this.leftAdjust) {
                FormatDesc.pad(buffer, ' ', n);
            }
        }

        public void format(Buffer buffer, double d) {
            buffer.append(String.valueOf(d));
        }

        public void format(Buffer buffer, LuaString luaString) {
            int n = luaString.indexOf((byte)0, 0);
            if (n != -1) {
                luaString = luaString.substring(0, n);
            }
            buffer.append(luaString);
        }

        public static final void pad(Buffer buffer, char c, int n) {
            byte by = (byte)c;
            while (n-- > 0) {
                buffer.append(by);
            }
        }
    }

    public static final class StringLibV
    extends VarArgFunction {
        public Varargs invoke(Varargs varargs) {
            switch (this.opcode) {
                case 0: {
                    return StringLib.byte_(varargs);
                }
                case 1: {
                    return StringLib.char_(varargs);
                }
                case 2: {
                    return StringLib.find(varargs);
                }
                case 3: {
                    return StringLib.format(varargs);
                }
                case 4: {
                    return StringLib.gmatch(varargs);
                }
                case 5: {
                    return StringLib.gsub(varargs);
                }
                case 6: {
                    return StringLib.match(varargs);
                }
                case 7: {
                    return StringLib.rep(varargs);
                }
                case 8: {
                    return StringLib.sub(varargs);
                }
            }
            return NONE;
        }
    }

    public static final class StringLib1
    extends OneArgFunction {
        public LuaValue call(LuaValue luaValue) {
            switch (this.opcode) {
                case 0: {
                    return StringLib.dump(luaValue);
                }
                case 1: {
                    return StringLib.len(luaValue);
                }
                case 2: {
                    return StringLib.lower(luaValue);
                }
                case 3: {
                    return StringLib.reverse(luaValue);
                }
                case 4: {
                    return StringLib.upper(luaValue);
                }
            }
            return NIL;
        }
    }
}

