/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib;

import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.LibFunction;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.VarArgFunction;

public class TableLib
extends OneArgFunction {
    public LuaValue call(LuaValue luaValue) {
        LuaTable luaTable = new LuaTable();
        luaTable.set("concat", (LuaValue)new concat());
        luaTable.set("insert", (LuaValue)new insert());
        luaTable.set("pack", (LuaValue)new pack());
        luaTable.set("remove", (LuaValue)new remove());
        luaTable.set("sort", (LuaValue)new sort());
        luaTable.set("unpack", (LuaValue)new unpack());
        luaValue.set("table", (LuaValue)luaTable);
        return NIL;
    }

    static class unpack
    extends VarArgFunction {
        unpack() {
        }

        public Varargs invoke(Varargs varargs) {
            LuaTable luaTable = varargs.checktable(1);
            switch (varargs.narg()) {
                case 1: {
                    return luaTable.unpack();
                }
                case 2: {
                    return luaTable.unpack(varargs.checkint(2));
                }
            }
            return luaTable.unpack(varargs.checkint(2), varargs.checkint(3));
        }
    }

    static class sort
    extends TwoArgFunction {
        sort() {
        }

        public LuaValue call(LuaValue luaValue, LuaValue luaValue2) {
            luaValue.checktable().sort(luaValue2.isnil() ? NIL : luaValue2.checkfunction());
            return NONE;
        }
    }

    static class remove
    extends TableLibFunction {
        remove() {
        }

        public LuaValue call(LuaValue luaValue) {
            return luaValue.checktable().remove(0);
        }

        public LuaValue call(LuaValue luaValue, LuaValue luaValue2) {
            return luaValue.checktable().remove(luaValue2.checkint());
        }
    }

    static class pack
    extends VarArgFunction {
        pack() {
        }

        public Varargs invoke(Varargs varargs) {
            LuaTable luaTable = pack.tableOf(varargs, 1);
            luaTable.set("n", varargs.narg());
            return luaTable;
        }
    }

    static class insert
    extends TableLibFunction {
        insert() {
        }

        public LuaValue call(LuaValue luaValue) {
            return insert.argerror(2, "value expected");
        }

        public LuaValue call(LuaValue luaValue, LuaValue luaValue2) {
            luaValue.checktable().insert(luaValue.length() + 1, luaValue2);
            return NONE;
        }

        public LuaValue call(LuaValue luaValue, LuaValue luaValue2, LuaValue luaValue3) {
            luaValue.checktable().insert(luaValue2.checkint(), luaValue3);
            return NONE;
        }
    }

    static class concat
    extends TableLibFunction {
        concat() {
        }

        public LuaValue call(LuaValue luaValue) {
            return luaValue.checktable().concat(EMPTYSTRING, 1, luaValue.length());
        }

        public LuaValue call(LuaValue luaValue, LuaValue luaValue2) {
            return luaValue.checktable().concat(luaValue2.checkstring(), 1, luaValue.length());
        }

        public LuaValue call(LuaValue luaValue, LuaValue luaValue2, LuaValue luaValue3) {
            return luaValue.checktable().concat(luaValue2.checkstring(), luaValue3.checkint(), luaValue.length());
        }

        public LuaValue call(LuaValue luaValue, LuaValue luaValue2, LuaValue luaValue3, LuaValue luaValue4) {
            return luaValue.checktable().concat(luaValue2.checkstring(), luaValue3.checkint(), luaValue4.checkint());
        }
    }

    static class TableLibFunction
    extends LibFunction {
        TableLibFunction() {
        }

        public LuaValue call() {
            return TableLibFunction.argerror(1, "table expected, got no value");
        }
    }
}

