/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.BigDecimalColumn;
import com.exasol.jdbc.CharColumn;
import com.exasol.jdbc.Column;
import com.exasol.jdbc.ConnectionLost;
import com.exasol.jdbc.DebugLog;
import com.exasol.jdbc.DecimalColumn;
import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.EXAInputStream;
import com.exasol.jdbc.EXAResult;
import com.exasol.jdbc.EXASQLException;
import com.exasol.jdbc.EXAStatement;
import com.exasol.jdbc.ExecutionStatus;
import com.exasol.jdbc.NotImplemented;
import com.exasol.jdbc.TimestampColumn;
import com.exasol.jdbc.Translator;
import com.exasol.jdbc.VarCharColumn;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class EXAResultSet
extends EXAResult
implements ResultSetMetaData,
ResultSet {
    private String catalogName = "";
    private String schemaName = "";
    private String tableName = "";
    private Column[] columns = null;
    private boolean lastNull = false;
    protected int myCursorPos = -1;
    private int rows = 0;
    private int fetchdirection = 1000;
    private int fetchsize = 2000;
    private long totalRows = 0L;
    private int handle = -1;
    private long firstIndex = 0L;
    private long maxRows = 0L;
    private boolean closed = false;
    private int resultLineSize = 10000;
    private static int optimalPackageSize = 2000000;

    public void setMaxRows(long rows) {
        this.maxRows = rows;
    }

    public EXAResultSet(DebugLog debug_) {
        super("EXAResultSet", debug_);
        this.connection = null;
        this.columns = null;
    }

    public EXAResultSet(EXAInputStream is, EXAConnection con, DebugLog debug_) throws SQLException {
        this(debug_);
        this.connection = con;
        this.fetchsize = this.connection.getDefaultFetchSize();
        try {
            this.handle = is.readInt();
            switch (this.handle) {
                case -3: {
                    if (this.debug == null) break;
                    this.log("Result set handle = SMALL_RESULTSET");
                    break;
                }
                case -4: {
                    if (this.debug != null) {
                        this.log("Result set handle = INVALID_RESULTSET");
                    }
                    return;
                }
                default: {
                    if (this.debug == null) break;
                    this.log("Result set handle = " + this.handle);
                }
            }
            this.columns = new Column[is.readInt()];
            if (this.debug != null) {
                this.log("Result set has " + this.columns.length + " columns");
            }
            this.totalRows = is.readLong();
            if (this.debug != null) {
                this.log("Result set has " + this.totalRows + " rows");
            }
            this.rows = (int)is.readLong();
            if (this.debug != null) {
                this.log("Received " + this.rows + " rows");
            }
            this.resultLineSize = 0;
            for (int col = 0; col < this.columns.length; ++col) {
                String column_name = is.readString();
                this.columns[col] = Column.from_jdbc_type(is, con);
                this.log(" Col(" + col + ") " + column_name + " " + this.columns[col].getTypeName());
                if (this.columns[col] instanceof DecimalColumn) {
                    ((DecimalColumn)this.columns[col]).setEnableNumericTypeConversion(this.connection.getEnableNumericTypeConversion());
                }
                if (this.columns[col] instanceof TimestampColumn) {
                    ((TimestampColumn)this.columns[col]).setScale(this.connection.getTimestampPrecision());
                }
                this.columns[col].resize(this.rows);
                if (column_name.length() > 0) {
                    this.columns[col].name = column_name;
                    this.columns[col].label = column_name;
                }
                this.resultLineSize += this.columns[col].getDisplaySize();
            }
            this.readRows(is, this.rows);
            if ((long)this.rows == this.totalRows) {
                this.closeInServer();
            }
        }
        catch (IOException e) {
            throw new ConnectionLost(e.toString(), this.connection.getSessionID());
        }
    }

    public EXAResultSet(String columnName, String[] values, DebugLog debug_) {
        this(debug_);
        if (debug_ != null) {
            debug_.log("EXAResultSet(String,String[],DebugLog)");
        }
        this.columns = new Column[1];
        this.columns[0] = new VarCharColumn(columnName, values);
        this.rows = values.length;
    }

    public EXAResultSet(String columnName, BigDecimal[] values, DebugLog debug_) {
        this(debug_);
        this.columns = new Column[1];
        this.columns[0] = new BigDecimalColumn(columnName, 36, 0, values);
        this.rows = values.length;
    }

    private SQLException ex(Throwable t) {
        if (this.debug != null) {
            try {
                CharArrayWriter w = new CharArrayWriter();
                t.printStackTrace(new PrintWriter(w));
                this.debug.log(w.toString(), 0);
            }
            catch (Throwable q) {
                this.log("internal log error:" + q.toString());
            }
        }
        if (t instanceof SQLException) {
            return (SQLException)t;
        }
        return new SQLException(t.toString());
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        boolean ret = false;
        if (0L != this.maxRows && (long)row >= this.maxRows) {
            ret = false;
        }
        if (row == 0) {
            ret = this.seek(0L);
            this.myCursorPos = -1;
        } else {
            ret = row > 0 ? this.seek(row - 1) : this.seek(this.totalRows + (long)row);
        }
        if (this.debug != null) {
            this.log("absolute(" + row + "): " + ret);
        }
        return ret;
    }

    @Override
    public int getRow() throws SQLException {
        int ret = 0;
        long num = (long)this.myCursorPos + this.firstIndex;
        ret = num > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)(num + 1L);
        if (this.debug != null) {
            this.log("getRow(): " + ret + " posInResult=" + this.myCursorPos);
        }
        return ret;
    }

    @Override
    public void afterLast() throws SQLException {
        if (this.debug != null) {
            this.log("afterLast()");
        }
        this.myCursorPos = 0;
        if (0L != this.maxRows && this.totalRows >= this.maxRows) {
            this.firstIndex = this.maxRows;
        }
        this.firstIndex = this.totalRows;
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (this.debug != null) {
            this.log("beforeFirst()");
        }
        this.seek(0L);
        this.myCursorPos = -1;
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        if (this.debug != null) {
            this.log("cancelRowUpdates() -> not implemented");
        }
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (this.debug != null) {
            this.log("clearWarnings()");
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.debug != null) {
            this.log("close()");
        }
        this.closed = true;
        this.closeInServer();
    }

    private void closeInServer() throws SQLException {
        if (this.debug != null) {
            this.log("closeInServer() for handle " + this.handle);
        }
        if (this.handle < 0) {
            return;
        }
        byte[] to_send = new byte[]{(byte)this.handle, (byte)(this.handle >> 8), (byte)(this.handle >> 16), (byte)(this.handle >> 24)};
        this.handle = -1;
        this.connection.communication(to_send, (byte)13, new ExecutionStatus(), null);
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void deleteRow() throws SQLException {
        if (this.debug != null) {
            this.log("deleteRow() -> not implemented");
        }
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        for (int i = 0; i < this.columns.length; ++i) {
            if (!columnName.equalsIgnoreCase(this.columns[i].name)) continue;
            if (this.debug != null) {
                this.log("findColumn(" + columnName + "): " + (i + 1));
            }
            return i + 1;
        }
        if (this.debug != null) {
            this.log("findColumn(" + columnName + ") -> not found");
        }
        throw new SQLException(Translator.Column_name() + " \"" + columnName + "\" " + Translator.not_found());
    }

    @Override
    public boolean first() throws SQLException {
        if (this.debug != null) {
            this.log("first(): absolute(1)");
        }
        return this.absolute(1);
    }

    @Override
    public Array getArray(int i) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        return this.getArray(this.findColumn(colName));
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        try {
            this.lastNull = this.columns[columnIndex - 1].isNull(this.myCursorPos);
            if (this.lastNull) {
                return null;
            }
            BigDecimal erg = this.columns[columnIndex - 1].getBigDecimal(this.myCursorPos);
            if (this.debug != null) {
                this.log("getBigDecimal(" + columnIndex + "): " + erg.toString());
            }
            return erg;
        }
        catch (Throwable t) {
            throw this.ex(t);
        }
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        try {
            this.lastNull = this.columns[columnIndex - 1].isNull(this.myCursorPos);
            if (this.lastNull) {
                return null;
            }
            BigDecimal erg = this.columns[columnIndex - 1].getBigDecimal(this.myCursorPos, scale);
            return erg;
        }
        catch (Throwable t) {
            throw this.ex(t);
        }
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        if (this.debug != null) {
            this.log("getBinaryStream(" + columnIndex + ")");
        }
        try {
            this.lastNull = this.columns[columnIndex - 1].isNull(this.myCursorPos);
            if (this.lastNull) {
                return null;
            }
            return this.columns[columnIndex - 1].getBinaryStream(this.myCursorPos);
        }
        catch (Throwable t) {
            throw this.ex(t);
        }
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        if (this.debug != null) {
            this.log("getBlob(" + columnIndex + ")");
        }
        try {
            this.lastNull = this.columns[columnIndex - 1].isNull(this.myCursorPos);
            if (this.lastNull) {
                return null;
            }
            return this.columns[columnIndex - 1].getBlob(this.myCursorPos);
        }
        catch (Throwable t) {
            throw this.ex(t);
        }
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        return this.getBlob(this.findColumn(colName));
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        try {
            this.lastNull = this.columns[columnIndex - 1].isNull(this.myCursorPos);
            if (this.lastNull) {
                return false;
            }
            boolean erg = this.columns[columnIndex - 1].getBoolean(this.myCursorPos);
            return erg;
        }
        catch (Throwable t) {
            throw this.ex(t);
        }
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        try {
            this.lastNull = this.columns[columnIndex - 1].isNull(this.myCursorPos);
            if (this.lastNull) {
                return 0;
            }
            byte erg = this.columns[columnIndex - 1].getByte(this.myCursorPos);
            return erg;
        }
        catch (Throwable t) {
            throw this.ex(t);
        }
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        try {
            this.lastNull = this.columns[columnIndex - 1].isNull(this.myCursorPos);
            if (this.lastNull) {
                return null;
            }
            return this.columns[columnIndex - 1].getBytes(this.myCursorPos);
        }
        catch (Throwable t) {
            throw this.ex(t);
        }
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        if (this.debug != null) {
            this.log("getCharacterStream(" + columnIndex + ")");
        }
        try {
            this.lastNull = this.columns[columnIndex - 1].isNull(this.myCursorPos);
            if (this.lastNull) {
                return null;
            }
            return this.columns[columnIndex - 1].getCharacterStream(this.myCursorPos);
        }
        catch (Throwable t) {
            throw this.ex(t);
        }
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        if (this.debug != null) {
            this.log("getClob(" + columnIndex + ")");
        }
        try {
            this.lastNull = this.columns[columnIndex - 1].isNull(this.myCursorPos);
            if (this.lastNull) {
                return null;
            }
            return this.columns[columnIndex - 1].getClob(this.myCursorPos);
        }
        catch (Throwable t) {
            throw this.ex(t);
        }
    }

    @Override
    public Clob getClob(String columnName) throws SQLException {
        return this.getClob(this.findColumn(columnName));
    }

    @Override
    public int getConcurrency() throws SQLException {
        if (this.debug != null) {
            this.log("getConcurrency(): CONCUR_READ_ONLY");
        }
        return 1007;
    }

    @Override
    public String getCursorName() throws SQLException {
        if (this.debug != null) {
            this.log("getCursorName()");
        }
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        try {
            this.lastNull = this.columns[columnIndex - 1].isNull(this.myCursorPos);
            if (this.lastNull) {
                return null;
            }
            Date erg = this.columns[columnIndex - 1].getDate(this.myCursorPos);
            return erg;
        }
        catch (Throwable t) {
            throw this.ex(t);
        }
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        try {
            this.lastNull = this.columns[columnIndex - 1].isNull(this.myCursorPos);
            if (this.lastNull) {
                return null;
            }
            Date erg = this.columns[columnIndex - 1].getDate(this.myCursorPos, cal);
            return erg;
        }
        catch (Throwable t) {
            throw this.ex(t);
        }
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnName), cal);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        try {
            this.lastNull = this.columns[columnIndex - 1].isNull(this.myCursorPos);
            if (this.lastNull) {
                return 0.0;
            }
            double erg = this.columns[columnIndex - 1].getDouble(this.myCursorPos);
            return erg;
        }
        catch (Throwable t) {
            throw this.ex(t);
        }
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    @Override
    public int getFetchDirection() throws SQLException {
        if (this.debug != null) {
            this.log("getFetchDirection(): " + this.fetchdirection);
        }
        return this.fetchdirection;
    }

    @Override
    public int getFetchSize() throws SQLException {
        if (this.debug != null) {
            this.log("EXAResultSet:getFetchSize(): " + this.fetchsize);
        }
        return this.fetchsize;
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        try {
            this.lastNull = this.columns[columnIndex - 1].isNull(this.myCursorPos);
            if (this.lastNull) {
                return 0.0f;
            }
            float erg = this.columns[columnIndex - 1].getFloat(this.myCursorPos);
            return erg;
        }
        catch (Throwable t) {
            throw this.ex(t);
        }
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        try {
            this.lastNull = this.columns[columnIndex - 1].isNull(this.myCursorPos);
            if (this.lastNull) {
                return 0;
            }
            int erg = this.columns[columnIndex - 1].getInt(this.myCursorPos);
            return erg;
        }
        catch (Throwable t) {
            throw this.ex(t);
        }
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        try {
            this.lastNull = this.columns[columnIndex - 1].isNull(this.myCursorPos);
            if (this.lastNull) {
                return 0L;
            }
            long erg = this.columns[columnIndex - 1].getLong(this.myCursorPos);
            return erg;
        }
        catch (Throwable t) {
            throw this.ex(t);
        }
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.debug != null) {
            this.log("EXAResultSet: getMetaData() - result set meta data");
        }
        return this;
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        try {
            this.lastNull = this.columns[columnIndex - 1].isNull(this.myCursorPos);
            if (this.lastNull) {
                return null;
            }
            if (type == BigDecimal.class) {
                return type.cast(this.columns[columnIndex - 1].getBigDecimal(this.myCursorPos));
            }
            if (type == Integer.class) {
                return type.cast(this.columns[columnIndex - 1].getInt(this.myCursorPos));
            }
            if (type == Boolean.class) {
                return type.cast(this.columns[columnIndex - 1].getBoolean(this.myCursorPos));
            }
            if (type == String.class) {
                return type.cast(this.columns[columnIndex - 1].getString(this.myCursorPos));
            }
            if (type == Long.class) {
                return type.cast(this.columns[columnIndex - 1].getLong(this.myCursorPos));
            }
            if (type == Double.class) {
                return type.cast(this.columns[columnIndex - 1].getDouble(this.myCursorPos));
            }
            if (type == Float.class) {
                return type.cast(this.columns[columnIndex - 1].getDouble(this.myCursorPos));
            }
            if (type == Date.class) {
                return type.cast(this.columns[columnIndex - 1].getDate(this.myCursorPos));
            }
            if (type == Timestamp.class) {
                return type.cast(this.columns[columnIndex - 1].getTimestamp(this.myCursorPos));
            }
            if (type == Time.class) {
                return type.cast(this.columns[columnIndex - 1].getTime(this.myCursorPos));
            }
            throw new SQLException("Type conversion not supported: getObject(" + columnIndex + ", " + type + ")");
        }
        catch (Throwable t) {
            throw this.ex(t);
        }
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), type);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        try {
            this.lastNull = this.columns[columnIndex - 1].isNull(this.myCursorPos);
            if (this.lastNull) {
                return null;
            }
            Object erg = this.columns[columnIndex - 1].getObject(this.myCursorPos);
            return erg;
        }
        catch (Throwable t) {
            throw this.ex(t);
        }
    }

    public Object getObject(int columnIndex, Map map) throws SQLException {
        try {
            this.lastNull = this.columns[columnIndex - 1].isNull(this.myCursorPos);
            if (this.lastNull) {
                return null;
            }
            Object erg = this.columns[columnIndex - 1].getObject(this.myCursorPos, map);
            return erg;
        }
        catch (Throwable t) {
            throw this.ex(t);
        }
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    public Object getObject(String columnName, Map map) throws SQLException {
        return this.getObject(this.findColumn(columnName), map);
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        try {
            Ref erg = this.columns[columnIndex - 1].getRef(this.myCursorPos);
            return erg;
        }
        catch (Throwable t) {
            throw this.ex(t);
        }
    }

    @Override
    public Ref getRef(String columnName) throws SQLException {
        return this.getRef(this.findColumn(columnName));
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        try {
            this.lastNull = this.columns[columnIndex - 1].isNull(this.myCursorPos);
            if (this.lastNull) {
                return 0;
            }
            short erg = this.columns[columnIndex - 1].getShort(this.myCursorPos);
            return erg;
        }
        catch (Throwable t) {
            throw this.ex(t);
        }
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        try {
            this.lastNull = this.columns[columnIndex - 1].isNull(this.myCursorPos);
            if (this.lastNull) {
                return null;
            }
            String erg = this.columns[columnIndex - 1].getString(this.myCursorPos);
            return erg;
        }
        catch (Throwable t) {
            throw this.ex(t);
        }
    }

    @Override
    public Statement getStatement() {
        if (this.debug != null) {
            this.log("getStatement(): statement");
        }
        return this.statement;
    }

    public void setStatement(EXAStatement stmt) {
        if (this.debug != null) {
            this.log("setStatement(): statement");
        }
        this.statement = stmt;
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        try {
            this.lastNull = this.columns[columnIndex - 1].isNull(this.myCursorPos);
            if (this.lastNull) {
                return null;
            }
            Time erg = this.columns[columnIndex - 1].getTime(this.myCursorPos);
            return erg;
        }
        catch (Throwable t) {
            throw this.ex(t);
        }
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        try {
            this.lastNull = this.columns[columnIndex - 1].isNull(this.myCursorPos);
            if (this.lastNull) {
                return null;
            }
            Time erg = this.columns[columnIndex - 1].getTime(this.myCursorPos, cal);
            return erg;
        }
        catch (Throwable t) {
            throw this.ex(t);
        }
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnName), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        try {
            this.lastNull = this.columns[columnIndex - 1].isNull(this.myCursorPos);
            if (this.lastNull) {
                return null;
            }
            Timestamp erg = this.columns[columnIndex - 1].getTimestamp(this.myCursorPos);
            return erg;
        }
        catch (Throwable t) {
            throw this.ex(t);
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        try {
            this.lastNull = this.columns[columnIndex - 1].isNull(this.myCursorPos);
            if (this.lastNull) {
                return null;
            }
            Timestamp erg = this.columns[columnIndex - 1].getTimestamp(this.myCursorPos, cal);
            return erg;
        }
        catch (Throwable t) {
            throw this.ex(t);
        }
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName), cal);
    }

    @Override
    public int getType() throws SQLException {
        if (this.debug != null) {
            this.log("getType(): TYPE_SCROLL_INSENSITIVE");
        }
        return 1004;
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        if (this.debug != null) {
            this.log("getUnicodeStream(" + columnIndex + ")");
        }
        try {
            this.lastNull = this.columns[columnIndex - 1].isNull(this.myCursorPos);
            if (this.lastNull) {
                return null;
            }
            return this.columns[columnIndex - 1].getUnicodeStream(this.myCursorPos);
        }
        catch (Throwable t) {
            throw this.ex(t);
        }
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnName));
    }

    @Override
    public URL getURL(int i) throws SQLException {
        if (this.debug != null) {
            this.log("getURL(" + i + ")");
        }
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public URL getURL(String s) throws SQLException {
        if (this.debug != null) {
            this.log("getURL(" + s + ")");
        }
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.debug != null) {
            this.log("getWarnings(): null");
        }
        return null;
    }

    @Override
    public void insertRow() throws SQLException {
        this.readOnly();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        if (this.debug != null) {
            this.log("isAfterLast(): " + ((long)this.myCursorPos + this.firstIndex == (long)this.rows));
        }
        if (0L != this.maxRows && this.firstIndex + (long)this.myCursorPos >= this.maxRows) {
            return true;
        }
        return this.firstIndex + (long)this.myCursorPos >= this.totalRows;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        if (this.debug != null) {
            this.log("isBeforeFirst(): " + ((long)this.myCursorPos + this.firstIndex == -1L));
        }
        return (long)this.myCursorPos + this.firstIndex == -1L;
    }

    @Override
    public boolean isFirst() throws SQLException {
        if (this.debug != null) {
            this.log("isFirst(): " + ((long)this.myCursorPos + this.firstIndex == 0L));
        }
        return (long)this.myCursorPos + this.firstIndex == 0L;
    }

    @Override
    public boolean isLast() throws SQLException {
        if (this.debug != null) {
            this.log("isLast(): " + (this.totalRows - 1L == (long)this.myCursorPos + this.firstIndex));
        }
        if (0L != this.maxRows && this.firstIndex + (long)this.myCursorPos == this.maxRows - 1L) {
            return true;
        }
        return (long)this.myCursorPos + this.firstIndex == this.totalRows - 1L;
    }

    @Override
    public boolean last() throws SQLException {
        if (this.debug != null) {
            this.log("last(): absolute(-1)");
        }
        return this.absolute(-1);
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        if (this.debug != null) {
            this.log("moveToCurrentRow()");
        }
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        if (this.debug != null) {
            this.log("moveToInsertRow()");
        }
    }

    @Override
    public boolean next() throws SQLException {
        if (0L != this.maxRows && (long)this.myCursorPos + this.firstIndex + 1L >= this.maxRows) {
            return false;
        }
        return this.seek((long)this.myCursorPos + this.firstIndex + 1L);
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.debug != null) {
            this.log("previous(): " + (this.myCursorPos >= 0));
        }
        return this.seek((long)this.myCursorPos + this.firstIndex - 1L);
    }

    @Override
    public void refreshRow() throws SQLException {
        if (this.debug != null) {
            this.log("refreshRow()");
        }
    }

    @Override
    public boolean relative(int rows_) throws SQLException {
        if (this.debug != null) {
            this.log("relative(" + rows_ + "): " + (this.myCursorPos >= 0 && this.myCursorPos < this.rows));
        }
        if (0L != this.maxRows && (long)(this.myCursorPos + rows_) >= this.maxRows) {
            return false;
        }
        return this.seek(this.myCursorPos + rows_);
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        if (this.debug != null) {
            this.log("rowDeleted(): false");
        }
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        if (this.debug != null) {
            this.log("rowInserted(): false");
        }
        return false;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        if (this.debug != null) {
            this.log("rowUpdated(): false");
        }
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (this.debug != null) {
            this.log("setFetchDirection(" + direction + ")");
        }
        this.fetchdirection = direction;
    }

    @Override
    public void setFetchSize(int rows_) throws SQLException {
        if (this.debug != null) {
            this.log("EXAResultSet::setFetchSize(" + rows_ + ")");
        }
        if (rows_ <= 0) {
            if (this.debug != null) {
                this.log("Ignoring invalid fetch size: " + rows_ + ". Fetch size will be set to statement default: " + this.statement.getFetchSize());
            }
            rows_ = this.statement.getFetchSize();
        }
        this.fetchsize = rows_;
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        if (this.debug != null) {
            this.log("updateArray(" + columnIndex + "," + x + ")");
        }
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        if (this.debug != null) {
            this.log("updateArray(" + columnName + "," + x + ")");
        }
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public int getHoldability() throws SQLException {
        return 1;
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.readOnly();
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), x, length);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.readOnly();
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnName), x);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.readOnly();
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), x, length);
    }

    @Override
    public void updateBlob(int i, Blob r) throws SQLException {
        if (this.debug != null) {
            this.log("updateBlob(" + i + "," + r + ")");
        }
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void updateBlob(String i, Blob r) throws SQLException {
        if (this.debug != null) {
            this.log("updateBlob(" + i + "," + r + ")");
        }
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.readOnly();
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.updateBoolean(this.findColumn(columnName), x);
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.readOnly();
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        this.updateByte(this.findColumn(columnName), x);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.readOnly();
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(columnName), x);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.readOnly();
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), reader, length);
    }

    @Override
    public void updateClob(int i, Clob r) throws SQLException {
        if (this.debug != null) {
            this.log("updateClob(" + i + "," + r + ")");
        }
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void updateClob(String i, Clob r) throws SQLException {
        if (this.debug != null) {
            this.log("updateClob(" + i + "," + r + ")");
        }
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.readOnly();
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        this.updateDate(this.findColumn(columnName), x);
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.readOnly();
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        this.updateDouble(this.findColumn(columnName), x);
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.readOnly();
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        this.updateFloat(this.findColumn(columnName), x);
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.readOnly();
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        this.updateInt(this.findColumn(columnName), x);
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.readOnly();
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        this.updateLong(this.findColumn(columnName), x);
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.readOnly();
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        this.updateNull(this.findColumn(columnName));
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.readOnly();
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.readOnly();
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        this.updateObject(this.findColumn(columnName), x);
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.updateObject(this.findColumn(columnName), x, scale);
    }

    @Override
    public void updateRow() throws SQLException {
        this.readOnly();
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.readOnly();
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        this.updateShort(this.findColumn(columnName), x);
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        this.readOnly();
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        this.updateString(this.findColumn(columnName), x);
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.readOnly();
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        this.updateTime(this.findColumn(columnName), x);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.readOnly();
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(columnName), x);
    }

    @Override
    public boolean wasNull() {
        return this.lastNull;
    }

    protected void addColumn(Column col, String name) {
        if (this.columns == null) {
            this.columns = new Column[1];
            this.columns[0] = col;
        } else {
            Column[] cols = this.columns;
            this.columns = new Column[cols.length + 1];
            for (int i = 0; i < cols.length; ++i) {
                this.columns[i] = cols[i];
            }
            this.columns[cols.length] = col;
        }
        this.columns[this.columns.length - 1].name = name;
        this.columns[this.columns.length - 1].label = name;
    }

    private synchronized void fetchNextRows(long first) throws SQLException {
        if (-3 == this.handle) {
            throw new SQLException("Result is already closed on server, can't fetch rows for this handle.");
        }
        int myFetchsize = 1000;
        if (0 != this.fetchsize) {
            myFetchsize = this.fetchsize;
        } else if (this.resultLineSize > 0 && this.resultLineSize < optimalPackageSize) {
            myFetchsize = optimalPackageSize / this.resultLineSize + 100;
        }
        if (this.handle < 0) {
            throw new SQLException("Invalid resultset handle.");
        }
        if (first >= this.totalRows) {
            throw new SQLException("Invalid row num!");
        }
        this.firstIndex = first;
        if (this.totalRows - first < (long)myFetchsize) {
            myFetchsize = (int)(this.totalRows - first);
        }
        if (myFetchsize != this.rows) {
            for (int c = 0; c < this.columns.length; ++c) {
                this.columns[c].resize(myFetchsize);
            }
        }
        this.rows = myFetchsize;
        byte[] to_send = new byte[]{(byte)this.handle, (byte)(this.handle >> 8), (byte)(this.handle >> 16), (byte)(this.handle >> 24), (byte)first, (byte)(first >> 8), (byte)(first >> 16), (byte)(first >> 24), (byte)(first >> 32), (byte)(first >> 40), (byte)(first >> 48), (byte)(first >> 56), (byte)myFetchsize, (byte)(myFetchsize >> 8), (byte)(myFetchsize >> 16), (byte)(myFetchsize >> 24), 0, 0, 0, 0};
        byte[] res = this.connection.communication(to_send, (byte)14, new ExecutionStatus(), null);
        EXAInputStream is = new EXAInputStream(res, this.connection);
        try {
            this.readRows(is, myFetchsize);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new SQLException("Error while reading data.");
        }
    }

    private synchronized void fetch2(long first) throws SQLException {
        this.log("EXAResultSet.fetch2(" + first + ")");
        if (-3 == this.handle) {
            throw new SQLException("Result is already closed on server, can't fetch rows for this handle.");
        }
        long fetchSizeInBytes = this.fetchsize * 1024;
        byte[] to_send = new byte[]{(byte)this.handle, (byte)(this.handle >> 8), (byte)(this.handle >> 16), (byte)(this.handle >> 24), (byte)first, (byte)(first >> 8), (byte)(first >> 16), (byte)(first >> 24), (byte)(first >> 32), (byte)(first >> 40), (byte)(first >> 48), (byte)(first >> 56), (byte)fetchSizeInBytes, (byte)(fetchSizeInBytes >> 8), (byte)(fetchSizeInBytes >> 16), (byte)(fetchSizeInBytes >> 24), (byte)(fetchSizeInBytes >> 32), (byte)(fetchSizeInBytes >> 40), (byte)(fetchSizeInBytes >> 48), (byte)(fetchSizeInBytes >> 56)};
        byte[] res = this.connection.communication(to_send, (byte)36, new ExecutionStatus(), null);
        if (null == res) {
            throw new SQLException(Translator.Error_fetching_lines_from_server());
        }
        EXAInputStream is = new EXAInputStream(res, this.connection);
        this.firstIndex = first;
        try {
            byte resultType;
            if (this.connection.getActiveProtocolVersion() >= 9 && (resultType = is.readByte()) == -1) {
                throw new EXASQLException(is, this.debug).getSQLExceptionIntern(this.connection);
            }
            this.rows = (int)is.readLong();
            for (int i = 0; i < this.columns.length; ++i) {
                this.columns[i].resize(this.rows);
            }
            this.readRows(is, this.rows);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new SQLException(Translator.Error_fetching_lines_from_server());
        }
    }

    private void readRows(EXAInputStream is, int count) throws SQLException, IOException {
        for (int c = 0; c < this.columns.length; ++c) {
            for (int r = 0; r < count; ++r) {
                this.columns[c].value_from_jdbc(is, r);
            }
        }
    }

    protected void setHandle(int aHandle) {
        this.handle = aHandle;
    }

    public int GetHandle() {
        return this.handle;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        if (this.debug != null) {
            this.log("getCatalogName(" + column + "): " + this.catalogName);
        }
        return this.catalogName;
    }

    @Override
    public String getColumnClassName(int column_number) throws SQLException {
        try {
            String erg = this.columns[column_number - 1].getClassName();
            if (this.debug != null) {
                this.log("getColumnClassName(" + column_number + "): " + erg);
            }
            return erg;
        }
        catch (Throwable t) {
            throw this.ex(t);
        }
    }

    @Override
    public int getColumnCount() throws SQLException {
        try {
            if (null == this.columns) {
                return 0;
            }
            int erg = this.columns.length;
            if (this.debug != null) {
                this.log("getColumnCount(): " + erg);
            }
            return erg;
        }
        catch (Throwable t) {
            throw this.ex(t);
        }
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        try {
            int erg = this.columns[column - 1].getDisplaySize();
            if (this.debug != null) {
                this.log("getColumnDisplaySize(" + column + "): " + erg);
            }
            return erg;
        }
        catch (Throwable t) {
            throw this.ex(t);
        }
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        try {
            String erg = this.columns[column - 1].label;
            if (this.debug != null) {
                this.log("getColumnLabel(" + column + "): " + erg);
            }
            return erg;
        }
        catch (Throwable t) {
            throw this.ex(t);
        }
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        try {
            String erg = this.columns[column - 1].name;
            if (this.debug != null) {
                this.log("getColumnName(" + column + "): " + erg);
            }
            return erg;
        }
        catch (Throwable t) {
            throw this.ex(t);
        }
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        try {
            int erg = this.columns[column - 1].getType();
            return erg;
        }
        catch (Throwable t) {
            throw this.ex(t);
        }
    }

    public int getEXAType(int column) throws SQLException {
        try {
            int erg = this.columns[column - 1].getEXAType();
            if (this.debug != null) {
                this.log("getEXAType(" + column + "): " + erg);
            }
            return erg;
        }
        catch (Throwable t) {
            throw this.ex(t);
        }
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        try {
            String erg = this.columns[column - 1].getTypeName();
            if (this.debug != null) {
                this.log("getColumnTypeName(" + column + "): " + erg);
            }
            return erg;
        }
        catch (Throwable t) {
            throw this.ex(t);
        }
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        try {
            int erg = this.columns[column - 1].getPrecision();
            return erg;
        }
        catch (Throwable t) {
            throw this.ex(t);
        }
    }

    @Override
    public int getScale(int column) throws SQLException {
        try {
            int erg = this.columns[column - 1].getScale();
            if (this.debug != null) {
                this.log("getScale(" + column + "): " + erg);
            }
            return erg;
        }
        catch (Throwable t) {
            throw this.ex(t);
        }
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        if (this.debug != null) {
            this.log("getSchemaName(" + column + "): " + this.schemaName);
        }
        return this.schemaName;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        if (this.debug != null) {
            this.log("getTableName(" + column + "): " + this.tableName);
        }
        return this.tableName;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        if (this.debug != null) {
            this.log("isAutoIncrement(" + column + "): false");
        }
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        if (this.debug != null) {
            this.log("isCaseSensitive(" + column + "): true");
        }
        return true;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        if (this.debug != null) {
            this.log("isCurrency(" + column + "): false");
        }
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        if (this.debug != null) {
            this.log("isDefinitelyWritable(" + column + "): false");
        }
        return false;
    }

    @Override
    public int isNullable(int column) {
        if (this.debug != null) {
            this.log("isNullable(" + column + "): " + 2);
        }
        return 2;
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        if (this.debug != null) {
            this.log("isReadOnly(" + column + "): true");
        }
        return true;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        if (this.debug != null) {
            this.log("isSearchable(" + column + ": true");
        }
        return true;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        try {
            boolean erg = this.columns[column - 1].isSigned();
            if (this.debug != null) {
                this.log("isSigned(" + column + "): " + erg);
            }
            return erg;
        }
        catch (Throwable t) {
            throw this.ex(t);
        }
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        if (this.debug != null) {
            this.log("isWritable(" + column + "): false");
        }
        return false;
    }

    private void readOnly() throws SQLException {
        if (this.debug != null) {
            this.log("readOnly() -> error");
        }
        throw new SQLException("resultset is read only");
    }

    public int[] calcOptimalColumnWidths() throws SQLException {
        int[] displaysize = new int[this.columns.length];
        for (int col = 0; col < this.columns.length; ++col) {
            int cwidth;
            int l = this.columns[col].label.length();
            if (l > displaysize[col]) {
                displaysize[col] = l;
            }
            if (4 > displaysize[col]) {
                displaysize[col] = 4;
            }
            if ((cwidth = this.columns[col].getDisplaySize()) <= displaysize[col]) continue;
            displaysize[col] = cwidth;
        }
        return displaysize;
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        if (this.debug != null) {
            this.log("updateRef(" + columnIndex + "," + x + ")");
        }
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        if (this.debug != null) {
            this.log("updateRef(" + columnName + "," + x + ")");
        }
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    protected Column getColumn(int column) {
        if (this.columns == null) {
            return null;
        }
        return this.columns[column];
    }

    protected void resize(int newSize) {
        this.rows = newSize;
        this.totalRows = newSize;
        if (this.columns != null) {
            for (int i = 0; i < this.columns.length; ++i) {
                this.columns[i].resize(newSize);
            }
        }
    }

    @Override
    public EXAResultSet toResultSet() {
        return this;
    }

    private boolean seek(long pos) throws SQLException {
        if (pos < 0L || pos > this.totalRows - 1L) {
            return false;
        }
        if (pos >= this.firstIndex) {
            int r;
            if (pos >= this.firstIndex + (long)this.rows) {
                if (this.connection.getActiveProtocolVersion() >= 8) {
                    this.fetch2(pos);
                } else {
                    this.fetchNextRows(pos);
                }
            }
            this.myCursorPos = r = (int)(pos - this.firstIndex);
        } else if (this.connection.getActiveProtocolVersion() >= 8) {
            this.fetch2(pos);
        } else {
            this.fetchNextRows(pos);
        }
        return true;
    }

    public long getNumberOfRows() {
        return this.totalRows;
    }

    public boolean isAscii(int column) throws SQLException {
        if (this.columns[column - 1] instanceof CharColumn) {
            int maxOctetLen = ((CharColumn)this.columns[column - 1]).getOctetLength();
            int maxWidth = this.columns[column - 1].getDisplaySize();
            return maxWidth == maxOctetLen;
        }
        return false;
    }

    public int compareTo(EXAResultSet ref) {
        int ret = 0;
        try {
            int col;
            if (this.getType() != ref.getType()) {
                return 1;
            }
            if (this.getColumnCount() != ref.getColumnCount()) {
                return 1;
            }
            if (this.getNumberOfRows() != ref.getNumberOfRows()) {
                return 1;
            }
            this.beforeFirst();
            ref.beforeFirst();
            for (col = 1; col <= this.getColumnCount(); ++col) {
                if (this.getColumnType(col) != ref.getColumnType(col)) {
                    System.out.println("Difference at getColumnType(" + col + ") this: " + this.getColumnType(col) + ", ref:" + ref.getColumnType(col));
                    ++ret;
                }
                if (this.getColumnDisplaySize(col) != ref.getColumnDisplaySize(col)) {
                    System.out.println("Difference at getColumnDisplaySize(" + col + ") this: " + this.getColumnDisplaySize(col) + ", ref:" + ref.getColumnDisplaySize(col));
                    ++ret;
                }
                try {
                    if (this.getPrecision(col) != ref.getPrecision(col)) {
                        System.out.println("Difference at getPrecision(" + col + ") this: " + this.getPrecision(col) + ", ref:" + ref.getPrecision(col));
                        ++ret;
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    if (this.getScale(col) != ref.getScale(col)) {
                        System.out.println("Difference at getScale(" + col + ") this: " + this.getScale(col) + ", ref:" + ref.getScale(col));
                        ++ret;
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                if (!this.getColumnTypeName(col).equals(ref.getColumnTypeName(col))) {
                    System.out.println("Difference at getColumnTypeName(" + col + ") this: " + this.getColumnTypeName(col) + ", ref:" + ref.getColumnTypeName(col));
                    ++ret;
                }
                if (!this.getColumnClassName(col).equals(ref.getColumnClassName(col))) {
                    System.out.println("Difference at getColumnClassName(" + col + ") this: " + this.getColumnClassName(col) + ", ref:" + ref.getColumnClassName(col));
                    ++ret;
                }
                if (!this.getColumnName(col).equals(ref.getColumnName(col))) {
                    System.out.println("Difference at getColumnName(" + col + ") this: " + this.getColumnName(col) + ", ref:" + ref.getColumnName(col));
                    ++ret;
                }
                if (this.getColumnLabel(col).equals(ref.getColumnLabel(col))) continue;
                System.out.println("Difference at getColumnLabel(" + col + ") this: " + this.getColumnLabel(col) + ", ref:" + ref.getColumnLabel(col));
                ++ret;
            }
            if (ret != 0) {
                return ret;
            }
            while (this.next() && ref.next()) {
                if (this.myCursorPos != ref.myCursorPos) {
                    System.out.println("Difference: cursorpos does not match. this:" + this.myCursorPos + ", " + ref.myCursorPos);
                    return ret + 1;
                }
                for (col = 1; col <= this.getColumnCount(); ++col) {
                    if (null == this.getObject(col) || null == ref.getObject(col)) {
                        if (null == this.getObject(col) && null == ref.getObject(col)) continue;
                        if (null == this.getObject(col)) {
                            System.out.println("Difference at row:" + this.myCursorPos + ", col:" + col + "   null!=" + ref.getObject(col));
                        }
                        if (null == ref.getObject(col)) {
                            System.out.println("Difference at row:" + this.myCursorPos + ", col:" + col + "   " + this.getObject(col) + "!=null");
                        }
                        this.PrintRows(this, ref);
                        ++ret;
                        continue;
                    }
                    if (this.getObject(col).equals(ref.getObject(col))) continue;
                    System.out.println("Difference at row:" + this.myCursorPos + ", col:" + col + "   this:" + this.getObject(col) + ", ref:" + ref.getObject(col));
                    this.PrintRows(this, ref);
                    ++ret;
                }
            }
            this.beforeFirst();
            ref.beforeFirst();
        }
        catch (Exception ex) {
            return ret + 1;
        }
        return ret;
    }

    private void PrintRows(EXAResultSet exaResultSet, EXAResultSet ref) throws SQLException {
        int col;
        for (col = 1; col <= exaResultSet.getColumnCount(); ++col) {
            if (null == exaResultSet.getObject(col)) {
                System.out.print("null ");
                continue;
            }
            System.out.print(exaResultSet.getObject(col) + " ");
        }
        System.out.println();
        for (col = 1; col <= ref.getColumnCount(); ++col) {
            if (null == ref.getObject(col)) {
                System.out.print("null ");
                continue;
            }
            System.out.print(ref.getObject(col) + " ");
        }
        System.out.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int backupMyCursorPos = this.myCursorPos;
        try {
            String result = "";
            for (int col = 1; col <= this.getColumnCount(); ++col) {
                result = result + this.getColumnName(col) + " ";
            }
            if (this.rows > 0) {
                this.seek(this.firstIndex);
                int lineCount = 0;
                if (this.firstIndex != 0L) {
                    result = result + "\n..........";
                }
                do {
                    ++lineCount;
                    result = result + "\n";
                    for (int col = 1; col <= this.getColumnCount(); ++col) {
                        result = result + this.getObject(col) + " ";
                    }
                } while (this.next() && lineCount < this.rows && (this.maxRows == 0L || (long)lineCount < this.maxRows));
                if ((long)lineCount < this.totalRows && (this.maxRows == 0L || (long)lineCount < this.maxRows)) {
                    result = result + "\n..........";
                }
                if (backupMyCursorPos == -1) {
                    this.beforeFirst();
                } else {
                    this.seek(backupMyCursorPos);
                }
            }
            String string = result;
            return string;
        }
        catch (Exception ex) {
            String string = ex.getMessage();
            return string;
        }
        finally {
            this.myCursorPos = backupMyCursorPos;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }
}

