/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.DebugLog;
import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.EXAInputStream;
import com.exasol.jdbc.EncryptedInputStream;
import com.exasol.jdbc.Header;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class InMessage {
    final EXAConnection connection;
    private EXAInputStream in;
    private ByteArrayInputStream inData;
    private Header header;
    private DebugLog debug;

    public InMessage(DebugLog log, InputStream input, EXAConnection connection) throws SQLException, IOException {
        this.connection = connection;
        this.debug = log;
        this.header = new Header(connection, log, connection.getNextSerialNumber());
        ((EncryptedInputStream)input).SetMemoryStream(this.header.read_from(input, null, 0));
        connection.updateSessionAttributes(this.header.getAttributes());
        EXAInputStream reader = new EXAInputStream(input, connection, null);
        byte[] bytes = new byte[this.header.getSize()];
        reader.read(bytes);
        this.inData = new ByteArrayInputStream(bytes);
        this.in = new EXAInputStream(this.inData, connection, null);
    }

    public EXAInputStream getStream() {
        return this.in;
    }

    public Header getHeader() {
        return this.header;
    }
}

