/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.Column;
import com.exasol.jdbc.DateTimeColumn;
import com.exasol.jdbc.EXAInputStream;
import com.exasol.jdbc.EXAOutputStream;
import com.exasol.jdbc.Translator;
import com.exasol.jdbc.exaTimestamp;
import java.io.IOException;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class TimestampColumn
extends DateTimeColumn {
    private exaTimestamp[] values;

    TimestampColumn(String name_, exaTimestamp[] values_) {
        super(name_);
        this.values = values_;
    }

    TimestampColumn() {
        this.precision = 19;
        this.scale = 6;
        this.values = new exaTimestamp[initialBatchCapacity];
    }

    @Override
    void resize(int size) {
        exaTimestamp[] nv = new exaTimestamp[size];
        boolean[] vm = new boolean[size];
        int s = this.values.length;
        if (s > size) {
            s = size;
        }
        for (int i = 0; i < s; ++i) {
            nv[i] = this.values[i];
            vm[i] = this.validMask[i];
        }
        for (int j = s; j < size; ++j) {
            vm[j] = false;
        }
        this.values = nv;
        this.validMask = vm;
    }

    @Override
    int getPrecision() throws SQLException {
        return this.precision + (this.scale == 0 ? 0 : 1 + this.scale);
    }

    @Override
    void setScale(int s) throws SQLException {
        if (s < 0 || s > 9) {
            throw new SQLException("Invalid scale value " + s);
        }
        this.scale = s;
    }

    @Override
    String getClassName() throws SQLException {
        return "java.sql.TimeStamp";
    }

    @Override
    int getDisplaySize() throws SQLException {
        return this.getPrecision();
    }

    @Override
    int getType() throws SQLException {
        return 93;
    }

    @Override
    String getTypeName() throws SQLException {
        return "TIMESTAMP";
    }

    @Override
    Object getObject(int row) throws SQLException {
        return this.getTimestamp(row);
    }

    @Override
    Date getDate(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("TimestampColumn::getDate: " + Translator.Accessed_null_value());
        }
        return this.dateFromCalendar(this.values[row], this.defCal);
    }

    @Override
    Date getDate(int row, Calendar cal) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("TimestampColumn::getDate: " + Translator.Accessed_null_value());
        }
        return this.dateFromCalendar(this.values[row], cal);
    }

    @Override
    long getLong(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("TimestampColumn::getLong: " + Translator.Accessed_null_value());
        }
        return this.values[row].getTimestamp(this.defCal).getTime();
    }

    @Override
    Time getTime(int row, Calendar cal) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("TimestampColumn::getTime: " + Translator.Accessed_null_value());
        }
        return this.timeFromCalendar(this.values[row], cal);
    }

    @Override
    Time getTime(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("TimestampColumn::getTime: " + Translator.Accessed_null_value());
        }
        return this.timeFromCalendar(this.values[row], this.defCal);
    }

    @Override
    Timestamp getTimestamp(int row, Calendar cal) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("TimestampColumn::getTimestamp: " + Translator.Accessed_null_value());
        }
        return this.timestampFromCalendar(this.values[row], cal);
    }

    @Override
    Timestamp getTimestamp(int row) throws SQLException {
        return this.getTimestamp(row, this.defCal);
    }

    @Override
    void setDate(int row, Date x, Calendar cal) throws SQLException {
        this.values[row] = this.exaTimestampFromCalendar(x.getTime(), cal);
        this.validMask[row] = true;
    }

    @Override
    void setDate(int row, Date x) throws SQLException {
        this.setDate(row, x, this.defCal);
    }

    @Override
    void setLong(int row, long x) throws SQLException {
        this.values[row] = this.exaTimestampFromCalendar(x, this.defCal);
        this.validMask[row] = true;
    }

    @Override
    void setObject(int row, Object x) throws SQLException {
        if (x instanceof Date) {
            this.setDate(row, (Date)x);
        } else if (x instanceof Time) {
            this.setTime(row, (Time)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(row, (Timestamp)x);
        } else {
            super.setObject(row, x);
        }
    }

    @Override
    String getString(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException(Translator.Accessed_null_value());
        }
        Timestamp ts = this.values[row].getTimestamp(this.defCal);
        String tss = ts.toString();
        if (this.scale == 0) {
            tss = tss.substring(0, tss.length() - 2);
        } else {
            int i;
            int l = tss.length();
            if (l - (i = tss.indexOf(".")) - 1 != this.scale) {
                if (l - i - 1 < this.scale) {
                    for (int x = 0; x < this.scale - (l - i - 1); ++x) {
                        tss = tss + "0";
                    }
                } else {
                    tss = tss.substring(0, i + 1 + this.scale);
                }
            }
        }
        return tss;
    }

    @Override
    void setString(int row, String x) throws SQLException {
        this.values[row] = this.exaTimestampFromCalendar(Timestamp.valueOf(x).getTime(), this.defCal);
        this.validMask[row] = true;
    }

    @Override
    void setTime(int row, Time x, Calendar cal) throws SQLException {
        this.values[row] = this.exaTimestampFromCalendar(x.getTime(), cal);
        this.validMask[row] = true;
    }

    @Override
    void setTime(int row, Time x) throws SQLException {
        this.setTime(row, x, this.defCal);
    }

    @Override
    void setTimestamp(int row, Timestamp x, Calendar cal) throws SQLException {
        this.values[row] = this.exaTimestampFromCalendar(x.getTime(), cal);
        this.values[row].setNanos(x.getNanos());
        this.validMask[row] = true;
    }

    @Override
    void setTimestamp(int row, Timestamp x) throws SQLException {
        this.setTimestamp(row, x, this.defCal);
    }

    static Column from_jdbc_type(EXAInputStream is) {
        return new TimestampColumn();
    }

    @Override
    long value_to_jdbc(EXAOutputStream os, int row) throws SQLException, IOException {
        if (this.validMask[row]) {
            os.writeByte((byte)1);
            os.writeTimestamp(this.values[row]);
            return 9L;
        }
        os.writeByte((byte)0);
        return 1L;
    }

    @Override
    void value_from_jdbc(EXAInputStream is, int row) throws SQLException, IOException {
        if (is.nextIsNull()) {
            this.validMask[row] = false;
        } else {
            this.values[row] = is.readTimestamp();
            this.validMask[row] = true;
        }
    }

    @Override
    int getEXAType() {
        return 21;
    }
}

