/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc.importExport;

import java.io.IOException;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import thirdparty.org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import thirdparty.org.bouncycastle.asn1.x500.X500Name;
import thirdparty.org.bouncycastle.asn1.x500.X500NameBuilder;
import thirdparty.org.bouncycastle.asn1.x500.style.RFC4519Style;
import thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import thirdparty.org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import thirdparty.org.bouncycastle.asn1.x509.BasicConstraints;
import thirdparty.org.bouncycastle.asn1.x509.Extension;
import thirdparty.org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import thirdparty.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import thirdparty.org.bouncycastle.cert.CertIOException;
import thirdparty.org.bouncycastle.cert.X509ExtensionUtils;
import thirdparty.org.bouncycastle.cert.X509v3CertificateBuilder;
import thirdparty.org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import thirdparty.org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import thirdparty.org.bouncycastle.jce.provider.BouncyCastleProvider;
import thirdparty.org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import thirdparty.org.bouncycastle.operator.ContentSigner;
import thirdparty.org.bouncycastle.operator.DigestCalculator;
import thirdparty.org.bouncycastle.operator.OperatorCreationException;
import thirdparty.org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import thirdparty.org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class CertificateBuilder {
    static final String sigAlgName = "SHA256WithRSA";
    static final String commonName = "EXALoader";
    static final int keysize = 2048;
    static final String keyAlg = "RSA";
    static final String organizationalUnit = "R&D";
    static final String organization = "EXASOL";
    static final String city = "Nuremberg";
    static final String state = "Bavaria";
    static final String country = "Germany";
    private KeyPair keyPair = null;

    private KeyPair getKeypair() throws NoSuchAlgorithmException {
        if (this.keyPair == null) {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(keyAlg);
            keyPairGenerator.initialize(2048);
            return keyPairGenerator.generateKeyPair();
        }
        return this.keyPair;
    }

    public PublicKey getPublicKey() {
        return this.keyPair.getPublic();
    }

    public PrivateKey getPrivateKey() {
        return this.keyPair.getPrivate();
    }

    private ContentSigner getSigner(String hashAlgorithm, KeyPair keyPair) throws OperatorCreationException {
        return new JcaContentSignerBuilder(hashAlgorithm).build(keyPair.getPrivate());
    }

    private static X500NameBuilder getSubject(String organization, String organizationalUnit, String city, String state, String country) {
        X500NameBuilder builder = new X500NameBuilder(RFC4519Style.INSTANCE);
        builder.addRDN(RFC4519Style.o, organization);
        builder.addRDN(RFC4519Style.ou, organizationalUnit);
        builder.addRDN(RFC4519Style.l, city);
        builder.addRDN(RFC4519Style.st, state);
        builder.addRDN(RFC4519Style.c, country);
        return builder;
    }

    public X509Certificate generate(int days) throws NoSuchAlgorithmException, CertificateException, IOException {
        X509Certificate cert;
        ContentSigner contentSigner;
        X509v3CertificateBuilder certificateBuilder;
        try {
            this.keyPair = this.getKeypair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new NoSuchAlgorithmException("ERROR: KeyPair failed. Exception: " + e.getLocalizedMessage());
        }
        Instant now = Instant.now();
        Date notBefore = Date.from(now);
        Date notAfter = Date.from(now.plus(Duration.ofDays(days)));
        X500Name x500Name = new X500Name("CN=EXALoader");
        try {
            certificateBuilder = new JcaX509v3CertificateBuilder(x500Name, BigInteger.valueOf(now.toEpochMilli()), notBefore, notAfter, CertificateBuilder.getSubject(organization, organizationalUnit, city, state, country).build(), this.keyPair.getPublic()).addExtension(Extension.subjectKeyIdentifier, false, CertificateBuilder.createSubjectKeyId(this.keyPair.getPublic())).addExtension(Extension.authorityKeyIdentifier, false, CertificateBuilder.createAuthorityKeyId(this.keyPair.getPublic())).addExtension(Extension.basicConstraints, true, new BasicConstraints(true));
        }
        catch (CertIOException | OperatorCreationException e) {
            throw new CertificateException("ERROR: Certificate Builder Error. Exception: " + e.getLocalizedMessage());
        }
        try {
            contentSigner = this.getSigner(sigAlgName, this.keyPair);
        }
        catch (OperatorCreationException e) {
            throw new IOException("ERROR: ContentSigner Failed. Exception: " + e.getLocalizedMessage());
        }
        try {
            cert = new JcaX509CertificateConverter().setProvider(new BouncyCastleProvider()).getCertificate(certificateBuilder.build(contentSigner));
        }
        catch (CertificateException e) {
            throw new CertificateException("ERROR: Certificate Signing Failed. Exception: " + e.getLocalizedMessage());
        }
        return cert;
    }

    private static SubjectKeyIdentifier createSubjectKeyId(PublicKey publicKey) throws OperatorCreationException {
        SubjectPublicKeyInfo publicKeyInfo = SubjectPublicKeyInfo.getInstance(publicKey.getEncoded());
        DigestCalculator digCalc = new BcDigestCalculatorProvider().get(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1));
        return new X509ExtensionUtils(digCalc).createSubjectKeyIdentifier(publicKeyInfo);
    }

    private static AuthorityKeyIdentifier createAuthorityKeyId(PublicKey publicKey) throws OperatorCreationException {
        SubjectPublicKeyInfo publicKeyInfo = SubjectPublicKeyInfo.getInstance(publicKey.getEncoded());
        DigestCalculator digCalc = new BcDigestCalculatorProvider().get(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1));
        return new X509ExtensionUtils(digCalc).createAuthorityKeyIdentifier(publicKeyInfo);
    }

    public static String x509CertificateToPem(X509Certificate cert) throws IOException {
        StringWriter writer = new StringWriter();
        JcaPEMWriter pemWriter = new JcaPEMWriter(writer);
        pemWriter.writeObject(cert);
        pemWriter.flush();
        pemWriter.close();
        return writer.toString();
    }
}

