/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.org.bouncycastle.crypto.kems;

import java.security.SecureRandom;
import thirdparty.org.bouncycastle.crypto.CipherParameters;
import thirdparty.org.bouncycastle.crypto.CryptoServicePurpose;
import thirdparty.org.bouncycastle.crypto.CryptoServicesRegistrar;
import thirdparty.org.bouncycastle.crypto.DerivationFunction;
import thirdparty.org.bouncycastle.crypto.KeyEncapsulation;
import thirdparty.org.bouncycastle.crypto.SecretWithEncapsulation;
import thirdparty.org.bouncycastle.crypto.constraints.ConstraintUtils;
import thirdparty.org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import thirdparty.org.bouncycastle.crypto.kems.RSAKEMExtractor;
import thirdparty.org.bouncycastle.crypto.kems.RSAKEMGenerator;
import thirdparty.org.bouncycastle.crypto.params.KeyParameter;
import thirdparty.org.bouncycastle.crypto.params.RSAKeyParameters;
import thirdparty.org.bouncycastle.util.Arrays;

public class RSAKeyEncapsulation
implements KeyEncapsulation {
    private DerivationFunction kdf;
    private SecureRandom rnd;
    private RSAKeyParameters key;

    public RSAKeyEncapsulation(DerivationFunction derivationFunction, SecureRandom secureRandom) {
        this.kdf = derivationFunction;
        this.rnd = secureRandom;
    }

    @Override
    public void init(CipherParameters cipherParameters) throws IllegalArgumentException {
        if (!(cipherParameters instanceof RSAKeyParameters)) {
            throw new IllegalArgumentException("RSA key required");
        }
        this.key = (RSAKeyParameters)cipherParameters;
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("RSAKem", ConstraintUtils.bitsOfSecurityFor(this.key.getModulus()), cipherParameters, this.key.isPrivate() ? CryptoServicePurpose.DECRYPTION : CryptoServicePurpose.ENCRYPTION));
    }

    @Override
    public CipherParameters encrypt(byte[] byArray, int n, int n2) throws IllegalArgumentException {
        if (this.key.isPrivate()) {
            throw new IllegalArgumentException("Public key required for encryption");
        }
        RSAKEMGenerator rSAKEMGenerator = new RSAKEMGenerator(n2, this.kdf, this.rnd);
        SecretWithEncapsulation secretWithEncapsulation = rSAKEMGenerator.generateEncapsulated(this.key);
        byte[] byArray2 = secretWithEncapsulation.getEncapsulation();
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        return new KeyParameter(secretWithEncapsulation.getSecret());
    }

    public CipherParameters encrypt(byte[] byArray, int n) {
        return this.encrypt(byArray, 0, n);
    }

    @Override
    public CipherParameters decrypt(byte[] byArray, int n, int n2, int n3) throws IllegalArgumentException {
        if (!this.key.isPrivate()) {
            throw new IllegalArgumentException("Private key required for decryption");
        }
        RSAKEMExtractor rSAKEMExtractor = new RSAKEMExtractor(this.key, n3, this.kdf);
        byte[] byArray2 = rSAKEMExtractor.extractSecret(Arrays.copyOfRange(byArray, n, n + n2));
        return new KeyParameter(byArray2);
    }

    public CipherParameters decrypt(byte[] byArray, int n) {
        return this.decrypt(byArray, 0, byArray.length, n);
    }
}

