/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.org.bouncycastle.dvcs;

import java.io.IOException;
import thirdparty.org.bouncycastle.cms.CMSException;
import thirdparty.org.bouncycastle.cms.CMSProcessableByteArray;
import thirdparty.org.bouncycastle.cms.CMSSignedData;
import thirdparty.org.bouncycastle.cms.CMSSignedDataGenerator;
import thirdparty.org.bouncycastle.dvcs.DVCSException;
import thirdparty.org.bouncycastle.dvcs.DVCSMessage;

public class SignedDVCSMessageGenerator {
    private final CMSSignedDataGenerator signedDataGen;

    public SignedDVCSMessageGenerator(CMSSignedDataGenerator cMSSignedDataGenerator) {
        this.signedDataGen = cMSSignedDataGenerator;
    }

    public CMSSignedData build(DVCSMessage dVCSMessage) throws DVCSException {
        try {
            byte[] byArray = dVCSMessage.getContent().toASN1Primitive().getEncoded("DER");
            return this.signedDataGen.generate(new CMSProcessableByteArray(dVCSMessage.getContentType(), byArray), true);
        }
        catch (CMSException cMSException) {
            throw new DVCSException("Could not sign DVCS request", cMSException);
        }
        catch (IOException iOException) {
            throw new DVCSException("Could not encode DVCS request", iOException);
        }
    }
}

