/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.org.bouncycastle.jcajce.provider.asymmetric.rsa;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import thirdparty.org.bouncycastle.asn1.DERNull;
import thirdparty.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import thirdparty.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import thirdparty.org.bouncycastle.crypto.CryptoServicesRegistrar;
import thirdparty.org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import thirdparty.org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import thirdparty.org.bouncycastle.crypto.params.RSAKeyParameters;
import thirdparty.org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import thirdparty.org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPrivateCrtKey;
import thirdparty.org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPublicKey;
import thirdparty.org.bouncycastle.jcajce.provider.asymmetric.util.PrimeCertaintyCalculator;

public class KeyPairGeneratorSpi
extends KeyPairGenerator {
    private static final AlgorithmIdentifier PKCS_ALGID = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, DERNull.INSTANCE);
    private static final AlgorithmIdentifier PSS_ALGID = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_RSASSA_PSS);
    static final BigInteger defaultPublicExponent = BigInteger.valueOf(65537L);
    RSAKeyGenerationParameters param;
    RSAKeyPairGenerator engine;
    AlgorithmIdentifier algId;

    public KeyPairGeneratorSpi(String string, AlgorithmIdentifier algorithmIdentifier) {
        super(string);
        this.algId = algorithmIdentifier;
        this.engine = new RSAKeyPairGenerator();
        this.param = new RSAKeyGenerationParameters(defaultPublicExponent, CryptoServicesRegistrar.getSecureRandom(), 2048, PrimeCertaintyCalculator.getDefaultCertainty(2048));
        this.engine.init(this.param);
    }

    public KeyPairGeneratorSpi() {
        this("RSA", PKCS_ALGID);
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) {
        this.param = new RSAKeyGenerationParameters(defaultPublicExponent, secureRandom, n, PrimeCertaintyCalculator.getDefaultCertainty(n));
        this.engine.init(this.param);
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof RSAKeyGenParameterSpec)) {
            throw new InvalidAlgorithmParameterException("parameter object not a RSAKeyGenParameterSpec");
        }
        RSAKeyGenParameterSpec rSAKeyGenParameterSpec = (RSAKeyGenParameterSpec)algorithmParameterSpec;
        this.param = new RSAKeyGenerationParameters(rSAKeyGenParameterSpec.getPublicExponent(), secureRandom, rSAKeyGenParameterSpec.getKeysize(), PrimeCertaintyCalculator.getDefaultCertainty(2048));
        this.engine.init(this.param);
    }

    @Override
    public KeyPair generateKeyPair() {
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.engine.generateKeyPair();
        RSAKeyParameters rSAKeyParameters = (RSAKeyParameters)asymmetricCipherKeyPair.getPublic();
        RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters = (RSAPrivateCrtKeyParameters)asymmetricCipherKeyPair.getPrivate();
        return new KeyPair(new BCRSAPublicKey(this.algId, rSAKeyParameters), new BCRSAPrivateCrtKey(this.algId, rSAPrivateCrtKeyParameters));
    }

    public static class PSS
    extends KeyPairGeneratorSpi {
        public PSS() {
            super("RSASSA-PSS", PSS_ALGID);
        }
    }
}

