/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.org.bouncycastle.jcajce.provider.symmetric;

import thirdparty.org.bouncycastle.crypto.BlockCipher;
import thirdparty.org.bouncycastle.crypto.CipherKeyGenerator;
import thirdparty.org.bouncycastle.crypto.engines.TwofishEngine;
import thirdparty.org.bouncycastle.crypto.generators.Poly1305KeyGenerator;
import thirdparty.org.bouncycastle.crypto.macs.GMac;
import thirdparty.org.bouncycastle.crypto.modes.CBCBlockCipher;
import thirdparty.org.bouncycastle.crypto.modes.GCMBlockCipher;
import thirdparty.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import thirdparty.org.bouncycastle.jcajce.provider.symmetric.SymmetricAlgorithmProvider;
import thirdparty.org.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher;
import thirdparty.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import thirdparty.org.bouncycastle.jcajce.provider.symmetric.util.BaseMac;
import thirdparty.org.bouncycastle.jcajce.provider.symmetric.util.BlockCipherProvider;
import thirdparty.org.bouncycastle.jcajce.provider.symmetric.util.IvAlgorithmParameters;
import thirdparty.org.bouncycastle.jcajce.provider.symmetric.util.PBESecretKeyFactory;

public final class Twofish {
    private Twofish() {
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        @Override
        protected String engineToString() {
            return "Twofish IV";
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new BlockCipherProvider(){

                @Override
                public BlockCipher get() {
                    return new TwofishEngine();
                }
            });
        }
    }

    public static class GMAC
    extends BaseMac {
        public GMAC() {
            super(new GMac(new GCMBlockCipher(new TwofishEngine())));
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("Twofish", 256, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends SymmetricAlgorithmProvider {
        private static final String PREFIX = Twofish.class.getName();

        @Override
        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("Cipher.Twofish", PREFIX + "$ECB");
            configurableProvider.addAlgorithm("KeyGenerator.Twofish", PREFIX + "$KeyGen");
            configurableProvider.addAlgorithm("AlgorithmParameters.Twofish", PREFIX + "$AlgParams");
            configurableProvider.addAlgorithm("Alg.Alias.AlgorithmParameters.PBEWITHSHAANDTWOFISH", "PKCS12PBE");
            configurableProvider.addAlgorithm("Alg.Alias.AlgorithmParameters.PBEWITHSHAANDTWOFISH-CBC", "PKCS12PBE");
            configurableProvider.addAlgorithm("Cipher.PBEWITHSHAANDTWOFISH-CBC", PREFIX + "$PBEWithSHA");
            configurableProvider.addAlgorithm("SecretKeyFactory.PBEWITHSHAANDTWOFISH-CBC", PREFIX + "$PBEWithSHAKeyFactory");
            this.addGMacAlgorithm(configurableProvider, "Twofish", PREFIX + "$GMAC", PREFIX + "$KeyGen");
            this.addPoly1305Algorithm(configurableProvider, "Twofish", PREFIX + "$Poly1305", PREFIX + "$Poly1305KeyGen");
        }
    }

    public static class PBEWithSHA
    extends BaseBlockCipher {
        public PBEWithSHA() {
            super(new CBCBlockCipher(new TwofishEngine()), 2, 1, 256, 16);
        }
    }

    public static class PBEWithSHAKeyFactory
    extends PBESecretKeyFactory {
        public PBEWithSHAKeyFactory() {
            super("PBEwithSHAandTwofish-CBC", null, true, 2, 1, 256, 128);
        }
    }

    public static class Poly1305
    extends BaseMac {
        public Poly1305() {
            super(new thirdparty.org.bouncycastle.crypto.macs.Poly1305(new TwofishEngine()));
        }
    }

    public static class Poly1305KeyGen
    extends BaseKeyGenerator {
        public Poly1305KeyGen() {
            super("Poly1305-Twofish", 256, new Poly1305KeyGenerator());
        }
    }
}

