/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.org.bouncycastle.operator.bc;

import java.io.IOException;
import thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import thirdparty.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import thirdparty.org.bouncycastle.crypto.ExtendedDigest;
import thirdparty.org.bouncycastle.crypto.Signer;
import thirdparty.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import thirdparty.org.bouncycastle.crypto.signers.RSADigestSigner;
import thirdparty.org.bouncycastle.crypto.util.PublicKeyFactory;
import thirdparty.org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import thirdparty.org.bouncycastle.operator.OperatorCreationException;
import thirdparty.org.bouncycastle.operator.bc.BcContentVerifierProviderBuilder;

public class BcRSAContentVerifierProviderBuilder
extends BcContentVerifierProviderBuilder {
    private DigestAlgorithmIdentifierFinder digestAlgorithmFinder;

    public BcRSAContentVerifierProviderBuilder(DigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder) {
        this.digestAlgorithmFinder = digestAlgorithmIdentifierFinder;
    }

    @Override
    protected Signer createSigner(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
        AlgorithmIdentifier algorithmIdentifier2 = this.digestAlgorithmFinder.find(algorithmIdentifier);
        ExtendedDigest extendedDigest = this.digestProvider.get(algorithmIdentifier2);
        return new RSADigestSigner(extendedDigest);
    }

    @Override
    protected AsymmetricKeyParameter extractKeyParameters(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        return PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }
}

