/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import java.nio.charset.StandardCharsets;

public class ChaCha20 {
    private int[] input = new int[16];

    protected static int U8TO32_LE(byte[] bs, int i) {
        return bs[i] & 0xFF | (bs[i + 1] & 0xFF) << 8 | (bs[i + 2] & 0xFF) << 16 | (bs[i + 3] & 0xFF) << 24;
    }

    private static void U32TO8_LE(int[] x, int i, int u) {
        x[i] = u;
        x[i + 1] = u >>>= 8;
        x[i + 2] = u >>>= 8;
        x[i + 3] = u >>>= 8;
    }

    private static int ROTATE(int v, int c) {
        return v << c | v >>> 32 - c;
    }

    public ChaCha20(byte[] key) {
        String ssigma = "expand 32-byte k";
        byte[] sigma = null;
        sigma = ssigma.getBytes(StandardCharsets.UTF_8);
        this.input[0] = ChaCha20.U8TO32_LE(sigma, 0);
        this.input[1] = ChaCha20.U8TO32_LE(sigma, 4);
        this.input[2] = ChaCha20.U8TO32_LE(sigma, 8);
        this.input[3] = ChaCha20.U8TO32_LE(sigma, 12);
        this.input[4] = ChaCha20.U8TO32_LE(key, 0);
        this.input[5] = ChaCha20.U8TO32_LE(key, 4);
        this.input[6] = ChaCha20.U8TO32_LE(key, 8);
        this.input[7] = ChaCha20.U8TO32_LE(key, 12);
        this.input[8] = ChaCha20.U8TO32_LE(key, 16);
        this.input[9] = ChaCha20.U8TO32_LE(key, 20);
        this.input[10] = ChaCha20.U8TO32_LE(key, 24);
        this.input[11] = ChaCha20.U8TO32_LE(key, 28);
        this.input[12] = 0;
        this.input[13] = 0;
        this.input[14] = 0;
        this.input[15] = 0;
    }

    private void quarterRound(int[] x, int a, int b, int c, int d) {
        int n = a;
        x[n] = x[n] + x[b];
        x[d] = ChaCha20.ROTATE(x[d] ^ x[a], 16);
        int n2 = c;
        x[n2] = x[n2] + x[d];
        x[b] = ChaCha20.ROTATE(x[b] ^ x[c], 12);
        int n3 = a;
        x[n3] = x[n3] + x[b];
        x[d] = ChaCha20.ROTATE(x[d] ^ x[a], 8);
        int n4 = c;
        x[n4] = x[n4] + x[d];
        x[b] = ChaCha20.ROTATE(x[b] ^ x[c], 7);
    }

    public void encrypt(byte[] dst, byte[] src, int len) {
        int[] x = new int[16];
        int[] output = new int[64];
        int dpos = 0;
        int spos = 0;
        while (len > 0) {
            int i = 16;
            while (i-- > 0) {
                x[i] = this.input[i];
            }
            for (i = 20; i > 0; i -= 2) {
                this.quarterRound(x, 0, 4, 8, 12);
                this.quarterRound(x, 1, 5, 9, 13);
                this.quarterRound(x, 2, 6, 10, 14);
                this.quarterRound(x, 3, 7, 11, 15);
                this.quarterRound(x, 0, 5, 10, 15);
                this.quarterRound(x, 1, 6, 11, 12);
                this.quarterRound(x, 2, 7, 8, 13);
                this.quarterRound(x, 3, 4, 9, 14);
            }
            i = 16;
            while (i-- > 0) {
                int n = i;
                x[n] = x[n] + this.input[i];
            }
            i = 16;
            while (i-- > 0) {
                ChaCha20.U32TO8_LE(output, 4 * i, x[i]);
            }
            this.input[12] = this.input[12] + 1;
            if (this.input[12] == 0) {
                this.input[13] = this.input[13] + 1;
                if (this.input[13] == 0) {
                    this.input[14] = this.input[14] + 1;
                    if (this.input[14] == 0) {
                        this.input[15] = this.input[15] + 1;
                        if (this.input[15] == 0) {
                            System.out.println("More than 2^128 parts have been encrypted.");
                            System.exit(1);
                        }
                    }
                }
            }
            if (len <= 64) {
                i = len;
                while (i-- > 0) {
                    dst[i + dpos] = (byte)(src[i + spos] ^ output[i]);
                }
                return;
            }
            i = 64;
            while (i-- > 0) {
                dst[i + dpos] = (byte)(src[i + spos] ^ output[i]);
            }
            len -= 64;
            spos += 64;
            dpos += 64;
        }
    }
}

