/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.ChaCha20;
import com.exasol.jdbc.StreamEncoder;

public class ChaCha20_encoder
extends StreamEncoder {
    ChaCha20 encoder = null;
    ChaCha20 decoder = null;
    public static int ENCRYPTION_KEY_LEN = 32;

    @Override
    public int SetKeys(byte[] eKey, byte[] dKey) {
        if (eKey.length != ENCRYPTION_KEY_LEN) {
            throw new RuntimeException("Wrong key len");
        }
        if (dKey.length != ENCRYPTION_KEY_LEN) {
            throw new RuntimeException("Wrong key len");
        }
        this.encoder = new ChaCha20(eKey);
        this.decoder = new ChaCha20(dKey);
        return 0;
    }

    @Override
    public int EncryptBytes(byte[] bytes, int offset, int len) {
        byte[] output = new byte[len];
        this.encoder.encrypt(output, bytes, len);
        System.arraycopy(output, 0, bytes, 0, len);
        return 0;
    }

    @Override
    public int DecryptBytes(byte[] bytes, int offset, int len) {
        byte[] output = new byte[len];
        this.decoder.encrypt(output, bytes, len);
        System.arraycopy(output, 0, bytes, 0, len);
        return 0;
    }

    public static void printHexString(byte[] b) {
        for (int i = 0; i < b.length; ++i) {
            String hex = Integer.toHexString(b[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            System.out.print(hex.toLowerCase());
        }
        System.out.println();
    }
}

