/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.Column;
import com.exasol.jdbc.DateTimeColumn;
import com.exasol.jdbc.EXAInputStream;
import com.exasol.jdbc.EXAOutputStream;
import com.exasol.jdbc.SimpleDate;
import com.exasol.jdbc.Translator;
import com.exasol.jdbc.exaTimestamp;
import java.io.IOException;
import java.sql.Date;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

class DateColumn
extends DateTimeColumn {
    protected int[] values = new int[initialBatchCapacity];
    private SimpleDate defDate = new SimpleDate();
    private int dateFormatWidth = 10;

    DateColumn() {
    }

    @Override
    String getClassName() {
        return "java.sql.Date";
    }

    @Override
    int getDisplaySize() {
        return this.dateFormatWidth;
    }

    @Override
    int getType() {
        return 91;
    }

    @Override
    String getTypeName() {
        return "DATE";
    }

    @Override
    Object getObject(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException(Translator.Accessed_null_value());
        }
        return Date.valueOf(this.getString(row));
    }

    @Override
    int getInt(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException(Translator.Accessed_null_value());
        }
        return this.values[row];
    }

    @Override
    String getString(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException(Translator.Accessed_null_value());
        }
        this.defDate.fromInt(this.values[row]);
        String ys = String.valueOf(this.defDate.year);
        String ms = String.valueOf(this.defDate.month);
        String ds = String.valueOf(this.defDate.day);
        while (ys.length() < 4) {
            ys = "0" + ys;
        }
        if (ms.length() < 2) {
            ms = "0" + ms;
        }
        if (ds.length() < 2) {
            ds = "0" + ds;
        }
        return ys + "-" + ms + "-" + ds;
    }

    @Override
    void setString(int row, String x) throws SQLException {
        this.validMask[row] = true;
        byte[] s = x.getBytes();
        if (s.length != 10 || s[0] < 48 || s[0] > 57 || s[1] < 48 || s[1] > 57 || s[2] < 48 || s[2] > 57 || s[3] < 48 || s[3] > 57 || s[4] != 45 || s[5] < 48 || s[5] > 57 || s[6] < 48 || s[6] > 57 || s[7] != 45 || s[8] < 48 || s[8] > 57 || s[9] < 48 || s[9] > 57) {
            throw new SQLDataException(" '" + x + "' " + Translator.invalid_datetime_format(), "007");
        }
        this.defDate.year = 1000 * (s[0] - 48) + 100 * (s[1] - 48) + 10 * (s[2] - 48) + (s[3] - 48);
        this.defDate.month = 10 * (s[5] - 48) + (s[6] - 48);
        this.defDate.day = 10 * (s[8] - 48) + (s[9] - 48);
        this.values[row] = this.defDate.toInt();
    }

    @Override
    void resize(int size) {
        int[] nv = new int[size];
        boolean[] vm = new boolean[size];
        int s = this.values.length;
        if (s > size) {
            s = size;
        }
        for (int i = 0; i < s; ++i) {
            nv[i] = this.values[i];
            vm[i] = this.validMask[i];
        }
        for (int j = s; j < size; ++j) {
            vm[j] = false;
        }
        this.values = nv;
        this.validMask = vm;
    }

    static Column from_jdbc_type(EXAInputStream is) {
        return new DateColumn();
    }

    @Override
    long value_to_jdbc(EXAOutputStream os, int row) throws IOException {
        if (this.validMask[row]) {
            os.writeByte((byte)1);
            os.writeInt(this.values[row]);
            return 5L;
        }
        os.writeByte((byte)0);
        return 1L;
    }

    @Override
    void value_from_jdbc(EXAInputStream is, int row) throws IOException {
        if (is.nextIsNull()) {
            this.validMask[row] = false;
        } else {
            this.values[row] = is.readInt();
            this.validMask[row] = true;
        }
    }

    @Override
    void setDate(int row, Date x, Calendar cal) throws SQLException {
        this.simpleDateFromCalendar(this.defDate, x.getTime(), cal);
        this.validMask[row] = true;
        this.values[row] = this.defDate.toInt();
    }

    @Override
    void setDate(int row, Date x) throws SQLException {
        this.setDate(row, x, this.defCal);
    }

    @Override
    void setTimestamp(int row, Timestamp x, Calendar cal) throws SQLException {
        this.simpleDateFromCalendar(this.defDate, x.getTime(), cal);
        this.validMask[row] = true;
        this.values[row] = this.defDate.toInt();
    }

    @Override
    void setTimestamp(int row, Timestamp x) throws SQLException {
        this.setTimestamp(row, x, this.defCal);
    }

    @Override
    Date getDate(int row, Calendar cal) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException(Translator.Accessed_null_value());
        }
        this.defDate.fromInt(this.values[row]);
        this.defDate.toCalendar(this.utcCal);
        return this.dateFromCalendar(new exaTimestamp((short)this.defDate.year, (byte)(this.defDate.month - 1), (byte)this.defDate.day, 0, 0, 0, 0), cal);
    }

    @Override
    Date getDate(int row) throws SQLException {
        return this.getDate(row, this.defCal);
    }

    @Override
    long getLong(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException(Translator.Accessed_null_value());
        }
        this.defDate.fromInt(this.values[row]);
        this.defDate.toCalendar(this.defCal);
        return this.defCal.getTimeInMillis();
    }

    @Override
    Object getObject(int row, Map map) throws SQLException {
        return this.getDate(row);
    }

    @Override
    Time getTime(int row, Calendar cal) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException(Translator.Accessed_null_value());
        }
        this.defDate.fromInt(this.values[row]);
        this.defDate.toCalendar(this.utcCal);
        return this.timeFromCalendar(new exaTimestamp((short)this.defDate.year, (byte)(this.defDate.month - 1), (byte)this.defDate.day, 0, 0, 0, 0), cal);
    }

    @Override
    Time getTime(int row) throws SQLException {
        return this.getTime(row, this.defCal);
    }

    @Override
    Timestamp getTimestamp(int row, Calendar cal) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException(Translator.Accessed_null_value());
        }
        this.defDate.fromInt(this.values[row]);
        this.defDate.toCalendar(this.utcCal);
        return this.timestampFromCalendar(new exaTimestamp((short)this.defDate.year, (byte)(this.defDate.month - 1), (byte)this.defDate.day, 0, 0, 0, 0), cal);
    }

    @Override
    Timestamp getTimestamp(int row) throws SQLException {
        return this.getTimestamp(row, this.defCal);
    }

    @Override
    void setLong(int row, long x) throws SQLException {
        this.validMask[row] = true;
        this.defCal.setTimeInMillis(x);
        this.defDate.fromCalendar(this.defCal);
        this.values[row] = this.defDate.toInt();
    }

    @Override
    void setObject(int row, Object x) throws SQLException {
        if (x instanceof Date) {
            this.setDate(row, (Date)x);
        } else if (x instanceof Time) {
            this.setTime(row, (Time)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(row, (Timestamp)x);
        } else {
            super.setObject(row, x);
        }
    }

    @Override
    void setTime(int row, Time x, Calendar cal) throws SQLException {
        this.simpleDateFromCalendar(this.defDate, x.getTime(), cal);
        this.validMask[row] = true;
        this.values[row] = this.defDate.toInt();
    }

    @Override
    void setTime(int row, Time x) throws SQLException {
        this.setTime(row, x, this.defCal);
    }

    @Override
    int getEXAType() {
        return 14;
    }
}

