/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import java.awt.Frame;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Properties;

public class DebugFrame
extends Frame
implements WindowListener {
    TextArea output;

    public DebugFrame() {
        super("SQL debug info");
        this.setLocation(new Point(0, 20));
        this.setSize(600, 800);
        this.output = new TextArea();
        this.add(this.output);
        this.addWindowListener(this);
        this.setVisible(true);
    }

    public void log(String msg, int level) {
        this.output.append(msg + "\n");
    }

    public void log(String msg) {
        this.output.append(msg + "\n");
    }

    public void log(Properties info) {
        Enumeration<Object> keys = info.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = info.get(key);
            this.output.append(key.toString() + ":" + value.toString() + "\n");
        }
    }

    public void log(Throwable t) {
        try {
            CharArrayWriter w = new CharArrayWriter();
            t.printStackTrace(new PrintWriter(w));
            this.log(w.toString(), 0);
        }
        catch (Throwable q) {
            this.log("internal log error:" + q.toString(), 0);
        }
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.dispose();
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }
}

