/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.EXAURLParser;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Properties;
import java.util.Random;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public abstract class EXASocketFactory
extends SocketFactory {
    private final String disableTLSChecksKeyword = "NOCERTCHECK";
    private String serverFingerprint = null;

    public abstract Socket createCustomSocket(InetAddress var1, int var2, int var3) throws IOException;

    public Socket createSSLSocket(Socket sock, Properties connParam, KeyStore keyStore, String host, int port, String type, String fingerprint, boolean validate) throws IOException {
        try {
            if (fingerprint != null && "NOCERTCHECK".toUpperCase().equals(fingerprint.toUpperCase())) {
                fingerprint = null;
                validate = false;
            }
            SSLContext sslContext = SSLContext.getInstance(type);
            TrustManager[] byPassTrustManagers = this.TrustManagerCallback(keyStore, fingerprint, validate);
            sslContext.init(null, byPassTrustManagers, null);
            SSLSocket sslSocket = (SSLSocket)sslContext.getSocketFactory().createSocket(sock, host, port, true);
            SSLParameters params = new SSLParameters();
            if (validate && fingerprint == null) {
                params.setEndpointIdentificationAlgorithm("HTTPS");
            }
            sslSocket.setSSLParameters(params);
            return sslSocket;
        }
        catch (KeyManagementException | NoSuchAlgorithmException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public Socket createSSLSocket(Properties connParam, KeyStore keyStore, InetAddress host, int port, String type, String protocol, String fingerprint, boolean validate, int timeout) throws IOException {
        try {
            if (fingerprint != null && "NOCERTCHECK".toUpperCase().equals(fingerprint.toUpperCase())) {
                fingerprint = null;
                validate = false;
            }
            SSLContext sslContext = SSLContext.getInstance(type);
            TrustManager[] byPassTrustManagers = this.TrustManagerCallback(keyStore, fingerprint, validate);
            sslContext.init(null, byPassTrustManagers, null);
            SSLSocket sslSocket = (SSLSocket)sslContext.getSocketFactory().createSocket();
            SSLParameters params = new SSLParameters();
            params.setProtocols(new String[]{protocol});
            if (validate && fingerprint == null) {
                params.setEndpointIdentificationAlgorithm("HTTPS");
            }
            sslSocket.setSSLParameters(params);
            sslSocket.connect(new InetSocketAddress(host, port), timeout);
            if (validate && fingerprint == null) {
                this.TestConnection(sslSocket, connParam, host.getHostName());
            }
            return sslSocket;
        }
        catch (KeyManagementException | NoSuchAlgorithmException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public Socket createSocket(InetAddress host, int port, int timeout) throws IOException {
        if (timeout < 0) {
            throw new IllegalArgumentException("createSocket: connect timeout cannot be negative: " + timeout);
        }
        Socket icsocket = new Socket();
        icsocket.connect(new InetSocketAddress(host, port), timeout);
        return icsocket;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.createSocket(InetAddress.getByName(host), port, 0);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.createSocket(host, port, 0);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        throw new UnsupportedOperationException();
    }

    private String CertificateToHash(X509Certificate cert) throws IOException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] hash = md.digest(cert.getEncoded());
            StringBuilder hexaString = new StringBuilder();
            for (int i = 0; i < hash.length; ++i) {
                String hex = Integer.toHexString(0xFF & hash[i]);
                if (hex.length() == 1) {
                    hexaString.append('0');
                }
                hexaString.append(hex);
            }
            return hexaString.toString().toUpperCase();
        }
        catch (NoSuchAlgorithmException | CertificateEncodingException e) {
            throw new IOException("[ERROR] Fingerprint could not be obtained from the certificate.");
        }
    }

    private void TestConnection(SSLSocket sslSocket, Properties connParam, String hostname) throws IOException {
        try {
            sslSocket.startHandshake();
        }
        catch (Exception ex) {
            if (this.serverFingerprint != null) {
                String period = ".";
                if (ex.getLocalizedMessage().endsWith(".")) {
                    period = "";
                }
                String connStr = null;
                if (connParam != null) {
                    String urlBegin = "jdbc:exa:";
                    connStr = connParam.getProperty("url");
                    HashMap<String, String> params = EXAURLParser.extractURL(connStr);
                    if (params == null) {
                        connStr = null;
                    } else {
                        String defaultPort = params.get("DefaultPort");
                        connStr = params.get("URL") + (defaultPort.length() > 0 ? ":" + defaultPort : "");
                        if (connStr.startsWith("//")) {
                            connStr = connStr + ";fingerprint=" + this.serverFingerprint;
                        } else {
                            String host = connStr.split(":|,|/|$")[0];
                            connStr = connStr.replaceFirst(host + "/*", host + "/" + this.serverFingerprint);
                        }
                    }
                }
                if (connStr != null) {
                    throw new IOException("TLS connection to host (" + hostname + ") failed: " + ex.getLocalizedMessage() + period + " If you trust the server, you can include the fingerprint in the connection string: " + connStr + ". ");
                }
                throw new IOException("TLS connection to host (" + hostname + ") failed: " + ex.getLocalizedMessage() + period);
            }
            throw new IOException("TLS connection to host (" + hostname + ") failed: " + ex.getLocalizedMessage());
        }
    }

    private TrustManager[] TrustManagerCallback(final KeyStore keyStore, final String fingerprint, boolean validate) {
        TrustManager[] byPassTrustManagers = null;
        byPassTrustManagers = fingerprint == null && !validate ? new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }
        }} : (fingerprint != null ? new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                if (chain.length > 0) {
                    try {
                        EXASocketFactory.this.serverFingerprint = EXASocketFactory.this.CertificateToHash(chain[0]);
                    }
                    catch (IOException e) {
                        throw new CertificateException(e.getMessage());
                    }
                    if (fingerprint.compareToIgnoreCase(EXASocketFactory.this.serverFingerprint) != 0) {
                        throw new CertificateException("[ERROR] Fingerprint did not match. The fingerprint provided: " + fingerprint.toUpperCase() + ". Server's certificate fingerprint: " + EXASocketFactory.this.serverFingerprint.toUpperCase() + ". ");
                    }
                } else {
                    throw new CertificateException("[ERROR] Certificate was not received from the server.");
                }
            }
        }} : new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                if (chain.length > 0) {
                    try {
                        X509TrustManager certificateValidator;
                        EXASocketFactory.this.serverFingerprint = EXASocketFactory.this.CertificateToHash(chain[0]);
                        int count = 0;
                        int MAX_TRIES = 3;
                        int MAX_TIMEOUT = 25;
                        do {
                            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                            trustManagerFactory.init(keyStore);
                            certificateValidator = (X509TrustManager)trustManagerFactory.getTrustManagers()[0];
                            if (certificateValidator.getAcceptedIssuers().length > 0) break;
                            try {
                                Random rtNum = new Random();
                                Thread.sleep(rtNum.nextInt(25));
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        } while (++count < 3);
                        certificateValidator.checkServerTrusted(chain, authType);
                        chain[0].checkValidity();
                    }
                    catch (CertificateExpiredException | CertificateNotYetValidException cee) {
                        throw cee;
                    }
                    catch (Exception e) {
                        throw new CertificateException(e.getMessage());
                    }
                } else {
                    throw new CertificateException("[ERROR] Certificate was not received from the server.");
                }
            }
        }});
        return byPassTrustManagers;
    }
}

