/*
 * Decompiled with CFR 0.152.
 */
package resources.dependencies.org.bouncycastle.crypto.agreement;

import java.math.BigInteger;
import resources.dependencies.org.bouncycastle.crypto.CipherParameters;
import resources.dependencies.org.bouncycastle.crypto.CryptoServicesRegistrar;
import resources.dependencies.org.bouncycastle.crypto.StagedAgreement;
import resources.dependencies.org.bouncycastle.crypto.agreement.Utils;
import resources.dependencies.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import resources.dependencies.org.bouncycastle.crypto.params.ECDomainParameters;
import resources.dependencies.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import resources.dependencies.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import resources.dependencies.org.bouncycastle.math.ec.ECAlgorithms;
import resources.dependencies.org.bouncycastle.math.ec.ECPoint;

public class ECDHCStagedAgreement
implements StagedAgreement {
    ECPrivateKeyParameters key;

    @Override
    public void init(CipherParameters cipherParameters) {
        this.key = (ECPrivateKeyParameters)cipherParameters;
        CryptoServicesRegistrar.checkConstraints(Utils.getDefaultProperties("ECCDH", this.key));
    }

    @Override
    public int getFieldSize() {
        return this.key.getParameters().getCurve().getFieldElementEncodingLength();
    }

    @Override
    public AsymmetricKeyParameter calculateStage(CipherParameters cipherParameters) {
        ECPoint eCPoint = this.calculateNextPoint((ECPublicKeyParameters)cipherParameters);
        return new ECPublicKeyParameters(eCPoint, this.key.getParameters());
    }

    @Override
    public BigInteger calculateAgreement(CipherParameters cipherParameters) {
        ECPoint eCPoint = this.calculateNextPoint((ECPublicKeyParameters)cipherParameters);
        return eCPoint.getAffineXCoord().toBigInteger();
    }

    private ECPoint calculateNextPoint(ECPublicKeyParameters eCPublicKeyParameters) {
        ECPublicKeyParameters eCPublicKeyParameters2 = eCPublicKeyParameters;
        ECDomainParameters eCDomainParameters = this.key.getParameters();
        if (!eCDomainParameters.equals(eCPublicKeyParameters2.getParameters())) {
            throw new IllegalStateException("ECDHC public key has wrong domain parameters");
        }
        BigInteger bigInteger = eCDomainParameters.getH().multiply(this.key.getD()).mod(eCDomainParameters.getN());
        ECPoint eCPoint = ECAlgorithms.cleanPoint(eCDomainParameters.getCurve(), eCPublicKeyParameters2.getQ());
        if (eCPoint.isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid public key for ECDHC");
        }
        ECPoint eCPoint2 = eCPoint.multiply(bigInteger).normalize();
        if (eCPoint2.isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid agreement value for ECDHC");
        }
        return eCPoint2;
    }
}

