/*
 * Decompiled with CFR 0.152.
 */
package resources.dependencies.org.bouncycastle.jcajce.provider.util;

import java.util.Map;
import resources.dependencies.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import resources.dependencies.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import resources.dependencies.org.bouncycastle.jcajce.provider.util.AlgorithmProvider;
import resources.dependencies.org.bouncycastle.jcajce.provider.util.AsymmetricKeyInfoConverter;

public abstract class AsymmetricAlgorithmProvider
extends AlgorithmProvider {
    protected void addSignatureAlgorithm(ConfigurableProvider configurableProvider, String string, String string2, ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        configurableProvider.addAlgorithm("Signature." + string, string2);
        if (aSN1ObjectIdentifier != null) {
            configurableProvider.addAlgorithm("Alg.Alias.Signature." + aSN1ObjectIdentifier, string);
            configurableProvider.addAlgorithm("Alg.Alias.Signature.OID." + aSN1ObjectIdentifier, string);
        }
    }

    protected void addSignatureAlias(ConfigurableProvider configurableProvider, String string, ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        configurableProvider.addAlgorithm("Alg.Alias.Signature." + aSN1ObjectIdentifier, string);
        configurableProvider.addAlgorithm("Alg.Alias.Signature.OID." + aSN1ObjectIdentifier, string);
    }

    protected void addSignatureAlgorithm(ConfigurableProvider configurableProvider, String string, String string2, String string3) {
        this.addSignatureAlgorithm(configurableProvider, string, string2, string3, null);
    }

    protected void addSignatureAlgorithm(ConfigurableProvider configurableProvider, String string, String string2, String string3, ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        String string4 = string + "WITH" + string2;
        String string5 = string + "with" + string2;
        String string6 = string + "With" + string2;
        String string7 = string + "/" + string2;
        configurableProvider.addAlgorithm("Signature." + string4, string3);
        configurableProvider.addAlgorithm("Alg.Alias.Signature." + string5, string4);
        configurableProvider.addAlgorithm("Alg.Alias.Signature." + string6, string4);
        configurableProvider.addAlgorithm("Alg.Alias.Signature." + string7, string4);
        if (aSN1ObjectIdentifier != null) {
            configurableProvider.addAlgorithm("Alg.Alias.Signature." + aSN1ObjectIdentifier, string4);
            configurableProvider.addAlgorithm("Alg.Alias.Signature.OID." + aSN1ObjectIdentifier, string4);
        }
    }

    protected void addSignatureAlgorithm(ConfigurableProvider configurableProvider, String string, String string2, String string3, ASN1ObjectIdentifier aSN1ObjectIdentifier, Map<String, String> map) {
        String string4 = string + "WITH" + string2;
        String string5 = string + "with" + string2;
        String string6 = string + "With" + string2;
        String string7 = string + "/" + string2;
        configurableProvider.addAlgorithm("Signature." + string4, string3);
        configurableProvider.addAlgorithm("Alg.Alias.Signature." + string5, string4);
        configurableProvider.addAlgorithm("Alg.Alias.Signature." + string6, string4);
        configurableProvider.addAlgorithm("Alg.Alias.Signature." + string7, string4);
        if (aSN1ObjectIdentifier != null) {
            configurableProvider.addAlgorithm("Alg.Alias.Signature." + aSN1ObjectIdentifier, string4);
            configurableProvider.addAlgorithm("Alg.Alias.Signature.OID." + aSN1ObjectIdentifier, string4);
        }
        configurableProvider.addAttributes("Signature." + string4, map);
    }

    protected void addKeyPairGeneratorAlgorithm(ConfigurableProvider configurableProvider, String string, String string2, ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        configurableProvider.addAlgorithm("KeyPairGenerator." + string, string2);
        if (aSN1ObjectIdentifier != null) {
            configurableProvider.addAlgorithm("Alg.Alias.KeyPairGenerator." + aSN1ObjectIdentifier, string);
            configurableProvider.addAlgorithm("Alg.Alias.KeyPairGenerator.OID." + aSN1ObjectIdentifier, string);
        }
    }

    protected void addKeyFactoryAlgorithm(ConfigurableProvider configurableProvider, String string, String string2, ASN1ObjectIdentifier aSN1ObjectIdentifier, AsymmetricKeyInfoConverter asymmetricKeyInfoConverter) {
        configurableProvider.addAlgorithm("KeyFactory." + string, string2);
        if (aSN1ObjectIdentifier != null) {
            configurableProvider.addAlgorithm("Alg.Alias.KeyFactory." + aSN1ObjectIdentifier, string);
            configurableProvider.addAlgorithm("Alg.Alias.KeyFactory.OID." + aSN1ObjectIdentifier, string);
            configurableProvider.addKeyInfoConverter(aSN1ObjectIdentifier, asymmetricKeyInfoConverter);
        }
    }

    protected void addKeyGeneratorAlgorithm(ConfigurableProvider configurableProvider, String string, String string2, ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        configurableProvider.addAlgorithm("KeyGenerator." + string, string2);
        if (aSN1ObjectIdentifier != null) {
            configurableProvider.addAlgorithm("Alg.Alias.KeyGenerator." + aSN1ObjectIdentifier, string);
            configurableProvider.addAlgorithm("Alg.Alias.KeyGenerator.OID." + aSN1ObjectIdentifier, string);
        }
    }

    protected void addCipherAlgorithm(ConfigurableProvider configurableProvider, String string, String string2, ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        configurableProvider.addAlgorithm("Cipher." + string, string2);
        if (aSN1ObjectIdentifier != null) {
            configurableProvider.addAlgorithm("Alg.Alias.Cipher." + aSN1ObjectIdentifier, string);
            configurableProvider.addAlgorithm("Alg.Alias.Cipher.OID." + aSN1ObjectIdentifier, string);
        }
    }

    protected void registerKeyFactoryOid(ConfigurableProvider configurableProvider, ASN1ObjectIdentifier aSN1ObjectIdentifier, String string, AsymmetricKeyInfoConverter asymmetricKeyInfoConverter) {
        configurableProvider.addAlgorithm("Alg.Alias.KeyFactory." + aSN1ObjectIdentifier, string);
        configurableProvider.addAlgorithm("Alg.Alias.KeyFactory.OID." + aSN1ObjectIdentifier, string);
        configurableProvider.addKeyInfoConverter(aSN1ObjectIdentifier, asymmetricKeyInfoConverter);
    }

    protected void registerOid(ConfigurableProvider configurableProvider, ASN1ObjectIdentifier aSN1ObjectIdentifier, String string, AsymmetricKeyInfoConverter asymmetricKeyInfoConverter) {
        configurableProvider.addAlgorithm("Alg.Alias.KeyFactory." + aSN1ObjectIdentifier, string);
        configurableProvider.addAlgorithm("Alg.Alias.KeyPairGenerator." + aSN1ObjectIdentifier, string);
        configurableProvider.addKeyInfoConverter(aSN1ObjectIdentifier, asymmetricKeyInfoConverter);
    }

    protected void registerOidAlgorithmParameters(ConfigurableProvider configurableProvider, ASN1ObjectIdentifier aSN1ObjectIdentifier, String string) {
        configurableProvider.addAlgorithm("Alg.Alias.AlgorithmParameters." + aSN1ObjectIdentifier, string);
    }

    protected void registerOidAlgorithmParameterGenerator(ConfigurableProvider configurableProvider, ASN1ObjectIdentifier aSN1ObjectIdentifier, String string) {
        configurableProvider.addAlgorithm("Alg.Alias.AlgorithmParameterGenerator." + aSN1ObjectIdentifier, string);
        configurableProvider.addAlgorithm("Alg.Alias.AlgorithmParameters." + aSN1ObjectIdentifier, string);
    }
}

