/*
 * Decompiled with CFR 0.152.
 */
package resources.dependencies.org.bouncycastle.pkcs.bc;

import java.io.InputStream;
import resources.dependencies.org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import resources.dependencies.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import resources.dependencies.org.bouncycastle.crypto.CipherParameters;
import resources.dependencies.org.bouncycastle.crypto.ExtendedDigest;
import resources.dependencies.org.bouncycastle.crypto.digests.SHA1Digest;
import resources.dependencies.org.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import resources.dependencies.org.bouncycastle.crypto.io.CipherInputStream;
import resources.dependencies.org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import resources.dependencies.org.bouncycastle.operator.GenericKey;
import resources.dependencies.org.bouncycastle.operator.InputDecryptor;
import resources.dependencies.org.bouncycastle.operator.InputDecryptorProvider;
import resources.dependencies.org.bouncycastle.pkcs.bc.PKCS12PBEUtils;

public class BcPKCS12PBEInputDecryptorProviderBuilder {
    private ExtendedDigest digest;

    public BcPKCS12PBEInputDecryptorProviderBuilder() {
        this(new SHA1Digest());
    }

    public BcPKCS12PBEInputDecryptorProviderBuilder(ExtendedDigest extendedDigest) {
        this.digest = extendedDigest;
    }

    public InputDecryptorProvider build(final char[] cArray) {
        return new InputDecryptorProvider(){

            @Override
            public InputDecryptor get(final AlgorithmIdentifier algorithmIdentifier) {
                final PaddedBufferedBlockCipher paddedBufferedBlockCipher = PKCS12PBEUtils.getEngine(algorithmIdentifier.getAlgorithm());
                PKCS12PBEParams pKCS12PBEParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
                CipherParameters cipherParameters = PKCS12PBEUtils.createCipherParameters(algorithmIdentifier.getAlgorithm(), BcPKCS12PBEInputDecryptorProviderBuilder.this.digest, paddedBufferedBlockCipher.getBlockSize(), pKCS12PBEParams, cArray);
                paddedBufferedBlockCipher.init(false, cipherParameters);
                return new InputDecryptor(){

                    @Override
                    public AlgorithmIdentifier getAlgorithmIdentifier() {
                        return algorithmIdentifier;
                    }

                    @Override
                    public InputStream getInputStream(InputStream inputStream) {
                        return new CipherInputStream(inputStream, paddedBufferedBlockCipher);
                    }

                    public GenericKey getKey() {
                        return new GenericKey(algorithmIdentifier, PKCS12ParametersGenerator.PKCS12PasswordToBytes(cArray));
                    }
                };
            }
        };
    }
}

