/*
 * Decompiled with CFR 0.152.
 */
package resources.dependencies.org.bouncycastle.pqc.crypto.saber;

import java.security.SecureRandom;
import resources.dependencies.org.bouncycastle.crypto.EncapsulatedSecretGenerator;
import resources.dependencies.org.bouncycastle.crypto.SecretWithEncapsulation;
import resources.dependencies.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import resources.dependencies.org.bouncycastle.pqc.crypto.saber.SABEREngine;
import resources.dependencies.org.bouncycastle.pqc.crypto.saber.SABERPublicKeyParameters;
import resources.dependencies.org.bouncycastle.pqc.crypto.util.SecretWithEncapsulationImpl;

public class SABERKEMGenerator
implements EncapsulatedSecretGenerator {
    private final SecureRandom sr;

    public SABERKEMGenerator(SecureRandom secureRandom) {
        this.sr = secureRandom;
    }

    @Override
    public SecretWithEncapsulation generateEncapsulated(AsymmetricKeyParameter asymmetricKeyParameter) {
        SABERPublicKeyParameters sABERPublicKeyParameters = (SABERPublicKeyParameters)asymmetricKeyParameter;
        SABEREngine sABEREngine = sABERPublicKeyParameters.getParameters().getEngine();
        byte[] byArray = new byte[sABEREngine.getCipherTextSize()];
        byte[] byArray2 = new byte[sABEREngine.getSessionKeySize()];
        sABEREngine.crypto_kem_enc(byArray, byArray2, sABERPublicKeyParameters.getPublicKey(), this.sr);
        return new SecretWithEncapsulationImpl(byArray2, byArray);
    }
}

