/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.Column;
import com.exasol.jdbc.EXAInputStream;
import com.exasol.jdbc.EXAOutputStream;
import com.exasol.jdbc.Translator;
import java.io.IOException;
import java.sql.SQLException;

class BoolColumn
extends Column {
    private boolean[] values;

    BoolColumn(String name_, boolean[] values_) {
        super(name_);
        this.values = values_;
        int num = this.values.length;
        this.validMask = new boolean[num];
        for (int i = 0; i < num; ++i) {
            this.validMask[i] = true;
        }
        this.precision = 1;
    }

    BoolColumn() {
        this.precision = 1;
        this.values = new boolean[initialBatchCapacity];
    }

    @Override
    String getClassName() {
        return "java.lang.Boolean";
    }

    @Override
    int getDisplaySize() {
        return 5;
    }

    @Override
    int getType() {
        return 16;
    }

    @Override
    String getTypeName() {
        return "BOOLEAN";
    }

    @Override
    Object getObject(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("BoolColumn::getObject: " + Translator.Accessed_null_value());
        }
        return this.values[row];
    }

    @Override
    String getString(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("BoolColumn::getString: " + Translator.Accessed_null_value());
        }
        return String.valueOf(this.values[row]).toUpperCase();
    }

    @Override
    boolean getBoolean(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("BoolColumn::getBoolean: " + Translator.Accessed_null_value());
        }
        return this.values[row];
    }

    @Override
    byte getByte(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("BoolColumn::getByte: " + Translator.Accessed_null_value());
        }
        if (this.values[row]) {
            return 1;
        }
        return 0;
    }

    @Override
    int getInt(int row) throws SQLException {
        return this.getByte(row);
    }

    @Override
    long getLong(int columnIndex) throws SQLException {
        return this.getByte(columnIndex);
    }

    @Override
    short getShort(int row) throws SQLException {
        return this.getByte(row);
    }

    @Override
    void setBoolean(int row, boolean val) {
        this.validMask[row] = true;
        this.values[row] = val;
    }

    @Override
    void setInt(int row, int x) throws SQLException {
        super.setBoolean(row, x != 0);
    }

    @Override
    void setLong(int columnIndex, long x) throws SQLException {
        super.setBoolean(columnIndex, x != 0L);
    }

    @Override
    void setShort(int row, short x) throws SQLException {
        super.setBoolean(row, x != 0);
    }

    @Override
    void resize(int size) {
        boolean[] nv = new boolean[size];
        boolean[] vm = new boolean[size];
        int s = this.values.length;
        if (s > size) {
            s = size;
        }
        for (int i = 0; i < s; ++i) {
            vm[i] = this.validMask[i];
            nv[i] = this.values[i];
        }
        for (int j = s; j < size; ++j) {
            vm[j] = false;
        }
        this.values = nv;
        this.validMask = vm;
    }

    @Override
    long value_to_jdbc(EXAOutputStream os, int row) throws IOException {
        if (this.validMask[row]) {
            os.writeByte((byte)1);
            os.writeBoolean(this.values[row]);
            return 2L;
        }
        os.writeByte((byte)0);
        return 1L;
    }

    @Override
    void value_from_jdbc(EXAInputStream is, int row) throws IOException {
        if (is.nextIsNull()) {
            this.validMask[row] = false;
        } else {
            this.validMask[row] = true;
            this.values[row] = is.readBoolean();
        }
    }

    static Column from_jdbc_type(EXAInputStream is) throws IOException {
        return new BoolColumn();
    }

    @Override
    int getEXAType() {
        return 9;
    }
}

