/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.BigDecimalColumn;
import com.exasol.jdbc.BoolColumn;
import com.exasol.jdbc.CharColumn;
import com.exasol.jdbc.DateColumn;
import com.exasol.jdbc.DecimalColumn;
import com.exasol.jdbc.DoubleColumn;
import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.EXAInputStream;
import com.exasol.jdbc.EXAOutputStream;
import com.exasol.jdbc.EXAPreparedStatement;
import com.exasol.jdbc.Protocol;
import com.exasol.jdbc.ProtocolException;
import com.exasol.jdbc.ProtocolTypes;
import com.exasol.jdbc.SmallDecimalColumn;
import com.exasol.jdbc.TimestampColumn;
import com.exasol.jdbc.Translator;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

abstract class Column
implements Protocol,
ProtocolTypes {
    protected boolean[] validMask;
    private static long cn = 0L;
    protected int precision = 0;
    protected int scale = 0;
    static int initialBatchCapacity = EXAPreparedStatement.capacityDefault;
    String name = Column.constructedName();
    String label = "";

    private static SQLException type_error() {
        new Throwable().printStackTrace();
        return new SQLException(Translator.type_error());
    }

    private static String constructedName() {
        return "$$" + ++cn;
    }

    Column() {
        this.validMask = new boolean[initialBatchCapacity];
        for (int i = 0; i < initialBatchCapacity; ++i) {
            this.validMask[i] = false;
        }
    }

    Column(String name_) {
        this();
        this.name = name_;
        this.label = name_;
    }

    abstract void resize(int var1);

    abstract String getClassName() throws SQLException;

    abstract int getDisplaySize() throws SQLException;

    abstract int getEXAType();

    abstract int getType() throws SQLException;

    abstract String getTypeName() throws SQLException;

    abstract Object getObject(int var1) throws SQLException;

    int getPrecision() throws SQLException {
        return this.precision;
    }

    int getScale() throws SQLException {
        return this.scale;
    }

    void setPrecision(int p) {
        if (p >= 0) {
            this.precision = p;
        }
    }

    void setScale(int s) {
        this.scale = s;
    }

    boolean isSigned() {
        return false;
    }

    Array getArray(int row) throws SQLException {
        throw Column.type_error();
    }

    BigDecimal getBigDecimal(int row) throws SQLException {
        throw Column.type_error();
    }

    BigDecimal getBigDecimal(int row, int s) throws SQLException {
        throw Column.type_error();
    }

    boolean isNull(int row) {
        return !this.validMask[row];
    }

    void setNull(int row) throws SQLException {
        this.validMask[row] = false;
    }

    Blob getBlob(int row) throws SQLException {
        throw Column.type_error();
    }

    boolean getBoolean(int row) throws SQLException {
        throw Column.type_error();
    }

    byte getByte(int row) throws SQLException {
        throw Column.type_error();
    }

    byte[] getBytes(int row) throws SQLException {
        throw Column.type_error();
    }

    Clob getClob(int row) throws SQLException {
        throw Column.type_error();
    }

    Date getDate(int row) throws SQLException {
        throw Column.type_error();
    }

    Date getDate(int row, Calendar cal) throws SQLException {
        throw Column.type_error();
    }

    double getDouble(int row) throws SQLException {
        throw Column.type_error();
    }

    float getFloat(int row) throws SQLException {
        throw Column.type_error();
    }

    int getInt(int row) throws SQLException {
        throw Column.type_error();
    }

    long getLong(int columnIndex) throws SQLException {
        throw Column.type_error();
    }

    Object getObject(int i, Map map) throws SQLException {
        throw Column.type_error();
    }

    Ref getRef(int i) throws SQLException {
        throw Column.type_error();
    }

    short getShort(int row) throws SQLException {
        throw Column.type_error();
    }

    String getString(int row) throws SQLException {
        throw Column.type_error();
    }

    Time getTime(int row) throws SQLException {
        throw Column.type_error();
    }

    Time getTime(int row, Calendar cal) throws SQLException {
        throw Column.type_error();
    }

    Timestamp getTimestamp(int row) throws SQLException {
        throw Column.type_error();
    }

    Timestamp getTimestamp(int row, Calendar cal) throws SQLException {
        throw Column.type_error();
    }

    InputStream getAsciiStream(int row) throws SQLException {
        throw Column.type_error();
    }

    InputStream getBinaryStream(int row) throws SQLException {
        throw Column.type_error();
    }

    Reader getCharacterStream(int row) throws SQLException {
        throw Column.type_error();
    }

    InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw Column.type_error();
    }

    void setArray(int row, Array x) throws SQLException {
        throw Column.type_error();
    }

    void setBigDecimal(int row, BigDecimal x) throws SQLException {
        throw Column.type_error();
    }

    void setBigDecimal(int row, int s, BigDecimal X) throws SQLException {
        throw Column.type_error();
    }

    void setBlob(int row, Blob x) throws SQLException {
        throw Column.type_error();
    }

    void setBoolean(int row, boolean x) throws SQLException {
        throw Column.type_error();
    }

    void setByte(int row, byte x) throws SQLException {
        throw Column.type_error();
    }

    void setBytes(int row, byte[] x) throws SQLException {
        throw Column.type_error();
    }

    void setClob(int row, Clob x) throws SQLException {
        throw Column.type_error();
    }

    void setDate(int row, Date x) throws SQLException {
        throw Column.type_error();
    }

    void setDate(int row, Date x, Calendar cal) throws SQLException {
        throw Column.type_error();
    }

    void setDouble(int row, double x) throws SQLException {
        throw Column.type_error();
    }

    void setFloat(int row, float x) throws SQLException {
        throw Column.type_error();
    }

    void setInt(int row, int x) throws SQLException {
        throw Column.type_error();
    }

    void setLong(int columnIndex, long x) throws SQLException {
        throw Column.type_error();
    }

    void setObject(int i, Object x) throws SQLException {
        throw Column.type_error();
    }

    void setObject(int i, Object x, int targetSqltype) throws SQLException {
        throw Column.type_error();
    }

    void setObject(int i, Object x, int targetSqlType, int s) throws SQLException {
        throw Column.type_error();
    }

    void setRef(int i, Ref x) throws SQLException {
        throw Column.type_error();
    }

    void setShort(int row, short x) throws SQLException {
        throw Column.type_error();
    }

    void setString(int row, String x) throws SQLException {
        throw Column.type_error();
    }

    void setTime(int row, Time x) throws SQLException {
        throw Column.type_error();
    }

    void setTime(int row, Time x, Calendar cal) throws SQLException {
        throw Column.type_error();
    }

    void setTimestamp(int row, Timestamp x) throws SQLException {
        throw Column.type_error();
    }

    void setTimestamp(int row, Timestamp x, Calendar cal) throws SQLException {
        throw Column.type_error();
    }

    void setAsciiStream(int row, InputStream x, int length) throws SQLException {
        throw Column.type_error();
    }

    void setBinaryStream(int row, InputStream x, int length) throws SQLException {
        throw Column.type_error();
    }

    void setCharacterStream(int row, Reader x, int length) throws SQLException {
        throw Column.type_error();
    }

    void setUnicodeStream(int row, InputStream x, int length) throws SQLException {
        throw Column.type_error();
    }

    abstract long value_to_jdbc(EXAOutputStream var1, int var2) throws SQLException, IOException;

    abstract void value_from_jdbc(EXAInputStream var1, int var2) throws SQLException, IOException;

    static Column from_jdbc_type(EXAInputStream is, EXAConnection con) throws ProtocolException, IOException {
        int type_code = is.readInt();
        switch (type_code) {
            case 8: {
                return DoubleColumn.from_jdbc_type(is);
            }
            case 63: {
                return SmallDecimalColumn.from_jdbc_type(is);
            }
            case 6: {
                return DecimalColumn.from_jdbc_type(is);
            }
            case 10: 
            case 16: 
            case 17: 
            case 123: 
            case 126: {
                return CharColumn.from_jdbc_type(is, con, type_code);
            }
            case 14: {
                return DateColumn.from_jdbc_type(is);
            }
            case 9: {
                return BoolColumn.from_jdbc_type(is);
            }
            case 21: {
                return TimestampColumn.from_jdbc_type(is, con);
            }
            case 64: {
                return BigDecimalColumn.from_jdbc_type(is);
            }
        }
        throw new ProtocolException(Translator.illegal_type_code() + type_code);
    }

    public String toString() {
        return "column size=" + this.validMask.length;
    }
}

