/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.EXAConnection;
import java.io.PrintWriter;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.CommonDataSource;

public class EXADataSource
implements CommonDataSource {
    private Properties params = null;

    public EXADataSource() throws ClassNotFoundException {
        Class.forName("com.exasol.jdbc.EXADriver");
    }

    public void setProperty(String key, String value) {
        if (null == this.params) {
            this.params = new Properties();
        }
        this.params.put(key == null ? key : key.toLowerCase(), value);
    }

    public String getProperty(String key) {
        return this.params.getProperty(key == null ? key : key.toLowerCase());
    }

    public void setProperties(Properties properties) {
        this.params = properties;
    }

    public EXAConnection getConnection(String connStr) throws SQLException {
        String connectionString = "jdbc:exa:" + connStr;
        EXAConnection connection = null;
        connection = (EXAConnection)DriverManager.getConnection(connectionString, this.params);
        return connection;
    }

    public void setSocketFactory(String socketFactoryClassName) {
        this.setProperty("socketfactory".toLowerCase(), socketFactoryClassName);
    }

    public void setSocketFactoryArg(String socketFactoryArg) {
        this.setProperty("socketfactoryarg".toLowerCase(), socketFactoryArg);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.setProperty("logintimeout".toLowerCase(), Integer.valueOf(seconds).toString());
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        String lt = this.getProperty("logintimeout".toLowerCase());
        return lt != null && lt.length() > 0 ? Integer.valueOf(lt) : 0;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }
}

